// ItemCharacrDlg.cpp : implementation file
//
#include "stdafx.h"
#include "dictionary.h"
#include "apl_api.h"
#include "ItemCharacrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CItemCharacrDlg dialog


CItemCharactDlg::CItemCharactDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CItemCharactDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CItemCharacrDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_aggr_val.SetUniqueName(_T("apl_psm_item_charact_dlg"));
	m_ReadOnly=false;
	m_api=0;
	m_item=0;
}


void CItemCharactDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CItemCharacrDlg)
	DDX_Control(pDX, IDC_ST_CHARACTS_NAME, m_st_charact_name);
	DDX_Control(pDX, IDC_TBL_RECT, m_tbl_rect);
	DDX_Control(pDX, IDC_SAVE_TO_FILE, m_save_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CItemCharactDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CItemCharacrDlg)
	ON_BN_CLICKED(IDC_ADD, OnAdd)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_NOTIFY(NM_DBLCLK, IDC_AGGR_VAL, OnDblclkList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CItemCharacrDlg message handlers

BOOL CItemCharactDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	RECT rect={5,5,10,10},rect1;
	m_aggr_val.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDC_AGGR_VAL);
	//CResizableDialog::OnInitDialog();// ,     ! DIV

	m_tbl_rect.GetWindowRect(&rect1);
	ScreenToClient(&rect1);
	m_aggr_val.MoveWindow(&rect1);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_AGGR_VAL, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_SAVE_TO_FILE, BOTTOM_LEFT);
	AddAnchor(IDC_ADD,TOP_RIGHT);
	AddAnchor(IDC_DEL,TOP_RIGHT);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_save_btn.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_save_btn.SetFlat(FALSE);	
	m_add_btn.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_add_btn.SetFlat(FALSE);
	m_del_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_del_btn.SetFlat(FALSE);

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(aplGetBitPerPixel(this)>8)
		m_name_bmp.LoadMappedBitmap(IDB_CHARACTS_NAME,0,&cm,1);
	else
		m_name_bmp.LoadMappedBitmap(IDB_CHARACTS_NAME_16,0,&cm,1);
		
	
	HBITMAP hBmpOld=m_st_charact_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);

	m_aggr_val.InsertColumn(0, APL_T(""),LVCFMT_LEFT,140);
	m_aggr_val.CListCtrl::SetColumnWidth(0,130);
	m_aggr_val.InsertColumn(1, APL_T(""),LVCFMT_LEFT,50);
	m_aggr_val.CListCtrl::SetColumnWidth(0,100);
	m_aggr_val.InsertColumn(2, APL_T(""),LVCFMT_LEFT,140);
	m_aggr_val.CListCtrl::SetColumnWidth(0,200);
	m_aggr_val.InsertColumn(3, APL_T(".."),LVCFMT_LEFT,100);
	m_aggr_val.CListCtrl::SetColumnWidth(0,200);


	int i;
	aplExtent ext1,ext2;
	CaplInstance *val,*inst;
	CString buf;
	m_api->m_charact_mgr.FindAssociatedCharacteristic(m_item,ext1,ext2);
	for(i=0;i<ext1.Size;i++)
	{
		val=ext1[i];
		if(val==0) continue;

		apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_charact,inst);
		apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_name,buf);
		
		int k=m_aggr_val.InsertItem(m_aggr_val.GetItemCount(),buf);
		m_aggr_val.SetItemData(k,(long)val);
		apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_unit,inst);
		m_api->m_charact_mgr.GetUnitName(inst,buf);
		m_aggr_val.SetItemText(k,3,buf);
		m_api->m_charact_mgr.PrintCharacteristicValue(val,0,buf);
		m_aggr_val.SetItemText(k,2,buf);
		buf=_T("");
		apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_type,inst);
		if(inst!=0) apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_type_name,buf);
		m_aggr_val.SetItemText(k,1,buf);		
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CItemCharactDlg::OnOK() 
{
	CResizableDialog::OnOK();
}

void CItemCharactDlg::OnAdd() 
{
	CaplInstance *val=0,*inst;
	if(!m_api->m_charact_mgr.CreateCharacteristic(m_item,0,&val)) return;
	
	m_cancel_btn.EnableWindow(FALSE);
	CString buf;
	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_charact,inst);
	apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_name,buf);

	int k=m_aggr_val.InsertItem(m_aggr_val.GetItemCount(),buf);
	m_aggr_val.SetItemData(k,(long)val);
	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_unit,inst);
	m_api->m_charact_mgr.GetUnitName(inst,buf);
	m_aggr_val.SetItemText(k,3,buf);
	m_api->m_charact_mgr.PrintCharacteristicValue(val,0,buf);
	m_aggr_val.SetItemText(k,2,buf);
	buf=_T("");
	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_type,inst);
	if(inst!=0) apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_type_name,buf);
	m_aggr_val.SetItemText(k,1,buf);
	
}

void CItemCharactDlg::OnDel() 
{
	POSITION pos;
 	pos=m_aggr_val.GetFirstSelectedItemPosition();
 	int k=m_aggr_val.GetNextSelectedItem(pos);
	if(k<0) return;
	CaplInstance *val=(CaplInstance*)m_aggr_val.GetItemData(k);

	if(val!=0)
	{
		if(val->GetAccessmode()>aplOWN)
		{
			aplErrorMessage(S::NoAccessRight());
			return;
		}
	}
	if(AfxMessageBox( APL_T("     ?"),MB_YESNO)==IDYES)
	{
		if(m_api->m_charact_mgr.DeleteCharacteristic(val))
		{
			m_aggr_val.DeleteItem(k);
			m_cancel_btn.EnableWindow(FALSE);
		}
	}
}

void CItemCharactDlg::OnDblclkList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;

	if(m_ReadOnly) return;
	if(lpnmitem==0) return;
	
	int k=lpnmitem->iItem;
	if(k<0||k>m_aggr_val.GetItemCount()-1) return;
	CaplInstance *inst,*val=(CaplInstance*)m_aggr_val.GetItemData(k);
	if(val==0) return;
	CString buf;
	
	if(!m_api->m_charact_mgr.ShowProperties(val)) return;

	m_cancel_btn.EnableWindow(FALSE);

	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_unit,inst);
	m_api->m_charact_mgr.GetUnitName(inst,buf);
	m_aggr_val.SetItemText(k,3,buf);
	m_api->m_charact_mgr.PrintCharacteristicValue(val,0,buf);
	m_aggr_val.SetItemText(k,2,buf);
	buf=_T("");
	apidata.GetAttr(val,m_api->m_charact_mgr.a_apl_charact_val_type,inst);
	if(inst!=0) apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_charact_type_name,buf);
	m_aggr_val.SetItemText(k,1,buf);
}
