// BPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dictionary.h"
#include "apl_api.h"
#include "ManufActionDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define CHECK_OUT_ICON 10
/////////////////////////////////////////////////////////////////////////////
// CBPDlg dialog


CBPDlg::CBPDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CBPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBPDlg)
	m_act_id = _T("");
	m_act_name = _T("");
	m_act_descr = _T("");
	m_act_code = _T("");
	m_act_label = _T("");
	//}}AFX_DATA_INIT
	m_data=0;
	m_bp_mgr=0;
	m_bp=0; m_base_bp=0;m_item=0,m_context=0;
	m_bp_ref=0;m_type=0;
	m_context_changed=false;
	m_ReadOnly=false; m_changed_aggr=false;
	m_add_mode=false;

	m_api	=NULL;
}


void CBPDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBPDlg)
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Control(pDX, IDC_B_PROPS_PROPS_BP, m_bPropsProps);
	DDX_Control(pDX, IDC_B_PROPS_DEL_BP, m_bPropsDel);
	DDX_Control(pDX, IDC_B_PROPS_ADD_BP, m_bPropsAdd);
	DDX_Control(pDX, IDC_ADD_BP, m_btn_add);
	DDX_Control(pDX, IDC_ST_ACTION_ICO, m_st_action_ico);
	DDX_Control(pDX, IDC_UNDO_CHECK_OUT, m_undo_check_out_ctrl);
	DDX_Control(pDX, IDC_CHECK_IN, m_check_in_ctrl);
	DDX_Control(pDX, IDC_CHECK_OUT, m_check_out_ctrl);
	DDX_Control(pDX, IDC_LABEL, m_act_label_ctrl);
	DDX_Control(pDX, IDC_PARENT_TEXT, m_act_parent_text_ctrl);
	DDX_Control(pDX, IDC_PARENT, m_act_parent_ctrl);
	DDX_Control(pDX, IDC_CONTEXT_SEL, m_context_sel);
	DDX_Control(pDX, IDC_CONTEXTS_NAMES, m_context_names);
	DDX_Control(pDX, IDC_CONTEXT_TEXT, m_context_text);
	DDX_Control(pDX, IDC_ACT_TYPE, m_type_ctrl);
	DDX_Control(pDX, IDC_ST_ACTION_NAME, m_st_bp_name);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_EL_BOTTOM, m_bottom_btn);
	DDX_Control(pDX, IDC_EL_TOP, m_top_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_ELEMENTS, m_elements);
	DDX_Control(pDX, IDC_ACTION_DESCR, m_act_descr_ctrl);
	DDX_Control(pDX, IDC_ACTION_NAME, m_act_name_ctrl);
	DDX_Control(pDX, IDC_ACTION_ID, m_act_id_ctrl);
	DDX_Control(pDX, IDC_CODE, m_act_code_ctrl);
	DDX_Text(pDX, IDC_ACTION_ID, m_act_id);
	DDX_Text(pDX, IDC_ACTION_NAME, m_act_name);
	DDX_Text(pDX, IDC_ACTION_DESCR, m_act_descr);
	DDX_Text(pDX, IDC_CODE, m_act_code);
	DDX_Text(pDX, IDC_LABEL, m_act_label);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_CUSTOMIZED, m_customized_ctrl);
	DDX_Control(pDX, IDC_OPTIONAL, m_optional_ctrl);
}


BEGIN_MESSAGE_MAP(CBPDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CBPDlg)
	ON_BN_CLICKED(IDC_EL_TOP, OnElTop)
	ON_BN_CLICKED(IDC_EL_BOTTOM, OnElBottom)
	ON_NOTIFY(NM_DBLCLK, IDC_ELEMENTS, OnDblclkElements)
	ON_CBN_SELCHANGE(IDC_ACT_TYPE, OnSelchangeActType)
	ON_BN_CLICKED(IDC_ST_ACTION_NAME, OnStActionName)
	ON_BN_CLICKED(IDC_CONTEXT_SEL, OnContextSel)
	ON_BN_CLICKED(IDC_CHECK_OUT, OnCheckOut)
	ON_BN_CLICKED(IDC_CHECK_IN, OnCheckIn)
	ON_BN_CLICKED(IDC_UNDO_CHECK_OUT, OnUndoCheckOut)
	ON_WM_CONTEXTMENU()
	ON_BN_CLICKED(IDC_ADD_BP, OnAddBp)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_BN_CLICKED(IDC_B_PROPS_ADD_BP, OnBPropsAdd)
	ON_BN_CLICKED(IDC_B_PROPS_DEL_BP, OnBPropsDel)
	ON_BN_CLICKED(IDC_B_PROPS_PROPS_BP, OnBPropsProps)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CBPDlg::SetAnchors(void)
{
	AddAnchor(IDC_TAB1,TOP_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_B_PROPS_ADD_BP,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_DEL_BP,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_PROPS_BP,TOP_RIGHT);

	AddAnchor(IDC_ST_ACTION_NAME,TOP_CENTER);

	AddAnchor(IDC_ACTION_ID,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_ACTION_NAME,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_ACT_TYPE,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_CUSTOMIZED,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_OPTIONAL,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_ACTION_DESCR,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_CODE_TEXT,TOP_RIGHT);
	AddAnchor(IDC_CODE,TOP_RIGHT);

	AddAnchor(IDC_PARENT_TEXT,TOP_LEFT);
	AddAnchor(IDC_PARENT,TOP_LEFT);

	AddAnchor(IDC_LABEL_TEXT,TOP_LEFT);
	AddAnchor(IDC_LABEL,TOP_LEFT, TOP_RIGHT);

	AddAnchor(IDC_ELEMENTS, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_EL_TOP, MIDDLE_LEFT);
	AddAnchor(IDC_EL_BOTTOM, MIDDLE_LEFT);

	AddAnchor(IDC_CONTEXT_TEXT,BOTTOM_LEFT);
	AddAnchor(IDC_CONTEXT_SEL,BOTTOM_RIGHT);
	AddAnchor(IDC_CONTEXTS_NAMES,BOTTOM_LEFT, BOTTOM_RIGHT);

	AddAnchor(IDC_CHECK_OUT,TOP_RIGHT);
	AddAnchor(IDC_CHECK_IN,TOP_RIGHT);
	AddAnchor(IDC_UNDO_CHECK_OUT,TOP_RIGHT);

	AddAnchor(IDC_ADD_BP,BOTTOM_LEFT);
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);

	return TRUE;
}

void CBPDlg::SetSize(int cy)
{
	CRect rt;
	CSize sz;

	GetWindowRect(rt);
	sz.cx=rt.right-rt.left;
	sz.cy=rt.bottom-rt.top-cy;
	SetMinTrackSize(sz);

	m_Tab.GetWindowRect(rt);
	ScreenToClient(rt);
	rt.bottom-=cy;
	m_Tab.MoveWindow(rt);
}

BOOL CBPDlg::InitViews(void)
{
	CaplCharactView*	pCharView	=NULL;
	CaplApprovalView*	pApprView	=NULL;
	CaplDocsView*		pDocsView	=NULL;
	CaplAccessView*		pAccView	=NULL;

	CWnd*				pWnd		=NULL;

	CArray<int,int>		caExcludes;

	CRect				rt;

	DWORD				dwStyles=WS_CHILD|WS_BORDER;

	CaplInstance*		cit			=NULL;

	cit=m_bp;

	m_Tab.SetImageList(aplGetTabCtrlImageList());

	m_Tab.InsertItem(0, APL_T(""),0);
	m_Tab.AddTab(0,NULL);
	m_Tab.SetCurSel(0);

	caExcludes.Add(IDC_ST_NAME);
	caExcludes.Add(IDC_B_PROPS_ADD_BP);
	caExcludes.Add(IDC_B_PROPS_DEL_BP);
	caExcludes.Add(IDC_B_PROPS_PROPS_BP);
	caExcludes.Add(IDC_ST_ACTION_NAME);
	caExcludes.Add(IDC_ST_ACTION_ICO);
	m_Tab.AddExcludeIDs(caExcludes);

	//pWnd=GetDlgItem(IDC_T_VIEW_FRAME);
	//pWnd->GetClientRect(rt);
	//pWnd->ClientToScreen(rt);
	m_Tab.GetWindowRect(rt);
	rt.DeflateRect(8,75,8,8);
	ScreenToClient(rt);

	if(NULL!=cit)
	{
		m_Tab.InsertItem(1, APL_T(""),1);
		pCharView=(CaplCharactView*)(RUNTIME_CLASS(CaplCharactView)->CreateObject());
		pCharView->Create(NULL,NULL,dwStyles,rt,this,0);
		pCharView->m_inst=cit;
		pCharView->m_api=m_api;

		pCharView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pCharView->OnInitialUpdate();
		m_Tab.AddTab(1,pCharView);
		AddAnchor(pCharView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(2, APL_T(""),2);
		pDocsView=(CaplDocsView*)(RUNTIME_CLASS(CaplDocsView)->CreateObject());
		pDocsView->Create(NULL,NULL,dwStyles,rt,this,0);
		pDocsView->m_inst=cit;
		pDocsView->m_api=m_api;

		pDocsView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pDocsView->OnInitialUpdate();
		m_Tab.AddTab(2,pDocsView);
		AddAnchor(pDocsView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(3, APL_T(" "),3);
		pApprView=(CaplApprovalView*)(RUNTIME_CLASS(CaplApprovalView)->CreateObject());
		pApprView->Create(NULL,NULL,dwStyles,rt,this,0);
		pApprView->m_inst=cit;
		pApprView->m_api=m_api;

		pApprView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pApprView->OnInitialUpdate();
		m_Tab.AddTab(3,pApprView);
		AddAnchor(pApprView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);
	}

	if(NULL==cit)
		m_Tab.InsertItem(1, APL_T(""),17);
	else
		m_Tab.InsertItem(4, APL_T(""),17);

	pAccView=(CaplAccessView*)(RUNTIME_CLASS(CaplAccessView)->CreateObject());
	pAccView->Create(NULL,NULL,dwStyles|LVS_NOSORTHEADER,rt,this,0);
	pAccView->m_inst=cit;
	pAccView->m_api=m_api;

	pAccView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
	pAccView->OnInitialUpdate();
	if(NULL==cit)
		m_Tab.AddTab(1,pAccView);
	else
		m_Tab.AddTab(4,pAccView);
	if(NULL==cit)
	{
		CString	csAccPatName;
		
		CaplEntity* et=NULL;

		et=m_api->m_bp_mgr.e_bp;
		if(NULL!=et)
			if(true==m_api->m_bp_mgr.m_AutoUsurpire)
				if(TRUE==m_api->m_options_mgr.GetDefTmplName(et,csAccPatName))
					pAccView->SetDefaultTemplate(csAccPatName);
	}

	AddAnchor(pAccView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

	return TRUE;
}

void CBPDlg::ChangeViewBtnsState(BOOL bDis,BOOL bHide)
{
	CWnd*	pwnd	=NULL;

	int		iIDs[]={IDC_B_PROPS_ADD_BP,IDC_B_PROPS_DEL_BP,IDC_B_PROPS_PROPS_BP};
	int		iShow=SW_SHOW;
	int		i;

	if(TRUE==bHide)
		iShow=SW_HIDE;

	for(i=0;i<sizeof(iIDs)/sizeof(int);i++)
	{
		pwnd=GetDlgItem(iIDs[i]);
		pwnd->EnableWindow(bDis);
		pwnd->ShowWindow(iShow);
	}
}

void CBPDlg::GetAccessString(void)
{
	CaplAccessView*	pAccView	=NULL;

	CWnd*			pwnd		=NULL;

	int				i;
	
	for(i=0;i<m_Tab.GetItemCount();i++)
	{
		m_Tab.GetTabView(i,pwnd);
		if(pwnd!=NULL)
			if(pwnd->IsKindOf(RUNTIME_CLASS(CaplAccessView)))
			{
				pAccView=(CaplAccessView*)pwnd;
				pAccView->GetAccessString(m_csAccessString);
			}
	}
}


/////////////////////////////////////////////////////////////////////////////
// CBPDlg message handlers

BOOL CBPDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();

	int i;

	{	//  Tab-   
		CRect rectTab,rectCancel;
		m_Tab.GetWindowRect(rectTab);
		m_cancel_btn.GetWindowRect(rectCancel);
		rectTab.bottom=rectCancel.top-5;
		rectTab.right=rectCancel.right;
		ScreenToClient(rectTab);
		m_Tab.MoveWindow(rectTab);
	}

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_top_btn.SetIcon(GetAplTableIco(APL_TABLE_TOP));
	m_bottom_btn.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));

	m_check_out_ctrl.SetFlat(false);
	m_check_in_ctrl.SetFlat(false);
	m_undo_check_out_ctrl.SetFlat(false);

	m_bPropsAdd.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_bPropsAdd.SetFlat(FALSE);
	m_bPropsDel.SetIcon(GetAplStdIco16(APLSTDICO_MINUS));
	m_bPropsDel.SetFlat(FALSE);
	m_bPropsProps.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_bPropsProps.SetFlat(FALSE);

	InitViews();

	int color_mode=0;
	if(aplGetBitPerPixel(this)>8) 
		color_mode=1;
	
	m_check_out_ctrl.SetIcon(GetAplCheckIco(APL_ICON_CHECKOUT,color_mode)); 
	m_check_in_ctrl.SetIcon(GetAplCheckIco(APL_ICON_CHECKIN,color_mode)); 
	m_undo_check_out_ctrl.SetIcon(GetAplCheckIco(APL_ICON_UNDOCHECKOUT,color_mode)); 

	RECT r1;
	m_undo_check_out_ctrl.GetWindowRect(&r1);
	ScreenToClient(&r1);
	m_check_out_ctrl.MoveWindow(&r1);

	m_check_out_ctrl.SetTooltipText(APL_T("  "));
	m_check_in_ctrl.SetTooltipText(APL_T(" "));
	m_undo_check_out_ctrl.SetTooltipText(APL_T(" ")); 

	m_btn_add.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_btn_add.SetTooltipText( APL_T("  -"));
	m_btn_add.SetFlat(FALSE);

	if(!m_base_bp) 
		m_btn_add.ShowWindow(false);
	
	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	m_ico_bmp.LoadMappedBitmap(IDB_ACTION_ICO,0,&cm,1);
	HBITMAP hBmpOld0=m_st_action_ico.SetBitmap(HBITMAP(m_ico_bmp));
	::DeleteObject(hBmpOld0);	
	
	if(aplGetBitPerPixel(this)>8)
	{
		m_name_bmp.LoadMappedBitmap(IDB_ACTION_NAME,0,&cm,1);
		m_name_qm_bmp.LoadMappedBitmap(IDB_ACTION_QM,0,&cm,1);
	}
	else
	{
		m_name_bmp.LoadMappedBitmap(IDB_ACTION_NAME_16,0,&cm,1);
		m_name_qm_bmp.LoadMappedBitmap(IDB_ACTION_QM_16,0,&cm,1);
	}

	HBITMAP hBmpOld=m_st_bp_name.SetBitmap(HBITMAP(m_name_bmp));
	::DeleteObject(hBmpOld);

	m_elements.InsertColumn(0, APL_T(""),LVCFMT_LEFT,25);
	m_elements.InsertColumn(1, APL_T(""),LVCFMT_LEFT,100);
	m_elements.InsertColumn(2, APL_T(""),LVCFMT_LEFT,150);
	m_elements.InsertColumn(3, APL_T(""),LVCFMT_LEFT,200);

    ListView_SetExtendedListViewStyle(m_elements.m_hWnd,
		ListView_GetExtendedListViewStyle(m_elements.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);

	//  -
	aplExtent ext;
	CString buf=_T("");
	int j;
	m_data->GetEntityExtent(m_bp_mgr->e_bp_type,ext);
	for(i=0;i<ext.Size;i++)
	{
		m_data->GetAttr(ext[i],m_bp_mgr->a_bp_type_name,buf);
		j=m_type_ctrl.AddString(buf);
		m_type_ctrl.SetItemData(j,(long)ext[i]);

	}
	j=m_type_ctrl.AddString(_T(""));
	m_type_ctrl.SetItemData(j,0);
	if(m_type!=0)
	{
		for(i=0;i<m_type_ctrl.GetCount();i++)
		{
			j=m_type_ctrl.GetItemData(i);
			if(j==(long)m_type) 
			{ 
				m_type_ctrl.SetCurSel(i);
				break;
			}
		}
	}

	if(m_bp_ref)
	{
		if(m_bp->GetAccessmode()==aplOWN)
		{
			m_context_sel.EnableWindow(TRUE);
			m_ok_btn.EnableWindow(TRUE);
		}
		m_data->GetAttr(m_bp_ref,m_bp_mgr->a_bp_ref_frames_of_reference,m_bp_ref_contexts);
		if(m_bp_ref_contexts.GetSize()>0)
			m_bp_mgr->PrintItemContextInString(m_bp_ref_contexts,buf);
		else 
			buf=S::all_context();
		
		m_context_names.SetWindowText(buf);
	}

	if(!m_bp_ref && m_item)	
	{
		m_context_sel.EnableWindow(TRUE);
		if(m_context)
		{
			m_bp_ref_contexts.Add(m_context);
			m_bp_mgr->PrintItemContextInString(m_bp_ref_contexts,buf);
		}
		else
			buf=S::all_context();
		m_context_names.SetWindowText(buf);
	}

	SetFromInst();
	SetReadOnlyItems();

	m_Tab.InitStates();
	SetAnchors();

	return TRUE;
}
void CBPDlg::UpdateElements()
{
	int k=m_elements.GetNextItem(-1,LVNI_SELECTED);
	m_elements.DeleteAllItems();
	if(m_bp==0) return;
	if(m_bp->GetType()==0) return;
	CaplInstance *inst;
	CaplAggr aggr0;
	CString buf;
	CaplInstance *bp_lock=0;
	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
	{
		bp_lock=m_bp_mgr->CheckMyLock(m_bp,false);
		if(bp_lock) m_data->GetAttr(bp_lock,m_bp_mgr->a_bp_ver_elements,aggr0);	
		else m_data->GetAttr(m_bp,m_bp_mgr->a_bp_elements,aggr0);	
	}
	else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_elements,aggr0);	

	for(int i=0;i<aggr0.GetSize();i++)
	{
		aggr0.GetByIndex(i,inst);
		if(inst==0) continue;
		buf.Format(_T("%3i"),i+1);
		int k=m_elements.InsertItem(i,buf);
		m_elements.SetItemData(k,(long)inst);
		CaplInstance *lock=m_bp_mgr->CheckMyLock(inst,false);
		CString id=_T(""),name=_T(""),descr=_T("");
		if(lock)
		{
			m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_id,id);
			m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_name,name);
			m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_descr,descr);
		}
		else
		{
			m_data->GetAttr(inst,m_bp_mgr->a_bp_id,id);
			m_data->GetAttr(inst,m_bp_mgr->a_bp_name,name);
			m_data->GetAttr(inst,m_bp_mgr->a_bp_descr,descr);
		}
		m_elements.SetItemText(k,1,id);
		m_elements.SetItemText(k,2,name);
		m_elements.SetItemText(k,3,descr);
	}

	if(k>0&&k<m_elements.GetItemCount())
		m_elements.SetItemState(k,LVIS_SELECTED| LVIS_FOCUSED|LVIS_DROPHILITED,-1);
	if(m_ReadOnly || !m_elements.GetItemCount())
	{
		m_top_btn.ShowWindow(SW_HIDE);
		m_bottom_btn.ShowWindow(SW_HIDE);
	}
	else 
	{
		m_top_btn.ShowWindow(SW_SHOW);
		m_bottom_btn.ShowWindow(SW_SHOW);
	}


}

void CBPDlg::OnOK() 
{
	if(!SaveChanges())
		return;

	GetAccessString();

	CResizableDialog::OnOK();
}

void CBPDlg::OnElTop() 
{
	if(m_ReadOnly) return;
	CaplAggr aggr0;
	CaplInstance *bp_lock=0;
	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
	{
		bp_lock=m_bp_mgr->CheckMyLock(m_bp,false);
		if(bp_lock) m_data->GetAttr(bp_lock,m_bp_mgr->a_bp_ver_elements,aggr0);	
		else m_data->GetAttr(m_bp,m_bp_mgr->a_bp_elements,aggr0);	
	}
	else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_elements,aggr0);	
	int k=m_elements.GetNextItem(-1,LVNI_SELECTED)-1;
	int k1=k+1;
	
	if(k<0)  return;
	if(k>aggr0.GetSize()-2) return;
	
	m_changed_aggr=true;
	CaplValue *v=aggr0.aggr.Data[k1];
	aggr0.aggr.Data[k1]=aggr0.aggr.Data[k];
	aggr0.aggr.Data[k]=v;
	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp) && !bp_lock)
		m_data->PutAttr(m_bp,m_bp_mgr->a_bp_elements,aggr0);	
	else 
	{
		if(bp_lock) m_data->PutAttr(bp_lock,m_bp_mgr->a_bp_ver_elements,aggr0);	
		else m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_elements,aggr0);	
	}	
	m_elements.SetItemState(k,LVIS_SELECTED| LVIS_FOCUSED,-1);
	UpdateElements();}

void CBPDlg::OnElBottom() 
{
	if(m_ReadOnly) return;
	CaplAggr aggr0;
	CaplInstance *bp_lock=0;
	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
	{
		bp_lock=m_bp_mgr->CheckMyLock(m_bp,false);
		if(bp_lock) m_data->GetAttr(bp_lock,m_bp_mgr->a_bp_ver_elements,aggr0);	
		else m_data->GetAttr(m_bp,m_bp_mgr->a_bp_elements,aggr0);	
	}
	else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_elements,aggr0);	
	int k=m_elements.GetNextItem(-1,LVNI_SELECTED);
	int k1=k+1;
	
	if(k<0)  return;
	if(k>aggr0.GetSize()-2) return;
	
	m_changed_aggr=true;
	CaplValue *v=aggr0.aggr.Data[k1];
	aggr0.aggr.Data[k1]=aggr0.aggr.Data[k];
	aggr0.aggr.Data[k]=v;

	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp) && !bp_lock)
		m_data->PutAttr(m_bp,m_bp_mgr->a_bp_elements,aggr0);	
	else 
	{
		if(bp_lock) m_data->PutAttr(bp_lock,m_bp_mgr->a_bp_ver_elements,aggr0);	
		else m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_elements,aggr0);	
	}
	m_elements.SetItemState(k+1,LVIS_SELECTED| LVIS_FOCUSED,-1);
	UpdateElements();
}

void CBPDlg::OnDblclkElements(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;
	int k=lpnmitem->iItem;
	if(k<0||k>m_elements.GetItemCount()-1) return;
	CaplInstance *act=(CaplInstance*)m_elements.GetItemData(k);
	if(act==0) return;
	if(m_bp_mgr->ShowBPProperties(act))
		UpdateElements();

}

void CBPDlg::OnSelchangeActType() 
{
	int i=m_type_ctrl.GetCurSel();
	if(i>=0)m_type=(CaplInstance*)m_type_ctrl.GetItemData(i);

	bool  bQM=false;
	if(m_type!=0)
	{
		CString buf;
		m_data->GetAttr(m_type,m_bp_mgr->a_bp_type_name,buf);
		if(buf.Find(_T("QM"))>=0) bQM=true;
	}
	HBITMAP hBmpOld=0;
	
	if(bQM) hBmpOld=m_st_bp_name.SetBitmap(HBITMAP(m_name_qm_bmp));
	else hBmpOld=m_st_bp_name.SetBitmap(HBITMAP(m_name_bmp));
	//if(hBmpOld!=0)::DeleteObject(hBmpOld);
}

void CBPDlg::OnStActionName() 
{
	// TODO: Add your control notification handler code here
	CString text,buf;
//	if(((GetKeyState(VK_LMENU) & 0xff00)!=0)&&((GetKeyState(VK_RMENU) & 0xff00)!=0)){
	if(((GetKeyState(VK_LMENU) )!=0)&&((GetKeyState(VK_RMENU) )!=0)){
		text.Format(_T("\n"));
		if(m_bp!=0){buf.Format(_T("m_bp->id %i;\n"),m_bp->GetId());text+=buf;}else{buf.Format(_T("m_bp==0;\n"));}
		if(m_base_bp!=0){buf.Format(_T("m_base_bp->id %i;\n"),m_base_bp->GetId());text+=buf;}else{buf.Format(_T("m_base_bp==0;\n"));}
		if(m_item!=0){buf.Format(_T("m_item->id %i;\n"),m_item->GetId());text+=buf;}else{buf.Format(_T("m_item==0;\n"));}
		if(m_context!=0){buf.Format(_T("m_context->id %i;\n"),m_context->GetId());text+=buf;}else{buf.Format(_T("m_context==0;\n"));}
		if(m_type!=0){buf.Format(_T("m_type->id %i;\n"),m_type->GetId());text+=buf;}else{buf.Format(_T("m_type==0;\n"));}
		if(m_bp_ref!=0){buf.Format(_T("m_bp_ref->id %i;\n"),m_bp_ref->GetId());text+=buf;}else{buf.Format(_T("m_bp_ref==0;\n"));}
		AfxMessageBox(text);
	}
	
}

void CBPDlg::OnContextSel() 
{
	// TODO: Add your control notification handler code here
	if(m_bp_mgr->ChangeItemContext(m_bp_ref_contexts))
	{
		CString buf;
		if(m_bp_ref_contexts.GetSize()>0)
			m_bp_mgr->PrintItemContextInString(m_bp_ref_contexts,buf);
		else buf=S::all_context();
		m_context_names.SetWindowText(buf);
		m_context_changed=true;
	}	
}

void CBPDlg::OnCheckOut() 
{
	if(m_bp_mgr->CheckOutWithRequest(m_bp))
	{
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_lock,m_bp);
		if(m_bp)
		{
			m_check_out_ctrl.ShowWindow(SW_HIDE);
			m_check_in_ctrl.ShowWindow(SW_SHOW);
			m_undo_check_out_ctrl.ShowWindow(SW_SHOW);
			m_ReadOnly=false;
			SetWindowText( APL_T(" -"));
			SetReadOnlyItems();
		}
	}

}

void CBPDlg::OnCheckIn() 
{
	CaplInstance *bp_ver_bp=0;
	m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_bp,bp_ver_bp);
	if(bp_ver_bp)
	{
		if(!SaveChanges()) return;
				
		if(m_bp_mgr->CheckInWithRequest(bp_ver_bp))
		{
			m_check_out_ctrl.ShowWindow(SW_SHOW);
			m_check_in_ctrl.ShowWindow(SW_HIDE);
			m_undo_check_out_ctrl.ShowWindow(SW_HIDE);
			m_ReadOnly=true;
			SetWindowText( APL_T("-"));
			SetReadOnlyItems();
			m_bp=bp_ver_bp;
		}
	}
}

void CBPDlg::OnUndoCheckOut() 
{
	CaplInstance *bp_ver_bp=0;
	m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_bp,bp_ver_bp);
	if(bp_ver_bp)
	{
		if(m_bp_mgr->UndoCheckOutWithRequest(bp_ver_bp))
		{
			m_check_out_ctrl.ShowWindow(SW_SHOW);
			m_check_in_ctrl.ShowWindow(SW_HIDE);
			m_undo_check_out_ctrl.ShowWindow(SW_HIDE);
			m_ReadOnly=true;
			SetReadOnlyItems();
			m_bp=bp_ver_bp;
			SetFromInst();
		}
	}	
}

void CBPDlg::SetReadOnlyItems()
{
	m_act_id_ctrl.SetReadOnly(m_ReadOnly);
	m_act_name_ctrl.SetReadOnly(m_ReadOnly);
	m_act_descr_ctrl.SetReadOnly(m_ReadOnly);

	if(m_bp_mgr->IsAdmin()) m_act_code_ctrl.SetReadOnly(m_ReadOnly);
	if(!m_bp_mgr->m_bUseVersions || !m_bp) 
	{
		m_check_out_ctrl.ShowWindow(SW_HIDE);
		m_check_in_ctrl.ShowWindow(SW_HIDE);
		m_undo_check_out_ctrl.ShowWindow(SW_HIDE);
		m_top_btn.ShowWindow(SW_HIDE);
		m_bottom_btn.ShowWindow(SW_HIDE);
	}
	m_type_ctrl.EnableWindow(!m_ReadOnly);
	m_customized_ctrl.EnableWindow(!m_ReadOnly);
	m_optional_ctrl.EnableWindow(!m_ReadOnly);
	m_ok_btn.EnableWindow(!m_ReadOnly);
	m_btn_add.EnableWindow(!m_ReadOnly);
	if(m_ReadOnly)
	{
		m_top_btn.ShowWindow(SW_HIDE);
		m_bottom_btn.ShowWindow(SW_HIDE);
	}
	else if(m_elements.GetItemCount())
	{
		m_top_btn.ShowWindow(SW_SHOW);
		m_bottom_btn.ShowWindow(SW_SHOW);
	}
	if(m_bp_ref) m_context_sel.EnableWindow(!m_ReadOnly);
	m_act_label_ctrl.SetReadOnly(m_ReadOnly);
}

bool CBPDlg::SaveChanges()
{
	// TODO: Add extra validation here
	UpdateData(TRUE);

	//  
	m_act_id.TrimLeft();
	m_act_id.TrimRight();
	m_act_name.TrimLeft();
	m_act_name.TrimRight();
	m_act_descr.TrimLeft();
	m_act_descr.TrimRight();
	m_act_code.TrimLeft();
	m_act_code.TrimRight();

	if(m_act_id==_T("")) {AfxMessageBox( APL_T(" \"\"   !")); return false;}
	
	CaplInstance *inst=m_bp;
	if(inst)
		if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_bp,inst);

	CaplInstance *parent_inst=m_base_bp;
	if(!parent_inst && inst) m_data->GetAttr(inst,m_bp_mgr->a_bp_parent,parent_inst);
	if(parent_inst)
		if(m_data->IsKindOf(parent_inst,m_bp_mgr->e_apl_bp_ver))
			m_data->GetAttr(parent_inst,m_bp_mgr->a_bp_ver_bp,parent_inst);

	CString buf=_T("");
	
	if(inst) m_data->GetAttr(inst,m_bp_mgr->a_bp_id,buf);
	
	if(buf!=m_act_id)
	{
		//  id
		CaplAttrValue tst_values[2];               

		tst_values[0].value.Set((LPCTSTR)m_act_id); 
		tst_values[0].attr=m_bp_mgr->a_bp_id;      
		tst_values[1].value.Set(parent_inst);
		tst_values[1].attr=m_bp_mgr->a_bp_parent;

		bool b_unique=true;
		aplExtent ext_existing;
		m_data->NET_FindInstancesWithAttrValues(m_bp_mgr->e_bp,2,&tst_values[0], ext_existing,false);
		if(ext_existing.GetSize())
		//if(!m_data->NET_TestUniqueAttrValues(m_bp_mgr->e_bp,inst,2,&tst_values[0], false))
		{
			b_unique=false;
		}
		if(b_unique && parent_inst)
		{
			//,    id   
			aplExtent ext_elems,ext;
			m_data->GetAttr(parent_inst,m_bp_mgr->a_bp_elements,ext_elems);
			CaplInstance *parent_lock=m_bp_mgr->CheckMyLock(parent_inst,false);
			if(parent_lock) 
			{
				m_data->GetAttr(parent_lock,m_bp_mgr->a_bp_ver_elements,ext);
				ext_elems.Append(ext);
			}
			for(int i=0;i<ext_elems.GetSize();i++)
			{
				if(ext_elems[i]!=inst)
				{
					CaplInstance *lock=m_bp_mgr->CheckMyLock(ext_elems[i],false);
					if(lock) 
					{
						m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_id,buf);
						if(buf==m_act_id){b_unique=false;break;}
					}
				}
			}
		}
		if(!b_unique)
		{
			AfxMessageBox( APL_T("-        !!!"));
			return false;
		}
	}
	buf=_T("");
	if(inst)
	{
		m_data->GetAttr(inst,m_bp_mgr->a_bp_code,buf);
	}
	if(buf!=m_act_code)
	{
		//  
		CaplAttrValue tst_code_values[1];               

		tst_code_values[0].value.Set((LPCTSTR)m_act_code); 
		tst_code_values[0].attr=m_bp_mgr->a_bp_code;      
		aplExtent ext_existing;
		m_data->NET_FindInstancesWithAttrValues(m_bp_mgr->e_bp,1,&tst_code_values[0], ext_existing,false);
		if(ext_existing.GetSize())
		{
	
			AfxMessageBox( APL_T("-        !!!"));
			return false;
		}
	}
	bool create_zero_version=false;// ,   
	if(m_bp==0) 
	{
		m_bp=m_data->CreateInstance(m_bp_mgr->e_bp);
		if(!m_bp) 
		{
			AfxMessageBox( APL_T("   -!"));
			return false;
		}
		create_zero_version=true;
	}

	CaplInstance *type=0;
	int i=m_type_ctrl.GetCurSel();
	if(i>=0)type=(CaplInstance*)m_type_ctrl.GetItemData(i);

	if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
	{
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_parent,inst);
		if(inst!=m_base_bp) 
		{
			if(m_base_bp)
			{
				if(m_data->IsKindOf(m_base_bp,m_bp_mgr->e_apl_bp_ver))
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_ver_bp,m_base_bp);
				if(m_base_bp) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_parent,m_base_bp);
			}
		}

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_id,buf);
		if(buf!=m_act_id) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_id,m_act_id);	

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_name,buf);
		if(buf!=m_act_name) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_name,m_act_name);

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_descr,buf);
		if(buf!=m_act_descr) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_descr,m_act_descr);
	
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_code,buf);
		if(buf!=m_act_code) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_code,m_act_code);

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_label,buf);
		if(buf!=m_act_label) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_label,m_act_label);

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_type,inst);
		if(inst!=type) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_type,type);

		bool bOld=false, bNew=false;
		bNew=m_customized_ctrl.GetCheck()? true: false;
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_customized,bOld);
		if(bOld!=bNew) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_customized,bNew);

		bNew=m_optional_ctrl.GetCheck()? true: false;
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_optional,bOld);
		if(bOld!=bNew) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_optional,bNew);

	}
	else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
	{
		if(m_bp==0) return false;

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_id,buf);
		if(buf!=m_act_id) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_id,m_act_id);	

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_name,buf);
		if(buf!=m_act_name) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_name,m_act_name);

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_descr,buf);
		if(buf!=m_act_descr) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_descr,m_act_descr);
	
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_code,buf);
		if(buf!=m_act_code) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_code,m_act_code);

		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_label,buf);
		if(buf!=m_act_label) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_label,m_act_label);
	
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_type,inst);
		if(inst!=type) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_type,type);

		bool bOld=false, bNew=false;
		bNew=m_customized_ctrl.GetCheck() ? true : false;
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_customized,bOld);
		if(bOld!=bNew) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_customized,bNew);

		bNew=m_optional_ctrl.GetCheck() ? true : false;
		m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_optional,bOld);
		if(bOld!=bNew) m_data->PutAttr(m_bp,m_bp_mgr->a_bp_ver_optional,bNew);
	}
	if(m_item && !m_bp_ref) 
	{
		m_bp_ref=m_bp_mgr->CreateAssociation(m_item,m_bp);
		m_context_changed=true;
	}
	
	if(m_bp_ref)
	{
		if(m_context_changed)
		{
			if(m_bp_ref_contexts.GetSize()>0)
				m_data->PutAttr(m_bp_ref,m_bp_mgr->a_bp_ref_frames_of_reference,m_bp_ref_contexts);
			else
			{
				CaplValue empty_val;
				m_data->PutAttr(m_bp_ref,m_bp_mgr->a_bp_ref_frames_of_reference,empty_val);
			}
		}
	}
	return true;
}

void CBPDlg::SetFromInst()
{
	int i,j;
	CString buf;
	aplExtent ext;
	CaplInstance *inst=0;

	if(m_bp!=0)
	{
		CaplInstance *lock=0;
		if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
		{
			if(m_bp_mgr->m_bUseVersions) 
			{
				m_check_in_ctrl.ShowWindow(SW_HIDE);
				m_undo_check_out_ctrl.ShowWindow(SW_HIDE);
				m_ReadOnly=true;
				if(m_bp->GetAccessmode()<aplRO)
				{
					m_data->GetAttr(m_bp,m_bp_mgr->a_bp_lock,lock);
					if(lock) m_check_out_ctrl.ShowWindow(SW_HIDE);
				}
				else
					m_check_out_ctrl.ShowWindow(SW_HIDE);
			}
			
			
			SetWindowText( APL_T("-"));
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_id,buf);
			m_act_id_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_name,buf);
			m_act_name_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_descr,buf);
			m_act_descr_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_code,buf);
			m_act_code_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_label,buf);
			m_act_label_ctrl.SetWindowText(buf);
			bool b=false;
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_customized,b);
			m_customized_ctrl.SetCheck(b?TRUE:FALSE);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_optional,b);
			m_optional_ctrl.SetCheck(b?TRUE:FALSE);

			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_parent,inst);
			if(inst)
			{
				if(inst->GetAccessmode()<aplNO)
				{
					m_data->GetAttr(inst,m_bp_mgr->a_bp_id,buf);
					m_act_parent_ctrl.SetWindowText(buf);		
				}
			}
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_type,inst);
		}
		else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver))
		{
			m_check_out_ctrl.ShowWindow(SW_HIDE);
			CaplInstance *bp_ver_bp=0;
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_bp,bp_ver_bp);
			lock=m_bp_mgr->CheckMyLock(bp_ver_bp,false);
			if(!lock || lock!=m_bp) 
			{
				m_check_in_ctrl.ShowWindow(SW_HIDE);
				m_undo_check_out_ctrl.ShowWindow(SW_HIDE);
				m_ReadOnly=true;
			}

			SetWindowText( APL_T(" -"));
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_id,buf);
			m_act_id_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_name,buf);
			m_act_name_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_descr,buf);
			m_act_descr_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_code,buf);
			m_act_code_ctrl.SetWindowText(buf);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_label,buf);
			m_act_label_ctrl.SetWindowText(buf);
			bool b=false;
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_customized,b);
			m_customized_ctrl.SetCheck(b?TRUE:FALSE);
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_optional,b);
			m_optional_ctrl.SetCheck(b?TRUE:FALSE);

			if(bp_ver_bp) m_data->GetAttr(bp_ver_bp,m_bp_mgr->a_bp_parent,inst);
			if(inst)
			{
				if(inst->GetAccessmode()<aplNO)
				{
					m_data->GetAttr(inst,m_bp_mgr->a_bp_id,buf);
					m_act_parent_ctrl.SetWindowText(buf);		
				}
			}
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_ver_type,inst);

		}
		if(inst!=0)
		{
			for(i=0;i<m_type_ctrl.GetCount();i++)
			{
				j=m_type_ctrl.GetItemData(i);
				if(j==(int)inst) { m_type_ctrl.SetCurSel(i); break;	}
			}
		}
		UpdateElements();
		OnSelchangeActType();
		
		if(m_bp->GetAccessmode()>=aplRO)
			m_ReadOnly=true;
		if(m_ReadOnly)
			SetReadOnlyItems();

	}
	else if(m_base_bp!=0)
	{
		if(m_base_bp->GetAccessmode()<aplNO)
		{
			CaplInstance *lock=0;
			if(m_bp_mgr->m_bUseVersions)
			{
				if(m_data->IsKindOf(m_base_bp,m_bp_mgr->e_bp))
					lock=m_bp_mgr->CheckMyLock(m_base_bp,false);
				else if(m_data->IsKindOf(m_base_bp,m_bp_mgr->e_apl_bp_ver))
					lock=m_base_bp;
				if(lock) m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_id,buf);
				else m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_id,buf);
			}
			else
				m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_id,buf);
				
			m_act_parent_ctrl.SetWindowText(buf);		

			if(m_creation_mode==APL_MODE_COPY_BP)
			{
				if(!lock)
				{
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_id,buf);
					m_act_id_ctrl.SetWindowText(buf);
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_name,buf);
					m_act_name_ctrl.SetWindowText(buf);
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_descr,buf);
					m_act_descr_ctrl.SetWindowText(buf);
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_code,buf);
					m_act_code_ctrl.SetWindowText(buf);
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_label,buf);
					m_act_label_ctrl.SetWindowText(buf);

					bool b=false;
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_customized,b);
					m_customized_ctrl.SetCheck(b?TRUE:FALSE);
					m_data->GetAttr(m_base_bp,m_bp_mgr->a_bp_optional,b);
					m_optional_ctrl.SetCheck(b?TRUE:FALSE);				}
				else 
				{
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_id,buf);
					m_act_id_ctrl.SetWindowText(buf);
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_name,buf);
					m_act_name_ctrl.SetWindowText(buf);
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_descr,buf);
					m_act_descr_ctrl.SetWindowText(buf);
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_code,buf);
					m_act_code_ctrl.SetWindowText(buf);
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_label,buf);
					m_act_label_ctrl.SetWindowText(buf);	

					bool b=false;
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_customized,b);
					m_customized_ctrl.SetCheck(b?TRUE:FALSE);
					m_data->GetAttr(lock,m_bp_mgr->a_bp_ver_optional,b);
					m_optional_ctrl.SetCheck(b?TRUE:FALSE);				}
			}
		}
	}

}

void LoadContextMenuIcon();

void CBPDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	if(m_ReadOnly) return;
	//if(!m_bp) return;
	int i=0,j=0;
	CaplInstance *sel_bp=0;
	if(false==PointToVal(&point,i,&sel_bp)) return;

    CMenu menu;CMenu* pPopup;
    VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
	LoadContextMenuIcon();
	CaplMenu::Install(this);
	

	pPopup = menu.GetSubMenu(4);
    if(!sel_bp)
	{
		pPopup->RemoveMenu(ID_DELETE_BP_REL, MF_BYCOMMAND );
		pPopup->RemoveMenu(ID_DELETE_BP, MF_BYCOMMAND );
	}
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON |TPM_RETURNCMD,	point.x, point.y,this); // use main window for cmds

	switch(res)
	{
		case ID_CREATE_BP:
			{
				CreateSubBP();
			}
			break;
		case ID_DELETE_BP_REL:
			{
				if(AfxMessageBox( APL_T("     ?"),MB_YESNO)==IDYES)
				{
					if(m_bp_mgr->DeleteBPRelation(sel_bp,m_bp)) 
						UpdateElements();
				}
			}
			break;
		case ID_DELETE_BP:
			{
				if(AfxMessageBox( APL_T("    - ?"),MB_YESNO)==IDYES)
				{
					if(m_bp_mgr->DeleteBP(sel_bp)) UpdateElements();
				}
			}
			break;

	}
	
}

bool CBPDlg::PointToVal(CPoint *point, int &i,CaplInstance **inst)
{
	*inst=0;

	if(point!=0)
	{
		i=-1; 
				
		CRect rect;
		m_elements.GetWindowRect(&rect);
		if(!rect.PtInRect(*point)) return false;

		CPoint m_point_context_menu=*point;
		m_elements.ScreenToClient(&m_point_context_menu);
	
		//    header
		CHeaderCtrl*head= m_elements.GetHeaderCtrl();
		head->GetWindowRect(&rect);
		if(rect.PtInRect(*point)) return false;

		LVHITTESTINFO lvhti;
		lvhti.pt = m_point_context_menu;
		m_elements.SubItemHitTest(&lvhti);
		
		i=lvhti.iItem;
		if(i<0) return true;
	}

	*inst=(CaplInstance*)m_elements.GetItemData(i);
	
	return true;
}

void CBPDlg::OnAddBp() 
{
	if(!SaveChanges()) return;
	m_add_mode=true;
	CResizableDialog::EndDialog(IDOK);

}

void CBPDlg::CreateSubBP()
{
	CaplInstance *bp=m_bp;
	if(!m_bp)
	{
		if(IDYES!=AfxMessageBox( APL_T("     \n  -\n ?"),
			MB_YESNO|MB_ICONQUESTION)) return;
		if(!SaveChanges()) return;
		if(!m_bp) return;
		bp=m_bp;
		CaplInstance *lock=0;
		if(m_data->IsKindOf(m_bp,m_bp_mgr->e_bp))
		{
			m_data->GetAttr(m_bp,m_bp_mgr->a_bp_lock,lock);
		}
		else if(m_data->IsKindOf(m_bp,m_bp_mgr->e_apl_bp_ver)) 
		{
			lock=m_bp;
		}
		if(lock)
		{
			m_bp=lock;
			m_check_out_ctrl.ShowWindow(SW_HIDE);
			m_check_in_ctrl.ShowWindow(SW_SHOW);
			m_undo_check_out_ctrl.ShowWindow(SW_SHOW);
			m_ReadOnly=false;
			SetWindowText( APL_T(" -"));
			SetReadOnlyItems();
		}
	}
	m_bp_mgr->CreateBP(bp);
	UpdateElements();

}

void CBPDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CaplPropsView* pView	=NULL;
	
	BOOL	bDis	=TRUE;
	BOOL	bHide	=FALSE;

	if(0==m_Tab.GetCurSel())
		bDis=FALSE;

	ChangeViewBtnsState(bDis,!bDis);

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	if(NULL!=pView)
	{
		pView->InitView();
		pView->ChangeCtrlsState();
	}
	
	*pResult = 0;
}

void CBPDlg::OnBPropsAdd() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBAdd();
}

void CBPDlg::OnBPropsDel() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBDel();
}

void CBPDlg::OnBPropsProps() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBProps();
}
