// PersonPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PersonPropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPersonPropDlg dialog


CPersonPropDlg::CPersonPropDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CPersonPropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPersonPropDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=0;
	m_person=0;
	m_sFirstName = _T("");
	m_sID = _T("");
	m_sLastName = _T("");
	m_sMiddleName = _T("");
	m_sPrefix = _T("");

	m_bEnableEdit=false;
}


void CPersonPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPersonPropDlg)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_KEYS_LIST, m_keysList);
	DDX_Control(pDX, IDC_LISTROLE, m_listRoleDo);
	DDX_Text(pDX, IDC_PERSON_FIRSTNAME, m_sFirstName);
	DDX_Text(pDX, IDC_PERSON_ID, m_sID);
	DDX_Text(pDX, IDC_PERSON_LASTNAME, m_sLastName);
	DDX_Text(pDX, IDC_PERSON_MIDDLENAME, m_sMiddleName);
	DDX_Text(pDX, IDC_PERSON_PREFIX, m_sPrefix);
	DDX_Text(pDX, IDC_DESCRIPTION, m_sDescription);
	DDX_Text(pDX, IDC_PERSON_PHONE, m_sPhone);
	DDX_Text(pDX, IDC_PERSON_EMAIL, m_sEmail);
	DDX_Text(pDX, IDC_PERSON_CODE, m_sCode);
	DDX_Text(pDX, IDC_PERSON_ACTUAL_ADRESS, m_sActualAddress);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_PERSON_ID, m_pers_id_ctrl);
	DDX_Control(pDX, IDC_PERSON_PREFIX, m_pers_prefix_ctrl);
	DDX_Control(pDX, IDC_PERSON_LASTNAME, m_pers_last_name_ctrl);
	DDX_Control(pDX, IDC_PERSON_FIRSTNAME, m_pers_first_name_ctrl);
	DDX_Control(pDX, IDC_PERSON_MIDDLENAME, m_pers_middle_name_ctrl);
	DDX_Control(pDX, IDC_DESCRIPTION, m_pers_descr_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_PERSON_CODE, m_pers_code_ctrl);
	DDX_Control(pDX, IDC_PERSON_PHONE, m_pers_phone_ctrl);
	DDX_Control(pDX, IDC_PERSON_EMAIL, m_pers_email_ctrl);
	DDX_Control(pDX, IDC_PERSON_ACTUAL_ADRESS, m_pers_actual_address_ctrl);
	DDX_Control(pDX, IDC_LIST_ORG, m_list_org);
}


BEGIN_MESSAGE_MAP(CPersonPropDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CPersonPropDlg)
	//}}AFX_MSG_MAP
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ORG, &CPersonPropDlg::OnNMDblclkListOrg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPersonPropDlg message handlers

BOOL CPersonPropDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	if(0==m_api) {EndDialog(0); return FALSE;}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));


	AddAnchor(ID_ST_ROLE_HEAD,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_LISTROLE,TOP_LEFT,TOP_RIGHT);
	AddAnchor(ID_ST_ORG_HEAD,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDC_LIST_ORG,TOP_LEFT,MIDDLE_RIGHT);
	AddAnchor(ID_ST_KEYS_HEAD,MIDDLE_LEFT,MIDDLE_RIGHT);
	AddAnchor(IDC_KEYS_LIST,MIDDLE_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);

	int i;
	
	m_cancel_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));

	m_keysList.DeleteAllItems();
	m_keysList.InsertColumn(0,APL_T(""), LVCFMT_LEFT, 200);
	m_keysList.InsertColumn(1,APL_T(""), LVCFMT_LEFT, 70);
	m_keysList.SetColumnDate(1);
	m_keysList.InsertColumn(2,APL_T(""), LVCFMT_LEFT, 70);
	m_keysList.SetColumnDate(2);
	m_keysList.InsertColumn(3,APL_T(""), LVCFMT_LEFT, 70);
	m_keysList.SetColumnDate(3);
	m_keysList.InsertColumn(4,APL_T(" "), LVCFMT_LEFT, 450);	
	m_keysList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_list_org.InsertColumn(0,APL_T(""), LVCFMT_LEFT, 250);
	m_list_org.InsertColumn(1,APL_T(""), LVCFMT_LEFT, 70);
	m_list_org.SetColumnDate(1);
	m_list_org.InsertColumn(2,APL_T(""), LVCFMT_LEFT, 70);
	m_list_org.SetColumnDate(2);
	m_list_org.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	if(0!=m_person)
	{
		CaplAggr aggr;
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_id, m_sID);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_last_name, m_sLastName);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_first_name, m_sFirstName);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_middle_names, aggr);
		aggr.GetByIndex(0, m_sMiddleName);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_prefix_titles, aggr);
		aggr.GetByIndex(0, m_sPrefix);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_descr, m_sDescription);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_code, m_sCode);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_phone, m_sPhone);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_e_mail, m_sEmail);
		m_api->m_data.GetAttr(m_person, m_api->m_appr_mgr.a_pers_actual_address, m_sActualAddress);

		CString bufRole;
		CaplInstance *instRole=0;

		m_api->m_data.GetAttrBN(m_person, _T("apl_person_roles") , aggr);
		for(i=0; i<aggr.GetSize();i++)
		{
			aggr.GetByIndex(i, instRole);
			if(instRole==0) continue;
			if(instRole->GetType()<=0)continue;
			m_api->m_data.GetAttrBN(instRole, _T("name") , bufRole);
			int k=m_listRoleDo.AddString(bufRole);
		}
		aplExtent ext0;
		m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_po_role,ext0); 
		int numCount=m_listRoleDo.GetCount();


		//   
		aplExtent PersonsKeys;
		m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_apl_digital_sign_open_key, PersonsKeys);

		COleDateTime odt;
		int iPos= 0;
		for(i=0; i<PersonsKeys.GetSize(); i++)
		{
			CaplInstance *inst1, *perskey=PersonsKeys[i];
			m_api->m_data.GetAttr(perskey, m_api->m_appr_mgr.a_apl_digital_sign_open_key_person, inst1);
			if(m_person!=inst1) continue;
			
			CString sBuf= _T("");
			m_api->m_data.GetAttr(perskey, m_api->m_appr_mgr.a_apl_digital_sign_open_key_open_key_metod, sBuf);

			iPos=m_keysList.InsertItem(iPos, sBuf);

			m_api->m_data.GetAttr(perskey,m_api->m_appr_mgr.a_apl_digital_sign_open_not_before, sBuf);
			if(sBuf!=_T(""))
			{
				aplString2Date(sBuf,odt);
				sBuf=odt.Format(_T("%d.%m.%Y"));
				m_keysList.SetItemText(iPos, 1, sBuf);
			}

			m_api->m_data.GetAttr(perskey,m_api->m_appr_mgr.a_apl_digital_sign_open_not_after, sBuf);
			if(sBuf!=_T(""))
			{
				aplString2Date(sBuf,odt);
				sBuf=odt.Format(_T("%d.%m.%Y"));
				m_keysList.SetItemText(iPos, 2, sBuf);
			}

			m_api->m_data.GetAttr(perskey,m_api->m_appr_mgr.a_apl_digital_sign_open_revocation_date, sBuf);
			if(sBuf!=_T(""))
			{
				aplString2Date(sBuf,odt);
				sBuf=odt.Format(_T("%d.%m.%Y"));
				m_keysList.SetItemText(iPos, 3, sBuf);
			}
			m_api->m_data.GetAttr(perskey,m_api->m_appr_mgr.a_apl_digital_sign_open_key_open_key, sBuf);
			m_keysList.SetItemText(iPos, 4, sBuf);
		}
		m_keysList.SortColumn(2,false);
		
		
		// 
		CString sBuf;
		aplExtent ext_po;
		CaplInstance *pers,*org;
		m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_pers_org,ext_po);
		for(i= 0; i<ext_po.GetSize(); i++)
		{
			CaplInstance *po=ext_po[i];
			m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_po_the_pers, pers);
			if(pers!=m_person) continue;

			m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_po_the_org, org);
			if(0==org) continue;
		
			m_api->m_appr_mgr.GetItemName(org,sBuf);

			int iPos=m_list_org.InsertItem(m_list_org.GetItemCount(), sBuf);
			m_list_org.SetItemData(iPos, (long)org);

			m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_po_start_date, sBuf);
			if(sBuf!=_T(""))
			{
				aplString2Date(sBuf,odt);
				sBuf=odt.Format(_T("%d.%m.%Y"));
				m_list_org.SetItemText(iPos, 1, sBuf);
			}

			m_api->m_data.GetAttr(po, m_api->m_appr_mgr.a_po_end_date, sBuf);
			if(sBuf!=_T(""))
			{
				aplString2Date(sBuf,odt);
				sBuf=odt.Format(_T("%d.%m.%Y"));
				m_list_org.SetItemText(iPos, 2, sBuf);
			}
		}
		m_list_org.SortColumn(1,false);
	}
	
	UpdateData(FALSE);

	if(m_api->m_appr_mgr.m_bAllowCreatePersonInSelect) m_bEnableEdit=true;

	if(m_bEnableEdit)
	{
		m_pers_id_ctrl.SetReadOnly(FALSE);
		m_pers_prefix_ctrl.SetReadOnly(FALSE);
		m_pers_last_name_ctrl.SetReadOnly(FALSE);
		m_pers_first_name_ctrl.SetReadOnly(FALSE);
		m_pers_middle_name_ctrl.SetReadOnly(FALSE);
		m_pers_descr_ctrl.SetReadOnly(FALSE);

		m_pers_email_ctrl.SetReadOnly(FALSE);
		m_pers_phone_ctrl.SetReadOnly(FALSE);
		m_pers_actual_address_ctrl.SetReadOnly(FALSE);
		m_pers_code_ctrl.SetReadOnly(FALSE);

		m_ok_btn.ShowWindow(TRUE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPersonPropDlg::OnOK()
{
	if(m_bEnableEdit)
	{
		UpdateData(TRUE);

		m_sID.TrimLeft();			m_sID.TrimRight();
		m_sLastName.TrimLeft();		m_sLastName.TrimRight();
		m_sFirstName.TrimLeft();	m_sFirstName.TrimRight();
		m_sDescription.TrimLeft();	m_sDescription.TrimRight();
		m_sMiddleName.TrimLeft();	m_sMiddleName.TrimRight();
		m_sPrefix.TrimLeft();		m_sPrefix.TrimRight();

		m_sPhone.TrimLeft();	m_sPhone.TrimRight();
		m_sEmail.TrimLeft();	m_sEmail.TrimRight();
		m_sActualAddress.TrimLeft();	m_sActualAddress.TrimRight();
		m_sCode.TrimLeft();		m_sCode.TrimRight();


		if(m_sID.IsEmpty())
		{
			AfxMessageBox( APL_T("    !"),  MB_ICONSTOP|MB_OK);
			m_pers_id_ctrl.SetFocus();
			return;
		}

		//    
		CaplAttrValue tst_val;
		aplExtent ext;
		tst_val.attr = m_api->m_appr_mgr.a_pers_id;
		tst_val.value.Set(m_sID);

		if(!m_api->m_data.NET_TestUniqueAttrValues(m_api->m_appr_mgr.e_person, m_person, 1, &tst_val, false))
		{
			AfxMessageBox( APL_T("  !"), MB_ICONSTOP|MB_OK);
			m_pers_id_ctrl.SetFocus();
			return;
		}

		if(m_sLastName==_T(""))
		{
			AfxMessageBox( APL_T("  "),  MB_ICONSTOP|MB_OK);
			m_pers_last_name_ctrl.SetFocus();
			return;
		}

		if(m_person==NULL)
			m_person = m_api->m_data.CreateInstance(m_api->m_appr_mgr.e_person);

		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_id, m_sID);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_last_name, m_sLastName);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_first_name, m_sFirstName);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_descr, m_sDescription);

		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_phone, m_sPhone);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_e_mail, m_sEmail);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_actual_address, m_sActualAddress);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_code, m_sCode);

		CaplAggr aggr,aggr1;
		aggr.Add(m_sMiddleName);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_middle_names, aggr);

		aggr1.Add(m_sPrefix);
		m_api->m_data.PutAttr(m_person, m_api->m_appr_mgr.a_pers_prefix_titles, aggr1);

		m_api->SaveChanges();
	}
	CaplResizableDialog::OnOK();
}


void CPersonPropDlg::OnNMDblclkListOrg(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;

	if(0==pNMItemActivate) return;
	if(pNMItemActivate->iItem<0) return;

	CaplInstance *org=(CaplInstance *)m_list_org.GetItemData(pNMItemActivate->iItem);
	if(0==org) return;
	m_api->m_appr_mgr.ShowOrganizationProperties(org);
}
