// PersonalOptionsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "PersonalOptionsDlg.h"


// CPersonalOptionsDlg dialog

IMPLEMENT_DYNAMIC(CPersonalOptionsDlg, CaplTranslateDialog)

CPersonalOptionsDlg::CPersonalOptionsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPersonalOptionsDlg::IDD, pParent)
{
	m_api=0;
	m_person=0;
	m_iAlwaysUseHtml=0;

}

CPersonalOptionsDlg::~CPersonalOptionsDlg()
{
}

void CPersonalOptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_MAIL_TEMPLATE, m_mail_template_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_RUN_TASK_NOTIFY, m_RunTaskNotifyCtrl);
	DDX_Control(pDX, IDC_COMPLETE_TASK_NOTIFY_EXECUTOR, m_CompleteTaskNotifyExecutorCtrl);
	DDX_Control(pDX, SUSPEND_TASK_NOTIFY_EXECUTOR, m_SuspendTaskNotifyExecutorCtrl);
	DDX_Control(pDX, CANCEL_TASK_NOTIFY_EXECUTOR, m_CancelTaskNotifyExecutorCtrl);
	DDX_Control(pDX, COMPLETE_TASK_NOTIFY_OWNER, m_CompleteTaskNotifyOwnerCtrl);
	DDX_Control(pDX, COMPLETE_PROCESS_NOTIFY, m_CompleteProcessNotifyCtrl);
	DDX_Control(pDX, CANCEL_TASK_NOTIFY_OWNER, m_CancelTaskNotifyOwnerCtrl);
	DDX_Control(pDX, SUSPEND_TASK_NOTIFY_OWNER, m_SuspendTaskNotifyOwnerCtrl);
	DDX_Control(pDX, IDC_CREATE_MSG_HTML, m_create_msg_html_ctrl);
	DDX_Control(pDX, IDC_EMAIL, m_email_ctrl);
	DDX_Control(pDX, IDC_COPY_MSG_TO_EMAIL, m_copy_msg_to_email_ctrl);
	DDX_Control(pDX, IDC_PHONE, m_phone_ctrl);
	DDX_Control(pDX, IDC_ACT_ADDRESS, m_actual_address_ctrl);
}


BEGIN_MESSAGE_MAP(CPersonalOptionsDlg, CaplTranslateDialog)
END_MESSAGE_MAP()


// CPersonalOptionsDlg message handlers

void AddValuesToCtrl(CComboBox &ctrl)
{
	ctrl.InsertString(0,APL_T(" "));
	ctrl.InsertString(1,APL_T(""));
	ctrl.InsertString(2,APL_T(""));
}


BOOL CPersonalOptionsDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	AddValuesToCtrl(m_RunTaskNotifyCtrl);
	AddValuesToCtrl(m_CompleteTaskNotifyExecutorCtrl);
	AddValuesToCtrl(m_SuspendTaskNotifyExecutorCtrl);
	AddValuesToCtrl(m_CancelTaskNotifyExecutorCtrl);
	AddValuesToCtrl(m_CompleteTaskNotifyOwnerCtrl);
	AddValuesToCtrl(m_CompleteProcessNotifyCtrl);
	AddValuesToCtrl(m_CancelTaskNotifyOwnerCtrl);
	AddValuesToCtrl(m_SuspendTaskNotifyOwnerCtrl);

	// TODO:  Add extra initialization here
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	if(0==m_api) {EndDialog(0); return FALSE;}

	m_person=m_api->m_appr_mgr.GetCurrentPerson();
	if(0==m_person) {AfxMessageBox(APL_T("   !"),MB_ICONSTOP|MB_OK); EndDialog(0); return FALSE;}


	CString text,sOptions,buf;
	m_api->m_data.GetAttr(m_person,m_api->m_appr_mgr.a_pers_e_mail,buf);
	m_email_ctrl.SetWindowText(buf);

	m_api->m_data.GetAttr(m_person,m_api->m_appr_mgr.a_pers_phone,buf);
	m_phone_ctrl.SetWindowText(buf);

	m_api->m_data.GetAttr(m_person,m_api->m_appr_mgr.a_pers_actual_address,buf);
	m_actual_address_ctrl.SetWindowText(buf);

	bool b;
	m_api->m_data.GetAttr(m_person,m_api->m_appr_mgr.a_pers_send_copy_message_to_email,b);
	if(b)  m_copy_msg_to_email_ctrl.SetCheck(TRUE); else  m_copy_msg_to_email_ctrl.SetCheck(FALSE); 
	
	m_api->m_data.GetAttr(m_person,m_api->m_appr_mgr.a_pers_mail_template,text);
	m_mail_template_ctrl.SetWindowText(text);

	m_api->m_options_mgr.LoadPersonalOptionString(sOptions);
	ComboByOptionSet(m_RunTaskNotifyCtrl,             APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_CompleteTaskNotifyExecutorCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_SuspendTaskNotifyExecutorCtrl, APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_CancelTaskNotifyExecutorCtrl,  APL_NO_T(" Workflow\\    "),sOptions);
	
	ComboByOptionSet(m_CompleteProcessNotifyCtrl,  APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_CompleteTaskNotifyOwnerCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_CancelTaskNotifyOwnerCtrl,  APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionSet(m_SuspendTaskNotifyOwnerCtrl,  APL_NO_T(" Workflow\\    "),sOptions);

#ifdef _UNICODE

	m_create_msg_html_ctrl.SetCheck(TRUE);
	m_create_msg_html_ctrl.EnableWindow(FALSE);

#else

	int ival=m_api->m_options_mgr.GetIntPersonalOptionValueBN(sOptions, APL_NO_T("\\  HTML"),0);
	m_create_msg_html_ctrl.SetCheck(ival);

	m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\    HTML"), m_iAlwaysUseHtml, 0);
	if(m_iAlwaysUseHtml>0)
	{
		m_create_msg_html_ctrl.SetCheck(TRUE);
		m_create_msg_html_ctrl.EnableWindow(FALSE);
	}
#endif	

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

//***************************************************************************************
void CPersonalOptionsDlg::OnOK()
{
	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1, _T("CPersonalOptionsDlg::OnOK"));

	CString text,sOptions,sEmail,sPhone,sAddress;
	m_mail_template_ctrl.GetWindowText(text);
	m_api->m_data.PutAttr(m_person,m_api->m_appr_mgr.a_pers_mail_template,text);

	m_email_ctrl.GetWindowText(sEmail);
	m_api->m_data.PutAttr(m_person,m_api->m_appr_mgr.a_pers_e_mail,sEmail);

	m_phone_ctrl.GetWindowText(sPhone);
	m_api->m_data.PutAttr(m_person,m_api->m_appr_mgr.a_pers_phone,sPhone);

	m_actual_address_ctrl.GetWindowText(sAddress);
	m_api->m_data.PutAttr(m_person,m_api->m_appr_mgr.a_pers_actual_address,sAddress);

	bool b=false;
	if(m_copy_msg_to_email_ctrl.GetCheck()) b=true;
	m_api->m_data.PutAttr(m_person,m_api->m_appr_mgr.a_pers_send_copy_message_to_email,b);

	m_api->m_options_mgr.LoadPersonalOptionString(sOptions);

#ifndef _UNICODE
	if(0==m_iAlwaysUseHtml)
	{
		int iCreateMsgHtml=m_create_msg_html_ctrl.GetCheck();
		if(0==iCreateMsgHtml)m_api->m_options_mgr.DeletePersonalOptionValueBN(sOptions, APL_NO_T("\\  HTML"));
		else m_api->m_options_mgr.SetIntPersonalOptionValueBN(sOptions, APL_NO_T("\\  HTML"),iCreateMsgHtml);
	}
#endif

	ComboByOptionGet(m_RunTaskNotifyCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_CompleteTaskNotifyExecutorCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_SuspendTaskNotifyExecutorCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_CancelTaskNotifyExecutorCtrl,APL_NO_T(" Workflow\\    "),sOptions);

	ComboByOptionGet(m_CompleteProcessNotifyCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_CompleteTaskNotifyOwnerCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_CancelTaskNotifyOwnerCtrl,APL_NO_T(" Workflow\\    "),sOptions);
	ComboByOptionGet(m_SuspendTaskNotifyOwnerCtrl,APL_NO_T(" Workflow\\    "),sOptions);

	m_api->m_options_mgr.SavePersonalOptionString(sOptions);

	CaplTranslateDialog::OnOK();
}

//***************************************************************************************

void CPersonalOptionsDlg::ComboByOptionSet(CComboBox &ctrl, LPCTSTR sOption, CString &sOptions)
{
	if(0==sOption) return; 	if(_T('\0')==sOption[0])return;

	int ival=m_api->m_options_mgr.GetIntPersonalOptionValueBN(sOptions, sOption,0);

	if(1==ival) ctrl.SelectString(0,APL_T(""));
	else if(-1==ival) ctrl.SelectString(0,APL_T(""));
	else ctrl.SelectString(0,APL_T(" "));
}

//***************************************************************************************
void CPersonalOptionsDlg::ComboByOptionGet(CComboBox &ctrl, LPCTSTR sOption, CString &sOptions)
{
	if(0==sOption) return; 	if(_T('\0')==sOption[0])return;

	CString sVal;
	ctrl.GetWindowText(sVal);

	int iVal=0;
	if(sVal==APL_T("")) iVal=1;
	else if(sVal==APL_T("")) iVal=-1;

	if(0==iVal)m_api->m_options_mgr.DeletePersonalOptionValueBN(sOptions, sOption);
	else m_api->m_options_mgr.SetIntPersonalOptionValueBN(sOptions, sOption,iVal);
}


