#if !defined(AFX_SELECTINSTANCEVIEW_H__91CC4C72_F897_4105_BC17_89EE3145D5F3__INCLUDED_)
#define AFX_SELECTINSTANCEVIEW_H__91CC4C72_F897_4105_BC17_89EE3145D5F3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SelectInstanceView.h : header file
//

//   
enum aplObjVersionType {aplNo=0, aplDoc=1, aplBP=2, aplCharact=3};
//    
#include "apl_gui.h"
#include "apl_api.h"
#include "aplBaseTreeItem.h"

class CSelectInstanceDlgEx ;

struct aplObjVertonInfo
{
	aplObjVersionType _type;

	int _ico;//  (+1 -   )

	CaplAttr* _VerIdAttr;//  
	CaplAttr* _VerBaseAttr;//   
	CaplAttr* _VerObjAttr;//  
	CaplAttr* _ObjActiveVerAttr;//    
};

class CLASS_DECL_APL_STEP_MGR CSelectInstanceTreeItem : public CaplBaseTreeItem
{

public:	
	CSelectInstanceTreeItem(CaplAPI* api= NULL, CTreeCtrl* tree= NULL, aplTIArray* items= NULL,
		CaplInstance* inst= NULL, CaplInstance* rel= NULL, CString sName= _T(""));
	virtual ~CSelectInstanceTreeItem();

	virtual bool CreateTreeItem(HTREEITEM parent_item);
	virtual bool Expand(UINT action);
	virtual	bool MyExpand();

	virtual void ShowRelatedItems();
//	int GetRelatedInstances(aplExtent &subItems);
	virtual int GetRelatedInstances(aplExtent &subItems, aplExtent& subRels, UINT& iRelIco, CaplAttr** related_inst= NULL);
	int GetRelatedInstancesBN(aplExtent &subItems);
	virtual CSelectInstanceTreeItem* InsertInstInTree(CaplInstance* inst, CaplInstance* rel, UINT iRelIco=-1, UINT iEffIco= -1);
	virtual HTREEITEM RestoreTreeItem(CTreeCtrl* tree, HTREEITEM parent_item);
	
	virtual void ShowAllDocs(bool bShowMessage= true);
	virtual void ShowAllApproval(bool showMsg= true);
    virtual	void ShowAllCharacteristic(bool  showMsg= true);
	
	void ShowAllLots(bool bShowMessage= true);
	void ShowAllBPInstances(bool bShowMessage= true);
	void ShowAllBPs(bool bShowMessage= true);
	void ShowAllBPResources(bool bShowMessage= true);
	void ShowAllMaters(bool bShowMessage= true);
	void ShowAllPrdInstances(bool bShowMessage= true);
	void ShowAllVersions(bool bShowMessage= true);
	void ShowAllUsage(bool bShowMessage= true);
	
	void ShowExpandOptions();
	virtual	void FillRevisionTree(HTREEITEM item, aplExtent& revExt);
	HTREEITEM Find(CaplInstance* inst_prev,HTREEITEM item=0);

	static aplObjVertonInfo m_ItemVertionInfo;
	static void SetObjVertionInfo(aplObjVersionType type, int ico, CaplAttr* id, CaplAttr* base, CaplAttr* obj, CaplAttr* active);
	static void ClearObjVertionInfo();	

	CString m_sName;
	bool m_expanded;
	bool m_bExpanding;
	UINT m_ico;
	UINT m_iRelIco;
	UINT m_iEffIco;
	UINT m_iStateIco;
	bool m_bShowRelated;

	bool m_bShowWorkObjectsInProcess;	//     
										// ,    
	static bool m_bFilterSubProduct;	//       
										//  
};

//////////////////////////////////////////////////////////////////////////
//************************************************************************

class CLASS_DECL_APL_STEP_MGR CSelectInstanceTreeItemEx  : public CSelectInstanceTreeItem
{
public:
	CaplTreeListCtrlWithToolTip *m_ToolTipTree;
	CaplInstance* m_ciParent;
	
	CSelectInstanceTreeItemEx(CaplAPI* api= NULL, CaplTreeListCtrlWithToolTip* tree= NULL, aplTIArray* items= NULL,
		CaplInstance* inst= NULL, CaplInstance* rel= NULL, CString sName= _T(""));
	~CSelectInstanceTreeItemEx();

	//virtual bool CreateTreeItem(CaplTreeListCtrlWithToolTip *tree, int &ico, CString &sName, HTREEITEM parent_item);
	virtual bool CreateTreeItem(HTREEITEM parent_item, CaplInstance *ciRel);
	virtual CSelectInstanceTreeItem* InsertInstInTree(CaplInstance* inst, CaplInstance* rel, UINT iRelIco = -1, UINT iEffIco = -1);
	virtual void Sort(bool bRefreshParent=false);
	
	virtual bool MyExpand();
	virtual void ShowRelatedItems();
	virtual void FillRevisionTree(HTREEITEM item, aplExtent &revExt);
	
	void CollapseItem(bool bInsertFictive = true);
	bool IsNeedToShow(CaplInstance *ciRel);

	static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);	
	virtual int GetRelatedInstances(aplExtent &subItems, aplExtent& subRels, UINT& iRelIco, CaplAttr** related_inst= NULL) override;
	
protected:
	int m_nShowBaseDoc;
};

/////////////////////////////////////////////////////////////////////////////
// CSelectInstanceView view

class CSelectInstanceView : public CaplTreeView
{
protected:
	CSelectInstanceView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CSelectInstanceView)

// Attributes
public:
	CaplAPI* m_api;
	
	CaplInstance* m_selectedInstance;

	aplExtent* m_BaseItems;
	
	static aplTIArray m_allItems;
	static aplTIArray m_rootItems;
	static CSelectInstanceTreeItem* m_lastSelectedItem;
	static void ClearRestoreData(void);

	long m_selectMode;
	CWnd* m_enableBtn;
	CSelectInstanceDlgEx* m_pDlg;

// Operations
public:
	bool GetSelectedItems(aplExtent &ext);
	bool IsCanReturnInstance(CaplInstance* inst);
	bool CheckAndRestore();
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSelectInstanceView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CSelectInstanceView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CSelectInstanceView)
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnShowAllDocs();
	afx_msg void OnShowAllApproval();
	afx_msg void OnShowAllBp();
	afx_msg void OnShowAllBpInst();
	afx_msg void OnShowAllBpResource();
	afx_msg void OnShowAllCharacteristic();
	afx_msg void OnShowAllPrdInst();
	afx_msg void OnShowAllVersion();
	afx_msg void OnShowAllUsage();
	afx_msg void OnShowAllLot();
	afx_msg void OnShowExpandOptions();
	afx_msg void OnUpdateSiShowAllDocs(CCmdUI* pCmdUI);
	afx_msg void OnSiProductShowAllZagotov();
	afx_msg void OnSiFind();
	afx_msg void OnButton61864();
	afx_msg void OnUpdateSiShowAllCharacteristic(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllApproval(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllBp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllLot(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllPrdInst(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllBpInst(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllBpResource(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiProductShowAllZagotov(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllVersion(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiShowAllUsage(CCmdUI* pCmdUI);
	afx_msg void OnSiCreateFolder();
	afx_msg void OnUpdateSiCreateFolder(CCmdUI* pCmdUI);
	afx_msg void OnSiViewDocument();
	afx_msg void OnUpdateSiViewDocument(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSiFind(CCmdUI* pCmdUI);
	//}}AFX_MSG
public:
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SELECTINSTANCEVIEW_H__91CC4C72_F897_4105_BC17_89EE3145D5F3__INCLUDED_)
