// SelectWFSDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelectWFSDlg.h"
#include "WFSHistoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectWFSDlg dialog


CSelectWFSDlg::CSelectWFSDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectWFSDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectWFSDlg)
	m_current = _T("");
	m_nState = -1;
	//}}AFX_DATA_INIT
	m_api = 0;
	m_inst = 0;
	m_states.RemoveAll();
	m_states.Add(_T("working"));
	m_states.Add(_T("approving"));
	m_states.Add(_T("approved"));
	m_states.Add(_T("changing"));
	m_states.Add(_T("approving_change"));
	m_states.Add(_T("canceled"));
	m_states.Add(_T("must_revision"));

	m_bModeFreeChange=false;
	m_bNoSetApproved=FALSE;
	m_bOnlyFreeChange=false;
}


void CSelectWFSDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectWFSDlg)
	DDX_Control(pDX, IDC_SHOW_ALL_STATES, m_show_all_states_dlg);
	DDX_Control(pDX, IDC_STATE_ICO_6, m_state_ico_6);
	DDX_Control(pDX, IDC_STATE_ICO_5, m_state_ico_5);
	DDX_Control(pDX, IDC_STATE_ICO_4, m_state_ico_4);
	DDX_Control(pDX, IDC_STATE_ICO_3, m_state_ico_3);
	DDX_Control(pDX, IDC_STATE_ICO_2, m_state_ico_2);
	DDX_Control(pDX, IDC_STATE_ICO_1, m_state_ico_1);
	DDX_Control(pDX, IDC_STATE_ICO_0, m_state_ico_0);
	DDX_Control(pDX, IDC_WFS_MREVISION, m_mrevision);
	DDX_Control(pDX, IDC_CHANGING, m_changing);
	DDX_Control(pDX, IDC_WFS_WORKING, m_working);
	DDX_Control(pDX, IDC_WFS_CANCELED, m_canceled);
	DDX_Control(pDX, IDC_WFS_APPROVING_CHANGE, m_approving_change);
	DDX_Control(pDX, IDC_WFS_APPROVING, m_approving);
	DDX_Control(pDX, IDC_WFS_APPROVED, m_approved);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_WFS_CURRENT, m_current);
	DDX_Radio(pDX, IDC_WFS_WORKING, m_nState);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectWFSDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectWFSDlg)
	ON_BN_CLICKED(IDC_SHOW_ALL_STATES, OnShowAllStates)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectWFSDlg message handlers

void CSelectWFSDlg::SetPossibleStates()
{
	if(!m_current.IsEmpty())
	{
		m_approved.EnableWindow(FALSE);
		m_approving.EnableWindow(FALSE);
		m_approving_change.EnableWindow(FALSE);
		m_working.EnableWindow(FALSE);
		m_canceled.EnableWindow(FALSE);
		m_changing.EnableWindow(FALSE);
		m_mrevision.EnableWindow(FALSE);

		CStringArray states;
		m_api->m_doc_mgr.GetPossibleWFState(m_inst, states);

		for(int i=0; i<states.GetSize();i++)
		{
			if(states.GetAt(i)==_T("approved")) m_approved.EnableWindow();
			else if(states.GetAt(i)==_T("approving")) m_approving.EnableWindow();
			else if(states.GetAt(i)==_T("approving_change")) m_approving_change.EnableWindow();
			else if(states.GetAt(i)==_T("canceled")) m_canceled.EnableWindow();
			else if(states.GetAt(i)==_T("working")) m_working.EnableWindow();
			else if(states.GetAt(i)==_T("changing")) m_changing.EnableWindow();
			else if(states.GetAt(i)==_T("must_revision")) m_mrevision.EnableWindow();
		}

		if(m_bNoSetApproved) m_approved.EnableWindow(FALSE);
	}

}

void CSelectWFSDlg::SetAllStatesAsPossible()
{
	m_approved.EnableWindow(TRUE);
	m_approving.EnableWindow(TRUE);
	m_approving_change.EnableWindow(TRUE);
	m_working.EnableWindow(TRUE);
	m_canceled.EnableWindow(TRUE);
	m_changing.EnableWindow(TRUE);
	m_mrevision.EnableWindow(TRUE);
}


BOOL CSelectWFSDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetFlat(FALSE);
	
	//  

	CImageList *il=aplGetStateImageList();
	if(il!=0)
	{
		m_state_ico_0.ModifyStyle(SS_BLACKFRAME,SS_ICON );
		m_state_ico_0.SetIcon(il->ExtractIcon(aplState2Ico(_T("working"))));

		m_state_ico_1.ModifyStyle(SS_BLACKFRAME,SS_ICON );
		m_state_ico_1.SetIcon(il->ExtractIcon(aplState2Ico(_T("approving"))));
		
		m_state_ico_2.ModifyStyle(SS_BLACKFRAME,SS_ICON );
		m_state_ico_2.SetIcon(il->ExtractIcon(aplState2Ico(_T("approved"))));

		m_state_ico_3.ModifyStyle(SS_BLACKFRAME,SS_ICON);
		m_state_ico_3.SetIcon(il->ExtractIcon(aplState2Ico(_T("changing"))));

		m_state_ico_4.ModifyStyle(SS_BLACKFRAME,SS_ICON);
		m_state_ico_4.SetIcon(il->ExtractIcon(aplState2Ico(_T("approving_change"))));

		m_state_ico_5.ModifyStyle(SS_BLACKFRAME,SS_ICON);
		m_state_ico_5.SetIcon(il->ExtractIcon(aplState2Ico(_T("canceled"))));

		m_state_ico_6.ModifyStyle(SS_BLACKFRAME,SS_ICON);
		m_state_ico_6.SetIcon(il->ExtractIcon(aplState2Ico(_T("must_revision"))));

	}


	if(m_api && m_api->m_data.IsConnected())
	{

		if(m_api->m_prd_mgr.IsAdmin()) m_bModeFreeChange=true;
		else
		{
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     ''"),m_bNoSetApproved,0);
			
			CString role;
			m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\      ''"),role,_T(""));
			if(!role.IsEmpty())
			{
				if(m_api->m_appr_mgr.CheckPersonRole(0,role))
				{
					m_bModeFreeChange=true;
					m_bNoSetApproved=FALSE;
				}
			}

			if(!m_bModeFreeChange && 0!=m_inst)
			{
				if(m_inst->GetAccessmode()<=aplRW)
				{
					m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\       ''"),role,_T(""));
					if(!role.IsEmpty())
					{
						if(m_api->m_appr_mgr.CheckPersonRole(0,role))
						{
							m_bModeFreeChange=true;
							m_bNoSetApproved=FALSE;
						}
					}
				}
			}
		}
		
		if(m_inst)
		{
			if(m_api->m_data.IsKindOf(m_inst, m_api->m_req_mgr.e_requirement)) 
				m_api->m_data.GetAttr(m_inst, m_api->m_req_mgr.a_req_wf_state, m_current);
			else
				m_api->m_data.GetAttrBN(m_inst, _T("state"), m_current);
		}
		else{m_nState= 0;m_current= _T("working");}

		if((m_current==_T("approved") || m_current==_T("canceled")) && m_bModeFreeChange==false)
		{
			m_approved.EnableWindow(FALSE);
			m_approving.EnableWindow(FALSE);
			m_approving_change.EnableWindow(FALSE);
			m_working.EnableWindow(FALSE);
			m_canceled.EnableWindow(FALSE);
			m_changing.EnableWindow(FALSE);
			m_mrevision.EnableWindow(FALSE);

			m_ok_btn.EnableWindow(FALSE);
		}
		else SetPossibleStates();

		m_current = m_api->m_doc_mgr.GetWFStateName(m_current);
		UpdateData(FALSE);

	}

	if(m_bOnlyFreeChange)
	{
		m_show_all_states_dlg.SetCheck(true);
		SetAllStatesAsPossible();
	}
	else if(m_bModeFreeChange) m_show_all_states_dlg.EnableWindow(TRUE);		
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectWFSDlg::OnOK() 
{
	UpdateData();
	if(m_nState>-1) m_new_state = m_states[m_nState];
	else 
	{
		AfxMessageBox( APL_T("    "),MB_OK|MB_ICONERROR);
		return;
	}
	
	CaplTranslateDialog::OnOK();
}

void CSelectWFSDlg::OnShowAllStates() 
{
	if(m_show_all_states_dlg.GetCheck()==0)
	{
		SetPossibleStates();
	}
	else
	{
		SetAllStatesAsPossible();
	}
	
}
