// Showdoc_copysDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ShowDocCopyesDlg.h"
#include "DocCopyFilterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShowDocCopyesDlg dialog

CShowDocCopyesDlg::CShowDocCopyesDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CShowDocCopyesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShowDocCopyesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=0;
	m_read_only=false;
	m_list_ctrl.SetUniqueName(_T("CShowDocCopyesDlg"));
	m_cur_person=0;
	m_bIsAdmin=false;
	m_filter=0;
	m_b_filter_created=false;
}


void CShowDocCopyesDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShowDocCopyesDlg)
	DDX_Control(pDX, IDC_BORDER, m_border_ctrl);
	DDX_Control(pDX, IDC_FILTER_BTN, m_filter_btn);
	DDX_Control(pDX, IDC_GO, m_go_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_ADD_BTN, m_add_btn);
	DDX_Control(pDX, IDC_DELETE_BTN, m_delete_btn);
	DDX_Control(pDX, IDC_MARK_CHANGED_BTN, m_mark_changed_btn);
	DDX_Control(pDX, IDC_SHOW_PROPERTIES_BTN, m_show_prop_btn);
	DDX_Control(pDX, IDC_FILTER_DESCR, m_filter_descr_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShowDocCopyesDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CShowDocCopyesDlg)
	ON_WM_CONTEXTMENU()
	ON_NOTIFY(NM_DBLCLK, IDS_DOC_COPYES_CTRL, OnDblclkItem)
	ON_BN_CLICKED(IDC_FILTER_BTN, OnFilterBtn)
	ON_BN_CLICKED(IDC_GO, OnGo)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_ADD_BTN, OnAddBtn)
	ON_BN_CLICKED(IDC_DELETE_BTN, OnDeleteBtn)
	ON_BN_CLICKED(IDC_MARK_CHANGED_BTN, OnMarkChangedBtn)
	ON_BN_CLICKED(IDC_SHOW_PROPERTIES_BTN, OnShowProppertiesBtn)
	ON_NOTIFY(LVN_ITEMCHANGED, IDS_DOC_COPYES_CTRL, OnSelChangedItem)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShowDocCopyesDlg message handlers

BOOL CShowDocCopyesDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_go_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_go_btn.SetFlat(FALSE);

	m_add_btn.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_add_btn.SetFlat(FALSE);
	m_delete_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_delete_btn.SetFlat(FALSE);
	m_mark_changed_btn.SetFlat(FALSE);
	m_show_prop_btn.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_show_prop_btn.SetFlat(FALSE);

	RECT rect={5,5,10,10};
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect); 
		
	m_list_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDS_DOC_COPYES_CTRL);
	
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_list_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_list_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_list_ctrl.m_hWnd)
			|LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	m_list_ctrl.SetImageList(aplGetInstImageList(),LVSIL_SMALL);

	ListView_SetExtendedListViewStyle(m_filter_descr_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_filter_descr_ctrl.m_hWnd)
			|LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	CRect list_ctrl_rect;
	m_filter_descr_ctrl.GetWindowRect(list_ctrl_rect);
	int list_ctrl_width=list_ctrl_rect.Width();
	m_filter_descr_ctrl.InsertColumn(0,  APL_T(""), LVCFMT_LEFT,(int)list_ctrl_width/4);
	m_filter_descr_ctrl.InsertColumn(1,  APL_T(""), LVCFMT_LEFT,(int)3*list_ctrl_width/4-5);

	AddAnchor(IDC_GO,TOP_LEFT);
	AddAnchor(IDC_FILTER_BTN,TOP_LEFT);
	AddAnchor(IDC_FILTER_DESCR,TOP_LEFT,TOP_RIGHT);
	AddAnchor(IDS_DOC_COPYES_CTRL,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_ADD_BTN,TOP_LEFT);
	AddAnchor(IDC_DELETE_BTN,TOP_LEFT);
	AddAnchor(IDC_MARK_CHANGED_BTN,TOP_LEFT);
	AddAnchor(IDC_SHOW_PROPERTIES_BTN,TOP_LEFT);

	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_SAVE,BOTTOM_LEFT);

	m_cur_person=m_api->m_message_mgr.GetCurrentPerson();

	int tab_count=0;
	CString query = _T("");
	m_bIsAdmin=m_api->m_message_mgr.IsAdmin();

	CString person_id=_T("");


	int count=0,i;
	m_list_ctrl.GetWindowRect(list_ctrl_rect);
	list_ctrl_width=list_ctrl_rect.Width();
	i=m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/9);count++;
	m_list_ctrl.SetColumnNumeric(i);
	m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, (int)2*list_ctrl_width/9);count++;
	m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, (int)list_ctrl_width/9);count++;
	m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, (int)list_ctrl_width/9);count++;
	m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, (int)list_ctrl_width/9);count++;
	i=m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, (int)list_ctrl_width/9);count++;
	m_list_ctrl.SetColumnDate(i);
	i=m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, (int)list_ctrl_width/9);count++;
	m_list_ctrl.SetColumnDate(i);
	i=m_list_ctrl.InsertColumn(count,  APL_T("  "), LVCFMT_LEFT, (int)list_ctrl_width/18);count++;
	m_list_ctrl.SetColumnNumeric(i);
	i=m_list_ctrl.InsertColumn(count,  APL_T("  "), LVCFMT_LEFT, (int)list_ctrl_width/18);count++;
	m_list_ctrl.SetColumnNumeric(i);

	if(m_filter) 
	{ 
		UpdateFilterDescr();
		FindDocCopyes();
	}
	else
	{
		m_filter=new CDocCopyFilter;
		m_b_filter_created=true;
		if(!ProcessFilterBtn())
		{
			EndDialog(0);
			return FALSE;
		}
	}
	if(!m_read_only) m_add_btn.EnableWindow(TRUE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShowDocCopyesDlg::CreateItem(CaplInstance *doc_copy,const char *id)
{
	if(!doc_copy) return;
	CString id_s=_T("");
	if(id) id_s=id;
	else m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_id,id_s);
	
	int ico= m_api->GetInstIco(doc_copy);
	int new_item=m_list_ctrl.InsertItem(0,id_s,ico);
	m_list_ctrl.SetItemData(new_item,(long)doc_copy);

	RefreshItem(new_item);
}


void CShowDocCopyesDlg::UpdateListCtrl()
{
	LockWindowUpdate();
	long trd=aplStartWaitDlg( APL_T("  "));
	m_list_ctrl.DeleteAllItems();
	for(int i=0;i<m_doc_copyes.GetSize();i++)
	{
		CreateItem(m_doc_copyes[i]);
	}
	if(m_list_ctrl.GetItemCount()) 
	{
		m_list_ctrl.SetItemSortState(0,ASCENDING);
		m_list_ctrl.SortColumn(0,false);
		m_list_ctrl.SetItemState(0,LVIS_SELECTED, LVIS_SELECTED);
	}
	aplEndWaitDlg(trd);
	UnlockWindowUpdate();
	
}

void CShowDocCopyesDlg::RefreshItem(int nItem)
{
	if(nItem<0) return;
	CaplInstance *doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	if(!doc_copy) return;
	if(doc_copy->GetAccessmode()>aplRO)return;

	CString buf=_T("");
	int count=0;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_id,buf);
	m_list_ctrl.SetItemText(nItem,count,buf);
	count++;
	buf=_T("");

	CaplInstance *copy_doc;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_doc,copy_doc);
	if(copy_doc)
	{
		CString doc_id=_T(""),doc_name=_T("");

		m_api->m_data.GetAttr(copy_doc,m_api->m_doc_mgr.a_doc_id,doc_id);
		if(doc_id==_T("")) doc_id=_T("?");
		buf+=doc_id;

		m_api->m_data.GetAttr(copy_doc,m_api->m_doc_mgr.a_doc_name,doc_name);
		if(doc_name==_T("")) doc_name=_T("?");
		if(doc_id>_T("")) buf+=_T(" : ") + doc_name;
		else buf+= doc_name;

		m_list_ctrl.SetItemText(nItem,1,buf);
	}
	count++;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_state,buf);
	if(buf!=_T(""))
	{
		m_list_ctrl.SetItemText(nItem,count,buf);
	}
	count++;
	buf=_T("");
	CaplInstance *inst;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_owner,inst);
	if(inst)
	{
		m_api->GetItemName(inst,buf);
		m_list_ctrl.SetItemText(nItem,count,buf);
	}
	count++;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_place_of_use,inst);
	if(inst)
	{
		m_api->GetItemName(inst,buf);
		m_list_ctrl.SetItemText(nItem,count,buf);
	}
	count++;
	COleDateTime odt;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_issue_date,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,odt);
		buf=odt.Format(_T("%d.%m.%Y"));
		m_list_ctrl.SetItemText(nItem,count,buf);
	}
	count++;
	m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_last_update,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,odt);
		buf=odt.Format(_T("%d.%m.%Y"));
		m_list_ctrl.SetItemText(nItem,count,buf);
	}
	count++;
	if(copy_doc)
	{
		m_api->m_data.GetAttr(copy_doc,m_api->m_doc_mgr.a_apl_doc_active,inst);
		if(inst)
		{
			m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_rev_id,buf);
			m_list_ctrl.SetItemText(nItem,count,buf);
		}
		count++;
		m_api->m_data.GetAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,inst);
		if(inst)
		{
			m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_rev_id,buf);
			m_list_ctrl.SetItemText(nItem,count,buf);
		}
	}
	LVITEM pItem;
	pItem.iItem=nItem;
	pItem.iSubItem=0;
	m_list_ctrl.GetItem(&pItem);
	pItem.mask=LVIF_IMAGE;
	pItem.iImage=m_api->GetInstIco(doc_copy);
	m_list_ctrl.SetItem(&pItem);

}
/*
void CShowDocCopyesDlg::OnClkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	if(lpnmitem==0) return;
	int nItem=lpnmitem->iItem;
	CaplInstance *inst=0;
	if(nItem>=0) inst=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	
	int selected_count=m_list_ctrl.GetSelectedCount();
	if(selected_count==0)
	{
		m_prop_btn.EnableWindow(FALSE);
		m_move_to_wp_btn.EnableWindow(FALSE);
		m_move_to_check_btn.EnableWindow(FALSE);
		m_delete_btn.EnableWindow(FALSE);
		m_approve_btn.EnableWindow(FALSE);
	}

}
*/
void CShowDocCopyesDlg::OnDblclkItem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	if(lpnmitem==0) return;
	int nItem=lpnmitem->iItem;
	if(nItem<0) return;
	CaplInstance *doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	if(!doc_copy) return;
	ShowProperties(doc_copy,nItem);
}

bool CShowDocCopyesDlg::ShowProperties(CaplInstance *doc_copy,int nItem)
{
	if(!doc_copy) return false;
	if(nItem<0) return false;
	if(doc_copy->GetAccessmode()>aplRO) return false;
	if(m_api->m_doc_mgr.ShowDocCopyProperties(doc_copy)) 
	{
		RefreshItem(nItem);
		return true;
	}
	return false;
}

void CShowDocCopyesDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	if(m_read_only) return;
	int i=0;

	int nItem=m_list_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_doc_copy=0,*doc=0,*copy_doc_cur_ver=0,*doc_act_ver=0;
	CString state=_T("");
	if(nItem>=0)  
	{
		sel_doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
		if(sel_doc_copy) 	
		{
			m_api->m_data.GetAttr(sel_doc_copy,m_api->m_doc_mgr.a_doc_copy_state,state);
			if(state==_T("")) state= APL_T("");
			m_api->m_data.GetAttr(sel_doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,copy_doc_cur_ver);
			m_api->m_data.GetAttr(sel_doc_copy,m_api->m_doc_mgr.a_doc_copy_doc,doc);
			if(doc) m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_apl_doc_active,doc_act_ver);
		}
		
	}

    CMenu menu;CMenu* pPopup;
    VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));

	pPopup = menu.GetSubMenu(10);

	if(sel_doc_copy)
	{
		if(doc_act_ver==copy_doc_cur_ver || !m_cur_person) 
			pPopup->EnableMenuItem(ID_MARK_CHANGED_COPY, MF_BYCOMMAND | MF_GRAYED);
		if(state== APL_T("")) 
		{
			pPopup->EnableMenuItem(ID_ANNUL_COPY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_MARK_CHANGED_COPY, MF_BYCOMMAND | MF_GRAYED);
		}
		else if(state== APL_T(""))
		{
			pPopup->EnableMenuItem(ID_DESTROY_COPY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_ANNUL_COPY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_MARK_CHANGED_COPY, MF_BYCOMMAND | MF_GRAYED);
		}
	}
	else
	{
		pPopup->EnableMenuItem(ID_MARK_CHANGED_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_ANNUL_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DESTROY_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_REV_CHANGES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_OWNERS_CHANGES, MF_BYCOMMAND | MF_GRAYED);
	}
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON |TPM_RETURNCMD,	point.x, point.y,this); // use main window for cmds

	switch(res)
	{
		case ID_CREATE_DOC_COPY:
			{
				CreateDocCopy();
			}
			break;
		case ID_SHOW_PROPERTIES:
			{
				ShowProperties(sel_doc_copy,nItem);
			}
			break;
		case ID_DELETE_COPY:
			{
				DeleteDocCopy(sel_doc_copy,nItem);
			}
			break;
		case ID_ANNUL_COPY:
			{
				if(ChangeDocCopyState(sel_doc_copy, APL_T("")))
					RefreshItem(nItem);
			}
			break;
		case ID_DESTROY_COPY:
			{
				if(ChangeDocCopyState(sel_doc_copy, APL_T("")))
					RefreshItem(nItem);	
			}
			break;
		case ID_SHOW_REV_CHANGES:
			{
				m_api->m_doc_mgr.ShowHardCopyRevChanges(sel_doc_copy);
			}
			break;
		case ID_SHOW_OWNERS_CHANGES:
			{
				m_api->m_doc_mgr.ShowHardCopyOwnerChanges(sel_doc_copy);
			}
			break;
		case ID_MARK_CHANGED_COPY:
			{
				ApplyHardCopyRevChanges(sel_doc_copy,nItem);
			}
			break;

		default:break;
	}
	
}


void CShowDocCopyesDlg::OnSelChangedItem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	if(m_read_only) return;
	int nItem=m_list_ctrl.GetNextItem(-1,LVNI_SELECTED);
	
	CaplInstance *sel_doc_copy=0;
	if(nItem>=0) sel_doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);

	if(m_list_ctrl.GetSelectedCount()==1)
	{
		m_show_prop_btn.EnableWindow(TRUE);
		m_delete_btn.EnableWindow(TRUE);

		CaplInstance *copy_doc_cur_ver=0,*doc=0,*doc_act_ver=0;
		if(sel_doc_copy && sel_doc_copy->GetId()) 	
		{
			m_api->m_data.GetAttr(sel_doc_copy,m_api->m_doc_mgr.a_doc_copy_cur_rev,copy_doc_cur_ver);
			m_api->m_data.GetAttr(sel_doc_copy,m_api->m_doc_mgr.a_doc_copy_doc,doc);
			if(doc) m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_apl_doc_active,doc_act_ver);
		}
		if(doc_act_ver!=copy_doc_cur_ver)
		{
			m_mark_changed_btn.EnableWindow(TRUE);
		}
		else
		{
			m_mark_changed_btn.EnableWindow(FALSE);
		}

		
	}
	else
	{
		m_show_prop_btn.EnableWindow(FALSE);
		m_delete_btn.EnableWindow(FALSE);
		m_mark_changed_btn.EnableWindow(FALSE);
	}

}

void CShowDocCopyesDlg::CreateDocCopy()
{
	CaplInstance *new_doc_copy=m_api->m_doc_mgr.CreateDocumentHardCopy();
	if(new_doc_copy)
	{
		CreateItem(new_doc_copy);
		m_list_ctrl.SetItemSortState(0,ASCENDING);
		m_list_ctrl.SortColumn(0,false);
	}
}

void CShowDocCopyesDlg::DeleteDocCopy(CaplInstance *doc_copy,int nItem)
{
	if(!doc_copy) return;
	if(nItem<0) return;
	if(m_api->m_doc_mgr.DeleteDocHardCopy(doc_copy))
	{
		m_list_ctrl.DeleteItem(nItem);
	}
}

void CShowDocCopyesDlg::OnFilterBtn()
{
	ProcessFilterBtn();
}

void CShowDocCopyesDlg::OnGo()
{
	FindDocCopyes();
}

void CShowDocCopyesDlg::OnSave()
{
	CString f_name= APL_T(" ");
	f_name+=_T(".csv");
	if(apl_SaveListCtrlToFile(&m_list_ctrl,f_name,_T(""),true))
	{
		AfxMessageBox( APL_T("    !"));
	}
}

void CShowDocCopyesDlg::OnAddBtn()
{
	CreateDocCopy();	
}

void CShowDocCopyesDlg::OnDeleteBtn()
{
	int nItem=m_list_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_doc_copy=0;
	if(nItem>=0) sel_doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	if(sel_doc_copy) DeleteDocCopy(sel_doc_copy,nItem);
}

void CShowDocCopyesDlg::OnMarkChangedBtn()
{
	int nItem=m_list_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_doc_copy=0;
	if(nItem>=0) sel_doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	if(sel_doc_copy) ApplyHardCopyRevChanges(sel_doc_copy,nItem);
}

void CShowDocCopyesDlg::OnShowProppertiesBtn()
{
	int nItem=m_list_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_doc_copy=0;
	if(nItem>=0) sel_doc_copy=(CaplInstance*)m_list_ctrl.GetItemData(nItem);
	if(sel_doc_copy) ShowProperties(sel_doc_copy,nItem);
}

bool CShowDocCopyesDlg::FindDocCopyes()
{
	m_api->m_doc_mgr.FindHardCopyes(m_doc_copyes,m_filter->m_id,m_filter->m_doc,m_filter->m_owner,m_filter->m_place_of_use,m_filter->m_state,m_filter->m_date_begin,m_filter->m_date_end,m_filter->m_b_only_out_of_order);
	if(!m_doc_copyes.GetSize())
	{
		AfxMessageBox( APL_T("   ,   ,  !"));
	}
	UpdateListCtrl();
	return true;
}

CShowDocCopyesDlg::~CShowDocCopyesDlg()
{
	if(m_filter && m_b_filter_created) delete m_filter;
}


bool CShowDocCopyesDlg::ChangeDocCopyState(CaplInstance *doc_copy,const TCHAR *new_state)
{
	if(!doc_copy) return false;
	if(!new_state) return false;
	if(doc_copy->GetAccessmode()>aplRW)
	{
		AfxMessageBox( APL_T(" !"));
		return false;
	}
	m_api->m_data.PutAttr(doc_copy,m_api->m_doc_mgr.a_doc_copy_state,new_state);
	m_api->SaveChanges();
	return true;
}

bool CShowDocCopyesDlg::ApplyHardCopyRevChanges(CaplInstance *doc_copy,int nItem)
{
	if(!doc_copy) return false;
	if(AfxMessageBox( APL_T("       ?"),MB_YESNO|MB_ICONQUESTION)==IDNO)
		return false;
	if(m_api->m_doc_mgr.ApplyHardCopyRevChanges(doc_copy,m_cur_person))
	{
		CString buf=_T(""),msg= APL_T("       :\n");
		m_api->m_appr_mgr.GetPersonName(m_cur_person,buf);
		msg+= APL_T(": ")+buf+_T("\n");
		COleDateTime dt=COleDateTime::GetCurrentTime();
		buf=dt.Format(_T("%d.%m.%Y %H:%M"));
		msg+= APL_T(": ")+buf+_T("\n");
		AfxMessageBox(msg);
		RefreshItem(nItem);	
	}
	return true;
}

void CShowDocCopyesDlg::UpdateFilterDescr()
{
	if(!m_filter) return;
	m_filter_descr_ctrl.DeleteAllItems();
	CString buf,buf0;
	int count=0,i;
	if(m_filter->m_id!=_T("")) 
	{
		i=m_filter_descr_ctrl.InsertItem(count, APL_T(" :"));
		m_filter_descr_ctrl.SetItemText(i,1,m_filter->m_id);
		count++;
	}
	if(m_filter->m_doc) 
	{
		m_api->GetItemName(m_filter->m_doc,buf);
		i=m_filter_descr_ctrl.InsertItem(count, APL_T(":"));
		m_filter_descr_ctrl.SetItemText(i,1,buf);
		count++;
	}
	if(m_filter->m_owner) 
	{
		m_api->m_appr_mgr.GetPersonName(m_filter->m_owner,buf);
		i=m_filter_descr_ctrl.InsertItem(count, APL_T(". :"));
		m_filter_descr_ctrl.SetItemText(i,1,buf);
		count++;
	}
	if(m_filter->m_place_of_use) 
	{
		m_api->m_data.GetAttr(m_filter->m_place_of_use,m_api->m_appr_mgr.a_org_name,buf); 
		i=m_filter_descr_ctrl.InsertItem(count, APL_T(" :"));
		m_filter_descr_ctrl.SetItemText(i,1,buf);
		count++;
	}
	if(m_filter->m_state!=_T("")) 
	{
		i=m_filter_descr_ctrl.InsertItem(count, APL_T(":"));
		m_filter_descr_ctrl.SetItemText(i,1,m_filter->m_state);
		count++;
	}
	if(m_filter->m_b_only_out_of_order) 
	{
		i=m_filter_descr_ctrl.InsertItem(count,_T(""));
		m_filter_descr_ctrl.SetItemText(i,1, APL_T("     ()"));
		count++;
	}
	if(m_filter->m_date_begin!=_T("") || m_filter->m_date_end!=_T("")) 
	{
		COleDateTime dt;
		i=m_filter_descr_ctrl.InsertItem(count, APL_T("  :"));
		if(m_filter->m_date_begin!=_T(""))
		{
			buf+=APL_T("c ");
			aplString2Date(m_filter->m_date_begin,dt);
			buf0=dt.Format(_T("%d.%m.%Y ")); 
			buf+=buf0;
		}
		if(m_filter->m_date_end!=_T(""))
		{
			buf+= APL_T(" ");
			aplString2Date(m_filter->m_date_end,dt);
			buf0=dt.Format(_T("%d.%m.%Y ")); 
			buf+=buf0;
		}
		m_filter_descr_ctrl.SetItemText(i,1,buf);
	}
	UpdateData(FALSE);
}

bool CShowDocCopyesDlg::ProcessFilterBtn()
{
	CDocCopyFilterDlg dlg;
	dlg.m_api=m_api;
	dlg.m_filter=m_filter;
	if(dlg.DoModal()==IDOK)
	{
		UpdateFilterDescr();
		FindDocCopyes();
		return true;
	}
	return false;
}