#pragma once

class CUnitConvertionItem
{
public:
	CUnitConvertionItem()
	{
		m_inst = 0;
		m_baseUnit = 0;
		m_newUnit = 0;
		m_baseCount = 0;
		m_newCount = 0;
	}

	CaplInstance *m_inst;
	CaplInstance *m_baseUnit;
	CaplInstance *m_newUnit;

	double m_baseCount;
	double m_newCount;
};

// CUnitConvertionDlg dialog

class CUnitConvertionDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CUnitConvertionDlg)

public:
	CUnitConvertionDlg(CaplAPI *api, CaplInstance *pPdf, CaplInstance *unit, double baseCount, CWnd* pParent = NULL);   // standard constructor
	virtual ~CUnitConvertionDlg();

// Dialog Data
	enum { IDD = IDD_UNIT_CONVERTION };

	CaplButton m_okBtn;
	CaplButton m_cancelBtn;
	CaplButton m_addBtn;
	CaplButton m_deleteBtn;
	CSortListCtrl m_list;
	CEdit m_edit;
	CComboBox m_combo;
	bool m_processSetFocusEvent;
	int m_newUnitColumn;
	int m_newCountColumn;
	int m_srcUnitColumn;
	int m_srcCountColumn;

	int m_item;
	int m_subItem;
	CWnd *m_currentCtrl;	
	bool m_bReadOnly;

private:
	void InitGui();
	void InitButtons();
	void InitList();
	void InitAnchors();
	void InitCtrlsParent();
	void ShowUnits();
	void GetAllUnits();
	void FillUnitCombo(CaplInstance *cur_unit);
	void StartComboField(int item, int subItem);
	void StartEditField(int item, int subItem);
	bool HideEditCtrl(bool copyText);
	bool CheckUp();
	bool Save();
	void GetUnitInUse(aplExtent &unitInUse);
	void AddUnitString(CUnitConvertionItem *unitItem, int index = -1);

	CaplAPI *m_api;
	CaplInstance *m_pdf;
	double m_baseCount;
	CaplInstance *m_baseUnit;
	aplExtent m_allUnits;
	aplExtent m_existUnitConvertions;
	CArray<CUnitConvertionItem*, CUnitConvertionItem*> m_deletedItems;

protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()

	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMSetfocusList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedAdd();
	afx_msg void OnBnClickedDelete();
};
