#if !defined(AFX_APLACCESSVIEW_H__0009FF58_E50E_496C_9002_2AE0F5A27ECA__INCLUDED_)
#define AFX_APLACCESSVIEW_H__0009FF58_E50E_496C_9002_2AE0F5A27ECA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// aplAccessView.h : header file
//
#include "apl_gui.h"
#include "apl_api.h"
#include "aplPropsView.h"
/////////////////////////////////////////////////////////////////////////////
// CaplAccessView view

typedef CArray<long,long>	CLongArray;
typedef CArray<int,int>		CIntArray;
typedef CMap<long,long,int,int> CAccMap;

class CaplAccessView : public CaplPropsView
{
protected:
	CaplAccessView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CaplAccessView)

// Attributes
public:

// Operations
public:

	virtual	BOOL	InitColumns(void);
	virtual BOOL	LoadData(void);
	virtual BOOL	FillList(void);

	virtual void	OnBAdd(void);
	virtual void	OnBDel(void);
	virtual void	OnBProps(void);

	BOOL			GetAccessString(CString& csOut);
	void			SetDefaultTemplate(LPCTSTR csTemplName);

protected:

	CString			m_csSysAcc;

	aplExtent		m_aeAccPats;
	//	0 = 
	int 			m_iSelPat;
	BOOL			m_bEdPat;

	CAccMap			m_mId2Acc;

	CComboBox*		m_pInplaceCombo;

	long			m_lEditingId;

	void			_GetDefAcc(CString& csIn,int& iAcc);
	void			_ParseAcc(CString& csIn);

	void			__TranslateAcc(CString& csIn,int& iOut);
	void			__TranslateAcc(int& iIn,CString& csOut);
	void			__TranslateAccShort(int& iIn,CString& csOut);

	void			_StartInplaceEditing(CRect& rt,int& iDefAcc,BOOL bTempl,BOOL bShowNC);
	BOOL			_StopInplaceEditing(int& iOutAcc);

	void			_ChangeBtnsState(BOOL bEn);

	virtual void	ChangeCtrlsState(void);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplAccessView)
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CaplAccessView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplAccessView)
	afx_msg void OnClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_APLACCESSVIEW_H__0009FF58_E50E_496C_9002_2AE0F5A27ECA__INCLUDED_)
