#if !defined(AFX_APLENTRYVIEW_H__5C234725_DC7C_4B67_83EC_B8AEB28A0E14__INCLUDED_)
#define AFX_APLENTRYVIEW_H__5C234725_DC7C_4B67_83EC_B8AEB28A0E14__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// aplEntryView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CaplEntryView view

#include "apl_gui.h"
#include "apl_api.h"
#include "aplPropsView.h"
#include "DocCreateDlg.h"

class CDocCreateDlg;

struct sData
{
	CaplInstance *m_ciDocEntry;
	CaplInstance *m_ciDocRevVal;
};

class CaplEntryView : public CaplPropsView
{
protected:
	CaplEntryView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CaplEntryView)

// Attributes
public:

	//           
	aplExtent m_aeEntryToCreate;

	bool m_bCanEdit;
	bool m_bIsActiveVer;

	CaplAdminModeProvider m_adminmode;

	CDocCreateDlg *m_pParent;
	CArray<sData*, sData*> m_caData;

	CListCtrl *m_list;

// Operations
public:

	virtual	BOOL	InitColumns(void);
 	virtual BOOL	LoadData(void);

	virtual BOOL	_FillItem(int iPos,CaplInstance* ciIn);

			void	CreateEditBox();
			void	HideEditBox(bool bCreateVal = true);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplEntryView)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view	
	//}}AFX_VIRTUAL

// Implementation
protected:
	//       
	bool UserHasSpecialRole();

	//      ?
	bool CanChangeEntryVal(CaplInstance *cit);

	//        
	void FillEntryFromDocVer(bool bActive, CaplInstance *cit, int nCol, bool bAddData = true);

	//       sName
	int GetSameEntryFromList(CString sName);

	//    apl_document_entry_value
	CaplInstance *CreateEntryValue(CaplInstance *ciDocRevValPrev, CaplInstance *ciEntry, CaplInstance *ciDocRev, CString sValue);

	//     sValue   
	CaplInstance* IsEntryAlreadyExist(CaplInstance *ciDocRev, CString sValue, CaplInstance *&ciDocEntryVal);
	
	//        " " 
	bool ChangeDocCard(CaplInstance *ciEntry, CString sValue);

	//         
	void CreateListItem(CaplInstance *cit, int nCol, bool bAddData);

	//     
	bool ChangeEntryVal(CString sValue, CString sName, int nItem);	

	//   
	void ParseMailList(CString& csInRasc,CString csDepotSep,CString csGrpSep,
							  CStringArray* csapOutDepots,CStringArray* csapOutGrps);

	//    
	bool DoesMailListCorrect(CString sMailList, bool bShowErrMsg);

	//  
	bool IsDateCorrect(CString sDate);

	//     
	bool CheckForValidDepot(CString sMailList);	
	
protected:
	CWnd *m_edit_wnd;
	CComboBox m_edit;
	CImageList m_image;

	CString m_sPrevVal;
	int m_nCurrentItem;			//   ,   edit box'o

	virtual ~CaplEntryView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplEntryView)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_APLENTRYVIEW_H__5C234725_DC7C_4B67_83EC_B8AEB28A0E14__INCLUDED_)
