// aplFormManager.cpp: implementation of the CaplFormManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "apl_api.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern HINSTANCE CaplFormManagerDlgDLL;

CaplFormManager::CaplFormManager():CaplStepManager()
{
	Detach();
	if(CaplFormManagerDlgDLL!=NULL) 
		(FARPROC&)m_FShowFormI= GetProcAddress(CaplFormManagerDlgDLL,"_ShowFormI");
}


bool CaplFormManager::Attach(CaplAPI *api)
{
	if(api==0 || !api->m_data.IsConnected()) {Detach();return false;}
	CaplStepManager::Attach(api);

	e_form			=m_data->GetEntityBN(_T("apl_form"));
	a_form_name		=m_data->GetAttrDefinition(e_form,_T("name"));
	a_form_width	=m_data->GetAttrDefinition(e_form,_T("width"));
	a_form_height	=m_data->GetAttrDefinition(e_form,_T("height"));
	a_form_instances=m_data->GetAttrDefinition(e_form,_T("instances"));
	a_form_elements	=m_data->GetAttrDefinition(e_form,_T("elements"));
	a_form_active	=m_data->GetAttrDefinition(e_form,_T("active"));
	a_form_locker	=m_data->GetAttrDefinition(e_form,_T("locker"));
	a_form_descr	=m_data->GetAttrDefinition(e_form,_T("description"));

	e_form_revision			=m_data->GetEntityBN(_T("apl_form_revision"));
	a_form_rev_id			=m_data->GetAttrDefinition(e_form_revision,_T("id"));
	a_form_rev_name			=m_data->GetAttrDefinition(e_form_revision,_T("name"));
	a_form_rev_width		=m_data->GetAttrDefinition(e_form_revision,_T("width"));
	a_form_rev_height		=m_data->GetAttrDefinition(e_form_revision,_T("height"));
	a_form_rev_start_date	=m_data->GetAttrDefinition(e_form_revision,_T("start_date"));
	a_form_rev_end_date		=m_data->GetAttrDefinition(e_form_revision,_T("end_date"));
	a_form_rev_author		=m_data->GetAttrDefinition(e_form_revision,_T("author"));
	a_form_rev_user			=m_data->GetAttrDefinition(e_form_revision,_T("user"));
	a_form_rev_of_form		=m_data->GetAttrDefinition(e_form_revision,_T("of_form"));
	a_form_rev_elements		=m_data->GetAttrDefinition(e_form_revision,_T("elements"));
	a_form_rev_instances	=m_data->GetAttrDefinition(e_form_revision,_T("instances"));
	a_form_rev_descr		=m_data->GetAttrDefinition(e_form_revision,_T("description"));

	e_form_instance							=m_data->GetEntityBN(_T("form_instance"));
	a_form_instance_base_instance			=m_data->GetAttrDefinition(e_form_instance,_T("base_instance"));
	a_form_instance_base_instance_attr_name	=m_data->GetAttrDefinition(e_form_instance,_T("base_instance_attr_name"));
	a_form_instance_entity_name				=m_data->GetAttrDefinition(e_form_instance,_T("entity_name"));
	a_form_instance_child_instances			=m_data->GetAttrDefinition(e_form_instance,_T("child_instances"));
	a_form_instance_attrs					=m_data->GetAttrDefinition(e_form_instance,_T("attrs"));
	
	e_form_el_access	=m_data->GetEntityBN(_T("form_el_access"));
	a_form_el_acc_type	=m_data->GetAttrDefinition(e_form_el_access,_T("access_type"));
	a_form_el_acc_dis	=m_data->GetAttrDefinition(e_form_el_access,_T("disable"));
	a_form_el_acc_roles	=m_data->GetAttrDefinition(e_form_el_access,_T("roles"));
	

	e_form_element				=m_data->GetEntityBN(_T("form_element"));
	a_form_element_point		=m_data->GetAttrDefinition(e_form_element,_T("point"));
	a_form_element_cx			=m_data->GetAttrDefinition(e_form_element,_T("cx"));
	a_form_element_cy			=m_data->GetAttrDefinition(e_form_element,_T("cy"));
	a_form_element_text			=m_data->GetAttrDefinition(e_form_element,_T("text"));
	a_form_element_form_instance=m_data->GetAttrDefinition(e_form_element,_T("form_instance"));
	a_form_element_tab_order	=m_data->GetAttrDefinition(e_form_element,_T("tab_order"));
	a_form_element_is_req		=m_data->GetAttrDefinition(e_form_element,_T("is_required"));
	a_form_element_access		=m_data->GetAttrDefinition(e_form_element,_T("access"));

	e_characteristic_element					=m_data->GetEntityBN(_T("characteristic_element"));
	a_characteristic_element_characteristic		=m_data->GetAttrDefinition(e_characteristic_element,_T("characteristic"));
	a_characteristic_element_characteristic_type=m_data->GetAttrDefinition(e_characteristic_element,_T("characteristic_type"));

	e_attr_element				=m_data->GetEntityBN(_T("attr_element"));
	a_attr_element_attr_name	=m_data->GetAttrDefinition(e_attr_element,_T("attr_name"));
	a_attr_element_attr_id		=m_data->GetAttrDefinition(e_attr_element,_T("attr_id"));
	a_attr_element_subst_form	=m_data->GetAttrDefinition(e_attr_element,_T("subst_form"));

	e_text_element	=m_data->GetEntityBN(_T("text_element"));
	e_frame_element	=m_data->GetEntityBN(_T("frame_element"));
	
	e_inst_select_element				=m_data->GetEntityBN(_T("inst_select_element"));
	a_inst_select_element_name			=m_data->GetAttrDefinition(e_inst_select_element,_T("name"));
	a_inst_select_element_instance_name	=m_data->GetAttrDefinition(e_inst_select_element,_T("instance_name"));

	e_picture_element		=m_data->GetEntityBN(_T("picture_element"));
	a_pic_element_mode		=m_data->GetAttrDefinition(e_picture_element,_T("mode"));
	a_pic_element_pic		=m_data->GetAttrDefinition(e_picture_element,_T("picture"));

	e_chars_list_element			=m_data->GetEntityBN(_T("charact_list_element"));
	a_chars_list_element_name		=m_data->GetAttrDefinition(e_chars_list_element,_T("name"));
	a_chars_list_element_chars_list	=m_data->GetAttrDefinition(e_chars_list_element,_T("chars_list"));

	LoadData();

	return true;
}

void CaplFormManager::Detach()
{
	e_form=0;
	a_form_name=0;
	a_form_width=0;
	a_form_height=0;
	a_form_instances=0;
	a_form_elements=0;
	a_form_active=0;
	a_form_locker=0;
	a_form_descr=0;

	e_form_revision=0;
	a_form_rev_id=0;
	a_form_rev_name=0;
	a_form_rev_width=0;
	a_form_rev_height=0;
	a_form_rev_start_date=0;
	a_form_rev_end_date=0;
	a_form_rev_author=0;
	a_form_rev_user=0;
	a_form_rev_of_form=0;
	a_form_rev_elements=0;
	a_form_rev_instances=0;
	a_form_rev_descr=0;

	e_form_instance=0;
	a_form_instance_base_instance=0;
	a_form_instance_base_instance_attr_name=0;
	a_form_instance_entity_name=0;
	a_form_instance_child_instances=0;
	a_form_instance_attrs=0;

	e_form_el_access=0;
	a_form_el_acc_type=0;
	a_form_el_acc_dis=0;
	a_form_el_acc_roles=0;

	e_form_element=0;
	a_form_element_point=0;
	a_form_element_cx=0;
	a_form_element_cy=0;
	a_form_element_text=0;
	a_form_element_form_instance=0;
	a_form_element_tab_order=0;
	a_form_element_is_req=0;
	a_form_element_access=0;

	e_characteristic_element=0;
	a_characteristic_element_characteristic=0;
	a_characteristic_element_characteristic_type=0;

	e_attr_element=0;
	a_attr_element_attr_name=0;
	a_attr_element_attr_id=0;
	a_attr_element_subst_form=0;

	e_text_element=0;
	e_frame_element=0;

	e_inst_select_element=0;
	a_inst_select_element_name=0;
	a_inst_select_element_instance_name=0;

	e_picture_element=0;
	a_pic_element_mode=0;
	a_pic_element_pic=0;

	e_chars_list_element=0;
	a_chars_list_element_name=0;
	a_chars_list_element_chars_list=0;
}

void CaplFormManager::LoadData()
{
	CaplEntity* ce_point=NULL;
	CaplAttr*	ca_x=NULL;
	CaplAttr*	ca_y=NULL;
	CaplLoadData cld(&(m_api->m_data),DEF_SOURCE);

	int i1,i2,i3,i4,i5,i6;

	ce_point=m_api->m_data.GetEntityBN(_T("apl_point"));
		ca_x=m_api->m_data.GetAttrDefinition(ce_point,_T("x"));
		ca_y=m_api->m_data.GetAttrDefinition(ce_point,_T("y"));

	i1=cld.AddQuery(_T('e'),0,e_form,0,true,true);
//		cld.AddQuery(_T('d'),i1,0,a_form_name,true);
//		cld.AddQuery(_T('d'),i1,0,a_form_width,true);
//		cld.AddQuery(_T('d'),i1,0,a_form_height,true);
//		i2=cld.AddQuery(_T('d'),i1,0,a_form_instances,true);
		i2=cld.AddQuery(_T('e'),0,e_form_instance,0,true,true);
//			cld.AddQuery(_T('d'),i2,0,a_form_instance_base_instance,true);
//			cld.AddQuery(_T('d'),i2,0,a_form_instance_base_instance_attr_name,true);
//			cld.AddQuery(_T('d'),i2,0,a_form_instance_entity_name,true);
//			cld.AddQuery(_T('d'),i2,0,a_form_instance_child_instances,true);
//			cld.AddQuery(_T('d'),i2,0,a_form_instance_attrs,true);
//		i3=cld.AddQuery(_T('d'),i1,0,a_form_elements,true);
		i3=cld.AddQuery(_T('e'),0,e_form_element,0,true,true);
				cld.AddQuery(_T('d'),i3,0,a_form_element_point,true,true);
			i4=cld.AddQuery(_T('d'),i3,0,a_chars_list_element_chars_list,true,true);
//				cld.AddQuery(_T('d'),i4,0,ca_x,true);
//				cld.AddQuery(_T('d'),i4,0,ca_y,true);
			i5=cld.AddQuery(_T('d'),i3,0,a_form_element_access,true,true);
//			cld.AddQuery(_T('d'),i3,0,a_form_element_cx,true);
//			cld.AddQuery(_T('d'),i3,0,a_form_element_cy,true);
//			cld.AddQuery(_T('d'),i3,0,a_form_element_text,true);
//			cld.AddQuery(_T('d'),i3,0,a_form_element_form_instance,true);
//			cld.AddQuery(_T('d'),i3,0,a_form_element_tab_order,true);
//			cld.AddQuery(_T('d'),i3,0,a_characteristic_element_characteristic,true);
//			cld.AddQuery(_T('d'),i3,0,a_characteristic_element_characteristic_type,true);
//			cld.AddQuery(_T('d'),i3,0,a_attr_element_attr_name,true);
//			cld.AddQuery(_T('d'),i3,0,a_attr_element_attr_id,true);
	i6=cld.AddQuery(_T('e'),0,e_form_revision,0,true,true);

	cld.LoadEx();
	cld.ClearQuery();
}

BOOL CaplFormManager::LoadInstAttrs(CaplInstance* cit)
{
	CaplLoadData cld(&(m_api->m_data),DEF_SOURCE);

	if(NULL==cit)
		return FALSE;
	if(NULL==cit->GetType())
		return FALSE;

	cld.AddQuery(-1,cit,true);
	if(false==cld.LoadEx())
		return FALSE;
	if(false==cld.ClearQuery())
		return FALSE;

	return TRUE;
}

BOOL CaplFormManager::LoadLockerAttrs(CaplInstance* ciLocker)
{
	int	i1,i2,i3,i4;
	CaplLoadData cld(&(m_api->m_data),DEF_SOURCE);

	if(NULL==ciLocker)
		return FALSE;
	if(NULL==ciLocker->GetType())
		return FALSE;

	i1=cld.AddQuery(-1,ciLocker,true);
		i2=cld.AddQuery(_T('d'),i1,0,a_form_rev_elements,true,true);
			i3=cld.AddQuery(_T('d'),i2,0,a_form_element_point,true,true);

		i4=cld.AddQuery(_T('d'),i1,0,a_form_rev_instances,true,true);
			cld.AddQuery(_T('d'),i4,0,a_form_instance_base_instance,true,true);
			cld.AddQuery(_T('d'),i4,0,a_form_instance_child_instances,true,true);
			cld.AddQuery(_T('d'),i4,0,a_form_instance_attrs,true,true);

	if(false==cld.LoadEx())
		return FALSE;
	if(false==cld.ClearQuery())
		return FALSE;

	return TRUE;
}

BOOL CaplFormManager::GetFormEntityName(CaplInstance* form,CString &entity_name)
{
	if(!m_api) return FALSE;
	if(!m_api->m_data.IsConnected()) return FALSE;
	if(form==0)return FALSE;

	CaplInstance *form_revision,*form_instance,*base_instance;
	aplExtent ext_fi;
	m_api->m_data.GetAttr(form,m_api->m_form_mgr.a_form_active,form_revision);
	if(form_revision==0){
		m_api->m_data.GetAttr(form,m_api->m_form_mgr.a_form_instances,ext_fi);
	}else{
		m_api->m_data.GetAttr(form_revision,m_api->m_form_mgr.a_form_rev_instances,ext_fi);
	}
	for(int i=0;i<ext_fi.GetSize();i++){
		form_instance=ext_fi.GetAt(i);
		m_api->m_data.GetAttr(form_instance,m_api->m_form_mgr.a_form_instance_base_instance,base_instance);
		if(base_instance==0){
			m_api->m_data.GetAttr(form_instance,m_api->m_form_mgr.a_form_instance_entity_name,entity_name);
			return TRUE;
		}
	}
	
	return TRUE;
}

bool CaplFormManager::TestFormCompatible(CaplInstance* form,CString &test_entity_name)
{
	if(!m_api) return false;
	if(!m_api->m_data.IsConnected()) return false;
	if(form==0)return false;
	if(test_entity_name.IsEmpty()==TRUE) return true;//      

	CaplEntity *test_entity=0;
	test_entity=m_api->m_data.GetEntityBN(test_entity_name);
	return TestFormCompatible(form,test_entity);

}
bool CaplFormManager::TestFormCompatible(CaplInstance* form,CaplEntity *test_entity)
{
	if(!m_api) return false;
	if(!m_api->m_data.IsConnected()) return false;
	if(form==0)return false;
	if(test_entity==0) return true;//      

	int i;
	CString form_ent_name=_T("");
	CaplEntity *form_entity=0;
	GetFormEntityName(form,form_ent_name);
	if(form_ent_name.IsEmpty()==TRUE) return false;//       !
	form_entity=m_api->m_data.GetEntityBN(form_ent_name);

	//     
	if(form_entity==test_entity)return true;
	//     
	for(i=0;i<test_entity->all_subtypes.GetSize();i++){
		if(test_entity->all_subtypes.GetAt(i)==form_entity)return true;
	}
	
	return false;
}

CaplInstance* CaplFormManager::GetFormBN(LPCTSTR lpszName)
{
	if(m_api==NULL) return NULL;
	if(!m_api->m_data.IsDictLoad()) return NULL;
	if(lpszName==NULL) return NULL;

	int i;
	CString sName;
	aplExtent ext;
	m_api->m_data.GetEntityExtent(e_form, ext);
	for(i=0; i<ext.GetSize(); i++)
	{
		if(ext[i]==NULL) continue;
		if(ext[i]->GetAccessmode()>aplRO) continue;
		
		m_api->m_data.GetAttr(ext[i], a_form_name, sName);
		if(sName.CompareNoCase(lpszName)==0) return ext[i];
	}

	return NULL;
}

bool CaplFormManager::ShowForm(CaplInstance* ciForm,
							   aplExtent& aeInInsts, aplExtent& aeOutInsts, aplExtent* aeChars, LPCTSTR csInstChg,
							   CString csPath, BOOL bAutoSave, BOOL bTst, BOOL bHideAdd)
{
	if(m_api==NULL) return false;
	if(!m_api->m_data.IsDictLoad()) return false;
	if(ciForm==NULL) return false;
	if(ciForm->GetAccessmode()>aplRO) return false;

	if(m_FShowFormI==NULL) return false;

	m_FShowFormI(m_api, ciForm, aeInInsts, aeOutInsts, aeChars, csInstChg, csPath, bAutoSave, bTst, bHideAdd);
	return true;
}
