// aplPropsView.cpp : implementation file
//

#include "stdafx.h"
#include "aplPropsView.h"
#include "aplAccessView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplPropsView

IMPLEMENT_DYNCREATE(CaplPropsView, CMultiColumnSortListView)

CaplPropsView::CaplPropsView()
{
	m_api	=NULL;
	m_inst	=NULL;

	m_pAdd		=NULL;
	m_pDel		=NULL;
	m_pProps	=NULL;

	m_bFirstTimeActivate= false;
}

CaplPropsView::~CaplPropsView()
{
}


BEGIN_MESSAGE_MAP(CaplPropsView, CMultiColumnSortListView)
	//{{AFX_MSG_MAP(CaplPropsView)
	ON_WM_MOUSEACTIVATE()
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnSelchanged)
	ON_NOTIFY_REFLECT(NM_CLICK, OnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CaplPropsView::InitColumns(void)
{
	return TRUE;
}

BOOL CaplPropsView::LoadData(void)
{
	return TRUE;
}

BOOL CaplPropsView::InitView(void)
{
	if(!m_bFirstTimeActivate)
	{
		LoadData();
		FillList();
		m_bFirstTimeActivate= true;
	}
	return TRUE;
}

BOOL CaplPropsView::FillList(void)
{
	CaplInstance*	cit		=NULL;

	int				i;

	if(NULL==m_api)
		return FALSE;

	for(i=0;i<m_aeItems.Size;i++)
	{
		cit=m_aeItems.GetAt(i);
		if(FALSE==_FillItem(i,cit))
			return FALSE;
	}
	
	if(!IsKindOf(RUNTIME_CLASS(CaplAccessView)))
	{
		ReSort();
		if(m_aeItems.Size>0)
			GetListCtrl().SetItem(0,0,LVIF_STATE,_T(""),0,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED,NULL);
	}

	return TRUE;
}

BOOL CaplPropsView::_FillItem(int iPos,CaplInstance* ciIn)
{
	return TRUE;
}

void CaplPropsView::OnBAdd(void)
{
}

void CaplPropsView::OnBDel(void)
{
}

void CaplPropsView::OnBProps(void)
{
}

void CaplPropsView::SetBtnsHandles(CaplButton* pAdd,CaplButton* pDel,CaplButton* pProps)
{
	m_pAdd		=pAdd;
	m_pDel		=pDel;
	m_pProps	=pProps;
}

void CaplPropsView::ChangeCtrlsState(void)
{
	POSITION pos		=NULL;

	BOOL	bEnAdd		=FALSE;
	BOOL	bEnDel		=FALSE;
	BOOL	bEnProps	=FALSE;

	if(!IsWindowVisible())
		return;

	pos=GetListCtrl().GetFirstSelectedItemPosition();
	if(NULL!=m_inst)
	{
		if(m_inst->GetAccessmode()<aplRO)
		{
			bEnAdd=TRUE;
			if(NULL!=pos)
			{
				bEnDel=TRUE;
				bEnProps=TRUE;
			}
			
		}
		else
		if(m_inst->GetAccessmode()==aplRO)
			if(NULL!=pos)
				bEnProps=TRUE;
	}

	m_pAdd->EnableWindow(bEnAdd);
	m_pDel->EnableWindow(bEnDel);
	m_pProps->EnableWindow(bEnProps);
}
/////////////////////////////////////////////////////////////////////////////
// CaplPropsView drawing

void CaplPropsView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CaplPropsView diagnostics

#ifdef _DEBUG
void CaplPropsView::AssertValid() const
{
	CMultiColumnSortListView::AssertValid();
}

void CaplPropsView::Dump(CDumpContext& dc) const
{
	CMultiColumnSortListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CaplPropsView message handlers
int CaplPropsView::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message) 
{
	int nResult = CWnd::OnMouseActivate(pDesktopWnd, nHitTest, message);
	if (nResult == MA_NOACTIVATE || nResult == MA_NOACTIVATEANDEAT)
		return nResult;   // frame does not want to activate

	return MA_ACTIVATE;
}

void CaplPropsView::OnInitialUpdate() 
{
	CMultiColumnSortListView::OnInitialUpdate();

	InitColumns();
	
	if(!IsKindOf(RUNTIME_CLASS(CaplAccessView)))
	{
		SetItemSortState(0, (SORT_STATE)ASCENDING);
		SortColumn(0, SINGLE_COLUMN_SORT);
	}
	
//	LoadData();
//	FillList();
}

void CaplPropsView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	*pResult = 0;

	ChangeCtrlsState();
}

void CaplPropsView::OnClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
//	ChangeCtrlsState();	
	*pResult = 0;
}

void CaplPropsView::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnBProps();
	*pResult = 0;
}

void CaplPropsView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CListCtrl* pList  =NULL;

	POSITION	pos	=NULL;

	static int iSpos=0;

	CMultiColumnSortListView::OnShowWindow(bShow, nStatus);

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	if(FALSE==bShow)
	{
		pos=pList->GetFirstSelectedItemPosition();
		if(NULL==pos)
			return;
		iSpos=pList->GetNextSelectedItem(pos);
	}
	if(TRUE==bShow)
	{
		pList->SetItem(iSpos,0,LVIF_STATE,_T(""),0,LVIS_FOCUSED|LVIS_SELECTED,LVIS_FOCUSED|LVIS_SELECTED,NULL);
		pList->SetFocus();
	}
}