// CChoose_inst_dlg.cpp : implementation file
//
#include "stdafx.h"
#include "choose_inst_dlg.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define CLASS_ICO_INDEX 0

/////////////////////////////////////////////////////////////////////////////
// CChoose_inst_dlg dialog

int CALLBACK CompareItemsByText(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort)
{
	CString buf1, buf2;

	return buf1.Compare(buf2);
}

CChoose_inst_dlg::CChoose_inst_dlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CChoose_inst_dlg::IDD, pParent)
	, m_sCodeTitle(APL_T(":"))
	, m_sNameTitle(APL_T(":"))
{
	//{{AFX_DATA_INIT(CChoose_inst_dlg)
	//}}AFX_DATA_INIT
	m_report_ctrl.SetUniqueName(_T("CChoose_inst_dlg"));
	chosen_element=0;
	//attached=false;
	m_api=0;
	m_default_names=0;
	m_attr_for_def=0;
	m_show_all_types=false;
	m_bSelectGroup=false;

	selected_group=0;
	selected_element=0;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		m_sCode = app->GetProfileString(_T("Settings"), _T("Code"), _T(""));
		m_sName =  app->GetProfileString(_T("Settings"), _T("Name"), _T(""));
	}
}

void CChoose_inst_dlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChoose_inst_dlg)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_BORDER, m_border);
	DDX_Control(pDX, IDC_TREE_CTRL, m_tree_ctrl);
	DDX_Control(pDX, IDC_REFRESH, m_refresh);

	DDX_Text(pDX, IDC_CODE, m_sCode);
	DDX_Text(pDX, IDC_NAME, m_sName);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_STATIC_CODE, m_sCodeTitle);
	DDX_Text(pDX, IDC_STATIC_NAME, m_sNameTitle);
}

BEGIN_MESSAGE_MAP(CChoose_inst_dlg, CResizableDialog)
	//{{AFX_MSG_MAP(CChoose_inst_dlg)
	ON_WM_PAINT()
	ON_NOTIFY(NM_DBLCLK, IDS_REP_CTRL, OnDblclkList1)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_CTRL, OnSelchangedTreeCtrl)
	ON_COMMAND(WM_SPLITTER_MOVED, OnSplitterMoved)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_REFRESH, &CChoose_inst_dlg::OnBnClickedRefresh)
	ON_EN_CHANGE(IDC_CODE, &CChoose_inst_dlg::OnEnChangeCode)
	ON_EN_CHANGE(IDC_NAME, &CChoose_inst_dlg::OnEnChangeName)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChoose_inst_dlg message handlers
void CChoose_inst_dlg::LoadContent()
{
	if(e_elem==m_api->m_doc_mgr.e_dt) GetAllDocTypes();

	m_report_ctrl.DeleteAllColumns();
	for(int i=0;i<elements.GetSize();i++)
	{
		m_report_ctrl.InsertColumn(i+1,elements[i].header,LVCFMT_LEFT,elements[i].width);
	}

	m_report_ctrl.SetItemSortState(0, (SORT_STATE)DESCENDING);
	m_report_ctrl.SortColumn(0, SINGLE_COLUMN_SORT);

	this->SetWindowText(header);

	m_tree_ctrl.DeleteAllItems();
	HTREEITEM def_items=0;

	if(m_default_names!=0)
	{
		def_items=m_tree_ctrl.InsertItem( APL_T(" "),CLASS_ICO_INDEX,CLASS_ICO_INDEX+1);
		m_tree_ctrl.SetItemData(def_items,-2);
	}

	HTREEITEM cur_item=m_tree_ctrl.InsertItem( APL_T("  "),CLASS_ICO_INDEX,CLASS_ICO_INDEX+1);
	m_tree_ctrl.SetItemData(cur_item,-1);

	AddGroupsToTree();

	if(selected_group)
	{
		HTREEITEM found_item=FindInTree(selected_group);
		if(found_item!=NULL)
			cur_item=found_item;
	}
	else if(m_default_names!=0) cur_item=def_items;

	m_tree_ctrl.Select(cur_item,TVGN_CARET);

	if(e_group==m_api->m_doc_mgr.e_dt_group)
	{
		m_report_ctrl.SetItemSortState(1, (SORT_STATE)ASCENDING);
		m_report_ctrl.SortColumn(1, SINGLE_COLUMN_SORT);
	}
	else
	{
		m_report_ctrl.SetItemSortState(0, (SORT_STATE)ASCENDING);
		m_report_ctrl.SortColumn(0, SINGLE_COLUMN_SORT);
	}	

	if(selected_element)
	{
		int sel_elem=FindElement(selected_element);
		if(sel_elem>=0){
			m_report_ctrl.SetItemState(sel_elem,LVIS_SELECTED | LVIS_FOCUSED,LVIS_SELECTED | LVIS_FOCUSED);
			m_report_ctrl.EnsureVisible(sel_elem,TRUE);
		}
	}

	m_report_ctrl.AutoSizeColumn(0);
}

BOOL CChoose_inst_dlg::OnInitDialog()
{
	RECT rect={5,5,10,10};
	m_report_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS|LVS_SINGLESEL,rect,this,IDS_REP_CTRL);
	
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_border.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_report_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_report_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_report_ctrl.m_hWnd)
			|LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);//|LVS_EX_ONECLICKACTIVATE


	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_refresh.SetFlat(FALSE);
		
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_TREE_CTRL, TOP_LEFT, CSize(50, 100));
	AddAnchor(IDS_REP_CTRL,CSize(50, 0), BOTTOM_RIGHT);
	AddAnchor(IDC_REFRESH, BOTTOM_LEFT);

	AddAnchor(IDC_STATIC_CODE, CSize(50, 0), CSize(75, 0));
	AddAnchor(IDC_CODE, CSize(50, 0), CSize(75, 0));
	AddAnchor(IDC_STATIC_NAME, CSize(75, 0), TOP_RIGHT);
	AddAnchor(IDC_NAME, CSize(75, 0), TOP_RIGHT);	

	m_imageList.Create(IDR_CLASS_ICO, 16, 2, RGB(192, 192, 192));
	m_tree_ctrl.SetImageList(&m_imageList,TVSIL_NORMAL);

	LoadContent();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CChoose_inst_dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

	}
	else
	{
		CResizableDialog::OnPaint();
	}
}

void CChoose_inst_dlg::AddGroupsToTree(CaplInstance *parent_group/* =0 */, HTREEITEM htParent/* = TVI_ROOT */)
{
	aplExtent ext;
	if(e_group==0)return;
	apidata.GetEntityExtent(e_group,ext);
	for(int i=0;i<ext.GetSize();i++)
	{
		CString id=_T("");
		CString name=_T("");
		CaplInstance *parent_inst=0;
		apidata.GetAttr(ext[i],a_group_parent,parent_inst);
		if(parent_inst==parent_group)
//		if(((parent_group)&&(parent_inst==parent_group))||((!parent_group)&&(!parent_inst)))
		{
			apidata.GetAttr(ext[i],a_group_id,id);
			apidata.GetAttr(ext[i],a_group_name,name);
			HTREEITEM hi=AddToTree(ext[i],id+_T(":")+name,parent_inst, htParent);
//			HTREEITEM hi=AddToTree(ext[i], name, parent_inst, htParent);
			AddGroupsToTree(ext[i], hi);
		}
	}

	m_tree_ctrl.Expand(htParent, TVE_EXPAND);
	m_tree_ctrl.SortChildren(htParent);
}

HTREEITEM CChoose_inst_dlg::AddToTree(CaplInstance *group, CString group_id, CaplInstance *parent_inst, HTREEITEM htParent)
{	
//	CArray<HTREEITEM, HTREEITEM> curItems;
//	CArray<HTREEITEM, HTREEITEM> childItems;
//	
//	HTREEITEM hRoot= m_tree_ctrl.GetRootItem();
//	HTREEITEM hNextItem= NULL;
//	while(hRoot)
//	{
//		curItems.Add(hRoot);
//		hNextItem = m_tree_ctrl.GetNextItem(hRoot, TVGN_NEXT);
//		hRoot = hNextItem;
//	}			
//
//	HTREEITEM foundItem= htParent;
//
//	while(curItems.GetSize())
//	{
//		for(int i= 0; i<curItems.GetSize(); i++)
//		{
//			CaplInstance *cur_group=(CaplInstance*)m_tree_ctrl.GetItemData(curItems[i]);
//			
//			CString id;
//			if(-1!=(long)cur_group && -2!=(long)cur_group && cur_group)
//			if(0<(long)cur_group)
//				apidata.GetAttr(cur_group,a_group_id,id);
//			
//			if(cur_group==parent_inst)
//			{
//				foundItem= curItems[i];
//				childItems.RemoveAll();
//				break;
//			}
//			
//			if(m_tree_ctrl.ItemHasChildren(curItems[i]))
//			{
//				HTREEITEM hChildItem = m_tree_ctrl.GetChildItem(curItems[i]);
//				hNextItem= NULL;
//				
//				while(hChildItem)
//				{
//					childItems.Add(hChildItem);
//					hNextItem = m_tree_ctrl.GetNextItem(hChildItem, TVGN_NEXT);
//					hChildItem = hNextItem;
//				}			
//			}
//		}
//
//		curItems.RemoveAll();
//		curItems.Append(childItems);
//		childItems.RemoveAll();
//	}
//
	HTREEITEM cur_item= m_tree_ctrl.InsertItem(group_id,CLASS_ICO_INDEX,CLASS_ICO_INDEX+1, htParent);

//	if(foundItem)
//		cur_item=m_tree_ctrl.InsertItem(group_id,CLASS_ICO_INDEX,CLASS_ICO_INDEX+1,foundItem);
//	else
//		cur_item=m_tree_ctrl.InsertItem(group_id,CLASS_ICO_INDEX,CLASS_ICO_INDEX+1);
	m_tree_ctrl.SetItemData(cur_item,DWORD(group));
//
//	return cur_item;

	return cur_item;
}

void CChoose_inst_dlg::SelchangedTreeCtrl(const HTREEITEM &hItem)
{
	UpdateData();

	m_report_ctrl.DeleteAllItems();
	DWORD item_data=m_tree_ctrl.GetItemData(hItem);
	int i;

	if(item_data==-1) // 
	{
		m_report_ctrl.SetRedraw(FALSE);

		aplExtent ext;
		selected_group=0;
		apidata.GetEntityExtent(e_elem,ext);
		for(i=0;i<ext.GetSize();i++)
			DisplayElement(ext[i],i);

		m_report_ctrl.SetRedraw(TRUE);
		return;
	}
	if(item_data==-2) // 
	{
		if((m_default_names==0) || (m_attr_for_def==0)) return;
		int counter=0;
		CString buf;
		aplExtent ext;

		apidata.GetEntityExtent(e_elem,ext);
		m_report_ctrl.SetRedraw(FALSE);

		for(i=0;i<ext.GetSize();i++)
		{
			bool bFound=false;
			apidata.GetAttr(ext[i],m_attr_for_def,buf);
			for(int j=0;j<m_default_names->GetSize();j++)
			{
				if(buf==(*m_default_names)[j]){bFound=true; break;}
			}
			if(bFound)
			{
				DisplayElement(ext[i],counter);
				counter++;
			}
		}

		m_report_ctrl.SetRedraw(TRUE);
		return;
	}


	CaplInstance *chosen_inst=(CaplInstance*)item_data;
	if(!chosen_inst)
		return;

	selected_group=chosen_inst;
	CaplAggr aggr;
	apidata.GetAttr(chosen_inst,a_group_content,aggr);
	for(i=0;i<aggr.GetSize();i++)
	{
		CaplInstance *inst=0;
		aggr.GetByIndex(i,inst);
		DisplayElement(inst,i);

	}
	m_report_ctrl.ReSort();
}

void CChoose_inst_dlg::OnSelchangedTreeCtrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	TV_ITEM item=pNMTreeView->itemNew;

	SelchangedTreeCtrl(item.hItem);
	
	*pResult = 0;
}

bool CChoose_inst_dlg::DisplayElement(CaplInstance *inst,int nItem)
{
	if(!inst) return false;
	if(inst->GetAccessmode()>aplRO) return false;

	nItem = m_report_ctrl.GetItemCount();
	if(e_elem==m_api->m_doc_mgr.e_dt)
		if(doc_types.Find(inst)<0) 
			return true;

	int inserted_item = m_report_ctrl.InsertItem(nItem,_T(""));
	m_report_ctrl.SetItemData(inserted_item,DWORD(inst));

	CString sName(m_sName), sCode(m_sCode);
	sName.MakeLower();
	sCode.MakeLower();
	
	for(int i=0;i<elements.GetSize();i++)
	{
		
		CString buf=_T(""), str;
		if(!elements[i].second_attr)
		{
			if(elements[i].function_type==0)
			{
				apidata.GetAttr(inst,elements[i].attr,buf);

				str = buf;
				str.MakeLower();

				//    
				if(_T("id") == elements[i].attr->name)
				{
					if(-1 == str.Find(sCode) && _T("") != m_sCode)
					{
						m_report_ctrl.DeleteItem(inserted_item);
						break;
					}
				}
				else if(_T("product_data_type") == elements[i].attr->name)
				{
					if(-1 == str.Find(sName) && _T("") != m_sName)
					{
						m_report_ctrl.DeleteItem(inserted_item);
						break;
					}
				}
				else if(_T("name") == elements[i].attr->name)
				{
					if(-1 == str.Find(sName) && _T("") != m_sName)
					{
						m_report_ctrl.DeleteItem(inserted_item);
						break;
					}
				}
			}
			if(elements[i].function_type==1)
			{
				m_api->m_charact_mgr.GetUnitName(inst,buf,true);				
				str = buf;
				str.MakeLower();

				//    
				if(-1 == str.Find(sName) && _T("") != m_sName)
				{
					m_report_ctrl.DeleteItem(inserted_item);
					break;
				}
			}
			if(elements[i].function_type==2)
			{
				GetUnitDescription(inst,buf);
			}
		}
		else
		{
			CaplInstance *inst1=0;
			apidata.GetAttr(inst,elements[i].attr,inst1);
			if(inst1)
			{
				if(elements[i].function_type==0)
					apidata.GetAttr(inst1,elements[i].attr,buf);
				if(elements[i].function_type==1)
					m_api->m_charact_mgr.GetUnitName(inst1,buf);
				if(elements[i].function_type==2)
					GetUnitDescription(inst1,buf);
			}
		}

		m_report_ctrl.SetItemText(nItem,i,buf);
	}	

	return true;
}

CaplInstance* CChoose_inst_dlg::GetChosenElement()
{
	return chosen_element;
}

bool CChoose_inst_dlg::GetUnitDescription(CaplInstance *unit, CString &buf)
{
	buf=_T("");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit))
		buf= APL_T("  ");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit))
		buf= APL_T("  ");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit))
		buf= APL_T(" ");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
		buf= APL_T("  ");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_derived_unit))
	{
		CaplAggr der_unit_elements;
		apidata.GetAttr(unit,m_api->m_unit_exch_mgr.a_apl_derived_unit_elements,der_unit_elements);
		for(int i=0;i<der_unit_elements.GetSize();i++)
		{
			CaplInstance *der_unit_element=0;

			der_unit_elements.GetByIndex(i,der_unit_element);
			if(der_unit_element)
			{
				CaplInstance *base_unit=0;
				double exponent=0;
				apidata.GetAttr(der_unit_element,m_api->m_unit_exch_mgr.a_apl_derived_unit_element_unit,base_unit);
				apidata.GetAttr(der_unit_element,m_api->m_unit_exch_mgr.a_apl_derived_unit_element_exponent,exponent);
				if(base_unit)
				{
					if(!buf.IsEmpty())
						buf += _T("*");
					CString unit_name_buf;
					m_api->m_charact_mgr.GetUnitName(base_unit,unit_name_buf);
					buf+=unit_name_buf;
					long longExponent=long(exponent);
					char buf_str[100];
					if(longExponent==exponent)
#if _MSC_VER >= 1400
						_ltoa(longExponent, buf_str, 10);
#else
						ltoa(longExponent,buf_str,10);
#endif
					else
						_gcvt(exponent,10,buf_str);
					buf+=_T("^")+CString(buf_str);
				}
			}
		}
	}
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_conv_base_unit))
	{
		CaplInstance *mvu=0;
		apidata.GetAttr(unit,m_api->m_unit_exch_mgr.a_apl_conv_base_unit_conv_factor,mvu);
		if(mvu)
		{
			CaplInstance *base_unit=0;
			double value=0;
			apidata.GetAttr(mvu,m_api->m_unit_exch_mgr.a_apl_measure_with_unit_unit_comp,base_unit);
			apidata.GetAttr(mvu,m_api->m_unit_exch_mgr.a_apl_measure_with_unit_value_comp,value);
			if(base_unit)
			{
				m_api->m_charact_mgr.GetUnitName(base_unit,buf);
				long longValue=long(value);
				char buf_str[100];
				if(longValue==value)
#if _MSC_VER >= 1400
					_ltoa(longValue,buf_str,10);
#else
					ltoa(longValue,buf_str,10);
#endif
				else
					_gcvt(value,10,buf_str);
				buf+=_T("*")+CString(buf_str);
			}
		}
	}
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_cont_dep_unit))
		buf= APL_T("- .");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_table_unit))
		buf= APL_T("..   ");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
		buf= APL_T(" ..");
	if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_si_unit))
		m_api->m_charact_mgr.GetUnitName(unit,buf);
	return true;
}

void CChoose_inst_dlg::AddToElements(ELEMS tmp)
{
	elements.Add(tmp);
}

void CChoose_inst_dlg::OnOK() 
{
	UpdateData();

	if(m_bSelectGroup && selected_group==0)
	{
		AfxMessageBox(APL_T("  "),MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	// TODO: Add extra validation here
	POSITION pos=m_report_ctrl.GetFirstSelectedItemPosition();
	int nItem=m_report_ctrl.GetNextSelectedItem(pos);
	if(nItem<0 && !m_bSelectGroup)
		return;
	if(nItem>=0) chosen_element=(CaplInstance*)m_report_ctrl.GetItemData(nItem);
	else chosen_element=0;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		app->WriteProfileString(_T("Settings"), _T("Code"), m_sCode);
		app->WriteProfileString(_T("Settings"), _T("Name"), m_sName);
	}

	CResizableDialog::OnOK();
}

void CChoose_inst_dlg::OnDblclkList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	OnOK();

	*pResult = 0;
}

HTREEITEM CChoose_inst_dlg::FindInTree(CaplInstance *group)
{
	CArray<HTREEITEM, HTREEITEM> curItems;
	CArray<HTREEITEM, HTREEITEM> childItems;
	
	HTREEITEM hRoot= m_tree_ctrl.GetRootItem();
	HTREEITEM hNextItem= NULL;
	while(hRoot)
	{
		curItems.Add(hRoot);
		hNextItem = m_tree_ctrl.GetNextItem(hRoot, TVGN_NEXT);
		hRoot = hNextItem;
	}			

	HTREEITEM foundItem= NULL;

	while(curItems.GetSize())
	{
		for(int i= 0; i<curItems.GetSize(); i++)
		{
			CaplInstance *cur_group=(CaplInstance*)m_tree_ctrl.GetItemData(curItems[i]);	
			if(cur_group==group)
				return curItems[i];
			
			if(m_tree_ctrl.ItemHasChildren(curItems[i]))
			{
				HTREEITEM hChildItem = m_tree_ctrl.GetChildItem(curItems[i]);
				hNextItem= NULL;
				
				while(hChildItem)
				{
					childItems.Add(hChildItem);
					hNextItem = m_tree_ctrl.GetNextItem(hChildItem, TVGN_NEXT);
					hChildItem = hNextItem;
				}			
			}
		}

		curItems.RemoveAll();
		curItems.Append(childItems);
		childItems.RemoveAll();
	}

	return NULL;
}

int CChoose_inst_dlg::FindElement(CaplInstance *element)
{
	for(int i=0;i<m_report_ctrl.GetItemCount();i++)
		if((CaplInstance*)m_report_ctrl.GetItemData(i)==element)
			return i;
	return -1;
}

void CChoose_inst_dlg::GetAllDocTypes()
{
	CaplInstance *inst;
	aplExtent ext;
	inst = m_api->m_appr_mgr.GetCurrentPerson();
	if(inst)m_api->m_data.GetAttrBN(inst,_T("apl_person_roles"),ext);

	/*      */
	if(m_show_all_types)
	{
		m_api->m_data.GetEntityExtent(m_api->m_doc_mgr.e_dt,doc_types);
		return;
	}

	/*  */
	for(int i=0; i<ext.Size;i++)
	{
		aplExtent tmp;
		bool nall=true;
		m_api->m_data.GetAttr(ext[i],m_api->m_appr_mgr.a_po_role_specified_document_types_set,nall);
		if(nall)
			m_api->m_data.GetAttrBN(ext[i],_T("document_types"),tmp);
		else
		{
			m_api->m_data.GetEntityExtent(m_api->m_doc_mgr.e_dt,doc_types);
			return;
		}
		doc_types.Append(tmp);
	}
}

void CChoose_inst_dlg::OnSplitterMoved()
{	
/*	ModifyAnchor(m_tree_ctrl.m_hWnd);
	ModifyAnchor(m_report_ctrl.m_hWnd);
	ModifyAnchor(m_wndVSplitterBar.m_hWnd);
	ModifyAnchor(m_zoomin_btn.m_hWnd);
	ModifyAnchor(m_zoomout_btn.m_hWnd);*/
}

void CChoose_inst_dlg::OnSize(UINT nType, int cx, int cy) 
{
	CResizableDialog::OnSize(nType, cx, cy);
}

void CChoose_inst_dlg::OnBnClickedRefresh()
{
	m_api->m_doc_mgr.LoadDictionary();

	LoadContent();	
	m_tree_ctrl.SelectItem( m_tree_ctrl.GetRootItem() );
}

void CChoose_inst_dlg::OnEnChangeCode()
{
	HTREEITEM hItem = m_tree_ctrl.GetSelectedItem();
	if(hItem) SelchangedTreeCtrl(hItem);
}

void CChoose_inst_dlg::OnEnChangeName()
{
	HTREEITEM hItem = m_tree_ctrl.GetSelectedItem();
	if(hItem) SelchangedTreeCtrl(hItem);
}

void CChoose_inst_dlg::OnCancel()
{
	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		app->WriteProfileString(_T("Settings"), _T("Code"), m_sCode);
		app->WriteProfileString(_T("Settings"), _T("Name"), m_sName);
	}

	CResizableDialog::OnCancel();
}