#include "stdafx.h"
#include "mainfunctions.h"
#include "apl_api.h"
#include "aplProjectMgr.h"


LPCTSTR plug_name = APL_T("  +  ");  //  
LPCTSTR plug_descr = APL_T("  +  "); //  

__declspec(dllexport) LPCTSTR GetAddInName(){return plug_name;}
__declspec(dllexport) LPCTSTR GetAddInDescription() {return plug_descr;}


// ,    
CaplItemInfo functionArray []=
{
	/*   PSM	
	CaplItemInfo(aplPopUp, "Project", "\\[-1]", "", -1, -1,""),
	CaplItemInfo(aplPopUp, "Project", "\\[-1] ", "add_ShowGantt", -1, -1,""),
	CaplItemInfo(aplPopUp, "Project", "\\[-1] ", "add_ShowProjectContentState", -1, -1,""),
	*/
	CaplItemInfo(aplPopUp, _T("Project"), APL_T("\\[-1]   "), _T("add_CertCreateProject"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T("Folder"), APL_T("[2]  "), _T("add_ShowFolderProjects"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T("Folder"), APL_T("[2]  "), _T("add_ShowProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T("Folder"), _T("[4]"), _T(""), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\  \\  "), _T("add_ShowAllProjects"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\  \\  "), _T("add_ShowGant4CurProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\  \\ ,   - "), _T("add_ShowGant4CurOwner"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\  \\ ,   - "), _T("add_ShowGant4CurKurator"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\  \\ ,   - "), _T("add_ShowGant4CurExecutor"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\ \\,   - "), _T("add_ShowCurOwnerProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\ \\,   - "), _T("add_ShowCurKuratorProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\ \\,   - "), _T("add_ShowCurExecutorProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\ \\ "), _T("add_ShowAllCurProjectsState"), -1, -1,_T("")),
	CaplItemInfo(aplPopUp, _T(""), APL_T("\\ \\"), _T("add_ShowAllProjectsState"), -1, -1,_T("")),
};

//************************************************************************
__declspec(dllexport) bool GetFunctionsList(CArray<CaplItemInfo*, CaplItemInfo*> *strArray)
{
	int functionArraySize= sizeof(functionArray)/sizeof(CaplItemInfo);
	for(int i= 0; i<functionArraySize; i++)
	{
		strArray->Add(&functionArray[i]);
	}
	return true;
}

//************************************************************************
//************************************************************************
//************************************************************************


enum eShowPrjMode{modeShowMoniror=1, modeShowGantt=2 };

//   
__declspec (dllexport) bool add_ShowGantt(CaplAPI* api,  aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	CaplProjectManager *m_project_mgr= (CaplProjectManager*)api->m_project_mgr;
	if(inExtent.GetSize()<1) return false;
	CaplInstance *prj=inExtent[0];
	if(0==prj)  return false;
	if(!api->m_data.IsKindOf(prj, m_project_mgr->e_project)) return false;		
	
	if(bUpdateUI)return true;

	if(prj->GetType()==0) return false;
	if(prj->GetAccessmode()>aplRO){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); return false;}

	aplExtent ext; ext.Add(prj);
	return m_project_mgr->ShowGanttDlg(ext);
}

//   
__declspec (dllexport) bool add_ShowFolderProjects(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	CaplProjectManager* m_project_mgr= (CaplProjectManager*)api->m_project_mgr;

	if(inExtent.GetSize()<0) return false;
	CaplInstance *folder=inExtent[0];
	if(!api->m_data.IsKindOf(folder, api->m_folder_mgr.e_folder)) return false;

	if(bUpdateUI) return true;

	if(folder->GetType()==0) return false;
	if(folder->GetAccessmode()>aplRO){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); return false;}


	//api->m_folder_mgr.LoadFolderInfo(inExtent[i]);

	//dlg.m_folder=inExtent[i];
	aplExtent ext,ext1,ext_rel;
	api->m_folder_mgr.GetFolderContents(folder,ext);
	int CreateAssocFolderDoc=AfxGetApp()->GetProfileInt(_T("options"),_T("CreateAssocFolderDoc"),0);
	if(1==CreateAssocFolderDoc)
	{
		((CaplProjectManager*)(api->m_project_mgr))->FindAssociatedProjects(folder,ext1,ext_rel);
		ext.Append(ext1);
	}
	return m_project_mgr->ShowGanttDlg(ext);
}

//    
__declspec (dllexport) bool add_ShowAllProjects(CaplAPI* api,  aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	CaplProjectManager *m_project_mgr= (CaplProjectManager *)api->m_project_mgr;

	if(bUpdateUI) return true;

	CString buf;
	int i;
	aplExtent ext,ext1;
	CaplLoadData ld(&(api->m_data),DEF_SOURCE);
	ld.AddQuery(_T('e'),0,m_project_mgr->e_project,0,true,true);
	ld.LoadEx(true,&ext);


	ext1.Unique=false;
	for(i=0;i<ext.GetSize();i++)
	{
		if(api->m_data.IsKindOf(ext[i], m_project_mgr->e_project)) ext1.Add(ext[i]);
	}
	ext1.Unique=true;;

	if(ext1.GetSize()==0) {AfxMessageBox(APL_T("  !")); return false;}
	if(ext1.GetSize()>1000)
	{
		buf.Format(APL_T(" %i .\n  1000      !\n\n ? "),ext1.GetSize());
		if(IDYES!=AfxMessageBox(buf,MB_ICONSTOP|MB_YESNO))return false;
	}
	else
	{
		buf.Format(APL_T(" %i .  ?"),ext1.GetSize());
		if(IDYES!=AfxMessageBox(buf,MB_ICONQUESTION|MB_YESNO))  return false;
	}
	return m_project_mgr->ShowGanttDlg(ext1);
}

//************************************************************************
//************************************************************************
//************************************************************************
//   

__declspec (dllexport) bool add_ShowAllProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;	
	
	aplExtent ext;
	return add_ShowProjectsState(api,ext,bUpdateUI);
}

//    
__declspec (dllexport) bool add_ShowProjectContentState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;
	if(inExtent.GetSize()<1) return false;

	CaplInstance *prj=inExtent[0];
	if(0==prj->GetId()) return false;
	if(prj->GetAccessmode()>aplRO) return false;
	if(!api->m_data.IsKindOf(prj,api->m_project_mgr->e_project)) return false;

	aplExtent ext_sub_prj;
	CaplProjectManager *m_project_mgr=(CaplProjectManager *)api->m_project_mgr;

	m_project_mgr->GetAllSubProject(prj,ext_sub_prj);

	if(ext_sub_prj.GetSize()<1) {AfxMessageBox(APL_T(" !"),MB_OK); return false;}
	return m_project_mgr->ShowProjectsMonitor(ext_sub_prj);
}




//    
__declspec (dllexport) bool add_ShowProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;

	CString buf;
	aplExtent extPrj,ext_rel,ext_tmp1;

	if(inExtent.GetSize()>0)
	{
		aplExtent ext_tmp,*ext=0;
		CaplInstance *inst=inExtent[0];
		if(api->m_data.IsKindOf(inst,api->m_folder_mgr.e_folder))
		{
			api->m_folder_mgr.GetFolderContents(inst,ext_tmp);
			int CreateAssocFolderDoc=AfxGetApp()->GetProfileInt(_T("options"),_T("CreateAssocFolderDoc"),0);
			{
				((CaplProjectManager*)(api->m_project_mgr))->FindAssociatedProjects(inst,ext_tmp1,ext_rel);
				ext_tmp.Append(ext_tmp1);
			}
			ext=&ext_tmp;
		}
		else ext=&inExtent;

		int i;
		for(i=0;i<ext->GetSize();i++)
		{
			inst =(*ext)[i];
			if(api->m_data.IsKindOf(inst,api->m_project_mgr->e_project))extPrj.Add(inst);
		}
	}
	else
	{
		//   
		CString query="SELECT Ext_ FROM Ext_{apl_project.id LIKE ''} 	END_SELECT";

		if(api->m_data.NET_QueryEditParse(query))
			api->m_data.NET_QueryExecute(extPrj, APL_T(" "));

		if(extPrj.GetSize()==0) {AfxMessageBox(APL_T("  !")); return false;}
		if(extPrj.GetSize()>1000)
		{
			buf.Format(APL_T(" %i .   1000  !"),extPrj.GetSize());
			return false;
		}

		buf.Format(APL_T(" %i .  ?"),extPrj.GetSize());

		if(IDYES!=AfxMessageBox(buf,MB_ICONQUESTION|MB_YESNO))  return false;
	}

	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowProjectsMonitor(extPrj);
}
//********************************************************************
//********************************************************************
//******************************************************************************************
//   

bool GetCurProjectsState(CaplAPI *api, aplExtent &extPrj)
{
	CString s_dt,buf;

	CString query=_T("SELECT Ext_ FROM Ext_{apl_project(");

	COleDateTime odt=COleDateTime::GetCurrentTime();
	aplDate2String(odt,s_dt);

	CString q1=_T("(.date_planned_begin='' OR .date_planned_begin<'%s') OR (.date_actual_begin!=''AND .date_actual_end='')"); 
	q1.Replace(_T("%s"),s_dt);
	query+=q1;
	query+=_T(")}END_SELECT");

	if(api->m_data.NET_QueryEditParse(query))
		api->m_data.NET_QueryExecute(extPrj, APL_T(" "));
	else AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING);

	if(extPrj.GetSize()==0) {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); return false;}
	return true;
}
//********************************************************************
__declspec (dllexport) bool add_ShowGant4CurProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;

	aplExtent extPrj;
	GetCurProjectsState(api, extPrj);
	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowGanttDlg(extPrj);
}

//********************************************************************
__declspec (dllexport) bool add_ShowAllCurProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;

	aplExtent extPrj;
	GetCurProjectsState(api, extPrj);
	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowProjectsMonitor(extPrj);
}

//********************************************************************
//********************************************************************
//********************************************************************
bool bShowProjectsStateWithRole(CaplAPI* api,LPCTSTR role, eShowPrjMode mode)
{
	if(!api || ! api->m_data.IsConnected()) return false;

	CaplInstance *pers=api->m_appr_mgr.GetCurrentPerson();
	if(0==pers)  {AfxMessageBox(APL_T("     !\\n\n !")); return false;}

	aplExtent ext_officials,ext_organizations;
	api->m_appr_mgr.GetPersonOfficials(pers,ext_officials);
	api->m_appr_mgr.FindPersonOrganizations(pers,ext_organizations,true);

	int i;
	CString q0,s_dt,buf;

	q0=_T("Ext1 {");
	buf.Format(_T("#%i"),pers->GetId());
	q0+=buf;

	for(i=0;i<ext_officials.GetSize();i++)
	{
		buf.Format(_T(",#%i"),ext_officials[i]->GetId());
		q0+=buf;
	}
	for(i=0;i<ext_organizations.GetSize();i++)
	{
		buf.Format(_T(",#%i"),ext_organizations[i]->GetId());
		q0+=buf;
	}
	q0+=_T("}");

	COleDateTime odt=COleDateTime::GetCurrentTime();
	aplDate2String(odt,s_dt);

	CString q1=_T("(.date_planned_begin='' OR .date_planned_begin<'%s') OR (.date_actual_begin!=''AND .date_actual_end='')"); 
	q1.Replace(_T("%s"),s_dt);

	CString q2=_T("(.@role IN #Ext1)");
	q2.Replace(_T("@role"),role);

	CString query=_T("SELECT Ext_ FROM \n@q0 \nExt_{apl_project((@q1) AND (@q2))}\n END_SELECT");
	query.Replace(_T("@q0"),q0);
	query.Replace(_T("@q1"),q1);
	query.Replace(_T("@q2"),q2);

	aplExtent extPrj;
	if(api->m_data.NET_QueryEditParse(query))
		api->m_data.NET_QueryExecute(extPrj, APL_T(" "));
	else {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); return false;}

	if(extPrj.GetSize()==0) {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); return false;}

	if(mode==modeShowGantt) 	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowGanttDlg(extPrj);

	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowProjectsMonitor(extPrj);

}
//******************************************************************
//******************************************************************
//******************************************************************

//   ,    - 
__declspec (dllexport) bool add_ShowCurKuratorProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;
	return bShowProjectsStateWithRole(api,_T("kurator"), modeShowMoniror);
}

__declspec (dllexport) bool add_ShowGant4CurKurator(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;
	return bShowProjectsStateWithRole(api,_T("kurator"), modeShowGantt);
}

//******************************************************************
//   ,    - 
__declspec (dllexport) bool add_ShowGant4CurOwner(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;	
	return bShowProjectsStateWithRole(api,_T("customer"), modeShowGantt);
}

__declspec (dllexport) bool add_ShowCurOwnerProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;	
	return bShowProjectsStateWithRole(api,_T("customer"), modeShowMoniror);
}
//******************************************************************

//   ,    - 
bool ShowExecutorPrj(CaplAPI *api, eShowPrjMode mode)
{
	CaplInstance *pers=api->m_appr_mgr.GetCurrentPerson();
	if(0==pers)  {AfxMessageBox(APL_T("     !\n\n !")); return false;}

	aplExtent ext_officials,ext_organizations;
	api->m_appr_mgr.GetPersonOfficials(pers,ext_officials);
	api->m_appr_mgr.FindPersonOrganizations(pers,ext_organizations,true);

	int i;
	CString q0,s_dt,buf;

	q0.Format(_T(".executors LIKE #%i"),pers->GetId());

	for(i=0;i<ext_officials.GetSize();i++)
	{
		buf.Format(_T(" OR .executors LIKE #%i"),ext_officials[i]->GetId());
		q0+=buf;
	}
	for(i=0;i<ext_organizations.GetSize();i++)
	{
		buf.Format(_T(" OR .executors LIKE #%i"),ext_organizations[i]->GetId());
		q0+=buf;
	}

	COleDateTime odt=COleDateTime::GetCurrentTime();
	aplDate2String(odt,s_dt);

	CString q1=_T("(.date_planned_begin='' OR .date_planned_begin<'%s') OR (.date_actual_begin!=''AND .date_actual_end='')"); 
	q1.Replace(_T("%s"),s_dt);


	CString query=_T("SELECT Ext_ FROM \nExt_{apl_project((@q1) AND (@q0))}\n END_SELECT");
	query.Replace(_T("@q0"),q0);
	query.Replace(_T("@q1"),q1);


	aplExtent extPrj;
	if(api->m_data.NET_QueryEditParse(query))
		api->m_data.NET_QueryExecute(extPrj, APL_T(" "));
	else {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); return false;}

	if(extPrj.GetSize()==0) {AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONWARNING); return false;}

	if(mode==modeShowGantt) return  ((CaplProjectManager*)(api->m_project_mgr))->ShowGanttDlg(extPrj);

	return  ((CaplProjectManager*)(api->m_project_mgr))->ShowProjectsMonitor(extPrj);
}
//*******************************************************

__declspec (dllexport) bool add_ShowCurExecutorProjectsState(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;

	return ShowExecutorPrj(api, modeShowMoniror);
}

__declspec (dllexport) bool add_ShowGant4CurExecutor(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;

	return ShowExecutorPrj(api, modeShowGantt);
}
//*******************************************************
//*******************************************************
//*******************************************************

//   ,    - 
__declspec (dllexport) bool add_CertCreateProject(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(!api || ! api->m_data.IsConnected()) return false;
	if(bUpdateUI) return true;
	if(inExtent.GetSize()<1) return false;

	CaplInstance *prj=inExtent[0];
	if(0==prj->GetId()) return false;
	if(prj->GetAccessmode()>aplRO) return false;
	if(!api->m_data.IsKindOf(prj,api->m_project_mgr->e_project)) return false;
	if(prj->GetType()==0) return false;
	if(prj->GetAccessmode()>aplRO){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); return false;}


	aplExtent ext_sub_prj;
	CaplProjectManager *m_project_mgr=(CaplProjectManager *)api->m_project_mgr;
	CaplInstance* folder=m_project_mgr->SelectInstance(APL_MODE_SELECT_FOLDER, APL_T("   "));
	if(folder==0) return false;

	CaplInstance *my_lock=0,*lock=0;
	api->m_data.GetAttr(prj,m_project_mgr->a_project_locker_adm_version,lock);
	if(lock==0)	
	{
		if(!m_project_mgr->CheckOut(prj))
		{
			AfxMessageBox(APL_T("     !"),MB_OK|MB_ICONSTOP);
			return false;
		}
	}
	else
	{
		my_lock=m_project_mgr->CheckMyLock(prj,false);
		if(my_lock!=lock)
		{
			AfxMessageBox(APL_T("   !  !"),MB_OK|MB_ICONSTOP);
			return false;
		}
	}

	CaplInstance *charact=api->m_charact_mgr.GetCharacteristicById(APL_T(""));
	if(0==charact)
	{
		if(IDYES!=AfxMessageBox(APL_T("   ''!     ?"),MB_YESNO|MB_ICONSTOP))return false;
	}

	aplExtent ext;
	api->m_folder_mgr.GetFolderContents(folder,ext);
	api->LoadExtentInfo(ext);

	//  -
	int i;
	CaplMap charact_map;
	if(0!=charact)
	{
		for(i=0;i<ext.GetSize();i++) charact_map.Add((long )ext[i],0);
		api->m_charact_mgr.GetInstancesCharact(charact_map,charact,0);
	}

	api->SetAutoSave(false);
	CString id,name,buf,sdt;
	aplExtent ext_prj;
	for(i=0;i<ext.GetSize();i++)
	{
		CaplInstance *doc=ext[i];
		if(0==doc) continue;
		if(0==doc->GetType()) continue;
		if(!api->m_data.IsKindOf(doc,api->m_doc_mgr.e_doc)) continue;

		api->m_data.GetAttr(doc,api->m_doc_mgr.a_doc_id,id);
		api->m_data.GetAttr(doc,api->m_doc_mgr.a_doc_name,name);

		//CaplInstance *prj1=m_project_mgr->CreateProject(0,LPCSTR(id));
		CaplInstance *prj1=m_project_mgr->FindProjectById(LPCTSTR(id),true);
		if(0==prj1)
		{
			prj1=api->m_data.CreateInstance(m_project_mgr->e_project);
			api->m_data.PutAttr(prj1,m_project_mgr->a_project_id,id);
			api->m_data.PutAttr(prj1,m_project_mgr->a_project_name,name);
		}
		api->m_data.PutAttr(prj1,m_project_mgr->a_project_parent,prj);
		ext_prj.Add(prj1);
		m_project_mgr->AddToParentContent(prj1,prj);

		CaplInstance *charact_val=(CaplInstance *)charact_map.GetByInP((long)doc);
		if(charact_val!=0)
		{
			api->m_data.GetAttr(charact_val,api->m_charact_mgr.a_apl_charact_val_time_val_s,sdt);
			if(sdt!=_T("") ) api->m_data.PutAttr(prj1,m_project_mgr->a_project_date_planned_end,sdt);
		}

		api->m_doc_mgr.CreateAssociation(prj1,doc);
	}

	api->SetAutoSave(true);
	api->SaveChanges();

	buf.Format(APL_T("!  %i ."),ext_prj.GetSize());
	AfxMessageBox(buf);

	return true;

}
