// aplStepDataWithFile.h: interface for the CaplStepDataWithFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLSTEPDATAWITHFILE_H__9C375534_74A9_45BB_99BE_54BF9684B4B0__INCLUDED_)
#define AFX_APLSTEPDATAWITHFILE_H__9C375534_74A9_45BB_99BE_54BF9684B4B0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StepData.h"


#ifndef APL_STEPDATA_WITH_FILE_NOAUTOLIB
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"CaplDataWithFile_ud.lib")
#else
#pragma comment (lib,"CaplDataWithFileD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"CaplDataWithFile_u.lib")
#else
#pragma comment (lib,"CaplDataWithFile.lib")
#endif
#endif
#endif

#define APLAPIERR_INTEGRATED_BIN_NOT_FOUND 50
#define APLAPIERR_INTEGRATED_BIN_BODY_NOT_FOUND 51
#define APLAPIERR_INTEGRATED_BIN_BODY_NOT_CORRECT 52
//#define APLAPIERR_ 51

#define SIZE_PORTION_FILE_OPERATE 1024*10


#ifdef APL_CAPLWF_IMPL
#define CLASS_DECL_APL_CAPLWF  _declspec(dllexport)
#else
#define CLASS_DECL_APL_CAPLWF  _declspec(dllimport)
#endif

class CLASS_DECL_APL_CAPLWF CaplIntegrBINValEx :public CaplIntegrBINVal
{
public:
	CaplIntegrBINValEx();
	~CaplIntegrBINValEx();
	void Clear();
	bool CreateTempFile();
	void ClearTempFile();
	//int blobId;
	CFile* tempFile;
	int size;
	int filePosition;
};

class CLASS_DECL_APL_CAPLWF CaplStepDataWithFile : public CaplStepData  
{
public:
	CaplStepDataWithFile();
	virtual ~CaplStepDataWithFile();
	
	void ClearDict();

	CaplTAggr<CaplIntegrBINValEx*,CaplIntegrBINValEx*,APLAGGR_LIST_OR_AUTOKILLREF> m_list_blob;
	CFile m_file;
	DWORD m_blob_begin_pos;
	int m_integr_blob_max_id;
	
	virtual bool LoadFromFile(const TCHAR *file_name, bool appload_mode=false);
	virtual bool ApploadFromFile(aplExtent *ext_inst=0);
	virtual bool SaveToFile(const TCHAR *file_name, bool bCreateBakup=true);
	bool CloseWithoutClear();

	bool PutIntegratedBlob(CaplInstance* inst,CaplAttr* attr,const TCHAR* namefilesource);
	bool GetIntegratedBlob(CaplInstance* inst,CaplAttr* attr,const TCHAR* namefiledestination);
	bool DelIntegratedBlob(CaplInstance* inst,CaplAttr* attr);

	bool GlobalCreateId();

	/**  instance    entity.    id*/
	virtual CaplInstance  *CreateInstance(CaplEntity *entity,bool is_temporary=false,bool create_attrs=true);
	/**  instance   entity.    id*/
	virtual CaplInstance  *CreateInstanceBN(const TCHAR *type_name,bool is_temporary=false,bool create_attrs=true);


	const TCHAR* GetErrorDescription(int ErrorCode );

	void aplFarCopyInstances(aplExtent &instances, CaplStepDataWithFile &out_data, bool clear_data);
};


bool CLASS_DECL_APL_CAPLWF aplReadValueFromFile(CFile &file, pCaplInstance *instmap, CaplValue *value, bool bAnsiString = true);

#endif // !defined(AFX_APLSTEPDATAWITHFILE_H__9C375534_74A9_45BB_99BE_54BF9684B4B0__INCLUDED_)
