#include "stdafx.h"
#include "finder.h"
#include <algorithm>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


void CStringArrWithSort::Sort(bool bMachCase)
{
	Sort(bMachCase ? FnCmp : FnCmpNoCase);
}

void CStringArrWithSort::Sort(FNCMP fnCmp)
{
	if(m_nSize > 1) std::sort(m_pData, m_pData + m_nSize, CLess(fnCmp));
}

int CStringArrWithSort::Find(const CString &s, bool bMachCase)
{
	return Find(s, bMachCase ? FnCmp : FnCmpNoCase);
}

int CStringArrWithSort::Find(const CString &s, FNCMP fnCmp)
{
	if(m_nSize <= 0) return -1;
	CString *en = m_pData + m_nSize;
	CString *fi = std::find_if(m_pData, en, CEq(fnCmp, s));
	return ((fi == en) ? -1 : fi - m_pData);
}

int CStringArrWithSort::QFind(const CString &s, bool bMachCase)
{
	return QFind(s, bMachCase ? FnCmp : FnCmpNoCase);
}

int CStringArrWithSort::QFind(const CString &s, FNCMP fnCmp)
{
	if(m_nSize <= 0) return -1;
	CString *en = m_pData + m_nSize;
	CString *fi = std::lower_bound(m_pData, en, s, CLess(fnCmp));
	return ((fi == en) ? -1 : fi - m_pData);
}

bool CStringArrWithSort::FindBreak(CString &ret, bool bMachCase, FNNEXTSTR fnNextStr, DWORD data)
{
	if(GetSize() < 1) return true;
	int i = 0, co = GetSize(), cmpr;
	int (CString::*fnCmp)(LPCTSTR) const;
	fnCmp = (bMachCase ? &CString::Compare : &CString::CompareNoCase);
	while(i<co)
	{
		cmpr = (ret.*fnCmp)(ElementAt(i));
		if(cmpr < 0) return true;
		else
		{
			if (fnNextStr(ret, data)) ++i;
			else return false;
		}
	}
	return false;
}