//    
#include "stdafx.h"

#define VCPP50 //   

#include "aplNetStepData.h"

#define ERR_2_TEXT(par,text) case par : txt= text; if(txt.Right(1)!= _T(".") && txt.Right(1)!= _T("!") && txt.Right(1)!= _T("?") && txt.Right(1)!= _T(" ")){txt+= _T(".");} if(err_descr != _T("")){txt+= CString(_T("\r\n")) + err_descr;} txt+= _T("\r\n");  txt+=CaplTranslate::Translate(APL_NO_T("  (")); txt+=_T(#par) _T(")"); break;
#define ERR_2_TEXT_S(par,text) case par : txt= text; if(err_descr != _T("")){txt+= err_descr;} txt+= _T("\r\n"); txt+=CaplTranslate::Translate(APL_NO_T("  (")); txt+=_T(#par) _T(")"); break;


CString APL_NET_ERROR2char(int error, CString err_descr)
{
	CString txt = _T("");
	if(error>0 && error<50)
	{
		txt=CaplStepData::GetErrorDescription(error);
		if(err_descr != _T(""))
		{
			txt += APL_T("\r\n");
			txt += err_descr;
		}
		return txt;
	}

	switch(error)
	{
		ERR_2_TEXT(APL_NET_OK, APL_T("  "))

		ERR_2_TEXT(APL_NET_SRV_MISSED_CONFIG, APL_T("   :  "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_LOAD_QUERY, APL_T("   :      "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_DATA, APL_T("   :  "))
		//ERR_2_TEXT(APL_NET_SRV_UNKNOWN_USER,"   :  ")
//		ERR_2_TEXT(APL_NET_SRV_UNKNOWN_USER,"    . \n"
//								"     \n"
//								"      .")
		case APL_NET_SRV_UNKNOWN_USER : 
			if(err_descr != _T("") && err_descr.Find(_T("APL_NET_SRV_UNKNOWN_USER"))==-1)
			{
				txt= APL_T("      . ");
				txt += err_descr;
				if(txt.Right(1)!= _T(".") && txt.Right(1)!= _T("!") && txt.Right(1)!= _T("?"))
					txt += CString(_T(". \n"));
			}
			else
			{
				txt += APL_T("     . \n ,     \n       .\n\n     ");
			}
			break;

		ERR_2_TEXT(APL_NET_SRV_NOT_CONNECT, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_USER_ALREADY_CONNECTED, APL_T("   :      "))
		ERR_2_TEXT(APL_NET_SRV_USER_IS_ACTIVE, APL_T("   :       ,      "))
		ERR_2_TEXT(APL_NET_SRV_ERROR_PROCESSED, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_NAME_BASE, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_CORRUPTED_BASE, APL_T("   :    !    !"))
		ERR_2_TEXT(APL_NET_SRV_UNKNOWN_ERROR, APL_T("   :  "))
		ERR_2_TEXT(APL_NET_SRV_SMALL_BUF, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_BLOB_BUSY, APL_T("   :  BLOB   "))
	
		ERR_2_TEXT(APL_NET_SRV_BLOB_NOT_FOUND, APL_T("   : BLOB  "))
		ERR_2_TEXT(APL_NET_SRV_BLOB_NOT_DEFINE, APL_T("   : BLOB   "))
		//ERR_2_TEXT(APL_NET_SRV_NOT_UNIQUE,) -      !
		ERR_2_TEXT(APL_NET_SRV_ORACLE_ERROR, APL_T("   :    ORACLE.       "))
		ERR_2_TEXT(APL_NET_SRV_ORACLE_NAVAIL, APL_T("   : ORACLE    "))
		ERR_2_TEXT(APL_NET_SRV_POSTGRES_ERROR, APL_T("    PostgreSQL (.  PG:)"))
		ERR_2_TEXT(APL_NET_SRV_POSTGRES_NAVAIL, APL_T(" PostgreSQL    "))
		//ERR_2_TEXT(APL_NET_SRV_LIMIT_CONNECT_EXESS,APL_T("   :       (. )"))
		ERR_2_TEXT(APL_NET_SRV_LIMIT_CONNECT_EXESS, APL_T("  .  .\n      \n      .\n"))
		ERR_2_TEXT(APL_NET_SRV_BREAK, APL_T("   !"))
		ERR_2_TEXT(APL_NET_SRV_MISSED_PROTECTED_CODE, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_BASE_VERSION, APL_T("   :    PSS       .   !"))

		// ERR_2_TEXT(APL_NET_SRV_AGGR_TOO_MUCH_LONG, APL_T("   :       .       ")) -    
		ERR_2_TEXT(APL_NET_SRV_STRING_TOO_MUCH_LONG, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_TEMPORARY_BUF_CORRUPTED, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_ATTR_VAL_TYPE, APL_T("   :      "))
		ERR_2_TEXT(APL_NET_SRV_ACCESS_DENY, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_SET_ACCESS_ERROR, APL_T("   :      "))

		ERR_2_TEXT(APL_NET_SRV_MISSED_BUF_FORMAT, APL_T("   :    \r\n\r\n        !"))
		ERR_2_TEXT(APL_NET_SRV_QUERY_PARSE_ERROR, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_ILLEGAL_ATTR_TYPE, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_OBJECT, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_CORRUPTED_ACLST, APL_T("   :     lite "))
		ERR_2_TEXT(APL_NET_SRV_USER_DISABLED, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_CLIENT_NOT_FOUND, APL_T("  :       "))
		ERR_2_TEXT(APL_NET_SRV_USER_READ_ONLY, APL_T("   :      "))

		ERR_2_TEXT(APL_NET_SRV_SINGLE_CONNECT_DB, APL_T("   :    .      !"))	
		ERR_2_TEXT(APL_NET_SRV_SINGLE_CONNECT_LITE_D, APL_T("   :   .      !"))
		ERR_2_TEXT(APL_NET_SRV_SINGLE_CONNECT_LITE_SRV, APL_T("   :   .          !     "))
		ERR_2_TEXT(APL_NET_SRV_FUNCTION_ONLY_DB, APL_T("   :        ORACLE  Postgre!"))
		ERR_2_TEXT(APL_NET_SRV_LOAD_DONT_EXECUTABLE, APL_T("   :      Load    !"))
		ERR_2_TEXT(APL_NET_SRV_EXPIRE_SRC_LIC_D, APL_T("   :    !      !"))
		

		ERR_2_TEXT(APL_NET_BO_SRV_MISSED_DATA, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_BO_SRV_NOT_CONNECT, APL_T("  :  "))
		ERR_2_TEXT(APL_NET_BO_SRV_ERROR_PROCESSED, APL_T("  :    "))
		ERR_2_TEXT(APL_NET_BO_SRV_SERVER_LOCKED, APL_T("   :   PSS     .\r\n    .\r\n"))
		ERR_2_TEXT(APL_NET_BO_SRV_TOO_MANY_SERVER, APL_T("   :       !   !"))
		ERR_2_TEXT(APL_NET_BO_ERROR_CREATE_BASE, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_BO_BASE_LIST_EMPTY, APL_T("   :     "))


		ERR_2_TEXT(APL_NET_SRV_EXPIRE_SRC_LIC_SRV, APL_T("   :    !           !"))
		ERR_2_TEXT(APL_NET_SRV_EXPIRE_KEY_IN_SRV_LIC_EXCLUSIVE, APL_T("   :    !      !"))
		
		ERR_2_TEXT(APL_SOCK_MISSED_VERSION, APL_T(" :   \r\n\r\n        "))
		ERR_2_TEXT(APL_SOCK_MISSED_COMMAND, APL_T(" :      .\r\n\r\n   !\r\n\r\n"))
		ERR_2_TEXT(APL_SOCK_MISSED_FUNCTION, APL_T(" :      .\r\n\r\n   !\r\n\r\n"))
		ERR_2_TEXT(APL_SOCK_MISSED_FUNCT_PARAM, APL_T(" :          \r\n\r\n        !\r\n\r\n     /!"))
		ERR_2_TEXT(APL_SOCK_FUNCTION_OBSOLETTE, APL_T(" :        \r\n\r\n        !\r\n\r\n  /!"))

		ERR_2_TEXT(APL_NET_SRV_EXPIRE_KEY_IN_SRV_LIC_BREAK, APL_T("   :    !   !"))
		
		//ERR_2_TEXT(APL_NET_SRV_MISSED_LAST_ACTION  
		
		ERR_2_TEXT(APL_NET_SRV_MISSED_CLIENTS_SQL, APL_T("   :    SQL   !       "))
		ERR_2_TEXT(APL_NET_SRV_DICT_NOT_FOUND, APL_T("   :       .  .     !"))
		ERR_2_TEXT(APL_NET_SRV_DICT_NOT_INI, APL_T("   :          .        .     !"))
		
		ERR_2_TEXT(APL_SOCK_ERROR_PROCESSED, APL_T(" :   "))	
		ERR_2_TEXT(APL_SOCK_CONNECT_FAULT, APL_T(" :       "))
		ERR_2_TEXT(APL_SOCK_OPERATION_IN_PROGRESS, APL_T(" :   "))	

		ERR_2_TEXT(APL_NET_SRV_MISSED_VERSION_SRV_LIC, APL_T("   :   ,    !"))

		ERR_2_TEXT(APL_NET_SRV_CORRUPTED_ORA_BD, APL_T("   :  PSS  Oracle ,  .       "))
		ERR_2_TEXT(APL_NET_SRV_CORRUPTED_PG_BD, APL_T("   :  PSS  PostgreSQL ,  .       "))
		ERR_2_TEXT(APL_NET_SRV_USER_BD_DONT_ADMIN, APL_T("   :  PSS     "))
		ERR_2_TEXT(APL_NET_SRV_IP_BLOCKED, APL_T("  :    IP-   "))
		ERR_2_TEXT(APL_NET_SRV_APPROACH_EXPIRE_SRC_LIC_SRV, APL_T("   :        30 !  !"))
		ERR_2_TEXT(APL_NET_SRV_INCOMPATIBLE_ORA_CLIENT, APL_T("   :   oracle     ."))
		ERR_2_TEXT(APL_NET_SRV_INCOMPATIBLE_ORA_SERVER, APL_T("   :      oracle  ."))
		ERR_2_TEXT(APL_NET_SRV_INCOMPATIBLE_PG_CLIENT, APL_T("  PostgreSQL     ."))
		ERR_2_TEXT(APL_NET_SRV_INCOMPATIBLE_PG_SERVER, APL_T("     PostgreSQL  ."))

		ERR_2_TEXT(APL_NET_SRV_OS_USER_NOT_ADMIN, APL_T("   :  OC,     ,    .    ,   "))
		ERR_2_TEXT(APL_NET_SRV_MISSED_KEY_IN_SRV_LIC, APL_T("   :   !      !"))
		ERR_2_TEXT(APL_NET_SRV_INST_LOCKED, APL_T("   :     !"))
		ERR_2_TEXT(APL_NET_SRV_EMPTY_PWD_DENIED, APL_T("      !"))
		ERR_2_TEXT(APL_NET_SRV_AD_SERVER_NOT_DEFINED, APL_T("   :     !"))
		ERR_2_TEXT(APL_NET_SRV_SAFETY_EVENT, APL_T("   :    .  .   "))
		ERR_2_TEXT(APL_NET_SRV_ERROR_INTEGRITY_CONTROL, APL_T("   :     .)"))
		ERR_2_TEXT(APL_NET_SRV_PARALLES_SESSION_EXCEEDED, APL_T("   :      .   ."))
		ERR_2_TEXT(APL_NET_SRV_SQL_DISABLES, APL_T("   : API    SQL      ."))
		ERR_2_TEXT(APL_NET_SRV_ADMIN_MODE_DISABLES, APL_T("   : API          ."))

		ERR_2_TEXT(APL_NET_SRV_KERBEROS_ERROR, APL_T("   :    Kerberos."))
		ERR_2_TEXT(APL_NET_SRV_UNKNOWN_KERBEROS_USER, APL_T("   Kerberos:    AD/ALD    . C     ,    AD/ALD,    "))
		ERR_2_TEXT(APL_NET_SRV_INTERNAL_AUTH_DENY, APL_T("  .   ."))
		ERR_2_TEXT(APL_NET_SRV_INTERNAL_AUTH_NET_DENY, APL_T("      .       ."))

		ERR_2_TEXT(APL_NET_SRV_EXTERNAL_AUTH_ERROR, APL_T("   :       ."))
//		ERR_2_TEXT(APL_NET_SRV_NEED_TO_UPDATE_THE_CLIENT, APL_T("   /."))
		ERR_2_TEXT(APL_NET_SRV_HASH_METHOD_CHANGED, APL_T("  ,    "))
		ERR_2_TEXT(APL_NET_SRV_INTERNAL_ACCESS_MANAGEMENT_DENY, APL_T("   ."))
		ERR_2_TEXT(APL_NET_SRV_EXTERNAL_ACCESS_MANAGEMENT_ERROR, APL_T("      ."))


		case APL_NET_SRV_UNKNOWN_AD_USER : txt=  APL_T("   active directory    . \n C   PSS   ,    active \n directory,    ")+err_descr;
			break;
		ERR_2_TEXT(APL_NET_SRV_AD_USER_CREATE_ERROR, APL_T("    ."))
// 		case APL_NET_SRV_AD_USER_CREATE_ERROR : txt=  APL_T("    .       "));
// 			break;
		ERR_2_TEXT(APL_NET_SRV_DICTIONARY_NEEDS_TO_BE_UPDATED, APL_T("   :     .    "))

		ERR_2_TEXT(APL_NET_SRV_SQL_TURNED_OFF, APL_T("   : API    SQL   ."))
		ERR_2_TEXT(APL_NET_SRV_ADMIN_MODE_TURNED_OFF, APL_T("   : API      ."))
		ERR_2_TEXT(APL_NET_SRV_FEATURE_IS_DISABLED, APL_T("      .     ."))


		ERR_2_TEXT(APL_NET_CLI_MISSED_DATA, APL_T(" :  "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_DATA_FROM_SERVER, APL_T(" :      "))
		ERR_2_TEXT(APL_NET_CLI_NOT_CONNECT, APL_T("  "))
		ERR_2_TEXT(APL_NET_CLI_ALREADY_CONNECT, APL_T("  "))
		ERR_2_TEXT(APL_NET_CLI_ERROR_PROCESSED, APL_T(" :    "))
		//ERR_2_TEXT(APL_NET_CLI_MISSED_BASE," :      (APL_NET_CLI_MISSED_BASE)")
		ERR_2_TEXT(APL_NET_CLI_FNF, APL_T(" :   : "))
		ERR_2_TEXT(APL_NET_CLI_FNCREATE, APL_T(" :    : "))
		ERR_2_TEXT(APL_NET_CLI_NET_ERROR, APL_T(" :   "))
		ERR_2_TEXT(APL_NET_CLI_LIST_OF_BASE_EMPTY, APL_T(" :   "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_ATTR_TYPE, APL_T(" :   "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_CONNECTION_REC, APL_T(" :        "))
		ERR_2_TEXT(APL_NET_CLI_QUERY_BUF_FULL, APL_T(" :       "))
		ERR_2_TEXT(APL_NET_CLI_BREAK, APL_T(" :    "))
		ERR_2_TEXT(APL_NET_CLI_ERROR_REESTR, APL_T(" :     "))
		ERR_2_TEXT(APL_NET_CLI_FILE_BIG, APL_T(" :    . "))
		ERR_2_TEXT(APL_NET_CLI_LOCAL_SERV_NOT_FOUND, APL_T(" :       : "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_CONNECT_PARAM_USERNAME, APL_T(" :      :    "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_CONNECT_PARAM_CONNECTION, APL_T(" :      :    "))
		ERR_2_TEXT(APL_NET_CLI_MISSED_ENCODING, APL_T(" :       !"))
		ERR_2_TEXT(APL_NET_CLI_MISSED_DLG_IN_HIDE_MODE, APL_T(" :    ,     hide mode"))
		ERR_2_TEXT_S(APL_NET_CLI_EXTERNAL_AUTH_ERROR, APL_T("      . "))
		ERR_2_TEXT(APL_NET_CLI_KERBEROS_ERROR, APL_T("    Kerberos"))
		ERR_2_TEXT(APL_NET_CLI_ACCESS_DENY, APL_T("    "))
		ERR_2_TEXT(APL_NET_CLI_SERVER_DN_SUPPORT_FUNCTION, APL_T("    .   ."))
		ERR_2_TEXT(APL_NET_CLI_DNS_ERROR, APL_T("   DNS"))

	
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_NODATA, APL_T("   : No data"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADTYPE, APL_T("   :      "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_FILE_IO, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADDICTIONARY, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADENT, APL_T("   :    entity"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADATTR, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADDATA, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_ATTRNSET, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADFILENAME, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADINSTANCE, APL_T("   :    Instance"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADINSTANCETYPE, APL_T("   :   Instance"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADSCHEMANAME, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_NOACCESSRIGHT, APL_T("   :     "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADDICTVERSION, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_INVALIDDATAFORMAT, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_INCOMPATIBLEDICT, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_FICTIVE_DATA, APL_T("   :      Fictive data"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_QUERY_ERROR, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_DICT_FILE_NOT_OPEN, APL_T("   :   "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADDATA_INVALID_ENTINY_ID, APL_T("   :        (entity),     "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_BADDATA_INVALID_ATTR_ID, APL_T("   :       ,     .\r\n,        ,   .    PSS"))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_FILE_BD_NOT_FOUND	, APL_T("   :    "))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_FILE_BD_READ_ONLY	, APL_T("   :      "))
		//ERR_2_TEXT(APL_NET_SRV_APLAPIERR_INCOMPATIBLDATAFORMAT	, APL_T("   :      .       .   PSS."))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_INCOMPATIBLDATAFORMAT	, APL_T("   :     .       PSS     ."))
		ERR_2_TEXT(APL_NET_SRV_APLAPIERR_OUT_OF_MEMORY	, APL_T("   :    ."))
		
		default:
			txt.Format( APL_T(" :    id %i"),error);
			if(err_descr != _T("")){txt+= CString(_T(" \n")) + err_descr;}
			break;
	}
	return txt;         
}


LPTSTR HRESULT2char(HRESULT res, LPTSTR* buf)
{

	switch(res)
	{
		case  ERROR_SUCCESS: _sprintf(*buf,_T(" The operation completed successfully.: ERROR_SUCCESS  0L"));
		; break;;case  ERROR_INVALID_FUNCTION: _sprintf(*buf,_T(" Incorrect function. ( ERROR_INVALID_FUNCTION "));
		; break;;case  ERROR_FILE_NOT_FOUND: _sprintf(*buf,_T(" The system cannot find the file specified. ( ERROR_FILE_NOT_FOUND "));
		; break;;case  ERROR_PATH_NOT_FOUND: _sprintf(*buf,_T(" The system cannot find the path specified. ( ERROR_PATH_NOT_FOUND "));
		; break;;case  ERROR_TOO_MANY_OPEN_FILES: _sprintf(*buf,_T("The system cannot open the file.( ERROR_TOO_MANY_OPEN_FILES "));
		; break;;case  ERROR_ACCESS_DENIED: _sprintf(*buf,_T(" Access is denied. ( ERROR_ACCESS_DENIED              5L"));
		; break;;case  ERROR_INVALID_HANDLE :  _sprintf(*buf,_T("   The handle is invalid.  ( ERROR_INVALID_HANDLE             6L "));
		; break;;case  ERROR_ARENA_TRASHED :  _sprintf(*buf,_T("   The storage control blocks were destroyed.  ( ERROR_ARENA_TRASHED              7L "));
		; break;;case  ERROR_NOT_ENOUGH_MEMORY :  _sprintf(*buf,_T("   Not enough storage is available to process this command.  ( ERROR_NOT_ENOUGH_MEMORY          8L     dderror "));
		; break;;case  ERROR_INVALID_BLOCK :  _sprintf(*buf,_T("   The storage control block address is invalid.  ( ERROR_INVALID_BLOCK              9L "));
		; break;;case  ERROR_BAD_ENVIRONMENT :  _sprintf(*buf,_T("   The environment is incorrect.  ( ERROR_BAD_ENVIRONMENT            10L "));
		; break;;case  ERROR_BAD_FORMAT :  _sprintf(*buf,_T("   An attempt was made to load a program with an  incorrect format.  ( ERROR_BAD_FORMAT                 11L "));
		; break;;case  ERROR_INVALID_ACCESS :  _sprintf(*buf,_T("   The access code is invalid.  ( ERROR_INVALID_ACCESS             12L "));
		; break;;case  ERROR_INVALID_DATA :  _sprintf(*buf,_T("   The data is invalid.  ( ERROR_INVALID_DATA               13L "));
		; break;;case  ERROR_OUTOFMEMORY :  _sprintf(*buf,_T("   Not enough storage is available to complete this operation.  ( ERROR_OUTOFMEMORY                14L "));
		; break;;case  ERROR_INVALID_DRIVE :  _sprintf(*buf,_T("   The system cannot find the drive specified.  ( ERROR_INVALID_DRIVE              15L "));
		; break;;case  ERROR_CURRENT_DIRECTORY :  _sprintf(*buf,_T("   The directory cannot be removed.  ( ERROR_CURRENT_DIRECTORY          16L "));
		; break;;case  ERROR_NOT_SAME_DEVICE :  _sprintf(*buf,_T("   The system cannot move the file to a different disk drive.  ( ERROR_NOT_SAME_DEVICE            17L "));
		; break;;case  ERROR_NO_MORE_FILES :  _sprintf(*buf,_T("   There are no more files.  ( ERROR_NO_MORE_FILES              18L "));
		; break;;case  ERROR_WRITE_PROTECT :  _sprintf(*buf,_T("   The media is write protected.  ( ERROR_WRITE_PROTECT              19L "));
		; break;;case  ERROR_BAD_UNIT :  _sprintf(*buf,_T("   The system cannot find the device specified.  ( ERROR_BAD_UNIT                   20L "));
		; break;;case  ERROR_NOT_READY :  _sprintf(*buf,_T("   The device is not ready.  ( ERROR_NOT_READY                  21L "));
		; break;;case  ERROR_BAD_COMMAND :  _sprintf(*buf,_T("   The device does not recognize the command.  ( ERROR_BAD_COMMAND                22L "));
		; break;;case  ERROR_CRC :  _sprintf(*buf,_T("   Data error (cyclic redundancy check).  ( ERROR_CRC                        23L "));
		; break;;case  ERROR_BAD_LENGTH :  _sprintf(*buf,_T("   The program issued a command but the  command length is incorrect.  ( ERROR_BAD_LENGTH                 24L "));
		; break;;case  ERROR_SEEK :  _sprintf(*buf,_T("   The drive cannot locate a specific  area or track on the disk.  ( ERROR_SEEK                       25L "));
		; break;;case  ERROR_NOT_DOS_DISK :  _sprintf(*buf,_T("   The specified disk or diskette cannot be accessed.  ( ERROR_NOT_DOS_DISK               26L "));
		; break;;case  ERROR_SECTOR_NOT_FOUND :  _sprintf(*buf,_T("   The drive cannot find the sector requested.  ( ERROR_SECTOR_NOT_FOUND           27L "));
		; break;;case  ERROR_OUT_OF_PAPER :  _sprintf(*buf,_T("   The printer is out of paper.  ( ERROR_OUT_OF_PAPER               28L "));
		; break;;case  ERROR_WRITE_FAULT :  _sprintf(*buf,_T("   The system cannot write to the specified device.  ( ERROR_WRITE_FAULT                29L "));
		; break;;case  ERROR_READ_FAULT :  _sprintf(*buf,_T("   The system cannot read from the specified device.  ( ERROR_READ_FAULT                 30L "));
		; break;;case  ERROR_GEN_FAILURE :  _sprintf(*buf,_T("   A device attached to the system is not functioning.  ( ERROR_GEN_FAILURE                31L "));
		; break;;case  ERROR_SHARING_VIOLATION :  _sprintf(*buf,_T("   The process cannot access the file because it is being used by another process.  ( ERROR_SHARING_VIOLATION          32L "));
		; break;;case  ERROR_LOCK_VIOLATION :  _sprintf(*buf,_T("   The process cannot access the file because  another process has locked a portion of the file.  ( ERROR_LOCK_VIOLATION             33L "));
		; break;;case  ERROR_WRONG_DISK :  _sprintf(*buf,_T("   The wrong diskette is in the drive.  Insert %2 (Volume Serial Number: %3)  into drive %1.  ( ERROR_WRONG_DISK                 34L "));
		; break;;case  ERROR_SHARING_BUFFER_EXCEEDED :  _sprintf(*buf,_T("   Too many files opened for sharing.  ( ERROR_SHARING_BUFFER_EXCEEDED    36L "));
		; break;;case  ERROR_HANDLE_EOF :  _sprintf(*buf,_T("   Reached the end of the file.  ( ERROR_HANDLE_EOF                 38L "));
		; break;;case  ERROR_HANDLE_DISK_FULL :  _sprintf(*buf,_T("   The disk is full.  ( ERROR_HANDLE_DISK_FULL           39L "));
		; break;;case  ERROR_NOT_SUPPORTED :  _sprintf(*buf,_T("   The network request is not supported.  ( ERROR_NOT_SUPPORTED              50L "));
		; break;;case  ERROR_REM_NOT_LIST :  _sprintf(*buf,_T("   The remote computer is not available.  ( ERROR_REM_NOT_LIST               51L "));
		; break;;case  ERROR_DUP_NAME :  _sprintf(*buf,_T("   A duplicate name exists on the network.  ( ERROR_DUP_NAME                   52L "));
		; break;;case  ERROR_BAD_NETPATH :  _sprintf(*buf,_T("   The network path was not found.  ( ERROR_BAD_NETPATH                53L "));
		; break;;case  ERROR_NETWORK_BUSY :  _sprintf(*buf,_T("   The network is busy.  ( ERROR_NETWORK_BUSY               54L "));
		; break;;case  ERROR_DEV_NOT_EXIST :  _sprintf(*buf,_T("   The specified network resource or device is no longer  available.  ( ERROR_DEV_NOT_EXIST              55L     dderror "));
		; break;;case  ERROR_TOO_MANY_CMDS :  _sprintf(*buf,_T("   The network BIOS command limit has been reached.  ( ERROR_TOO_MANY_CMDS              56L "));
		; break;;case  ERROR_ADAP_HDW_ERR :  _sprintf(*buf,_T("   A network adapter hardware error occurred.  ( ERROR_ADAP_HDW_ERR               57L "));
		; break;;case  ERROR_BAD_NET_RESP :  _sprintf(*buf,_T("   The specified server cannot perform the requested  operation.  ( ERROR_BAD_NET_RESP               58L "));
		; break;;case  ERROR_UNEXP_NET_ERR :  _sprintf(*buf,_T("   An unexpected network error occurred.  ( ERROR_UNEXP_NET_ERR              59L "));
		; break;;case  ERROR_BAD_REM_ADAP :  _sprintf(*buf,_T("   The remote adapter is not compatible.  ( ERROR_BAD_REM_ADAP               60L "));
		; break;;case  ERROR_PRINTQ_FULL :  _sprintf(*buf,_T("   The printer queue is full.  ( ERROR_PRINTQ_FULL                61L "));
		; break;;case  ERROR_NO_SPOOL_SPACE :  _sprintf(*buf,_T("   Space to store the file waiting to be printed is not available on the server.  ( ERROR_NO_SPOOL_SPACE             62L "));
		; break;;case  ERROR_PRINT_CANCELLED :  _sprintf(*buf,_T("   Your file waiting to be printed was deleted.  ( ERROR_PRINT_CANCELLED            63L "));
		; break;;case  ERROR_NETNAME_DELETED :  _sprintf(*buf,_T("   The specified network name is no longer available.  ( ERROR_NETNAME_DELETED            64L "));
		; break;;case  ERROR_NETWORK_ACCESS_DENIED :  _sprintf(*buf,_T("   Network access is denied.  ( ERROR_NETWORK_ACCESS_DENIED      65L "));
		; break;;case  ERROR_BAD_DEV_TYPE :  _sprintf(*buf,_T("   The network resource type is not correct.  ( ERROR_BAD_DEV_TYPE               66L "));
		; break;;case  ERROR_BAD_NET_NAME :  _sprintf(*buf,_T("   The network name cannot be found.  ( ERROR_BAD_NET_NAME               67L "));
		; break;;case  ERROR_TOO_MANY_NAMES :  _sprintf(*buf,_T("   The name limit for the local computer network  adapter card was exceeded.  ( ERROR_TOO_MANY_NAMES             68L "));
		; break;;case  ERROR_TOO_MANY_SESS :  _sprintf(*buf,_T("   The network BIOS session limit was exceeded.  ( ERROR_TOO_MANY_SESS              69L "));
		; break;;case  ERROR_SHARING_PAUSED :  _sprintf(*buf,_T("   The remote server has been paused or is in the  process of being started.  ( ERROR_SHARING_PAUSED             70L "));
		; break;;case  ERROR_REQ_NOT_ACCEP :  _sprintf(*buf,_T("   No more connections can be made to this remote computer at this time  because there are already as many connections as the computer can accept.  ( ERROR_REQ_NOT_ACCEP              71L "));
		; break;;case  ERROR_REDIR_PAUSED :  _sprintf(*buf,_T("   The specified printer or disk device has been paused.  ( ERROR_REDIR_PAUSED               72L "));
		; break;;case  ERROR_FILE_EXISTS :  _sprintf(*buf,_T("   The file exists.  ( ERROR_FILE_EXISTS                80L "));
		; break;;case  ERROR_CANNOT_MAKE :  _sprintf(*buf,_T("   The directory or file cannot be created.  ( ERROR_CANNOT_MAKE                82L "));
		; break;;case  ERROR_FAIL_I24 :  _sprintf(*buf,_T("   Fail on INT 24.  ( ERROR_FAIL_I24                   83L "));
		; break;;case  ERROR_OUT_OF_STRUCTURES :  _sprintf(*buf,_T("   Storage to process this request is not available.  ( ERROR_OUT_OF_STRUCTURES          84L "));
		; break;;case  ERROR_ALREADY_ASSIGNED :  _sprintf(*buf,_T("   The local device name is already in use.  ( ERROR_ALREADY_ASSIGNED           85L "));
		; break;;case  ERROR_INVALID_PASSWORD :  _sprintf(*buf,_T("   The specified network password is not correct.  ( ERROR_INVALID_PASSWORD           86L "));
		; break;;case  ERROR_INVALID_PARAMETER :  _sprintf(*buf,_T("   The parameter is incorrect.  ( ERROR_INVALID_PARAMETER          87L     dderror "));
		; break;;case  ERROR_NET_WRITE_FAULT :  _sprintf(*buf,_T("   A write fault occurred on the network.  ( ERROR_NET_WRITE_FAULT            88L "));
		; break;;case  ERROR_NO_PROC_SLOTS :  _sprintf(*buf,_T("   The system cannot start another process at this time.  ( ERROR_NO_PROC_SLOTS              89L "));
		; break;;case  ERROR_TOO_MANY_SEMAPHORES :  _sprintf(*buf,_T("   Cannot create another system semaphore.  ( ERROR_TOO_MANY_SEMAPHORES        100L "));
		; break;;case  ERROR_EXCL_SEM_ALREADY_OWNED :  _sprintf(*buf,_T("   The exclusive semaphore is owned by another process.  ( ERROR_EXCL_SEM_ALREADY_OWNED     101L "));
		; break;;case  ERROR_SEM_IS_SET :  _sprintf(*buf,_T("   The semaphore is set and cannot be closed.  ( ERROR_SEM_IS_SET                 102L "));
		; break;;case  ERROR_TOO_MANY_SEM_REQUESTS :  _sprintf(*buf,_T("   The semaphore cannot be set again.  ( ERROR_TOO_MANY_SEM_REQUESTS      103L "));
		; break;;case  ERROR_INVALID_AT_INTERRUPT_TIME :  _sprintf(*buf,_T("   Cannot request exclusive semaphores at interrupt time.  ( ERROR_INVALID_AT_INTERRUPT_TIME  104L "));
		; break;;case  ERROR_SEM_OWNER_DIED :  _sprintf(*buf,_T("   The previous ownership of this semaphore has ended.  ( ERROR_SEM_OWNER_DIED             105L "));
		; break;;case  ERROR_SEM_USER_LIMIT :  _sprintf(*buf,_T("   Insert the diskette for drive %1.  ( ERROR_SEM_USER_LIMIT             106L "));
		; break;;case  ERROR_DISK_CHANGE :  _sprintf(*buf,_T("   The program stopped because an alternate diskette was not inserted.  ( ERROR_DISK_CHANGE                107L "));
		; break;;case  ERROR_DRIVE_LOCKED :  _sprintf(*buf,_T("   The disk is in use or locked by  another process.  ( ERROR_DRIVE_LOCKED               108L "));
		; break;;case  ERROR_BROKEN_PIPE :  _sprintf(*buf,_T("   The pipe has been ended.  ( ERROR_BROKEN_PIPE                109L "));
		; break;;case  ERROR_OPEN_FAILED :  _sprintf(*buf,_T("   The system cannot open the  device or file specified.  ( ERROR_OPEN_FAILED                110L "));
		; break;;case  ERROR_BUFFER_OVERFLOW :  _sprintf(*buf,_T("   The file name is too long.  ( ERROR_BUFFER_OVERFLOW            111L "));
		; break;;case  ERROR_DISK_FULL :  _sprintf(*buf,_T("   There is not enough space on the disk.  ( ERROR_DISK_FULL                  112L "));
		; break;;case  ERROR_NO_MORE_SEARCH_HANDLES :  _sprintf(*buf,_T("   No more internal file identifiers available.  ( ERROR_NO_MORE_SEARCH_HANDLES     113L "));
		; break;;case  ERROR_INVALID_TARGET_HANDLE :  _sprintf(*buf,_T("   The target internal file identifier is incorrect.  ( ERROR_INVALID_TARGET_HANDLE      114L "));
		; break;;case  ERROR_INVALID_CATEGORY :  _sprintf(*buf,_T("   The IOCTL call made by the application program is not correct.  ( ERROR_INVALID_CATEGORY           117L "));
		; break;;case  ERROR_INVALID_VERIFY_SWITCH :  _sprintf(*buf,_T("   The verify-on-write switch parameter value is not  correct.  ( ERROR_INVALID_VERIFY_SWITCH      118L "));
		; break;;case  ERROR_BAD_DRIVER_LEVEL :  _sprintf(*buf,_T("   The system does not support the command requested.  ( ERROR_BAD_DRIVER_LEVEL           119L "));
		; break;;case  ERROR_CALL_NOT_IMPLEMENTED :  _sprintf(*buf,_T("   This function is not supported on this system.  ( ERROR_CALL_NOT_IMPLEMENTED       120L "));
		; break;;case  ERROR_SEM_TIMEOUT :  _sprintf(*buf,_T("   The semaphore timeout period has expired.  ( ERROR_SEM_TIMEOUT                121L "));
		; break;;case  ERROR_INSUFFICIENT_BUFFER :  _sprintf(*buf,_T("   The data area passed to a system call is too  small.  ( ERROR_INSUFFICIENT_BUFFER        122L     dderror "));
		; break;;case  ERROR_INVALID_NAME :  _sprintf(*buf,_T("   The filename, directory name, or volume label syntax is incorrect.  ( ERROR_INVALID_NAME               123L "));
		; break;;case  ERROR_INVALID_LEVEL :  _sprintf(*buf,_T("   The system call level is not correct.  ( ERROR_INVALID_LEVEL              124L "));
		; break;;case  ERROR_NO_VOLUME_LABEL :  _sprintf(*buf,_T("   The disk has no volume label.  ( ERROR_NO_VOLUME_LABEL            125L "));
		; break;;case  ERROR_MOD_NOT_FOUND :  _sprintf(*buf,_T("   The specified module could not be found.  ( ERROR_MOD_NOT_FOUND              126L "));
		; break;;case  ERROR_PROC_NOT_FOUND :  _sprintf(*buf,_T("   The specified procedure could not be found.  ( ERROR_PROC_NOT_FOUND             127L "));
		; break;;case  ERROR_WAIT_NO_CHILDREN :  _sprintf(*buf,_T("   There are no child processes to wait for.  ( ERROR_WAIT_NO_CHILDREN           128L "));
		; break;;case  ERROR_CHILD_NOT_COMPLETE :  _sprintf(*buf,_T("   The %1 application cannot be run in Win32 mode.  ( ERROR_CHILD_NOT_COMPLETE         129L "));
		; break;;case  ERROR_DIRECT_ACCESS_HANDLE :  _sprintf(*buf,_T("   Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O.  ( ERROR_DIRECT_ACCESS_HANDLE       130L "));
		; break;;case  ERROR_NEGATIVE_SEEK :  _sprintf(*buf,_T("   An attempt was made to move the file pointer before the beginning of the file.  ( ERROR_NEGATIVE_SEEK              131L "));
		; break;;case  ERROR_SEEK_ON_DEVICE :  _sprintf(*buf,_T("   The file pointer cannot be set on the specified device or file.  ( ERROR_SEEK_ON_DEVICE             132L "));
		; break;;case  ERROR_IS_JOIN_TARGET :  _sprintf(*buf,_T("   A JOIN or SUBST command cannot be used for a drive that  contains previously joined drives.  ( ERROR_IS_JOIN_TARGET             133L "));
		; break;;case  ERROR_IS_JOINED :  _sprintf(*buf,_T("   An attempt was made to use a  JOIN or SUBST command on a drive that has  already been joined.  ( ERROR_IS_JOINED                  134L "));
		; break;;case  ERROR_IS_SUBSTED :  _sprintf(*buf,_T("   An attempt was made to use a  JOIN or SUBST command on a drive that has  already been substituted.  ( ERROR_IS_SUBSTED                 135L "));
		; break;;case  ERROR_NOT_JOINED :  _sprintf(*buf,_T("   The system tried to delete  the JOIN of a drive that is not joined.  ( ERROR_NOT_JOINED                 136L "));
		; break;;case  ERROR_NOT_SUBSTED :  _sprintf(*buf,_T("   The system tried to delete the  substitution of a drive that is not substituted.  ( ERROR_NOT_SUBSTED                137L "));
		; break;;case  ERROR_JOIN_TO_JOIN :  _sprintf(*buf,_T("   The system tried to join a drive  to a directory on a joined drive.  ( ERROR_JOIN_TO_JOIN               138L "));
		; break;;case  ERROR_SUBST_TO_SUBST :  _sprintf(*buf,_T("   The system tried to substitute a  drive to a directory on a substituted drive.  ( ERROR_SUBST_TO_SUBST             139L "));
		; break;;case  ERROR_JOIN_TO_SUBST :  _sprintf(*buf,_T("   The system tried to join a drive to  a directory on a substituted drive.  ( ERROR_JOIN_TO_SUBST              140L "));
		; break;;case  ERROR_SUBST_TO_JOIN :  _sprintf(*buf,_T("   The system tried to SUBST a drive  to a directory on a joined drive.  ( ERROR_SUBST_TO_JOIN              141L "));
		; break;;case  ERROR_BUSY_DRIVE :  _sprintf(*buf,_T("   The system cannot perform a JOIN or SUBST at this time.  ( ERROR_BUSY_DRIVE                 142L "));
		; break;;case  ERROR_SAME_DRIVE :  _sprintf(*buf,_T("   The system cannot join or substitute a drive to or for a directory on the same drive.  ( ERROR_SAME_DRIVE                 143L "));
		; break;;case  ERROR_DIR_NOT_ROOT :  _sprintf(*buf,_T("   The directory is not a subdirectory of the root directory.  ( ERROR_DIR_NOT_ROOT               144L "));
		; break;;case  ERROR_DIR_NOT_EMPTY :  _sprintf(*buf,_T("   The directory is not empty.  ( ERROR_DIR_NOT_EMPTY              145L "));
		; break;;case  ERROR_IS_SUBST_PATH :  _sprintf(*buf,_T("   The path specified is being used in  a substitute.  ( ERROR_IS_SUBST_PATH              146L "));
		; break;;case  ERROR_IS_JOIN_PATH :  _sprintf(*buf,_T("   Not enough resources are available to  process this command.  ( ERROR_IS_JOIN_PATH               147L "));
		; break;;case  ERROR_PATH_BUSY :  _sprintf(*buf,_T("   The path specified cannot be used at this time.  ( ERROR_PATH_BUSY                  148L "));
		; break;;case  ERROR_IS_SUBST_TARGET :  _sprintf(*buf,_T("   An attempt was made to join  or substitute a drive for which a directory  on the drive is the target of a previous  substitute.  ( ERROR_IS_SUBST_TARGET            149L "));
		; break;;case  ERROR_SYSTEM_TRACE :  _sprintf(*buf,_T("   System trace information was not specified in your  CONFIG.SYS file, or tracing is disallowed.  ( ERROR_SYSTEM_TRACE               150L "));
		; break;;case  ERROR_INVALID_EVENT_COUNT :  _sprintf(*buf,_T("   The number of specified semaphore events for  DosMuxSemWait is not correct.  ( ERROR_INVALID_EVENT_COUNT        151L "));
		; break;;case  ERROR_TOO_MANY_MUXWAITERS :  _sprintf(*buf,_T("   DosMuxSemWait did not execute; too many semaphores  are already set.  ( ERROR_TOO_MANY_MUXWAITERS        152L "));
		; break;;case  ERROR_INVALID_LIST_FORMAT :  _sprintf(*buf,_T("   The DosMuxSemWait list is not correct.  ( ERROR_INVALID_LIST_FORMAT        153L "));
		; break;;case  ERROR_LABEL_TOO_LONG :  _sprintf(*buf,_T("   The volume label you entered exceeds the label character  limit of the target file system.  ( ERROR_LABEL_TOO_LONG             154L "));
		; break;;case  ERROR_TOO_MANY_TCBS :  _sprintf(*buf,_T("   Cannot create another thread.  ( ERROR_TOO_MANY_TCBS              155L "));
		; break;;case  ERROR_SIGNAL_REFUSED :  _sprintf(*buf,_T("   The recipient process has refused the signal.  ( ERROR_SIGNAL_REFUSED             156L "));
		; break;;case  ERROR_DISCARDED :  _sprintf(*buf,_T("   The segment is already discarded and cannot be locked.  ( ERROR_DISCARDED                  157L "));
		; break;;case  ERROR_NOT_LOCKED :  _sprintf(*buf,_T("   The segment is already unlocked.  ( ERROR_NOT_LOCKED                 158L "));
		; break;;case  ERROR_BAD_THREADID_ADDR :  _sprintf(*buf,_T("   The address for the thread ID is not correct.  ( ERROR_BAD_THREADID_ADDR          159L "));
		; break;;case  ERROR_BAD_ARGUMENTS :  _sprintf(*buf,_T("   The argument string passed to DosExecPgm is not correct.  ( ERROR_BAD_ARGUMENTS              160L "));
		; break;;case  ERROR_BAD_PATHNAME :  _sprintf(*buf,_T("   The specified path is invalid.  ( ERROR_BAD_PATHNAME               161L "));
		; break;;case  ERROR_SIGNAL_PENDING :  _sprintf(*buf,_T("   A signal is already pending.  ( ERROR_SIGNAL_PENDING             162L "));
		; break;;case  ERROR_MAX_THRDS_REACHED :  _sprintf(*buf,_T("   No more threads can be created in the system.  ( ERROR_MAX_THRDS_REACHED          164L "));
		; break;;case  ERROR_LOCK_FAILED :  _sprintf(*buf,_T("   Unable to lock a region of a file.  ( ERROR_LOCK_FAILED                167L "));
		; break;;case  ERROR_BUSY :  _sprintf(*buf,_T("   The requested resource is in use.  ( ERROR_BUSY                       170L "));
		; break;;case  ERROR_CANCEL_VIOLATION :  _sprintf(*buf,_T("   A lock request was not outstanding for the supplied cancel region.  ( ERROR_CANCEL_VIOLATION           173L "));
		; break;;case  ERROR_ATOMIC_LOCKS_NOT_SUPPORTED :  _sprintf(*buf,_T("   The file system does not support atomic changes to the lock type.  ( ERROR_ATOMIC_LOCKS_NOT_SUPPORTED 174L "));
		; break;;case  ERROR_INVALID_SEGMENT_NUMBER :  _sprintf(*buf,_T("   The system detected a segment number that was not correct.  ( ERROR_INVALID_SEGMENT_NUMBER     180L "));
		; break;;case  ERROR_INVALID_ORDINAL :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_ORDINAL            182L "));
		; break;;case  ERROR_ALREADY_EXISTS :  _sprintf(*buf,_T("   Cannot create a file when that file already exists.  ( ERROR_ALREADY_EXISTS             183L "));
		; break;;case  ERROR_INVALID_FLAG_NUMBER :  _sprintf(*buf,_T("   The flag passed is not correct.  ( ERROR_INVALID_FLAG_NUMBER        186L "));
		; break;;case  ERROR_SEM_NOT_FOUND :  _sprintf(*buf,_T("   The specified system semaphore name was not found.  ( ERROR_SEM_NOT_FOUND              187L "));
		; break;;case  ERROR_INVALID_STARTING_CODESEG :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_STARTING_CODESEG   188L "));
		; break;;case  ERROR_INVALID_STACKSEG :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_STACKSEG           189L "));
		; break;;case  ERROR_INVALID_MODULETYPE :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_MODULETYPE         190L "));
		; break;;case  ERROR_INVALID_EXE_SIGNATURE :  _sprintf(*buf,_T("   Cannot run %1 in Win32 mode.  ( ERROR_INVALID_EXE_SIGNATURE      191L "));
		; break;;case  ERROR_EXE_MARKED_INVALID :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_EXE_MARKED_INVALID         192L "));
		; break;;case  ERROR_BAD_EXE_FORMAT :  _sprintf(*buf,_T("   %1 is not a valid Win32 application.  ( ERROR_BAD_EXE_FORMAT             193L "));
		; break;;case  ERROR_ITERATED_DATA_EXCEEDS_64k :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_ITERATED_DATA_EXCEEDS_64k  194L "));
		; break;;case  ERROR_INVALID_MINALLOCSIZE :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_MINALLOCSIZE       195L "));
		; break;;case  ERROR_DYNLINK_FROM_INVALID_RING :  _sprintf(*buf,_T("   The operating system cannot run this  application program.  ( ERROR_DYNLINK_FROM_INVALID_RING  196L "));
		; break;;case  ERROR_IOPL_NOT_ENABLED :  _sprintf(*buf,_T("   The operating system is not presently  configured to run this application.  ( ERROR_IOPL_NOT_ENABLED           197L "));
		; break;;case  ERROR_INVALID_SEGDPL :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INVALID_SEGDPL             198L "));
		; break;;case  ERROR_AUTODATASEG_EXCEEDS_64k :  _sprintf(*buf,_T("   The operating system cannot run this  application program.  ( ERROR_AUTODATASEG_EXCEEDS_64k    199L "));
		; break;;case  ERROR_RING2SEG_MUST_BE_MOVABLE :  _sprintf(*buf,_T("   The code segment cannot be greater than or equal to 64K.  ( ERROR_RING2SEG_MUST_BE_MOVABLE   200L "));
		; break;;case  ERROR_RELOC_CHAIN_XEEDS_SEGLIM :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_RELOC_CHAIN_XEEDS_SEGLIM   201L "));
		; break;;case  ERROR_INFLOOP_IN_RELOC_CHAIN :  _sprintf(*buf,_T("   The operating system cannot run %1.  ( ERROR_INFLOOP_IN_RELOC_CHAIN     202L "));
		; break;;case  ERROR_ENVVAR_NOT_FOUND :  _sprintf(*buf,_T("   The system could not find the environment  option that was entered.  ( ERROR_ENVVAR_NOT_FOUND           203L "));
		; break;;case  ERROR_NO_SIGNAL_SENT :  _sprintf(*buf,_T("   No process in the command subtree has a  signal handler.  ( ERROR_NO_SIGNAL_SENT             205L "));
		; break;;case  ERROR_FILENAME_EXCED_RANGE :  _sprintf(*buf,_T("   The filename or extension is too long.  ( ERROR_FILENAME_EXCED_RANGE       206L "));
		; break;;case  ERROR_RING2_STACK_IN_USE :  _sprintf(*buf,_T("   The ring 2 stack is in use.  ( ERROR_RING2_STACK_IN_USE         207L "));
		; break;;case  ERROR_META_EXPANSION_TOO_LONG :  _sprintf(*buf,_T("   The global filename characters, * or ?, are entered  incorrectly or too many global filename characters are specified.  ( ERROR_META_EXPANSION_TOO_LONG    208L "));
		; break;;case  ERROR_INVALID_SIGNAL_NUMBER :  _sprintf(*buf,_T("   The signal being posted is not correct.  ( ERROR_INVALID_SIGNAL_NUMBER      209L "));
		; break;;case  ERROR_THREAD_1_INACTIVE :  _sprintf(*buf,_T("   The signal handler cannot be set.  ( ERROR_THREAD_1_INACTIVE          210L "));
		; break;;case  ERROR_LOCKED :  _sprintf(*buf,_T("   The segment is locked and cannot be reallocated.  ( ERROR_LOCKED                     212L "));
		; break;;case  ERROR_TOO_MANY_MODULES :  _sprintf(*buf,_T("   Too many dynamic-link modules are attached to this  program or dynamic-link module.  ( ERROR_TOO_MANY_MODULES           214L "));
		; break;;case  ERROR_NESTING_NOT_ALLOWED :  _sprintf(*buf,_T("   Can't nest calls to LoadModule.  ( ERROR_NESTING_NOT_ALLOWED        215L "));
		; break;;case  ERROR_EXE_MACHINE_TYPE_MISMATCH :  _sprintf(*buf,_T("   The image file %1 is valid, but is for a machine type other  than the current machine.  ( ERROR_EXE_MACHINE_TYPE_MISMATCH  216L "));
		; break;;case  ERROR_BAD_PIPE :  _sprintf(*buf,_T("   The pipe state is invalid.  ( ERROR_BAD_PIPE                   230L "));
		; break;;case  ERROR_PIPE_BUSY :  _sprintf(*buf,_T("   All pipe instances are busy.  ( ERROR_PIPE_BUSY                  231L "));
		; break;;case  ERROR_NO_DATA :  _sprintf(*buf,_T("   The pipe is being closed.  ( ERROR_NO_DATA                    232L "));
		; break;;case  ERROR_PIPE_NOT_CONNECTED :  _sprintf(*buf,_T("   No process is on the other end of the pipe.  ( ERROR_PIPE_NOT_CONNECTED         233L "));
		; break;;case  ERROR_MORE_DATA :  _sprintf(*buf,_T("   More data is available.  ( ERROR_MORE_DATA                  234L     dderror "));
		; break;;case  ERROR_VC_DISCONNECTED :  _sprintf(*buf,_T("   The session was canceled.  ( ERROR_VC_DISCONNECTED            240L "));
		; break;;case  ERROR_INVALID_EA_NAME :  _sprintf(*buf,_T("   The specified extended attribute name was invalid.  ( ERROR_INVALID_EA_NAME            254L "));
		; break;;case  ERROR_EA_LIST_INCONSISTENT :  _sprintf(*buf,_T("   The extended attributes are inconsistent.  ( ERROR_EA_LIST_INCONSISTENT       255L "));
		; break;;case  ERROR_NO_MORE_ITEMS :  _sprintf(*buf,_T("   No more data is available.  ( ERROR_NO_MORE_ITEMS              259L "));
		; break;;case  ERROR_CANNOT_COPY :  _sprintf(*buf,_T("   The copy functions cannot be used.  ( ERROR_CANNOT_COPY                266L "));
		; break;;case  ERROR_DIRECTORY :  _sprintf(*buf,_T("   The directory name is invalid.  ( ERROR_DIRECTORY                  267L "));
		; break;;case  ERROR_EAS_DIDNT_FIT :  _sprintf(*buf,_T("   The extended attributes did not fit in the buffer.  ( ERROR_EAS_DIDNT_FIT              275L "));
		; break;;case  ERROR_EA_FILE_CORRUPT :  _sprintf(*buf,_T("   The extended attribute file on the mounted file system is corrupt.  ( ERROR_EA_FILE_CORRUPT            276L "));
		; break;;case  ERROR_EA_TABLE_FULL :  _sprintf(*buf,_T("   The extended attribute table file is full.  ( ERROR_EA_TABLE_FULL              277L "));
		; break;;case  ERROR_INVALID_EA_HANDLE :  _sprintf(*buf,_T("   The specified extended attribute handle is invalid.  ( ERROR_INVALID_EA_HANDLE          278L "));
		; break;;case  ERROR_EAS_NOT_SUPPORTED :  _sprintf(*buf,_T("   The mounted file system does not support extended attributes.  ( ERROR_EAS_NOT_SUPPORTED          282L "));
		; break;;case  ERROR_NOT_OWNER :  _sprintf(*buf,_T("   Attempt to release mutex not owned by caller.  ( ERROR_NOT_OWNER                  288L "));
		; break;;case  ERROR_TOO_MANY_POSTS :  _sprintf(*buf,_T("   Too many posts were made to a semaphore.  ( ERROR_TOO_MANY_POSTS             298L "));
		; break;;case  ERROR_PARTIAL_COPY :  _sprintf(*buf,_T("   Only part of a ReadProcessMemoty or WriteProcessMemory request was completed.  ( ERROR_PARTIAL_COPY               299L "));
#ifndef VCPP50
		; break;;case  ERROR_OPLOCK_NOT_GRANTED :  _sprintf(*buf,_T("   The oplock request is denied.  ( ERROR_OPLOCK_NOT_GRANTED         300L "));
		; break;;case  ERROR_INVALID_OPLOCK_PROTOCOL :  _sprintf(*buf,_T("   An invalid oplock acknowledgment was received by the system.  ( ERROR_INVALID_OPLOCK_PROTOCOL    301L "));
#endif
		; break;;case  ERROR_MR_MID_NOT_FOUND :  _sprintf(*buf,_T("   The system cannot find message text for message number 0x%1  in the message file for %2.  ( ERROR_MR_MID_NOT_FOUND           317L "));
		; break;;case  ERROR_INVALID_ADDRESS :  _sprintf(*buf,_T("   Attempt to access invalid address.  ( ERROR_INVALID_ADDRESS            487L "));
		; break;;case  ERROR_ARITHMETIC_OVERFLOW :  _sprintf(*buf,_T("   Arithmetic result exceeded 32 bits.  ( ERROR_ARITHMETIC_OVERFLOW        534L "));
		; break;;case  ERROR_PIPE_CONNECTED :  _sprintf(*buf,_T("   There is a process on other end of the pipe.  ( ERROR_PIPE_CONNECTED             535L "));
		; break;;case  ERROR_PIPE_LISTENING :  _sprintf(*buf,_T("   Waiting for a process to open the other end of the pipe.  ( ERROR_PIPE_LISTENING             536L "));
		; break;;case  ERROR_EA_ACCESS_DENIED :  _sprintf(*buf,_T("   Access to the extended attribute was denied.  ( ERROR_EA_ACCESS_DENIED           994L "));
		; break;;case  ERROR_OPERATION_ABORTED :  _sprintf(*buf,_T("   The I/O operation has been aborted because of either a thread exit  or an application request.  ( ERROR_OPERATION_ABORTED          995L "));
		; break;;case  ERROR_IO_INCOMPLETE :  _sprintf(*buf,_T("   Overlapped I/O event is not in a signaled state.  ( ERROR_IO_INCOMPLETE              996L "));
		; break;;case  ERROR_IO_PENDING :  _sprintf(*buf,_T("   Overlapped I/O operation is in progress.  ( ERROR_IO_PENDING                 997L     dderror "));
		; break;;case  ERROR_NOACCESS :  _sprintf(*buf,_T("   Invalid access to memory location.  ( ERROR_NOACCESS                   998L "));
		; break;;case  ERROR_SWAPERROR :  _sprintf(*buf,_T("   Error performing inpage operation.  ( ERROR_SWAPERROR                  999L "));
		; break;;case  ERROR_STACK_OVERFLOW :  _sprintf(*buf,_T("   Recursion too deep; the stack overflowed.  ( ERROR_STACK_OVERFLOW             1001L "));
		; break;;case  ERROR_INVALID_MESSAGE :  _sprintf(*buf,_T("   The window cannot act on the sent message.  ( ERROR_INVALID_MESSAGE            1002L "));
		; break;;case  ERROR_CAN_NOT_COMPLETE :  _sprintf(*buf,_T("   Cannot complete this function.  ( ERROR_CAN_NOT_COMPLETE           1003L "));
		; break;;case  ERROR_INVALID_FLAGS :  _sprintf(*buf,_T("   Invalid flags.  ( ERROR_INVALID_FLAGS              1004L "));
		; break;;case  ERROR_UNRECOGNIZED_VOLUME :  _sprintf(*buf,_T("   The volume does not contain a recognized file system.  Please make sure that all required file system drivers are loaded and that the  volume is not corrupted.  ( ERROR_UNRECOGNIZED_VOLUME        1005L "));
		; break;;case  ERROR_FILE_INVALID :  _sprintf(*buf,_T("   The volume for a file has been externally altered so that the  opened file is no longer valid.  ( ERROR_FILE_INVALID               1006L "));
		; break;;case  ERROR_FULLSCREEN_MODE :  _sprintf(*buf,_T("   The requested operation cannot be performed in full-screen mode.  ( ERROR_FULLSCREEN_MODE            1007L "));
		; break;;case  ERROR_NO_TOKEN :  _sprintf(*buf,_T("   An attempt was made to reference a token that does not exist.  ( ERROR_NO_TOKEN                   1008L "));
		; break;;case  ERROR_BADDB :  _sprintf(*buf,_T("   The configuration registry database is corrupt.  ( ERROR_BADDB                      1009L "));
		; break;;case  ERROR_BADKEY :  _sprintf(*buf,_T("   The configuration registry key is invalid.  ( ERROR_BADKEY                     1010L "));
		; break;;case  ERROR_CANTOPEN :  _sprintf(*buf,_T("   The configuration registry key could not be opened.  ( ERROR_CANTOPEN                   1011L "));
		; break;;case  ERROR_CANTREAD :  _sprintf(*buf,_T("   The configuration registry key could not be read.  ( ERROR_CANTREAD                   1012L "));
		; break;;case  ERROR_CANTWRITE :  _sprintf(*buf,_T("   The configuration registry key could not be written.  ( ERROR_CANTWRITE                  1013L "));
		; break;;case  ERROR_REGISTRY_RECOVERED :  _sprintf(*buf,_T("   One of the files in the registry database had to be recovered  by use of a log or alternate copy.  The recovery was successful.  ( ERROR_REGISTRY_RECOVERED         1014L "));
		; break;;case  ERROR_REGISTRY_CORRUPT :  _sprintf(*buf,_T("   The registry is corrupted. The structure of one of the files that contains  registry data is corrupted, or the system's image of the file in memory  is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted.  ( ERROR_REGISTRY_CORRUPT           1015L "));
		; break;;case  ERROR_REGISTRY_IO_FAILED :  _sprintf(*buf,_T("   An I/O operation initiated by the registry failed unrecoverably.  The registry could not read in, or write out, or flush, one of the files  that contain the system's image of the registry.  ( ERROR_REGISTRY_IO_FAILED         1016L "));
		; break;;case  ERROR_NOT_REGISTRY_FILE :  _sprintf(*buf,_T("   The system has attempted to load or restore a file into the registry, but the  specified file is not in a registry file format.  ( ERROR_NOT_REGISTRY_FILE          1017L "));
		; break;;case  ERROR_KEY_DELETED :  _sprintf(*buf,_T("   Illegal operation attempted on a registry key that has been marked for deletion.  ( ERROR_KEY_DELETED                1018L "));
		; break;;case  ERROR_NO_LOG_SPACE :  _sprintf(*buf,_T("   System could not allocate the required space in a registry log.  ( ERROR_NO_LOG_SPACE               1019L "));
		; break;;case  ERROR_KEY_HAS_CHILDREN :  _sprintf(*buf,_T("   Cannot create a symbolic link in a registry key that already  has subkeys or values.  ( ERROR_KEY_HAS_CHILDREN           1020L "));
		; break;;case  ERROR_CHILD_MUST_BE_VOLATILE :  _sprintf(*buf,_T("   Cannot create a stable subkey under a volatile parent key.  ( ERROR_CHILD_MUST_BE_VOLATILE     1021L "));
		; break;;case  ERROR_NOTIFY_ENUM_DIR :  _sprintf(*buf,_T("   A notify change request is being completed and the information  is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes.  ( ERROR_NOTIFY_ENUM_DIR            1022L "));
		; break;;case  ERROR_DEPENDENT_SERVICES_RUNNING :  _sprintf(*buf,_T("   A stop control has been sent to a service that other running services  are dependent on.  ( ERROR_DEPENDENT_SERVICES_RUNNING 1051L "));
		; break;;case  ERROR_INVALID_SERVICE_CONTROL :  _sprintf(*buf,_T("   The requested control is not valid for this service.  ( ERROR_INVALID_SERVICE_CONTROL    1052L "));
		; break;;case  ERROR_SERVICE_REQUEST_TIMEOUT :  _sprintf(*buf,_T("   The service did not respond to the start or control request in a timely  fashion.  ( ERROR_SERVICE_REQUEST_TIMEOUT    1053L "));
		; break;;case  ERROR_SERVICE_NO_THREAD :  _sprintf(*buf,_T("   A thread could not be created for the service.  ( ERROR_SERVICE_NO_THREAD          1054L "));
		; break;;case  ERROR_SERVICE_DATABASE_LOCKED :  _sprintf(*buf,_T("   The service database is locked.  ( ERROR_SERVICE_DATABASE_LOCKED    1055L "));
		; break;;case  ERROR_SERVICE_ALREADY_RUNNING :  _sprintf(*buf,_T("   An instance of the service is already running.  ( ERROR_SERVICE_ALREADY_RUNNING    1056L "));
		; break;;case  ERROR_INVALID_SERVICE_ACCOUNT :  _sprintf(*buf,_T("   The account name is invalid or does not exist.  ( ERROR_INVALID_SERVICE_ACCOUNT    1057L "));
		; break;;case  ERROR_SERVICE_DISABLED :  _sprintf(*buf,_T("   The service cannot be started, either because it is disabled or because  it has no enabled devices associated with it.  ( ERROR_SERVICE_DISABLED           1058L "));
		; break;;case  ERROR_CIRCULAR_DEPENDENCY :  _sprintf(*buf,_T("   Circular service dependency was specified.  ( ERROR_CIRCULAR_DEPENDENCY        1059L "));
		; break;;case  ERROR_SERVICE_DOES_NOT_EXIST :  _sprintf(*buf,_T("   The specified service does not exist as an installed service.  ( ERROR_SERVICE_DOES_NOT_EXIST     1060L "));
		; break;;case  ERROR_SERVICE_CANNOT_ACCEPT_CTRL :  _sprintf(*buf,_T("   The service cannot accept control messages at this time.  ( ERROR_SERVICE_CANNOT_ACCEPT_CTRL 1061L "));
		; break;;case  ERROR_SERVICE_NOT_ACTIVE :  _sprintf(*buf,_T("   The service has not been started.  ( ERROR_SERVICE_NOT_ACTIVE         1062L "));
		; break;;case  ERROR_FAILED_SERVICE_CONTROLLER_CONNECT :  _sprintf(*buf,_T("   The service process could not connect to the service controller.  ( ERROR_FAILED_SERVICE_CONTROLLER_CONNECT 1063L "));
		; break;;case  ERROR_EXCEPTION_IN_SERVICE :  _sprintf(*buf,_T("   An exception occurred in the service when handling the control request.  ( ERROR_EXCEPTION_IN_SERVICE       1064L "));
		; break;;case  ERROR_DATABASE_DOES_NOT_EXIST :  _sprintf(*buf,_T("   The database specified does not exist.  ( ERROR_DATABASE_DOES_NOT_EXIST    1065L "));
		; break;;case  ERROR_SERVICE_SPECIFIC_ERROR :  _sprintf(*buf,_T("   The service has returned a service-specific error code.  ( ERROR_SERVICE_SPECIFIC_ERROR     1066L "));
		; break;;case  ERROR_PROCESS_ABORTED :  _sprintf(*buf,_T("   The process terminated unexpectedly.  ( ERROR_PROCESS_ABORTED            1067L "));
		; break;;case  ERROR_SERVICE_DEPENDENCY_FAIL :  _sprintf(*buf,_T("   The dependency service or group failed to start.  ( ERROR_SERVICE_DEPENDENCY_FAIL    1068L "));
		; break;;case  ERROR_SERVICE_LOGON_FAILED :  _sprintf(*buf,_T("   The service did not start due to a logon failure.  ( ERROR_SERVICE_LOGON_FAILED       1069L "));
		; break;;case  ERROR_SERVICE_START_HANG :  _sprintf(*buf,_T("   After starting, the service hung in a start-pending state.  ( ERROR_SERVICE_START_HANG         1070L "));
		; break;;case  ERROR_INVALID_SERVICE_LOCK :  _sprintf(*buf,_T("   The specified service database lock is invalid.  ( ERROR_INVALID_SERVICE_LOCK       1071L "));
		; break;;case  ERROR_SERVICE_MARKED_FOR_DELETE :  _sprintf(*buf,_T("   The specified service has been marked for deletion.  ( ERROR_SERVICE_MARKED_FOR_DELETE  1072L "));
		; break;;case  ERROR_SERVICE_EXISTS :  _sprintf(*buf,_T("   The specified service already exists.  ( ERROR_SERVICE_EXISTS             1073L "));
		; break;;case  ERROR_ALREADY_RUNNING_LKG :  _sprintf(*buf,_T("   The system is currently running with the last-known-good configuration.  ( ERROR_ALREADY_RUNNING_LKG        1074L "));
		; break;;case  ERROR_SERVICE_DEPENDENCY_DELETED :  _sprintf(*buf,_T("   The dependency service does not exist or has been marked for  deletion.  ( ERROR_SERVICE_DEPENDENCY_DELETED 1075L "));
		; break;;case  ERROR_BOOT_ALREADY_ACCEPTED :  _sprintf(*buf,_T("   The current boot has already been accepted for use as the  last-known-good control set.  ( ERROR_BOOT_ALREADY_ACCEPTED      1076L "));
		; break;;case  ERROR_SERVICE_NEVER_STARTED :  _sprintf(*buf,_T("   No attempts to start the service have been made since the last boot.  ( ERROR_SERVICE_NEVER_STARTED      1077L "));
		; break;;case  ERROR_DUPLICATE_SERVICE_NAME :  _sprintf(*buf,_T("   The name is already in use as either a service name or a service display  name.  ( ERROR_DUPLICATE_SERVICE_NAME     1078L "));
		; break;;case  ERROR_DIFFERENT_SERVICE_ACCOUNT :  _sprintf(*buf,_T("   The account specified for this service is different from the account  specified for other services running in the same process.  ( ERROR_DIFFERENT_SERVICE_ACCOUNT  1079L "));
#ifndef VCPP50
		; break;;case  ERROR_CANNOT_DETECT_DRIVER_FAILURE :  _sprintf(*buf,_T("   Failure actions can only be set for Win32 services, not for drivers.  ( ERROR_CANNOT_DETECT_DRIVER_FAILURE 1080L "));
		; break;;case  ERROR_CANNOT_DETECT_PROCESS_ABORT :  _sprintf(*buf,_T("   This service runs in the same process as the service control manager.  Therefore, the service control manager cannot take action if this  service's process terminates unexpectedly.  ( ERROR_CANNOT_DETECT_PROCESS_ABORT 1081L "));
		; break;;case  ERROR_NO_RECOVERY_PROGRAM :  _sprintf(*buf,_T("   No recovery program has been configured for this service.  ( ERROR_NO_RECOVERY_PROGRAM        1082L "));
#endif
		; break;;case  ERROR_END_OF_MEDIA :  _sprintf(*buf,_T("   The physical end of the tape has been reached.  ( ERROR_END_OF_MEDIA               1100L "));
		; break;;case  ERROR_FILEMARK_DETECTED :  _sprintf(*buf,_T("   A tape access reached a filemark.  ( ERROR_FILEMARK_DETECTED          1101L "));
		; break;;case  ERROR_BEGINNING_OF_MEDIA :  _sprintf(*buf,_T("   The beginning of the tape or a partition was encountered.  ( ERROR_BEGINNING_OF_MEDIA         1102L "));
		; break;;case  ERROR_SETMARK_DETECTED :  _sprintf(*buf,_T("   A tape access reached the end of a set of files.  ( ERROR_SETMARK_DETECTED           1103L "));
		; break;;case  ERROR_NO_DATA_DETECTED :  _sprintf(*buf,_T("   No more data is on the tape.  ( ERROR_NO_DATA_DETECTED           1104L "));
		; break;;case  ERROR_PARTITION_FAILURE :  _sprintf(*buf,_T("   Tape could not be partitioned.  ( ERROR_PARTITION_FAILURE          1105L "));
		; break;;case  ERROR_INVALID_BLOCK_LENGTH :  _sprintf(*buf,_T("   When accessing a new tape of a multivolume partition, the current  blocksize is incorrect.  ( ERROR_INVALID_BLOCK_LENGTH       1106L "));
		; break;;case  ERROR_DEVICE_NOT_PARTITIONED :  _sprintf(*buf,_T("   Tape partition information could not be found when loading a tape.  ( ERROR_DEVICE_NOT_PARTITIONED     1107L "));
		; break;;case  ERROR_UNABLE_TO_LOCK_MEDIA :  _sprintf(*buf,_T("   Unable to lock the media eject mechanism.  ( ERROR_UNABLE_TO_LOCK_MEDIA       1108L "));
		; break;;case  ERROR_UNABLE_TO_UNLOAD_MEDIA :  _sprintf(*buf,_T("   Unable to unload the media.  ( ERROR_UNABLE_TO_UNLOAD_MEDIA     1109L "));
		; break;;case  ERROR_MEDIA_CHANGED :  _sprintf(*buf,_T("   The media in the drive may have changed.  ( ERROR_MEDIA_CHANGED              1110L "));
		; break;;case  ERROR_BUS_RESET :  _sprintf(*buf,_T("   The I/O bus was reset.  ( ERROR_BUS_RESET                  1111L "));
		; break;;case  ERROR_NO_MEDIA_IN_DRIVE :  _sprintf(*buf,_T("   No media in drive.  ( ERROR_NO_MEDIA_IN_DRIVE          1112L "));
		; break;;case  ERROR_NO_UNICODE_TRANSLATION :  _sprintf(*buf,_T("   No mapping for the Unicode character exists in the target multi-BYTE code page.  ( ERROR_NO_UNICODE_TRANSLATION     1113L "));
		; break;;case  ERROR_DLL_INIT_FAILED :  _sprintf(*buf,_T("   A dynamic link library (DLL) initialization routine failed.  ( ERROR_DLL_INIT_FAILED            1114L "));
		; break;;case  ERROR_SHUTDOWN_IN_PROGRESS :  _sprintf(*buf,_T("   A system shutdown is in progress.  ( ERROR_SHUTDOWN_IN_PROGRESS       1115L "));
		; break;;case  ERROR_NO_SHUTDOWN_IN_PROGRESS :  _sprintf(*buf,_T("   Unable to abort the system shutdown because no shutdown was in progress.  ( ERROR_NO_SHUTDOWN_IN_PROGRESS    1116L "));
		; break;;case  ERROR_IO_DEVICE :  _sprintf(*buf,_T("   The request could not be performed because of an I/O device error.  ( ERROR_IO_DEVICE                  1117L "));
		; break;;case  ERROR_SERIAL_NO_DEVICE :  _sprintf(*buf,_T("   No serial device was successfully initialized.  The serial driver will unload.  ( ERROR_SERIAL_NO_DEVICE           1118L "));
		; break;;case  ERROR_IRQ_BUSY :  _sprintf(*buf,_T("   Unable to open a device that was sharing an interrupt request (IRQ)  with other devices. At least one other device that uses that IRQ  was already opened.  ( ERROR_IRQ_BUSY                   1119L "));
		; break;;case  ERROR_MORE_WRITES :  _sprintf(*buf,_T("   A serial I/O operation was completed by another write to the serial port.  (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)  ( ERROR_MORE_WRITES                1120L "));
		; break;;case  ERROR_COUNTER_TIMEOUT :  _sprintf(*buf,_T("   A serial I/O operation completed because the timeout period expired.  (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)  ( ERROR_COUNTER_TIMEOUT            1121L "));
		; break;;case  ERROR_FLOPPY_ID_MARK_NOT_FOUND :  _sprintf(*buf,_T("   No ID address mark was found on the floppy disk.  ( ERROR_FLOPPY_ID_MARK_NOT_FOUND   1122L "));
		; break;;case  ERROR_FLOPPY_WRONG_CYLINDER :  _sprintf(*buf,_T("   Mismatch between the floppy disk sector ID field and the floppy disk  controller track address.  ( ERROR_FLOPPY_WRONG_CYLINDER      1123L "));
		; break;;case  ERROR_FLOPPY_UNKNOWN_ERROR :  _sprintf(*buf,_T("   The floppy disk controller reported an error that is not recognized  by the floppy disk driver.  ( ERROR_FLOPPY_UNKNOWN_ERROR       1124L "));
		; break;;case  ERROR_FLOPPY_BAD_REGISTERS :  _sprintf(*buf,_T("   The floppy disk controller returned inconsistent results in its registers.  ( ERROR_FLOPPY_BAD_REGISTERS       1125L "));
		; break;;case  ERROR_DISK_RECALIBRATE_FAILED :  _sprintf(*buf,_T("   While accessing the hard disk, a recalibrate operation failed, even after retries.  ( ERROR_DISK_RECALIBRATE_FAILED    1126L "));
		; break;;case  ERROR_DISK_OPERATION_FAILED :  _sprintf(*buf,_T("   While accessing the hard disk, a disk operation failed even after retries.  ( ERROR_DISK_OPERATION_FAILED      1127L "));
		; break;;case  ERROR_DISK_RESET_FAILED :  _sprintf(*buf,_T("   While accessing the hard disk, a disk controller reset was needed, but  even that failed.  ( ERROR_DISK_RESET_FAILED          1128L "));
		; break;;case  ERROR_EOM_OVERFLOW :  _sprintf(*buf,_T("   Physical end of tape encountered.  ( ERROR_EOM_OVERFLOW               1129L "));
		; break;;case  ERROR_NOT_ENOUGH_SERVER_MEMORY :  _sprintf(*buf,_T("   Not enough server storage is available to process this command.  ( ERROR_NOT_ENOUGH_SERVER_MEMORY   1130L "));
		; break;;case  ERROR_POSSIBLE_DEADLOCK :  _sprintf(*buf,_T("   A potential deadlock condition has been detected.  ( ERROR_POSSIBLE_DEADLOCK          1131L "));
		; break;;case  ERROR_MAPPED_ALIGNMENT :  _sprintf(*buf,_T("   The base address or the file offset specified does not have the proper  alignment.  ( ERROR_MAPPED_ALIGNMENT           1132L "));
		; break;;case  ERROR_SET_POWER_STATE_VETOED :  _sprintf(*buf,_T("   An attempt to change the system power state was vetoed by another  application or driver.  ( ERROR_SET_POWER_STATE_VETOED     1140L "));
		; break;;case  ERROR_SET_POWER_STATE_FAILED :  _sprintf(*buf,_T("   The system BIOS failed an attempt to change the system power state.  ( ERROR_SET_POWER_STATE_FAILED     1141L "));
		; break;;case  ERROR_TOO_MANY_LINKS :  _sprintf(*buf,_T("   An attempt was made to create more links on a file than  the file system supports.  ( ERROR_TOO_MANY_LINKS             1142L "));
		; break;;case  ERROR_OLD_WIN_VERSION :  _sprintf(*buf,_T("   The specified program requires a newer version of Windows.  ( ERROR_OLD_WIN_VERSION            1150L "));
		; break;;case  ERROR_APP_WRONG_OS :  _sprintf(*buf,_T("   The specified program is not a Windows or MS-DOS program.  ( ERROR_APP_WRONG_OS               1151L "));
		; break;;case  ERROR_SINGLE_INSTANCE_APP :  _sprintf(*buf,_T("   Cannot start more than one instance of the specified program.  ( ERROR_SINGLE_INSTANCE_APP        1152L "));
		; break;;case  ERROR_RMODE_APP :  _sprintf(*buf,_T("   The specified program was written for an earlier version of Windows.  ( ERROR_RMODE_APP                  1153L "));
		; break;;case  ERROR_INVALID_DLL :  _sprintf(*buf,_T("   One of the library files needed to run this application is damaged.  ( ERROR_INVALID_DLL                1154L "));
		; break;;case  ERROR_NO_ASSOCIATION :  _sprintf(*buf,_T("   No application is associated with the specified file for this operation.  ( ERROR_NO_ASSOCIATION             1155L "));
		; break;;case  ERROR_DDE_FAIL :  _sprintf(*buf,_T("   An error occurred in sending the command to the application.  ( ERROR_DDE_FAIL                   1156L "));
		; break;;case  ERROR_DLL_NOT_FOUND :  _sprintf(*buf,_T("   One of the library files needed to run this application cannot be found.  ( ERROR_DLL_NOT_FOUND              1157L "));
#ifndef VCPP50
		; break;;case  ERROR_NO_MORE_USER_HANDLES :  _sprintf(*buf,_T("   The current process has used all of its system allowance of handles for Window Manager objects.  ( ERROR_NO_MORE_USER_HANDLES       1158L "));
		; break;;case  ERROR_MESSAGE_SYNC_ONLY :  _sprintf(*buf,_T("   The message can be used only with synchronous operations.  ( ERROR_MESSAGE_SYNC_ONLY          1159L "));
		; break;;case  ERROR_SOURCE_ELEMENT_EMPTY :  _sprintf(*buf,_T("   The indicated source element has no media.  ( ERROR_SOURCE_ELEMENT_EMPTY       1160L "));
		; break;;case  ERROR_DESTINATION_ELEMENT_FULL :  _sprintf(*buf,_T("   The indicated destination element already contains media.  ( ERROR_DESTINATION_ELEMENT_FULL   1161L "));
		; break;;case  ERROR_ILLEGAL_ELEMENT_ADDRESS :  _sprintf(*buf,_T("   The indicated element does not exist.  ( ERROR_ILLEGAL_ELEMENT_ADDRESS    1162L "));
		; break;;case  ERROR_MAGAZINE_NOT_PRESENT :  _sprintf(*buf,_T("   The indicated element is part of a magazine that is not present.  ( ERROR_MAGAZINE_NOT_PRESENT       1163L "));
		; break;;case  ERROR_DEVICE_REINITIALIZATION_NEEDED :  _sprintf(*buf,_T("   The indicated device requires reinitialization due to hardware errors.  ( ERROR_DEVICE_REINITIALIZATION_NEEDED 1164L     dderror "));
		; break;;case  ERROR_DEVICE_REQUIRES_CLEANING :  _sprintf(*buf,_T("   The device has indicated that cleaning is required before further operations are attempted.  ( ERROR_DEVICE_REQUIRES_CLEANING   1165L "));
		; break;;case  ERROR_DEVICE_DOOR_OPEN :  _sprintf(*buf,_T("   The device has indicated that its door is open.  ( ERROR_DEVICE_DOOR_OPEN           1166L "));
		; break;;case  ERROR_DEVICE_NOT_CONNECTED :  _sprintf(*buf,_T("   The device is not connected.  ( ERROR_DEVICE_NOT_CONNECTED       1167L "));
		; break;;case  ERROR_NOT_FOUND :  _sprintf(*buf,_T("   Element not found.  ( ERROR_NOT_FOUND                  1168L "));
		; break;;case  ERROR_NO_MATCH :  _sprintf(*buf,_T("   There was no match for the specified key in the index.  ( ERROR_NO_MATCH                   1169L "));
		; break;;case  ERROR_SET_NOT_FOUND :  _sprintf(*buf,_T("   The property set specified does not exist on the object.  ( ERROR_SET_NOT_FOUND              1170L "));
		; break;;case  ERROR_POINT_NOT_FOUND :  _sprintf(*buf,_T("   The point passed to GetMouseMovePoints is not in the buffer.  ( ERROR_POINT_NOT_FOUND            1171L "));
		; break;;case  ERROR_NO_TRACKING_SERVICE :  _sprintf(*buf,_T("   The tracking (workstation) service is not running.  ( ERROR_NO_TRACKING_SERVICE        1172L "));
		; break;;case  ERROR_NO_VOLUME_ID :  _sprintf(*buf,_T("   The Volume ID could not be found.  ( ERROR_NO_VOLUME_ID               1173L "));
		; break;;case  ERROR_CONNECTED_OTHER_PASSWORD :  _sprintf(*buf,_T("   The network connection was made successfully, but the user had to be prompted  for a password other than the one originally specified.  ( ERROR_CONNECTED_OTHER_PASSWORD   2108L "));
#endif
		; break;;case  ERROR_BAD_USERNAME :  _sprintf(*buf,_T("   The specified username is invalid.  ( ERROR_BAD_USERNAME               2202L "));
		; break;;case  ERROR_NOT_CONNECTED :  _sprintf(*buf,_T("   This network connection does not exist.  ( ERROR_NOT_CONNECTED              2250L "));
		; break;;case  ERROR_OPEN_FILES :  _sprintf(*buf,_T("   This network connection has files open or requests pending.  ( ERROR_OPEN_FILES                 2401L "));
		; break;;case  ERROR_ACTIVE_CONNECTIONS :  _sprintf(*buf,_T("   Active connections still exist.  ( ERROR_ACTIVE_CONNECTIONS         2402L "));
		; break;;case  ERROR_DEVICE_IN_USE :  _sprintf(*buf,_T("   The device is in use by an active process and cannot be disconnected.  ( ERROR_DEVICE_IN_USE              2404L "));
		; break;;case  ERROR_BAD_DEVICE :  _sprintf(*buf,_T("   The specified device name is invalid.  ( ERROR_BAD_DEVICE                 1200L "));
		; break;;case  ERROR_CONNECTION_UNAVAIL :  _sprintf(*buf,_T("   The device is not currently connected but it is a remembered connection.  ( ERROR_CONNECTION_UNAVAIL         1201L "));
		; break;;case  ERROR_DEVICE_ALREADY_REMEMBERED :  _sprintf(*buf,_T("   An attempt was made to remember a device that had previously been remembered.  ( ERROR_DEVICE_ALREADY_REMEMBERED  1202L "));
		; break;;case  ERROR_NO_NET_OR_BAD_PATH :  _sprintf(*buf,_T("   No network provider accepted the given network path.  ( ERROR_NO_NET_OR_BAD_PATH         1203L "));
		; break;;case  ERROR_BAD_PROVIDER :  _sprintf(*buf,_T("   The specified network provider name is invalid.  ( ERROR_BAD_PROVIDER               1204L "));
		; break;;case  ERROR_CANNOT_OPEN_PROFILE :  _sprintf(*buf,_T("   Unable to open the network connection profile.  ( ERROR_CANNOT_OPEN_PROFILE        1205L "));
		; break;;case  ERROR_BAD_PROFILE :  _sprintf(*buf,_T("   The network connection profile is corrupted.  ( ERROR_BAD_PROFILE                1206L "));
		; break;;case  ERROR_NOT_CONTAINER :  _sprintf(*buf,_T("   Cannot enumerate a noncontainer.  ( ERROR_NOT_CONTAINER              1207L "));
		; break;;case  ERROR_EXTENDED_ERROR :  _sprintf(*buf,_T("   An extended error has occurred.  ( ERROR_EXTENDED_ERROR             1208L "));
		; break;;case  ERROR_INVALID_GROUPNAME :  _sprintf(*buf,_T("   The format of the specified group name is invalid.  ( ERROR_INVALID_GROUPNAME          1209L "));
		; break;;case  ERROR_INVALID_COMPUTERNAME :  _sprintf(*buf,_T("   The format of the specified computer name is invalid.  ( ERROR_INVALID_COMPUTERNAME       1210L "));
		; break;;case  ERROR_INVALID_EVENTNAME :  _sprintf(*buf,_T("   The format of the specified event name is invalid.  ( ERROR_INVALID_EVENTNAME          1211L "));
		; break;;case  ERROR_INVALID_DOMAINNAME :  _sprintf(*buf,_T("   The format of the specified domain name is invalid.  ( ERROR_INVALID_DOMAINNAME         1212L "));
		; break;;case  ERROR_INVALID_SERVICENAME :  _sprintf(*buf,_T("   The format of the specified service name is invalid.  ( ERROR_INVALID_SERVICENAME        1213L "));
		; break;;case  ERROR_INVALID_NETNAME :  _sprintf(*buf,_T("   The format of the specified network name is invalid.  ( ERROR_INVALID_NETNAME            1214L "));
		; break;;case  ERROR_INVALID_SHARENAME :  _sprintf(*buf,_T("   The format of the specified share name is invalid.  ( ERROR_INVALID_SHARENAME          1215L "));
		; break;;case  ERROR_INVALID_PASSWORDNAME :  _sprintf(*buf,_T("   The format of the specified password is invalid.  ( ERROR_INVALID_PASSWORDNAME       1216L "));
		; break;;case  ERROR_INVALID_MESSAGENAME :  _sprintf(*buf,_T("   The format of the specified message name is invalid.  ( ERROR_INVALID_MESSAGENAME        1217L "));
		; break;;case  ERROR_INVALID_MESSAGEDEST :  _sprintf(*buf,_T("   The format of the specified message destination is invalid.  ( ERROR_INVALID_MESSAGEDEST        1218L "));
		; break;;case  ERROR_SESSION_CREDENTIAL_CONFLICT :  _sprintf(*buf,_T("   The credentials supplied conflict with an existing set of credentials.  ( ERROR_SESSION_CREDENTIAL_CONFLICT 1219L "));
		; break;;case  ERROR_REMOTE_SESSION_LIMIT_EXCEEDED :  _sprintf(*buf,_T("   An attempt was made to establish a session to a network server, but there  are already too many sessions established to that server.  ( ERROR_REMOTE_SESSION_LIMIT_EXCEEDED 1220L "));
		; break;;case  ERROR_DUP_DOMAINNAME :  _sprintf(*buf,_T("   The workgroup or domain name is already in use by another computer on the  network.  ( ERROR_DUP_DOMAINNAME             1221L "));
		; break;;case  ERROR_NO_NETWORK :  _sprintf(*buf,_T("   The network is not present or not started.  ( ERROR_NO_NETWORK                 1222L "));
		; break;;case  ERROR_CANCELLED :  _sprintf(*buf,_T("   The operation was canceled by the user.  ( ERROR_CANCELLED                  1223L "));
		; break;;case  ERROR_USER_MAPPED_FILE :  _sprintf(*buf,_T("   The requested operation cannot be performed on a file with a user-mapped section open.  ( ERROR_USER_MAPPED_FILE           1224L "));
		; break;;case  ERROR_CONNECTION_REFUSED :  _sprintf(*buf,_T("   The remote system refused the network connection.  ( ERROR_CONNECTION_REFUSED         1225L "));
		; break;;case  ERROR_GRACEFUL_DISCONNECT :  _sprintf(*buf,_T("   The network connection was gracefully closed.  ( ERROR_GRACEFUL_DISCONNECT        1226L "));
		; break;;case  ERROR_ADDRESS_ALREADY_ASSOCIATED :  _sprintf(*buf,_T("   The network transport endpoint already has an address associated with it.  ( ERROR_ADDRESS_ALREADY_ASSOCIATED 1227L "));
		; break;;case  ERROR_ADDRESS_NOT_ASSOCIATED :  _sprintf(*buf,_T("   An address has not yet been associated with the network endpoint.  ( ERROR_ADDRESS_NOT_ASSOCIATED     1228L "));
		; break;;case  ERROR_CONNECTION_INVALID :  _sprintf(*buf,_T("   An operation was attempted on a nonexistent network connection.  ( ERROR_CONNECTION_INVALID         1229L "));
		; break;;case  ERROR_CONNECTION_ACTIVE :  _sprintf(*buf,_T("   An invalid operation was attempted on an active network connection.  ( ERROR_CONNECTION_ACTIVE          1230L "));
		; break;;case  ERROR_NETWORK_UNREACHABLE :  _sprintf(*buf,_T("   The remote network is not reachable by the transport.  ( ERROR_NETWORK_UNREACHABLE        1231L "));
		; break;;case  ERROR_HOST_UNREACHABLE :  _sprintf(*buf,_T("   The remote system is not reachable by the transport.  ( ERROR_HOST_UNREACHABLE           1232L "));
		; break;;case  ERROR_PROTOCOL_UNREACHABLE :  _sprintf(*buf,_T("   The remote system does not support the transport protocol.  ( ERROR_PROTOCOL_UNREACHABLE       1233L "));
		; break;;case  ERROR_PORT_UNREACHABLE :  _sprintf(*buf,_T("   No service is operating at the destination network endpoint  on the remote system.  ( ERROR_PORT_UNREACHABLE           1234L "));
		; break;;case  ERROR_REQUEST_ABORTED :  _sprintf(*buf,_T("   The request was aborted.  ( ERROR_REQUEST_ABORTED            1235L "));
		; break;;case  ERROR_CONNECTION_ABORTED :  _sprintf(*buf,_T("   The network connection was aborted by the local system.  ( ERROR_CONNECTION_ABORTED         1236L "));
		; break;;case  ERROR_RETRY :  _sprintf(*buf,_T("   The operation could not be completed.  A retry should be performed.  ( ERROR_RETRY                      1237L "));
		; break;;case  ERROR_CONNECTION_COUNT_LIMIT :  _sprintf(*buf,_T("   A connection to the server could not be made because the limit on the number of  concurrent connections for this account has been reached.  ( ERROR_CONNECTION_COUNT_LIMIT     1238L "));
		; break;;case  ERROR_LOGIN_TIME_RESTRICTION :  _sprintf(*buf,_T("   Attempting to log in during an unauthorized time of day for this account.  ( ERROR_LOGIN_TIME_RESTRICTION     1239L "));
		; break;;case  ERROR_LOGIN_WKSTA_RESTRICTION :  _sprintf(*buf,_T("   The account is not authorized to log in from this station.  ( ERROR_LOGIN_WKSTA_RESTRICTION    1240L "));
		; break;;case  ERROR_INCORRECT_ADDRESS :  _sprintf(*buf,_T("   The network address could not be used for the operation requested.  ( ERROR_INCORRECT_ADDRESS          1241L "));
		; break;;case  ERROR_ALREADY_REGISTERED :  _sprintf(*buf,_T("   The service is already registered.  ( ERROR_ALREADY_REGISTERED         1242L "));
		; break;;case  ERROR_SERVICE_NOT_FOUND :  _sprintf(*buf,_T("   The specified service does not exist.  ( ERROR_SERVICE_NOT_FOUND          1243L "));
		; break;;case  ERROR_NOT_AUTHENTICATED :  _sprintf(*buf,_T("   The operation being requested was not performed because the user  has not been authenticated.  ( ERROR_NOT_AUTHENTICATED          1244L "));
		; break;;case  ERROR_NOT_LOGGED_ON :  _sprintf(*buf,_T("   The operation being requested was not performed because the user  has not logged on to the network.  The specified service does not exist.  ( ERROR_NOT_LOGGED_ON              1245L "));
		; break;;case  ERROR_CONTINUE :  _sprintf(*buf,_T("   Continue with work in progress.  ( ERROR_CONTINUE                   1246L "));
		; break;;case  ERROR_ALREADY_INITIALIZED :  _sprintf(*buf,_T("   An attempt was made to perform an initialization operation when  initialization has already been completed.  ( ERROR_ALREADY_INITIALIZED        1247L "));
		; break;;case  ERROR_NO_MORE_DEVICES :  _sprintf(*buf,_T("   No more local devices.  ( ERROR_NO_MORE_DEVICES            1248L "));
#ifndef VCPP50
		; break;;case  ERROR_NO_SUCH_SITE :  _sprintf(*buf,_T("   The specified site does not exist.  ( ERROR_NO_SUCH_SITE               1249L "));
		; break;;case  ERROR_DOMAIN_CONTROLLER_EXISTS :  _sprintf(*buf,_T("   A domain controller with the specified name already exists.  ( ERROR_DOMAIN_CONTROLLER_EXISTS   1250L "));
		; break;;case  ERROR_DS_NOT_INSTALLED :  _sprintf(*buf,_T("   An error occurred while installing the Windows NT directory service. Please view the event log for more information.  ( ERROR_DS_NOT_INSTALLED           1251L "));
#endif
		; break;;case  ERROR_NOT_ALL_ASSIGNED :  _sprintf(*buf,_T("   Not all privileges referenced are assigned to the caller.  ( ERROR_NOT_ALL_ASSIGNED           1300L "));
		; break;;case  ERROR_SOME_NOT_MAPPED :  _sprintf(*buf,_T("   Some mapping between account names and security IDs was not done.  ( ERROR_SOME_NOT_MAPPED            1301L "));
		; break;;case  ERROR_NO_QUOTAS_FOR_ACCOUNT :  _sprintf(*buf,_T("   No system quota limits are specifically set for this account.  ( ERROR_NO_QUOTAS_FOR_ACCOUNT      1302L "));
		; break;;case  ERROR_LOCAL_USER_SESSION_KEY :  _sprintf(*buf,_T("   No encryption key is available.  A well-known encryption key was returned.  ( ERROR_LOCAL_USER_SESSION_KEY     1303L "));
		; break;;case  ERROR_NULL_LM_PASSWORD :  _sprintf(*buf,_T("   The Windows NT password is too complex to be converted to a LAN Manager  password.  The LAN Manager password returned is a NULL string.  ( ERROR_NULL_LM_PASSWORD           1304L "));
		; break;;case  ERROR_UNKNOWN_REVISION :  _sprintf(*buf,_T("   The revision level is unknown.  ( ERROR_UNKNOWN_REVISION           1305L "));
		; break;;case  ERROR_REVISION_MISMATCH :  _sprintf(*buf,_T("   Indicates two revision levels are incompatible.  ( ERROR_REVISION_MISMATCH          1306L "));
		; break;;case  ERROR_INVALID_OWNER :  _sprintf(*buf,_T("   This security ID may not be assigned as the owner of this object.  ( ERROR_INVALID_OWNER              1307L "));
		; break;;case  ERROR_INVALID_PRIMARY_GROUP :  _sprintf(*buf,_T("   This security ID may not be assigned as the primary group of an object.  ( ERROR_INVALID_PRIMARY_GROUP      1308L "));
		; break;;case  ERROR_NO_IMPERSONATION_TOKEN :  _sprintf(*buf,_T("   An attempt has been made to operate on an impersonation token  by a thread that is not currently impersonating a client.  ( ERROR_NO_IMPERSONATION_TOKEN     1309L "));
		; break;;case  ERROR_CANT_DISABLE_MANDATORY :  _sprintf(*buf,_T("   The group may not be disabled.  ( ERROR_CANT_DISABLE_MANDATORY     1310L "));
		; break;;case  ERROR_NO_LOGON_SERVERS :  _sprintf(*buf,_T("   There are currently no logon servers available to service the logon  request.  ( ERROR_NO_LOGON_SERVERS           1311L "));
		; break;;case  ERROR_NO_SUCH_LOGON_SESSION :  _sprintf(*buf,_T("    A specified logon session does not exist.  It may already have   been terminated.  ( ERROR_NO_SUCH_LOGON_SESSION      1312L "));
		; break;;case  ERROR_NO_SUCH_PRIVILEGE :  _sprintf(*buf,_T("    A specified privilege does not exist.  ( ERROR_NO_SUCH_PRIVILEGE          1313L "));
		; break;;case  ERROR_PRIVILEGE_NOT_HELD :  _sprintf(*buf,_T("    A required privilege is not held by the client.  ( ERROR_PRIVILEGE_NOT_HELD         1314L "));
		; break;;case  ERROR_INVALID_ACCOUNT_NAME :  _sprintf(*buf,_T("   The name provided is not a properly formed account name.  ( ERROR_INVALID_ACCOUNT_NAME       1315L "));
		; break;;case  ERROR_USER_EXISTS :  _sprintf(*buf,_T("   The specified user already exists.  ( ERROR_USER_EXISTS                1316L "));
		; break;;case  ERROR_NO_SUCH_USER :  _sprintf(*buf,_T("   The specified user does not exist.  ( ERROR_NO_SUCH_USER               1317L "));
		; break;;case  ERROR_GROUP_EXISTS :  _sprintf(*buf,_T("   The specified group already exists.  ( ERROR_GROUP_EXISTS               1318L "));
		; break;;case  ERROR_NO_SUCH_GROUP :  _sprintf(*buf,_T("   The specified group does not exist.  ( ERROR_NO_SUCH_GROUP              1319L "));
		; break;;case  ERROR_MEMBER_IN_GROUP :  _sprintf(*buf,_T("   Either the specified user account is already a member of the specified  group, or the specified group cannot be deleted because it contains a member.  ( ERROR_MEMBER_IN_GROUP            1320L "));
		; break;;case  ERROR_MEMBER_NOT_IN_GROUP :  _sprintf(*buf,_T("   The specified user account is not a member of the specified group account.  ( ERROR_MEMBER_NOT_IN_GROUP        1321L "));
		; break;;case  ERROR_LAST_ADMIN :  _sprintf(*buf,_T("   The last remaining administration account cannot be disabled  or deleted.  ( ERROR_LAST_ADMIN                 1322L "));
		; break;;case  ERROR_WRONG_PASSWORD :  _sprintf(*buf,_T("   Unable to update the password.  The value provided as the current  password is incorrect.  ( ERROR_WRONG_PASSWORD             1323L "));
		; break;;case  ERROR_ILL_FORMED_PASSWORD :  _sprintf(*buf,_T("   Unable to update the password.  The value provided for the new password  contains values that are not allowed in passwords.  ( ERROR_ILL_FORMED_PASSWORD        1324L "));
		; break;;case  ERROR_PASSWORD_RESTRICTION :  _sprintf(*buf,_T("   Unable to update the password because a password update rule has been  violated.  ( ERROR_PASSWORD_RESTRICTION       1325L "));
		; break;;case  ERROR_LOGON_FAILURE :  _sprintf(*buf,_T("   Logon failure: unknown user name or bad password.  ( ERROR_LOGON_FAILURE              1326L "));
		; break;;case  ERROR_ACCOUNT_RESTRICTION :  _sprintf(*buf,_T("   Logon failure: user account restriction.  ( ERROR_ACCOUNT_RESTRICTION        1327L "));
		; break;;case  ERROR_INVALID_LOGON_HOURS :  _sprintf(*buf,_T("   Logon failure: account logon time restriction violation.  ( ERROR_INVALID_LOGON_HOURS        1328L "));
		; break;;case  ERROR_INVALID_WORKSTATION :  _sprintf(*buf,_T("   Logon failure: user not allowed to log on to this computer.  ( ERROR_INVALID_WORKSTATION        1329L "));
		; break;;case  ERROR_PASSWORD_EXPIRED :  _sprintf(*buf,_T("   Logon failure: the specified account password has expired.  ( ERROR_PASSWORD_EXPIRED           1330L "));
		; break;;case  ERROR_ACCOUNT_DISABLED :  _sprintf(*buf,_T("   Logon failure: account currently disabled.  ( ERROR_ACCOUNT_DISABLED           1331L "));
		; break;;case  ERROR_NONE_MAPPED :  _sprintf(*buf,_T("   No mapping between account names and security IDs was done.  ( ERROR_NONE_MAPPED                1332L "));
		; break;;case  ERROR_TOO_MANY_LUIDS_REQUESTED :  _sprintf(*buf,_T("   Too many local user identifiers (LUIDs) were requested at one time.  ( ERROR_TOO_MANY_LUIDS_REQUESTED   1333L "));
		; break;;case  ERROR_LUIDS_EXHAUSTED :  _sprintf(*buf,_T("   No more local user identifiers (LUIDs) are available.  ( ERROR_LUIDS_EXHAUSTED            1334L "));
		; break;;case  ERROR_INVALID_SUB_AUTHORITY :  _sprintf(*buf,_T("   The subauthority part of a security ID is invalid for this particular use.  ( ERROR_INVALID_SUB_AUTHORITY      1335L "));
		; break;;case  ERROR_INVALID_ACL :  _sprintf(*buf,_T("   The access control list (ACL) structure is invalid.  ( ERROR_INVALID_ACL                1336L "));
		; break;;case  ERROR_INVALID_SID :  _sprintf(*buf,_T("   The security ID structure is invalid.  ( ERROR_INVALID_SID                1337L "));
		; break;;case  ERROR_INVALID_SECURITY_DESCR :  _sprintf(*buf,_T("   The security descriptor structure is invalid.  ( ERROR_INVALID_SECURITY_DESCR     1338L "));
		; break;;case  ERROR_BAD_INHERITANCE_ACL :  _sprintf(*buf,_T("   The inherited access control list (ACL) or access control entry (ACE)  could not be built.  ( ERROR_BAD_INHERITANCE_ACL        1340L "));
		; break;;case  ERROR_SERVER_DISABLED :  _sprintf(*buf,_T("   The server is currently disabled.  ( ERROR_SERVER_DISABLED            1341L "));
		; break;;case  ERROR_SERVER_NOT_DISABLED :  _sprintf(*buf,_T("   The server is currently enabled.  ( ERROR_SERVER_NOT_DISABLED        1342L "));
		; break;;case  ERROR_INVALID_ID_AUTHORITY :  _sprintf(*buf,_T("   The value provided was an invalid value for an identifier authority.  ( ERROR_INVALID_ID_AUTHORITY       1343L "));
		; break;;case  ERROR_ALLOTTED_SPACE_EXCEEDED :  _sprintf(*buf,_T("   No more memory is available for security information updates.  ( ERROR_ALLOTTED_SPACE_EXCEEDED    1344L "));
		; break;;case  ERROR_INVALID_GROUP_ATTRIBUTES :  _sprintf(*buf,_T("   The specified attributes are invalid, or incompatible with the  attributes for the group as a whole.  ( ERROR_INVALID_GROUP_ATTRIBUTES   1345L "));
		; break;;case  ERROR_BAD_IMPERSONATION_LEVEL :  _sprintf(*buf,_T("   Either a required impersonation level was not provided, or the  provided impersonation level is invalid.  ( ERROR_BAD_IMPERSONATION_LEVEL    1346L "));
		; break;;case  ERROR_CANT_OPEN_ANONYMOUS :  _sprintf(*buf,_T("   Cannot open an anonymous level security token.  ( ERROR_CANT_OPEN_ANONYMOUS        1347L "));
		; break;;case  ERROR_BAD_VALIDATION_CLASS :  _sprintf(*buf,_T("   The validation information class requested was invalid.  ( ERROR_BAD_VALIDATION_CLASS       1348L "));
		; break;;case  ERROR_BAD_TOKEN_TYPE :  _sprintf(*buf,_T("   The type of the token is inappropriate for its attempted use.  ( ERROR_BAD_TOKEN_TYPE             1349L "));
		; break;;case  ERROR_NO_SECURITY_ON_OBJECT :  _sprintf(*buf,_T("   Unable to perform a security operation on an object  that has no associated security.  ( ERROR_NO_SECURITY_ON_OBJECT      1350L "));
		; break;;case  ERROR_CANT_ACCESS_DOMAIN_INFO :  _sprintf(*buf,_T("   Indicates a Windows NT Server could not be contacted or that  objects within the domain are protected such that necessary  information could not be retrieved.  ( ERROR_CANT_ACCESS_DOMAIN_INFO    1351L "));
		; break;;case  ERROR_INVALID_SERVER_STATE :  _sprintf(*buf,_T("   The security account manager (SAM) or local security  authority (LSA) server was in the wrong state to perform  the security operation.  ( ERROR_INVALID_SERVER_STATE       1352L "));
		; break;;case  ERROR_INVALID_DOMAIN_STATE :  _sprintf(*buf,_T("   The domain was in the wrong state to perform the security operation.  ( ERROR_INVALID_DOMAIN_STATE       1353L "));
		; break;;case  ERROR_INVALID_DOMAIN_ROLE :  _sprintf(*buf,_T("   This operation is only allowed for the Primary Domain Controller of the domain.  ( ERROR_INVALID_DOMAIN_ROLE        1354L "));
		; break;;case  ERROR_NO_SUCH_DOMAIN :  _sprintf(*buf,_T("   The specified domain did not exist.  ( ERROR_NO_SUCH_DOMAIN             1355L "));
		; break;;case  ERROR_DOMAIN_EXISTS :  _sprintf(*buf,_T("   The specified domain already exists.  ( ERROR_DOMAIN_EXISTS              1356L "));
		; break;;case  ERROR_DOMAIN_LIMIT_EXCEEDED :  _sprintf(*buf,_T("   An attempt was made to exceed the limit on the number of domains per server.  ( ERROR_DOMAIN_LIMIT_EXCEEDED      1357L "));
		; break;;case  ERROR_INTERNAL_DB_CORRUPTION :  _sprintf(*buf,_T("   Unable to complete the requested operation because of either a  catastrophic media failure or a data structure corruption on the disk.  ( ERROR_INTERNAL_DB_CORRUPTION     1358L "));
		; break;;case  ERROR_INTERNAL_ERROR :  _sprintf(*buf,_T("   The security account database contains an internal inconsistency.  ( ERROR_INTERNAL_ERROR             1359L "));
		; break;;case  ERROR_GENERIC_NOT_MAPPED :  _sprintf(*buf,_T("   Generic access types were contained in an access mask which should already be mapped to nongeneric types.  ( ERROR_GENERIC_NOT_MAPPED         1360L "));
		; break;;case  ERROR_BAD_DESCRIPTOR_FORMAT :  _sprintf(*buf,_T("   A security descriptor is not in the right format (absolute or self-relative).  ( ERROR_BAD_DESCRIPTOR_FORMAT      1361L "));
		; break;;case  ERROR_NOT_LOGON_PROCESS :  _sprintf(*buf,_T("   The requested action is restricted for use by logon processes  only.  The calling process has not registered as a logon process.  ( ERROR_NOT_LOGON_PROCESS          1362L "));
		; break;;case  ERROR_LOGON_SESSION_EXISTS :  _sprintf(*buf,_T("   Cannot start a new logon session with an ID that is already in use.  ( ERROR_LOGON_SESSION_EXISTS       1363L "));
		; break;;case  ERROR_NO_SUCH_PACKAGE :  _sprintf(*buf,_T("   A specified authentication package is unknown.  ( ERROR_NO_SUCH_PACKAGE            1364L "));
		; break;;case  ERROR_BAD_LOGON_SESSION_STATE :  _sprintf(*buf,_T("   The logon session is not in a state that is consistent with the  requested operation.  ( ERROR_BAD_LOGON_SESSION_STATE    1365L "));
		; break;;case  ERROR_LOGON_SESSION_COLLISION :  _sprintf(*buf,_T("   The logon session ID is already in use.  ( ERROR_LOGON_SESSION_COLLISION    1366L "));
		; break;;case  ERROR_INVALID_LOGON_TYPE :  _sprintf(*buf,_T("   A logon request contained an invalid logon type value.  ( ERROR_INVALID_LOGON_TYPE         1367L "));
		; break;;case  ERROR_CANNOT_IMPERSONATE :  _sprintf(*buf,_T("   Unable to impersonate using a named pipe until data has been read  from that pipe.  ( ERROR_CANNOT_IMPERSONATE         1368L "));
		; break;;case  ERROR_RXACT_INVALID_STATE :  _sprintf(*buf,_T("   The transaction state of a registry subtree is incompatible with the  requested operation.  ( ERROR_RXACT_INVALID_STATE        1369L "));
		; break;;case  ERROR_RXACT_COMMIT_FAILURE :  _sprintf(*buf,_T("   An internal security database corruption has been encountered.  ( ERROR_RXACT_COMMIT_FAILURE       1370L "));
		; break;;case  ERROR_SPECIAL_ACCOUNT :  _sprintf(*buf,_T("   Cannot perform this operation on built-in accounts.  ( ERROR_SPECIAL_ACCOUNT            1371L "));
		; break;;case  ERROR_SPECIAL_GROUP :  _sprintf(*buf,_T("   Cannot perform this operation on this built-in special group.  ( ERROR_SPECIAL_GROUP              1372L "));
		; break;;case  ERROR_SPECIAL_USER :  _sprintf(*buf,_T("   Cannot perform this operation on this built-in special user.  ( ERROR_SPECIAL_USER               1373L "));
		; break;;case  ERROR_MEMBERS_PRIMARY_GROUP :  _sprintf(*buf,_T("   The user cannot be removed from a group because the group  is currently the user's primary group.  ( ERROR_MEMBERS_PRIMARY_GROUP      1374L "));
		; break;;case  ERROR_TOKEN_ALREADY_IN_USE :  _sprintf(*buf,_T("   The token is already in use as a primary token.  ( ERROR_TOKEN_ALREADY_IN_USE       1375L "));
		; break;;case  ERROR_NO_SUCH_ALIAS :  _sprintf(*buf,_T("   The specified local group does not exist.  ( ERROR_NO_SUCH_ALIAS              1376L "));
		; break;;case  ERROR_MEMBER_NOT_IN_ALIAS :  _sprintf(*buf,_T("   The specified account name is not a member of the local group.  ( ERROR_MEMBER_NOT_IN_ALIAS        1377L "));
		; break;;case  ERROR_MEMBER_IN_ALIAS :  _sprintf(*buf,_T("   The specified account name is already a member of the local group.  ( ERROR_MEMBER_IN_ALIAS            1378L "));
		; break;;case  ERROR_ALIAS_EXISTS :  _sprintf(*buf,_T("   The specified local group already exists.  ( ERROR_ALIAS_EXISTS               1379L "));
		; break;;case  ERROR_LOGON_NOT_GRANTED :  _sprintf(*buf,_T("   Logon failure: the user has not been granted the requested  logon type at this computer.  ( ERROR_LOGON_NOT_GRANTED          1380L "));
		; break;;case  ERROR_TOO_MANY_SECRETS :  _sprintf(*buf,_T("   The maximum number of secrets that may be stored in a single system has been  exceeded.  ( ERROR_TOO_MANY_SECRETS           1381L "));
		; break;;case  ERROR_SECRET_TOO_LONG :  _sprintf(*buf,_T("   The length of a secret exceeds the maximum length allowed.  ( ERROR_SECRET_TOO_LONG            1382L "));
		; break;;case  ERROR_INTERNAL_DB_ERROR :  _sprintf(*buf,_T("   The local security authority database contains an internal inconsistency.  ( ERROR_INTERNAL_DB_ERROR          1383L "));
		; break;;case  ERROR_TOO_MANY_CONTEXT_IDS :  _sprintf(*buf,_T("   During a logon attempt, the user's security context accumulated too many security IDs.  ( ERROR_TOO_MANY_CONTEXT_IDS       1384L "));
		; break;;case  ERROR_LOGON_TYPE_NOT_GRANTED :  _sprintf(*buf,_T("   Logon failure: the user has not been granted the requested logon type  at this computer.  ( ERROR_LOGON_TYPE_NOT_GRANTED     1385L "));
		; break;;case  ERROR_NT_CROSS_ENCRYPTION_REQUIRED :  _sprintf(*buf,_T("   A cross-encrypted password is necessary to change a user password.  ( ERROR_NT_CROSS_ENCRYPTION_REQUIRED 1386L "));
		; break;;case  ERROR_NO_SUCH_MEMBER :  _sprintf(*buf,_T("   A new member could not be added to a local group because the member does  not exist.  ( ERROR_NO_SUCH_MEMBER             1387L "));
		; break;;case  ERROR_INVALID_MEMBER :  _sprintf(*buf,_T("   A new member could not be added to a local group because the member has the  wrong account type.  ( ERROR_INVALID_MEMBER             1388L "));
		; break;;case  ERROR_TOO_MANY_SIDS :  _sprintf(*buf,_T("   Too many security IDs have been specified.  ( ERROR_TOO_MANY_SIDS              1389L "));
		; break;;case  ERROR_LM_CROSS_ENCRYPTION_REQUIRED :  _sprintf(*buf,_T("   A cross-encrypted password is necessary to change this user password.  ( ERROR_LM_CROSS_ENCRYPTION_REQUIRED 1390L "));
		; break;;case  ERROR_NO_INHERITANCE :  _sprintf(*buf,_T("   Indicates an ACL contains no inheritable components.  ( ERROR_NO_INHERITANCE             1391L "));
		; break;;case  ERROR_FILE_CORRUPT :  _sprintf(*buf,_T("   The file or directory is corrupted and unreadable.  ( ERROR_FILE_CORRUPT               1392L "));
		; break;;case  ERROR_DISK_CORRUPT :  _sprintf(*buf,_T("   The disk structure is corrupted and unreadable.  ( ERROR_DISK_CORRUPT               1393L "));
		; break;;case  ERROR_NO_USER_SESSION_KEY :  _sprintf(*buf,_T("   There is no user session key for the specified logon session.  ( ERROR_NO_USER_SESSION_KEY        1394L "));
		; break;;case  ERROR_LICENSE_QUOTA_EXCEEDED :  _sprintf(*buf,_T("   The service being accessed is licensed for a particular number of connections.  No more connections can be made to the service at this time  because there are already as many connections as the service can accept.  ( ERROR_LICENSE_QUOTA_EXCEEDED     1395L  End of security error codes "));
		; break;;case  ERROR_INVALID_WINDOW_HANDLE :  _sprintf(*buf,_T("   Invalid window handle.  ( ERROR_INVALID_WINDOW_HANDLE      1400L "));
		; break;;case  ERROR_INVALID_MENU_HANDLE :  _sprintf(*buf,_T("   Invalid menu handle.  ( ERROR_INVALID_MENU_HANDLE        1401L "));
		; break;;case  ERROR_INVALID_CURSOR_HANDLE :  _sprintf(*buf,_T("   Invalid cursor handle.  ( ERROR_INVALID_CURSOR_HANDLE      1402L "));
		; break;;case  ERROR_INVALID_ACCEL_HANDLE :  _sprintf(*buf,_T("   Invalid accelerator table handle.  ( ERROR_INVALID_ACCEL_HANDLE       1403L "));
		; break;;case  ERROR_INVALID_HOOK_HANDLE :  _sprintf(*buf,_T("   Invalid hook handle.  ( ERROR_INVALID_HOOK_HANDLE        1404L "));
		; break;;case  ERROR_INVALID_DWP_HANDLE :  _sprintf(*buf,_T("   Invalid handle to a multiple-window position structure.  ( ERROR_INVALID_DWP_HANDLE         1405L "));
		; break;;case  ERROR_TLW_WITH_WSCHILD :  _sprintf(*buf,_T("   Cannot create a top-level child window.  ( ERROR_TLW_WITH_WSCHILD           1406L "));
		; break;;case  ERROR_CANNOT_FIND_WND_CLASS :  _sprintf(*buf,_T("   Cannot find window class.  ( ERROR_CANNOT_FIND_WND_CLASS      1407L "));
		; break;;case  ERROR_WINDOW_OF_OTHER_THREAD :  _sprintf(*buf,_T("   Invalid window; it belongs to other thread.  ( ERROR_WINDOW_OF_OTHER_THREAD     1408L "));
		; break;;case  ERROR_HOTKEY_ALREADY_REGISTERED :  _sprintf(*buf,_T("   Hot key is already registered.  ( ERROR_HOTKEY_ALREADY_REGISTERED  1409L "));
		; break;;case  ERROR_CLASS_ALREADY_EXISTS :  _sprintf(*buf,_T("   Class already exists.  ( ERROR_CLASS_ALREADY_EXISTS       1410L "));
		; break;;case  ERROR_CLASS_DOES_NOT_EXIST :  _sprintf(*buf,_T("   Class does not exist.  ( ERROR_CLASS_DOES_NOT_EXIST       1411L "));
		; break;;case  ERROR_CLASS_HAS_WINDOWS :  _sprintf(*buf,_T("   Class still has open windows.  ( ERROR_CLASS_HAS_WINDOWS          1412L "));
		; break;;case  ERROR_INVALID_INDEX :  _sprintf(*buf,_T("   Invalid index.  ( ERROR_INVALID_INDEX              1413L "));
		; break;;case  ERROR_INVALID_ICON_HANDLE :  _sprintf(*buf,_T("   Invalid icon handle.  ( ERROR_INVALID_ICON_HANDLE        1414L "));
		; break;;case  ERROR_PRIVATE_DIALOG_INDEX :  _sprintf(*buf,_T("   Using private DIALOG window words.  ( ERROR_PRIVATE_DIALOG_INDEX       1415L "));
		; break;;case  ERROR_LISTBOX_ID_NOT_FOUND :  _sprintf(*buf,_T("   The list box identifier was not found.  ( ERROR_LISTBOX_ID_NOT_FOUND       1416L "));
		; break;;case  ERROR_NO_WILDCARD_CHARACTERS :  _sprintf(*buf,_T("   No wildcards were found.  ( ERROR_NO_WILDCARD_CHARACTERS     1417L "));
		; break;;case  ERROR_CLIPBOARD_NOT_OPEN :  _sprintf(*buf,_T("   Thread does not have a clipboard open.  ( ERROR_CLIPBOARD_NOT_OPEN         1418L "));
		; break;;case  ERROR_HOTKEY_NOT_REGISTERED :  _sprintf(*buf,_T("   Hot key is not registered.  ( ERROR_HOTKEY_NOT_REGISTERED      1419L "));
		; break;;case  ERROR_WINDOW_NOT_DIALOG :  _sprintf(*buf,_T("   The window is not a valid dialog window.  ( ERROR_WINDOW_NOT_DIALOG          1420L "));
		; break;;case  ERROR_CONTROL_ID_NOT_FOUND :  _sprintf(*buf,_T("   Control ID not found.  ( ERROR_CONTROL_ID_NOT_FOUND       1421L "));
		; break;;case  ERROR_INVALID_COMBOBOX_MESSAGE :  _sprintf(*buf,_T("   Invalid message for a combo box because it does not have an edit control.  ( ERROR_INVALID_COMBOBOX_MESSAGE   1422L "));
		; break;;case  ERROR_WINDOW_NOT_COMBOBOX :  _sprintf(*buf,_T("   The window is not a combo box.  ( ERROR_WINDOW_NOT_COMBOBOX        1423L "));
		; break;;case  ERROR_INVALID_EDIT_HEIGHT :  _sprintf(*buf,_T("   Height must be less than 256.  ( ERROR_INVALID_EDIT_HEIGHT        1424L "));
		; break;;case  ERROR_DC_NOT_FOUND :  _sprintf(*buf,_T("   Invalid device context (DC) handle.  ( ERROR_DC_NOT_FOUND               1425L "));
		; break;;case  ERROR_INVALID_HOOK_FILTER :  _sprintf(*buf,_T("   Invalid hook procedure type.  ( ERROR_INVALID_HOOK_FILTER        1426L "));
		; break;;case  ERROR_INVALID_FILTER_PROC :  _sprintf(*buf,_T("   Invalid hook procedure.  ( ERROR_INVALID_FILTER_PROC        1427L "));
		; break;;case  ERROR_HOOK_NEEDS_HMOD :  _sprintf(*buf,_T("   Cannot set nonlocal hook without a module handle.  ( ERROR_HOOK_NEEDS_HMOD            1428L "));
		; break;;case  ERROR_GLOBAL_ONLY_HOOK :  _sprintf(*buf,_T("   This hook procedure can only be set globally.  ( ERROR_GLOBAL_ONLY_HOOK           1429L "));
		; break;;case  ERROR_JOURNAL_HOOK_SET :  _sprintf(*buf,_T("   The journal hook procedure is already installed.  ( ERROR_JOURNAL_HOOK_SET           1430L "));
		; break;;case  ERROR_HOOK_NOT_INSTALLED :  _sprintf(*buf,_T("   The hook procedure is not installed.  ( ERROR_HOOK_NOT_INSTALLED         1431L "));
		; break;;case  ERROR_INVALID_LB_MESSAGE :  _sprintf(*buf,_T("   Invalid message for single-selection list box.  ( ERROR_INVALID_LB_MESSAGE         1432L "));
		; break;;case  ERROR_SETCOUNT_ON_BAD_LB :  _sprintf(*buf,_T("   LB_SETCOUNT sent to non-lazy list box.  ( ERROR_SETCOUNT_ON_BAD_LB         1433L "));
		; break;;case  ERROR_LB_WITHOUT_TABSTOPS :  _sprintf(*buf,_T("   This list box does not support tab stops.  ( ERROR_LB_WITHOUT_TABSTOPS        1434L "));
		; break;;case  ERROR_DESTROY_OBJECT_OF_OTHER_THREAD :  _sprintf(*buf,_T("   Cannot destroy object created by another thread.  ( ERROR_DESTROY_OBJECT_OF_OTHER_THREAD 1435L "));
		; break;;case  ERROR_CHILD_WINDOW_MENU :  _sprintf(*buf,_T("   Child windows cannot have menus.  ( ERROR_CHILD_WINDOW_MENU          1436L "));
		; break;;case  ERROR_NO_SYSTEM_MENU :  _sprintf(*buf,_T("   The window does not have a system menu.  ( ERROR_NO_SYSTEM_MENU             1437L "));
		; break;;case  ERROR_INVALID_MSGBOX_STYLE :  _sprintf(*buf,_T("   Invalid message box style.  ( ERROR_INVALID_MSGBOX_STYLE       1438L "));
		; break;;case  ERROR_INVALID_SPI_VALUE :  _sprintf(*buf,_T("   Invalid system-wide (SPI_*) parameter.  ( ERROR_INVALID_SPI_VALUE          1439L "));
		; break;;case  ERROR_SCREEN_ALREADY_LOCKED :  _sprintf(*buf,_T("   Screen already locked.  ( ERROR_SCREEN_ALREADY_LOCKED      1440L "));
		; break;;case  ERROR_HWNDS_HAVE_DIFF_PARENT :  _sprintf(*buf,_T("   All handles to windows in a multiple-window position structure must  have the same parent.  ( ERROR_HWNDS_HAVE_DIFF_PARENT     1441L "));
		; break;;case  ERROR_NOT_CHILD_WINDOW :  _sprintf(*buf,_T("   The window is not a child window.  ( ERROR_NOT_CHILD_WINDOW           1442L "));
		; break;;case  ERROR_INVALID_GW_COMMAND :  _sprintf(*buf,_T("   Invalid GW_* command.  ( ERROR_INVALID_GW_COMMAND         1443L "));
		; break;;case  ERROR_INVALID_THREAD_ID :  _sprintf(*buf,_T("   Invalid thread identifier.  ( ERROR_INVALID_THREAD_ID          1444L "));
		; break;;case  ERROR_NON_MDICHILD_WINDOW :  _sprintf(*buf,_T("   Cannot process a message from a window that is not a multiple document  interface (MDI) window.  ( ERROR_NON_MDICHILD_WINDOW        1445L "));
		; break;;case  ERROR_POPUP_ALREADY_ACTIVE :  _sprintf(*buf,_T("   Popup menu already active.  ( ERROR_POPUP_ALREADY_ACTIVE       1446L "));
		; break;;case  ERROR_NO_SCROLLBARS :  _sprintf(*buf,_T("   The window does not have scroll bars.  ( ERROR_NO_SCROLLBARS              1447L "));
		; break;;case  ERROR_INVALID_SCROLLBAR_RANGE :  _sprintf(*buf,_T("   Scroll bar range cannot be greater than 0x7FFF.  ( ERROR_INVALID_SCROLLBAR_RANGE    1448L "));
		; break;;case  ERROR_INVALID_SHOWWIN_COMMAND :  _sprintf(*buf,_T("   Cannot show or remove the window in the way specified.  ( ERROR_INVALID_SHOWWIN_COMMAND    1449L "));
		; break;;case  ERROR_NO_SYSTEM_RESOURCES :  _sprintf(*buf,_T("   Insufficient system resources exist to complete the requested service.  ( ERROR_NO_SYSTEM_RESOURCES        1450L "));
		; break;;case  ERROR_NONPAGED_SYSTEM_RESOURCES :  _sprintf(*buf,_T("   Insufficient system resources exist to complete the requested service.  ( ERROR_NONPAGED_SYSTEM_RESOURCES  1451L "));
		; break;;case  ERROR_PAGED_SYSTEM_RESOURCES :  _sprintf(*buf,_T("   Insufficient system resources exist to complete the requested service.  ( ERROR_PAGED_SYSTEM_RESOURCES     1452L "));
		; break;;case  ERROR_WORKING_SET_QUOTA :  _sprintf(*buf,_T("   Insufficient quota to complete the requested service.  ( ERROR_WORKING_SET_QUOTA          1453L "));
		; break;;case  ERROR_PAGEFILE_QUOTA :  _sprintf(*buf,_T("   Insufficient quota to complete the requested service.  ( ERROR_PAGEFILE_QUOTA             1454L "));
		; break;;case  ERROR_COMMITMENT_LIMIT :  _sprintf(*buf,_T("   The paging file is too small for this operation to complete.  ( ERROR_COMMITMENT_LIMIT           1455L "));
		; break;;case  ERROR_MENU_ITEM_NOT_FOUND :  _sprintf(*buf,_T("   A menu item was not found.  ( ERROR_MENU_ITEM_NOT_FOUND        1456L "));
		; break;;case  ERROR_INVALID_KEYBOARD_HANDLE :  _sprintf(*buf,_T("   Invalid keyboard layout handle.  ( ERROR_INVALID_KEYBOARD_HANDLE    1457L "));
		; break;;case  ERROR_HOOK_TYPE_NOT_ALLOWED :  _sprintf(*buf,_T("   Hook type not allowed.  ( ERROR_HOOK_TYPE_NOT_ALLOWED      1458L "));
		; break;;case  ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION :  _sprintf(*buf,_T("   This operation requires an interactive window station.  ( ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION 1459L "));
		; break;;case  ERROR_TIMEOUT :  _sprintf(*buf,_T("   This operation returned because the timeout period expired.  ( ERROR_TIMEOUT                    1460L "));
#ifndef VCPP50
		; break;;case  ERROR_INVALID_MONITOR_HANDLE :  _sprintf(*buf,_T("   Invalid monitor handle.  ( ERROR_INVALID_MONITOR_HANDLE     1461L  End of WinUser error codes "));
#endif
		; break;;case  ERROR_EVENTLOG_FILE_CORRUPT :  _sprintf(*buf,_T("   The event log file is corrupted.  ( ERROR_EVENTLOG_FILE_CORRUPT      1500L "));
		; break;;case  ERROR_EVENTLOG_CANT_START :  _sprintf(*buf,_T("   No event log file could be opened, so the event logging service did not start.  ( ERROR_EVENTLOG_CANT_START        1501L "));
		; break;;case  ERROR_LOG_FILE_FULL :  _sprintf(*buf,_T("   The event log file is full.  ( ERROR_LOG_FILE_FULL              1502L "));
		; break;;case  ERROR_EVENTLOG_FILE_CHANGED :  _sprintf(*buf,_T("   The event log file has changed between read operations.  ( ERROR_EVENTLOG_FILE_CHANGED      1503L  End of eventlog error codes "));
#ifndef VCPP50
		; break;;case  ERROR_INSTALL_SERVICE :  _sprintf(*buf,_T("   Failure accessing install service.  ( ERROR_INSTALL_SERVICE            1601L "));
		; break;;case  ERROR_INSTALL_USEREXIT :  _sprintf(*buf,_T("   The user canceled the installation.  ( ERROR_INSTALL_USEREXIT           1602L "));
		; break;;case  ERROR_INSTALL_FAILURE :  _sprintf(*buf,_T("   Fatal error during installation.  ( ERROR_INSTALL_FAILURE            1603L "));
		; break;;case  ERROR_INSTALL_SUSPEND :  _sprintf(*buf,_T("   Installation suspended, incomplete.  ( ERROR_INSTALL_SUSPEND            1604L "));
		; break;;case  ERROR_UNKNOWN_PRODUCT :  _sprintf(*buf,_T("   Product code not registered.  ( ERROR_UNKNOWN_PRODUCT            1605L "));
		; break;;case  ERROR_UNKNOWN_FEATURE :  _sprintf(*buf,_T("   Feature ID not registered.  ( ERROR_UNKNOWN_FEATURE            1606L "));
		; break;;case  ERROR_UNKNOWN_COMPONENT :  _sprintf(*buf,_T("   Component ID not registered.  ( ERROR_UNKNOWN_COMPONENT          1607L "));
		; break;;case  ERROR_UNKNOWN_PROPERTY :  _sprintf(*buf,_T("   Unknown property.  ( ERROR_UNKNOWN_PROPERTY           1608L "));
		; break;;case  ERROR_INVALID_HANDLE_STATE :  _sprintf(*buf,_T("   Handle is in an invalid state.  ( ERROR_INVALID_HANDLE_STATE       1609L "));
		; break;;case  ERROR_BAD_CONFIGURATION :  _sprintf(*buf,_T("   Configuration data corrupt.  ( ERROR_BAD_CONFIGURATION          1610L "));
		; break;;case  ERROR_INDEX_ABSENT :  _sprintf(*buf,_T("   Language not available.  ( ERROR_INDEX_ABSENT               1611L "));
		; break;;case  ERROR_INSTALL_SOURCE_ABSENT :  _sprintf(*buf,_T("   Install source unavailable.  ( ERROR_INSTALL_SOURCE_ABSENT      1612L "));
		; break;;case  ERROR_BAD_DATABASE_VERSION :  _sprintf(*buf,_T("   Database version unsupported.  ( ERROR_BAD_DATABASE_VERSION       1613L "));
		; break;;case  ERROR_PRODUCT_UNINSTALLED :  _sprintf(*buf,_T("   Product is uninstalled.  ( ERROR_PRODUCT_UNINSTALLED        1614L "));
		; break;;case  ERROR_BAD_QUERY_SYNTAX :  _sprintf(*buf,_T("   SQL query syntax invalid or unsupported.  ( ERROR_BAD_QUERY_SYNTAX           1615L "));
		; break;;case  ERROR_INVALID_FIELD :  _sprintf(*buf,_T("   Record field does not exist.  ( ERROR_INVALID_FIELD              1616L  End of MSI error codes "));
#endif
		; break;;case  RPC_S_INVALID_STRING_BINDING :  _sprintf(*buf,_T("   The string binding is invalid.  ( RPC_S_INVALID_STRING_BINDING     1700L "));
		; break;;case  RPC_S_WRONG_KIND_OF_BINDING :  _sprintf(*buf,_T("   The binding handle is not the correct type.  ( RPC_S_WRONG_KIND_OF_BINDING      1701L "));
		; break;;case  RPC_S_INVALID_BINDING :  _sprintf(*buf,_T("   The binding handle is invalid.  ( RPC_S_INVALID_BINDING            1702L "));
		; break;;case  RPC_S_PROTSEQ_NOT_SUPPORTED :  _sprintf(*buf,_T("   The RPC protocol sequence is not supported.  ( RPC_S_PROTSEQ_NOT_SUPPORTED      1703L "));
		; break;;case  RPC_S_INVALID_RPC_PROTSEQ :  _sprintf(*buf,_T("   The RPC protocol sequence is invalid.  ( RPC_S_INVALID_RPC_PROTSEQ        1704L "));
		; break;;case  RPC_S_INVALID_STRING_UUID :  _sprintf(*buf,_T("   The string universal unique identifier (UUID) is invalid.  ( RPC_S_INVALID_STRING_UUID        1705L "));
		; break;;case  RPC_S_INVALID_ENDPOINT_FORMAT :  _sprintf(*buf,_T("   The endpoint format is invalid.  ( RPC_S_INVALID_ENDPOINT_FORMAT    1706L "));
		; break;;case  RPC_S_INVALID_NET_ADDR :  _sprintf(*buf,_T("   The network address is invalid.  ( RPC_S_INVALID_NET_ADDR           1707L "));
		; break;;case  RPC_S_NO_ENDPOINT_FOUND :  _sprintf(*buf,_T("   No endpoint was found.  ( RPC_S_NO_ENDPOINT_FOUND          1708L "));
		; break;;case  RPC_S_INVALID_TIMEOUT :  _sprintf(*buf,_T("   The timeout value is invalid.  ( RPC_S_INVALID_TIMEOUT            1709L "));
		; break;;case  RPC_S_OBJECT_NOT_FOUND :  _sprintf(*buf,_T("   The object universal unique identifier (UUID) was not found.  ( RPC_S_OBJECT_NOT_FOUND           1710L "));
		; break;;case  RPC_S_ALREADY_REGISTERED :  _sprintf(*buf,_T("   The object universal unique identifier (UUID) has already been registered.  ( RPC_S_ALREADY_REGISTERED         1711L "));
		; break;;case  RPC_S_TYPE_ALREADY_REGISTERED :  _sprintf(*buf,_T("   The type universal unique identifier (UUID) has already been registered.  ( RPC_S_TYPE_ALREADY_REGISTERED    1712L "));
		; break;;case  RPC_S_ALREADY_LISTENING :  _sprintf(*buf,_T("   The RPC server is already listening.  ( RPC_S_ALREADY_LISTENING          1713L "));
		; break;;case  RPC_S_NO_PROTSEQS_REGISTERED :  _sprintf(*buf,_T("   No protocol sequences have been registered.  ( RPC_S_NO_PROTSEQS_REGISTERED     1714L "));
		; break;;case  RPC_S_NOT_LISTENING :  _sprintf(*buf,_T("   The RPC server is not listening.  ( RPC_S_NOT_LISTENING              1715L "));
		; break;;case  RPC_S_UNKNOWN_MGR_TYPE :  _sprintf(*buf,_T("   The manager type is unknown.  ( RPC_S_UNKNOWN_MGR_TYPE           1716L "));
		; break;;case  RPC_S_UNKNOWN_IF :  _sprintf(*buf,_T("   The interface is unknown.  ( RPC_S_UNKNOWN_IF                 1717L "));
		; break;;case  RPC_S_NO_BINDINGS :  _sprintf(*buf,_T("   There are no bindings.  ( RPC_S_NO_BINDINGS                1718L "));
		; break;;case  RPC_S_NO_PROTSEQS :  _sprintf(*buf,_T("   There are no protocol sequences.  ( RPC_S_NO_PROTSEQS                1719L "));
		; break;;case  RPC_S_CANT_CREATE_ENDPOINT :  _sprintf(*buf,_T("   The endpoint cannot be created.  ( RPC_S_CANT_CREATE_ENDPOINT       1720L "));
		; break;;case  RPC_S_OUT_OF_RESOURCES :  _sprintf(*buf,_T("   Not enough resources are available to complete this operation.  ( RPC_S_OUT_OF_RESOURCES           1721L "));
		; break;;case  RPC_S_SERVER_UNAVAILABLE :  _sprintf(*buf,_T("   The RPC server is unavailable.  ( RPC_S_SERVER_UNAVAILABLE         1722L "));
		; break;;case  RPC_S_SERVER_TOO_BUSY :  _sprintf(*buf,_T("   The RPC server is too busy to complete this operation.  ( RPC_S_SERVER_TOO_BUSY            1723L "));
		; break;;case  RPC_S_INVALID_NETWORK_OPTIONS :  _sprintf(*buf,_T("   The network options are invalid.  ( RPC_S_INVALID_NETWORK_OPTIONS    1724L "));
		; break;;case  RPC_S_NO_CALL_ACTIVE :  _sprintf(*buf,_T("   There are no remote procedure calls active on this thread.  ( RPC_S_NO_CALL_ACTIVE             1725L "));
		; break;;case  RPC_S_CALL_FAILED :  _sprintf(*buf,_T("   The remote procedure call failed.  ( RPC_S_CALL_FAILED                1726L "));
		; break;;case  RPC_S_CALL_FAILED_DNE :  _sprintf(*buf,_T("   The remote procedure call failed and did not execute.  ( RPC_S_CALL_FAILED_DNE            1727L "));
		; break;;case  RPC_S_PROTOCOL_ERROR :  _sprintf(*buf,_T("   A remote procedure call (RPC) protocol error occurred.  ( RPC_S_PROTOCOL_ERROR             1728L "));
		; break;;case  RPC_S_UNSUPPORTED_TRANS_SYN :  _sprintf(*buf,_T("   The transfer syntax is not supported by the RPC server.  ( RPC_S_UNSUPPORTED_TRANS_SYN      1730L "));
		; break;;case  RPC_S_UNSUPPORTED_TYPE :  _sprintf(*buf,_T("   The universal unique identifier (UUID) type is not supported.  ( RPC_S_UNSUPPORTED_TYPE           1732L "));
		; break;;case  RPC_S_INVALID_TAG :  _sprintf(*buf,_T("   The tag is invalid.  ( RPC_S_INVALID_TAG                1733L "));
		; break;;case  RPC_S_INVALID_BOUND :  _sprintf(*buf,_T("   The array bounds are invalid.  ( RPC_S_INVALID_BOUND              1734L "));
		; break;;case  RPC_S_NO_ENTRY_NAME :  _sprintf(*buf,_T("   The binding does not contain an entry name.  ( RPC_S_NO_ENTRY_NAME              1735L "));
		; break;;case  RPC_S_INVALID_NAME_SYNTAX :  _sprintf(*buf,_T("   The name syntax is invalid.  ( RPC_S_INVALID_NAME_SYNTAX        1736L "));
		; break;;case  RPC_S_UNSUPPORTED_NAME_SYNTAX :  _sprintf(*buf,_T("   The name syntax is not supported.  ( RPC_S_UNSUPPORTED_NAME_SYNTAX    1737L "));
		; break;;case  RPC_S_UUID_NO_ADDRESS :  _sprintf(*buf,_T("   No network address is available to use to construct a universal  unique identifier (UUID).  ( RPC_S_UUID_NO_ADDRESS            1739L "));
		; break;;case  RPC_S_DUPLICATE_ENDPOINT :  _sprintf(*buf,_T("   The endpoint is a duplicate.  ( RPC_S_DUPLICATE_ENDPOINT         1740L "));
		; break;;case  RPC_S_UNKNOWN_AUTHN_TYPE :  _sprintf(*buf,_T("   The authentication type is unknown.  ( RPC_S_UNKNOWN_AUTHN_TYPE         1741L "));
		; break;;case  RPC_S_MAX_CALLS_TOO_SMALL :  _sprintf(*buf,_T("   The maximum number of calls is too small.  ( RPC_S_MAX_CALLS_TOO_SMALL        1742L "));
		; break;;case  RPC_S_STRING_TOO_LONG :  _sprintf(*buf,_T("   The string is too long.  ( RPC_S_STRING_TOO_LONG            1743L "));
		; break;;case  RPC_S_PROTSEQ_NOT_FOUND :  _sprintf(*buf,_T("   The RPC protocol sequence was not found.  ( RPC_S_PROTSEQ_NOT_FOUND          1744L "));
		; break;;case  RPC_S_PROCNUM_OUT_OF_RANGE :  _sprintf(*buf,_T("   The procedure number is out of range.  ( RPC_S_PROCNUM_OUT_OF_RANGE       1745L "));
		; break;;case  RPC_S_BINDING_HAS_NO_AUTH :  _sprintf(*buf,_T("   The binding does not contain any authentication information.  ( RPC_S_BINDING_HAS_NO_AUTH        1746L "));
		; break;;case  RPC_S_UNKNOWN_AUTHN_SERVICE :  _sprintf(*buf,_T("   The authentication service is unknown.  ( RPC_S_UNKNOWN_AUTHN_SERVICE      1747L "));
		; break;;case  RPC_S_UNKNOWN_AUTHN_LEVEL :  _sprintf(*buf,_T("   The authentication level is unknown.  ( RPC_S_UNKNOWN_AUTHN_LEVEL        1748L "));
		; break;;case  RPC_S_INVALID_AUTH_IDENTITY :  _sprintf(*buf,_T("   The security context is invalid.  ( RPC_S_INVALID_AUTH_IDENTITY      1749L "));
		; break;;case  RPC_S_UNKNOWN_AUTHZ_SERVICE :  _sprintf(*buf,_T("   The authorization service is unknown.  ( RPC_S_UNKNOWN_AUTHZ_SERVICE      1750L "));
		; break;;case  EPT_S_INVALID_ENTRY :  _sprintf(*buf,_T("   The entry is invalid.  ( EPT_S_INVALID_ENTRY              1751L "));
		; break;;case  EPT_S_CANT_PERFORM_OP :  _sprintf(*buf,_T("   The server endpoint cannot perform the operation.  ( EPT_S_CANT_PERFORM_OP            1752L "));
		; break;;case  EPT_S_NOT_REGISTERED :  _sprintf(*buf,_T("   There are no more endpoints available from the endpoint mapper.  ( EPT_S_NOT_REGISTERED             1753L "));
		; break;;case  RPC_S_NOTHING_TO_EXPORT :  _sprintf(*buf,_T("   No interfaces have been exported.  ( RPC_S_NOTHING_TO_EXPORT          1754L "));
		; break;;case  RPC_S_INCOMPLETE_NAME :  _sprintf(*buf,_T("   The entry name is incomplete.  ( RPC_S_INCOMPLETE_NAME            1755L "));
		; break;;case  RPC_S_INVALID_VERS_OPTION :  _sprintf(*buf,_T("   The version option is invalid.  ( RPC_S_INVALID_VERS_OPTION        1756L "));
		; break;;case  RPC_S_NO_MORE_MEMBERS :  _sprintf(*buf,_T("   There are no more members.  ( RPC_S_NO_MORE_MEMBERS            1757L "));
		; break;;case  RPC_S_NOT_ALL_OBJS_UNEXPORTED :  _sprintf(*buf,_T("   There is nothing to unexport.  ( RPC_S_NOT_ALL_OBJS_UNEXPORTED    1758L "));
		; break;;case  RPC_S_INTERFACE_NOT_FOUND :  _sprintf(*buf,_T("   The interface was not found.  ( RPC_S_INTERFACE_NOT_FOUND        1759L "));
		; break;;case  RPC_S_ENTRY_ALREADY_EXISTS :  _sprintf(*buf,_T("   The entry already exists.  ( RPC_S_ENTRY_ALREADY_EXISTS       1760L "));
		; break;;case  RPC_S_ENTRY_NOT_FOUND :  _sprintf(*buf,_T("   The entry is not found.  ( RPC_S_ENTRY_NOT_FOUND            1761L "));
		; break;;case  RPC_S_NAME_SERVICE_UNAVAILABLE :  _sprintf(*buf,_T("   The name service is unavailable.  ( RPC_S_NAME_SERVICE_UNAVAILABLE   1762L "));
		; break;;case  RPC_S_INVALID_NAF_ID :  _sprintf(*buf,_T("   The network address family is invalid.  ( RPC_S_INVALID_NAF_ID             1763L "));
		; break;;case  RPC_S_CANNOT_SUPPORT :  _sprintf(*buf,_T("   The requested operation is not supported.  ( RPC_S_CANNOT_SUPPORT             1764L "));
		; break;;case  RPC_S_NO_CONTEXT_AVAILABLE :  _sprintf(*buf,_T("   No security context is available to allow impersonation.  ( RPC_S_NO_CONTEXT_AVAILABLE       1765L "));
		; break;;case  RPC_S_INTERNAL_ERROR :  _sprintf(*buf,_T("   An internal error occurred in a remote procedure call (RPC).  ( RPC_S_INTERNAL_ERROR             1766L "));
		; break;;case  RPC_S_ZERO_DIVIDE :  _sprintf(*buf,_T("   The RPC server attempted an integer division by zero.  ( RPC_S_ZERO_DIVIDE                1767L "));
		; break;;case  RPC_S_ADDRESS_ERROR :  _sprintf(*buf,_T("   An addressing error occurred in the RPC server.  ( RPC_S_ADDRESS_ERROR              1768L "));
		; break;;case  RPC_S_FP_DIV_ZERO :  _sprintf(*buf,_T("   A floating-point operation at the RPC server caused a division by zero.  ( RPC_S_FP_DIV_ZERO                1769L "));
		; break;;case  RPC_S_FP_UNDERFLOW :  _sprintf(*buf,_T("   A floating-point underflow occurred at the RPC server.  ( RPC_S_FP_UNDERFLOW               1770L "));
		; break;;case  RPC_S_FP_OVERFLOW :  _sprintf(*buf,_T("   A floating-point overflow occurred at the RPC server.  ( RPC_S_FP_OVERFLOW                1771L "));
		; break;;case  RPC_X_NO_MORE_ENTRIES :  _sprintf(*buf,_T("   The list of RPC servers available for the binding of auto handles  has been exhausted.  ( RPC_X_NO_MORE_ENTRIES            1772L "));
		; break;;case  RPC_X_SS_CHAR_TRANS_OPEN_FAIL :  _sprintf(*buf,_T("   Unable to open the character translation table file.  ( RPC_X_SS_CHAR_TRANS_OPEN_FAIL    1773L "));
		; break;;case  RPC_X_SS_CHAR_TRANS_SHORT_FILE :  _sprintf(*buf,_T("   The file containing the character translation table has fewer than  512 BYTEs.  ( RPC_X_SS_CHAR_TRANS_SHORT_FILE   1774L "));
		; break;;case  RPC_X_SS_IN_NULL_CONTEXT :  _sprintf(*buf,_T("   A null context handle was passed from the client to the host during  a remote procedure call.  ( RPC_X_SS_IN_NULL_CONTEXT         1775L "));
		; break;;case  RPC_X_SS_CONTEXT_DAMAGED :  _sprintf(*buf,_T("   The context handle changed during a remote procedure call.  ( RPC_X_SS_CONTEXT_DAMAGED         1777L "));
		; break;;case  RPC_X_SS_HANDLES_MISMATCH :  _sprintf(*buf,_T("   The binding handles passed to a remote procedure call do not match.  ( RPC_X_SS_HANDLES_MISMATCH        1778L "));
		; break;;case  RPC_X_SS_CANNOT_GET_CALL_HANDLE :  _sprintf(*buf,_T("   The stub is unable to get the remote procedure call handle.  ( RPC_X_SS_CANNOT_GET_CALL_HANDLE  1779L "));
		; break;;case  RPC_X_NULL_REF_POINTER :  _sprintf(*buf,_T("   A null reference pointer was passed to the stub.  ( RPC_X_NULL_REF_POINTER           1780L "));
		; break;;case  RPC_X_ENUM_VALUE_OUT_OF_RANGE :  _sprintf(*buf,_T("   The enumeration value is out of range.  ( RPC_X_ENUM_VALUE_OUT_OF_RANGE    1781L "));
		; break;;case  RPC_X_BYTE_COUNT_TOO_SMALL :  _sprintf(*buf,_T("   The BYTE count is too small.  ( RPC_X_BYTE_COUNT_TOO_SMALL       1782L "));
		; break;;case  RPC_X_BAD_STUB_DATA :  _sprintf(*buf,_T("   The stub received bad data.  ( RPC_X_BAD_STUB_DATA              1783L "));
		; break;;case  ERROR_INVALID_USER_BUFFER :  _sprintf(*buf,_T("   The supplied user buffer is not valid for the requested operation.  ( ERROR_INVALID_USER_BUFFER        1784L "));
		; break;;case  ERROR_UNRECOGNIZED_MEDIA :  _sprintf(*buf,_T("   The disk media is not recognized.  It may not be formatted.  ( ERROR_UNRECOGNIZED_MEDIA         1785L "));
		; break;;case  ERROR_NO_TRUST_LSA_SECRET :  _sprintf(*buf,_T("   The workstation does not have a trust secret.  ( ERROR_NO_TRUST_LSA_SECRET        1786L "));
		; break;;case  ERROR_NO_TRUST_SAM_ACCOUNT :  _sprintf(*buf,_T("   The SAM database on the Windows NT Server does not have a computer account for this workstation trust relationship.  ( ERROR_NO_TRUST_SAM_ACCOUNT       1787L "));
		; break;;case  ERROR_TRUSTED_DOMAIN_FAILURE :  _sprintf(*buf,_T("   The trust relationship between the primary domain and the trusted  domain failed.  ( ERROR_TRUSTED_DOMAIN_FAILURE     1788L "));
		; break;;case  ERROR_TRUSTED_RELATIONSHIP_FAILURE :  _sprintf(*buf,_T("   The trust relationship between this workstation and the primary  domain failed.  ( ERROR_TRUSTED_RELATIONSHIP_FAILURE 1789L "));
		; break;;case  ERROR_TRUST_FAILURE :  _sprintf(*buf,_T("   The network logon failed.  ( ERROR_TRUST_FAILURE              1790L "));
		; break;;case  RPC_S_CALL_IN_PROGRESS :  _sprintf(*buf,_T("   A remote procedure call is already in progress for this thread.  ( RPC_S_CALL_IN_PROGRESS           1791L "));
		; break;;case  ERROR_NETLOGON_NOT_STARTED :  _sprintf(*buf,_T("   An attempt was made to logon, but the network logon service was not started.  ( ERROR_NETLOGON_NOT_STARTED       1792L "));
		; break;;case  ERROR_ACCOUNT_EXPIRED :  _sprintf(*buf,_T("   The user's account has expired.  ( ERROR_ACCOUNT_EXPIRED            1793L "));
		; break;;case  ERROR_REDIRECTOR_HAS_OPEN_HANDLES :  _sprintf(*buf,_T("   The redirector is in use and cannot be unloaded.  ( ERROR_REDIRECTOR_HAS_OPEN_HANDLES 1794L "));
		; break;;case  ERROR_PRINTER_DRIVER_ALREADY_INSTALLED :  _sprintf(*buf,_T("   The specified printer driver is already installed.  ( ERROR_PRINTER_DRIVER_ALREADY_INSTALLED 1795L "));
		; break;;case  ERROR_UNKNOWN_PORT :  _sprintf(*buf,_T("   The specified port is unknown.  ( ERROR_UNKNOWN_PORT               1796L "));
		; break;;case  ERROR_UNKNOWN_PRINTER_DRIVER :  _sprintf(*buf,_T("   The printer driver is unknown.  ( ERROR_UNKNOWN_PRINTER_DRIVER     1797L "));
		; break;;case  ERROR_UNKNOWN_PRINTPROCESSOR :  _sprintf(*buf,_T("   The print processor is unknown.  ( ERROR_UNKNOWN_PRINTPROCESSOR     1798L "));
		; break;;case  ERROR_INVALID_SEPARATOR_FILE :  _sprintf(*buf,_T("   The specified separator file is invalid.  ( ERROR_INVALID_SEPARATOR_FILE     1799L "));
		; break;;case  ERROR_INVALID_PRIORITY :  _sprintf(*buf,_T("   The specified priority is invalid.  ( ERROR_INVALID_PRIORITY           1800L "));
		; break;;case  ERROR_INVALID_PRINTER_NAME :  _sprintf(*buf,_T("   The printer name is invalid.  ( ERROR_INVALID_PRINTER_NAME       1801L "));
		; break;;case  ERROR_PRINTER_ALREADY_EXISTS :  _sprintf(*buf,_T("   The printer already exists.  ( ERROR_PRINTER_ALREADY_EXISTS     1802L "));
		; break;;case  ERROR_INVALID_PRINTER_COMMAND :  _sprintf(*buf,_T("   The printer command is invalid.  ( ERROR_INVALID_PRINTER_COMMAND    1803L "));
		; break;;case  ERROR_INVALID_DATATYPE :  _sprintf(*buf,_T("   The specified datatype is invalid.  ( ERROR_INVALID_DATATYPE           1804L "));
		; break;;case  ERROR_INVALID_ENVIRONMENT :  _sprintf(*buf,_T("   The environment specified is invalid.  ( ERROR_INVALID_ENVIRONMENT        1805L "));
		; break;;case  RPC_S_NO_MORE_BINDINGS :  _sprintf(*buf,_T("   There are no more bindings.  ( RPC_S_NO_MORE_BINDINGS           1806L "));
		; break;;case  ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT :  _sprintf(*buf,_T("   The account used is an interdomain trust account.  Use your global user account or local user account to access this server.  ( ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 1807L "));
		; break;;case  ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT :  _sprintf(*buf,_T("   The account used is a computer account.  Use your global user account or local user account to access this server.  ( ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT 1808L "));
		; break;;case  ERROR_NOLOGON_SERVER_TRUST_ACCOUNT :  _sprintf(*buf,_T("   The account used is a server trust account. Use your global user account or local user account to access this server.  ( ERROR_NOLOGON_SERVER_TRUST_ACCOUNT 1809L "));
		; break;;case  ERROR_DOMAIN_TRUST_INCONSISTENT :  _sprintf(*buf,_T("   The name or security ID (SID) of the domain specified is inconsistent  with the trust information for that domain.  ( ERROR_DOMAIN_TRUST_INCONSISTENT  1810L "));
		; break;;case  ERROR_SERVER_HAS_OPEN_HANDLES :  _sprintf(*buf,_T("   The server is in use and cannot be unloaded.  ( ERROR_SERVER_HAS_OPEN_HANDLES    1811L "));
		; break;;case  ERROR_RESOURCE_DATA_NOT_FOUND :  _sprintf(*buf,_T("   The specified image file did not contain a resource section.  ( ERROR_RESOURCE_DATA_NOT_FOUND    1812L "));
		; break;;case  ERROR_RESOURCE_TYPE_NOT_FOUND :  _sprintf(*buf,_T("   The specified resource type cannot be found in the image file.  ( ERROR_RESOURCE_TYPE_NOT_FOUND    1813L "));
		; break;;case  ERROR_RESOURCE_NAME_NOT_FOUND :  _sprintf(*buf,_T("   The specified resource name cannot be found in the image file.  ( ERROR_RESOURCE_NAME_NOT_FOUND    1814L "));
		; break;;case  ERROR_RESOURCE_LANG_NOT_FOUND :  _sprintf(*buf,_T("   The specified resource language ID cannot be found in the image file.  ( ERROR_RESOURCE_LANG_NOT_FOUND    1815L "));
		; break;;case  ERROR_NOT_ENOUGH_QUOTA :  _sprintf(*buf,_T("   Not enough quota is available to process this command.  ( ERROR_NOT_ENOUGH_QUOTA           1816L "));
		; break;;case  RPC_S_NO_INTERFACES :  _sprintf(*buf,_T("   No interfaces have been registered.  ( RPC_S_NO_INTERFACES              1817L "));
		; break;;case  RPC_S_CALL_CANCELLED :  _sprintf(*buf,_T("   The remote procedure call was cancelled.  ( RPC_S_CALL_CANCELLED             1818L "));
		; break;;case  RPC_S_BINDING_INCOMPLETE :  _sprintf(*buf,_T("   The binding handle does not contain all required information.  ( RPC_S_BINDING_INCOMPLETE         1819L "));
		; break;;case  RPC_S_COMM_FAILURE :  _sprintf(*buf,_T("   A communications failure occurred during a remote procedure call.  ( RPC_S_COMM_FAILURE               1820L "));
		; break;;case  RPC_S_UNSUPPORTED_AUTHN_LEVEL :  _sprintf(*buf,_T("   The requested authentication level is not supported.  ( RPC_S_UNSUPPORTED_AUTHN_LEVEL    1821L "));
		; break;;case  RPC_S_NO_PRINC_NAME :  _sprintf(*buf,_T("   No principal name registered.  ( RPC_S_NO_PRINC_NAME              1822L "));
		; break;;case  RPC_S_NOT_RPC_ERROR :  _sprintf(*buf,_T("   The error specified is not a valid Windows RPC error code.  ( RPC_S_NOT_RPC_ERROR              1823L "));
		; break;;case  RPC_S_UUID_LOCAL_ONLY :  _sprintf(*buf,_T("   A UUID that is valid only on this computer has been allocated.  ( RPC_S_UUID_LOCAL_ONLY            1824L "));
		; break;;case  RPC_S_SEC_PKG_ERROR :  _sprintf(*buf,_T("   A security package specific error occurred.  ( RPC_S_SEC_PKG_ERROR              1825L "));
		; break;;case  RPC_S_NOT_CANCELLED :  _sprintf(*buf,_T("   Thread is not canceled.  ( RPC_S_NOT_CANCELLED              1826L "));
		; break;;case  RPC_X_INVALID_ES_ACTION :  _sprintf(*buf,_T("   Invalid operation on the encoding/decoding handle.  ( RPC_X_INVALID_ES_ACTION          1827L "));
		; break;;case  RPC_X_WRONG_ES_VERSION :  _sprintf(*buf,_T("   Incompatible version of the serializing package.  ( RPC_X_WRONG_ES_VERSION           1828L "));
		; break;;case  RPC_X_WRONG_STUB_VERSION :  _sprintf(*buf,_T("   Incompatible version of the RPC stub.  ( RPC_X_WRONG_STUB_VERSION         1829L "));
		; break;;case  RPC_X_INVALID_PIPE_OBJECT :  _sprintf(*buf,_T("   The RPC pipe object is invalid or corrupted.  ( RPC_X_INVALID_PIPE_OBJECT        1830L "));
#ifndef VCPP50
		; break;;case  RPC_X_WRONG_PIPE_ORDER :  _sprintf(*buf,_T("   An invalid operation was attempted on an RPC pipe object.  ( RPC_X_WRONG_PIPE_ORDER           1831L "));
#endif
		; break;;case  RPC_X_WRONG_PIPE_VERSION :  _sprintf(*buf,_T("   Unsupported RPC pipe version.  ( RPC_X_WRONG_PIPE_VERSION         1832L "));
		; break;;case  RPC_S_GROUP_MEMBER_NOT_FOUND :  _sprintf(*buf,_T("   The group member was not found.  ( RPC_S_GROUP_MEMBER_NOT_FOUND     1898L "));
		; break;;case  EPT_S_CANT_CREATE :  _sprintf(*buf,_T("   The endpoint mapper database entry could not be created.  ( EPT_S_CANT_CREATE                1899L "));
		; break;;case  RPC_S_INVALID_OBJECT :  _sprintf(*buf,_T("   The object universal unique identifier (UUID) is the nil UUID.  ( RPC_S_INVALID_OBJECT             1900L "));
		; break;;case  ERROR_INVALID_TIME :  _sprintf(*buf,_T("   The specified time is invalid.  ( ERROR_INVALID_TIME               1901L "));
		; break;;case  ERROR_INVALID_FORM_NAME :  _sprintf(*buf,_T("   The specified form name is invalid.  ( ERROR_INVALID_FORM_NAME          1902L "));
		; break;;case  ERROR_INVALID_FORM_SIZE :  _sprintf(*buf,_T("   The specified form size is invalid.  ( ERROR_INVALID_FORM_SIZE          1903L "));
		; break;;case  ERROR_ALREADY_WAITING :  _sprintf(*buf,_T("   The specified printer handle is already being waited on  ( ERROR_ALREADY_WAITING            1904L "));
		; break;;case  ERROR_PRINTER_DELETED :  _sprintf(*buf,_T("   The specified printer has been deleted.  ( ERROR_PRINTER_DELETED            1905L "));
		; break;;case  ERROR_INVALID_PRINTER_STATE :  _sprintf(*buf,_T("   The state of the printer is invalid.  ( ERROR_INVALID_PRINTER_STATE      1906L "));
		; break;;case  ERROR_PASSWORD_MUST_CHANGE :  _sprintf(*buf,_T("   The user must change his password before he logs on the first time.  ( ERROR_PASSWORD_MUST_CHANGE       1907L "));
		; break;;case  ERROR_DOMAIN_CONTROLLER_NOT_FOUND :  _sprintf(*buf,_T("   Could not find the domain controller for this domain.  ( ERROR_DOMAIN_CONTROLLER_NOT_FOUND 1908L "));
		; break;;case  ERROR_ACCOUNT_LOCKED_OUT :  _sprintf(*buf,_T("   The referenced account is currently locked out and may not be logged on to.  ( ERROR_ACCOUNT_LOCKED_OUT         1909L "));
		; break;;case  OR_INVALID_OXID :  _sprintf(*buf,_T("   The object exporter specified was not found.  ( OR_INVALID_OXID                  1910L "));
		; break;;case  OR_INVALID_OID :  _sprintf(*buf,_T("   The object specified was not found.  ( OR_INVALID_OID                   1911L "));
		; break;;case  OR_INVALID_SET :  _sprintf(*buf,_T("   The object resolver set specified was not found.  ( OR_INVALID_SET                   1912L "));
		; break;;case  RPC_S_SEND_INCOMPLETE :  _sprintf(*buf,_T("   Some data remains to be sent in the request buffer.  ( RPC_S_SEND_INCOMPLETE            1913L "));
#ifndef VCPP50
		; break;;case  RPC_S_INVALID_ASYNC_HANDLE :  _sprintf(*buf,_T("   Invalid asynchronous remote procedure call handle.  ( RPC_S_INVALID_ASYNC_HANDLE       1914L "));
		; break;;case  RPC_S_INVALID_ASYNC_CALL :  _sprintf(*buf,_T("   Invalid asynchronous RPC call handle for this operation.  ( RPC_S_INVALID_ASYNC_CALL         1915L "));
		; break;;case  RPC_X_PIPE_CLOSED :  _sprintf(*buf,_T("   The RPC pipe object has already been closed.  ( RPC_X_PIPE_CLOSED                1916L "));
		; break;;case  RPC_X_PIPE_DISCIPLINE_ERROR :  _sprintf(*buf,_T("   The RPC call completed before all pipes were processed.  ( RPC_X_PIPE_DISCIPLINE_ERROR      1917L "));
		; break;;case  RPC_X_PIPE_EMPTY :  _sprintf(*buf,_T("   No more data is available from the RPC pipe.  ( RPC_X_PIPE_EMPTY                 1918L "));
		; break;;case  ERROR_NO_SITENAME :  _sprintf(*buf,_T("   No site name is available for this machine.  ( ERROR_NO_SITENAME                1919L "));
		; break;;case  ERROR_CANT_ACCESS_FILE :  _sprintf(*buf,_T("   The file can not be accessed by the system.  ( ERROR_CANT_ACCESS_FILE           1920L "));
		; break;;case  ERROR_CANT_RESOLVE_FILENAME :  _sprintf(*buf,_T("   The name of the file cannot be resolved by the system.  ( ERROR_CANT_RESOLVE_FILENAME      1921L "));
		; break;;case  ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY :  _sprintf(*buf,_T("   The directory service evaluated group memberships locally.  ( ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY 1922L "));
		; break;;case  ERROR_DS_NO_ATTRIBUTE_OR_VALUE :  _sprintf(*buf,_T("   The specified directory service attribute or value does not exist.  ( ERROR_DS_NO_ATTRIBUTE_OR_VALUE   1923L "));
		; break;;case  ERROR_DS_INVALID_ATTRIBUTE_SYNTAX :  _sprintf(*buf,_T("   The attribute syntax specified to the directory service is invalid.  ( ERROR_DS_INVALID_ATTRIBUTE_SYNTAX 1924L "));
		; break;;case  ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED :  _sprintf(*buf,_T("   The attribute type specified to the directory service is not defined.  ( ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED 1925L "));
		; break;;case  ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS :  _sprintf(*buf,_T("   The specified directory service attribute or value already exists.  ( ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS 1926L "));
		; break;;case  ERROR_DS_BUSY :  _sprintf(*buf,_T("   The directory service is busy.  ( ERROR_DS_BUSY                    1927L "));
		; break;;case  ERROR_DS_UNAVAILABLE :  _sprintf(*buf,_T("   The directory service is unavailable.  ( ERROR_DS_UNAVAILABLE             1928L "));
		; break;;case  ERROR_DS_NO_RIDS_ALLOCATED :  _sprintf(*buf,_T("   The directory service was unable to allocate a relative identifier.  ( ERROR_DS_NO_RIDS_ALLOCATED       1929L "));
		; break;;case  ERROR_DS_NO_MORE_RIDS :  _sprintf(*buf,_T("   The directory service has exhausted the pool of relative identifiers.  ( ERROR_DS_NO_MORE_RIDS            1930L "));
		; break;;case  ERROR_DS_INCORRECT_ROLE_OWNER :  _sprintf(*buf,_T("   The requested operation could not be performed because the directory service is not the  master for that type of operation.  ( ERROR_DS_INCORRECT_ROLE_OWNER    1931L "));
		; break;;case  ERROR_DS_RIDMGR_INIT_ERROR :  _sprintf(*buf,_T("   The directory service was unable to initialize the subsystem that allocates relative identifiers.  ( ERROR_DS_RIDMGR_INIT_ERROR       1932L "));
		; break;;case  ERROR_DS_OBJ_CLASS_VIOLATION :  _sprintf(*buf,_T("   The requested operation did not satisfy one or more constraints associated with the class of the object.  ( ERROR_DS_OBJ_CLASS_VIOLATION     1933L "));
		; break;;case  ERROR_DS_CANT_ON_NON_LEAF :  _sprintf(*buf,_T("   The directory service can perform the requested operation only on a leaf object.  ( ERROR_DS_CANT_ON_NON_LEAF        1934L "));
		; break;;case  ERROR_DS_CANT_ON_RDN :  _sprintf(*buf,_T("   The directory service cannot perform the requested operation on the RDN attribute of an object.  ( ERROR_DS_CANT_ON_RDN             1935L "));
		; break;;case  ERROR_DS_CANT_MOD_OBJ_CLASS :  _sprintf(*buf,_T("   The directory service detected an attempt to modify the object class of an object.  ( ERROR_DS_CANT_MOD_OBJ_CLASS      1936L "));
		; break;;case  ERROR_DS_CROSS_DOM_MOVE_ERROR :  _sprintf(*buf,_T("   The requested cross domain move operation could not be performed.  ( ERROR_DS_CROSS_DOM_MOVE_ERROR    1937L "));
		; break;;case  ERROR_DS_GC_NOT_AVAILABLE :  _sprintf(*buf,_T("   Unable to contact the global catalog server.  ( ERROR_DS_GC_NOT_AVAILABLE        1938L "));
#endif
		; break;;case  ERROR_NO_BROWSER_SERVERS_FOUND :  _sprintf(*buf,_T("   The list of servers for this workgroup is not currently available  ( ERROR_NO_BROWSER_SERVERS_FOUND   6118L "));
		; break;;case  ERROR_INVALID_PIXEL_FORMAT :  _sprintf(*buf,_T("   The pixel format is invalid.  ( ERROR_INVALID_PIXEL_FORMAT       2000L "));
		; break;;case  ERROR_BAD_DRIVER :  _sprintf(*buf,_T("   The specified driver is invalid.  ( ERROR_BAD_DRIVER                 2001L "));
		; break;;case  ERROR_INVALID_WINDOW_STYLE :  _sprintf(*buf,_T("   The window style or class attribute is invalid for this operation.  ( ERROR_INVALID_WINDOW_STYLE       2002L "));
		; break;;case  ERROR_METAFILE_NOT_SUPPORTED :  _sprintf(*buf,_T("   The requested metafile operation is not supported.  ( ERROR_METAFILE_NOT_SUPPORTED     2003L "));
		; break;;case  ERROR_TRANSFORM_NOT_SUPPORTED :  _sprintf(*buf,_T("   The requested transformation operation is not supported.  ( ERROR_TRANSFORM_NOT_SUPPORTED    2004L "));
		; break;;case  ERROR_CLIPPING_NOT_SUPPORTED :  _sprintf(*buf,_T("   The requested clipping operation is not supported.  ( ERROR_CLIPPING_NOT_SUPPORTED     2005L  End of OpenGL error codes "));
#ifndef VCPP50
		; break;;case  ERROR_INVALID_CMM :  _sprintf(*buf,_T("   The specified color management module is invalid.  ( ERROR_INVALID_CMM                2300L "));
		; break;;case  ERROR_INVALID_PROFILE :  _sprintf(*buf,_T("   The specified color profile is invalid.  ( ERROR_INVALID_PROFILE            2301L "));
		; break;;case  ERROR_TAG_NOT_FOUND :  _sprintf(*buf,_T("   The specified tag was not found.  ( ERROR_TAG_NOT_FOUND              2302L "));
		; break;;case  ERROR_TAG_NOT_PRESENT :  _sprintf(*buf,_T("   A required tag is not present.  ( ERROR_TAG_NOT_PRESENT            2303L "));
		; break;;case  ERROR_DUPLICATE_TAG :  _sprintf(*buf,_T("   The specified tag is already present.  ( ERROR_DUPLICATE_TAG              2304L "));
		; break;;case  ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE :  _sprintf(*buf,_T("   The specified color profile is not associated with any device.  ( ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE 2305L "));
		; break;;case  ERROR_PROFILE_NOT_FOUND :  _sprintf(*buf,_T("   The specified color profile was not found.  ( ERROR_PROFILE_NOT_FOUND          2306L "));
		; break;;case  ERROR_INVALID_COLORSPACE :  _sprintf(*buf,_T("   The specified color space is invalid.  ( ERROR_INVALID_COLORSPACE         2307L "));
		; break;;case  ERROR_ICM_NOT_ENABLED :  _sprintf(*buf,_T("   Image Color Management is not enabled.  ( ERROR_ICM_NOT_ENABLED            2308L "));
		; break;;case  ERROR_DELETING_ICM_XFORM :  _sprintf(*buf,_T("   There was an error while deleting the color transform.  ( ERROR_DELETING_ICM_XFORM         2309L "));
		; break;;case  ERROR_INVALID_TRANSFORM :  _sprintf(*buf,_T("   The specified color transform is invalid.  ( ERROR_INVALID_TRANSFORM          2310L "));
#endif
		; break;;case  ERROR_UNKNOWN_PRINT_MONITOR :  _sprintf(*buf,_T("   The specified print monitor is unknown.  ( ERROR_UNKNOWN_PRINT_MONITOR      3000L "));
		; break;;case  ERROR_PRINTER_DRIVER_IN_USE :  _sprintf(*buf,_T("   The specified printer driver is currently in use.  ( ERROR_PRINTER_DRIVER_IN_USE      3001L "));
		; break;;case  ERROR_SPOOL_FILE_NOT_FOUND :  _sprintf(*buf,_T("   The spool file was not found.  ( ERROR_SPOOL_FILE_NOT_FOUND       3002L "));
		; break;;case  ERROR_SPL_NO_STARTDOC :  _sprintf(*buf,_T("   A StartDocPrinter call was not issued.  ( ERROR_SPL_NO_STARTDOC            3003L "));
		; break;;case  ERROR_SPL_NO_ADDJOB :  _sprintf(*buf,_T("   An AddJob call was not issued.  ( ERROR_SPL_NO_ADDJOB              3004L "));
		; break;;case  ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED :  _sprintf(*buf,_T("   The specified print processor has already been installed.  ( ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED 3005L "));
		; break;;case  ERROR_PRINT_MONITOR_ALREADY_INSTALLED :  _sprintf(*buf,_T("   The specified print monitor has already been installed.  ( ERROR_PRINT_MONITOR_ALREADY_INSTALLED 3006L "));
		; break;;case  ERROR_INVALID_PRINT_MONITOR :  _sprintf(*buf,_T("   The specified print monitor does not have the required functions.  ( ERROR_INVALID_PRINT_MONITOR      3007L "));
		; break;;case  ERROR_PRINT_MONITOR_IN_USE :  _sprintf(*buf,_T("   The specified print monitor is currently in use.  ( ERROR_PRINT_MONITOR_IN_USE       3008L "));
		; break;;case  ERROR_PRINTER_HAS_JOBS_QUEUED :  _sprintf(*buf,_T("   The requested operation is not allowed when there are jobs queued to the printer.  ( ERROR_PRINTER_HAS_JOBS_QUEUED    3009L "));
		; break;;case  ERROR_SUCCESS_REBOOT_REQUIRED :  _sprintf(*buf,_T("   The requested operation is successful.  Changes will not be effective until the system is rebooted.  ( ERROR_SUCCESS_REBOOT_REQUIRED    3010L "));
		; break;;case  ERROR_SUCCESS_RESTART_REQUIRED :  _sprintf(*buf,_T("   The requested operation is successful.  Changes will not be effective until the service is restarted.  ( ERROR_SUCCESS_RESTART_REQUIRED   3011L "));
		; break;;case  ERROR_WINS_INTERNAL :  _sprintf(*buf,_T("   WINS encountered an error while processing the command.  ( ERROR_WINS_INTERNAL              4000L "));
		; break;;case  ERROR_CAN_NOT_DEL_LOCAL_WINS :  _sprintf(*buf,_T("   The local WINS can not be deleted.  ( ERROR_CAN_NOT_DEL_LOCAL_WINS     4001L "));
		; break;;case  ERROR_STATIC_INIT :  _sprintf(*buf,_T("   The importation from the file failed.  ( ERROR_STATIC_INIT                4002L "));
		; break;;case  ERROR_INC_BACKUP :  _sprintf(*buf,_T("   The backup failed. Was a full backup done before?  ( ERROR_INC_BACKUP                 4003L "));
		; break;;case  ERROR_FULL_BACKUP :  _sprintf(*buf,_T("   The backup failed. Check the directory to which you are backing the database.  ( ERROR_FULL_BACKUP                4004L "));
		; break;;case  ERROR_REC_NON_EXISTENT :  _sprintf(*buf,_T("   The name does not exist in the WINS database.  ( ERROR_REC_NON_EXISTENT           4005L "));
		; break;;case  ERROR_RPL_NOT_ALLOWED :  _sprintf(*buf,_T("   Replication with a nonconfigured partner is not allowed.  ( ERROR_RPL_NOT_ALLOWED            4006L "));
#ifndef VCPP50
		; break;;case  ERROR_DHCP_ADDRESS_CONFLICT :  _sprintf(*buf,_T("   The DHCP client has obtained an IP address that is already in use on the network.  The local interface will be disabled until the DHCP client can obtain a new address.  ( ERROR_DHCP_ADDRESS_CONFLICT      4100L "));
		; break;;case  ERROR_WMI_GUID_NOT_FOUND :  _sprintf(*buf,_T("   The GUID passed was not recognized as valid by a WMI data provider.  ( ERROR_WMI_GUID_NOT_FOUND         4200L "));
		; break;;case  ERROR_WMI_INSTANCE_NOT_FOUND :  _sprintf(*buf,_T("   The instance name passed was not recognized as valid by a WMI data provider.  ( ERROR_WMI_INSTANCE_NOT_FOUND     4201L "));
		; break;;case  ERROR_WMI_ITEMID_NOT_FOUND :  _sprintf(*buf,_T("   The data item ID passed was not recognized as valid by a WMI data provider.  ( ERROR_WMI_ITEMID_NOT_FOUND       4202L "));
		; break;;case  ERROR_WMI_TRY_AGAIN :  _sprintf(*buf,_T("   The WMI request could not be completed and should be retried.  ( ERROR_WMI_TRY_AGAIN              4203L "));
		; break;;case  ERROR_WMI_DP_NOT_FOUND :  _sprintf(*buf,_T("   The WMI data provider could not be located.  ( ERROR_WMI_DP_NOT_FOUND           4204L "));
		; break;;case  ERROR_WMI_UNRESOLVED_INSTANCE_REF :  _sprintf(*buf,_T("   The WMI data provider references an instance set that has not been registered.  ( ERROR_WMI_UNRESOLVED_INSTANCE_REF 4205L "));
		; break;;case  ERROR_WMI_ALREADY_ENABLED :  _sprintf(*buf,_T("   The WMI data block or event notification has already been enabled.  ( ERROR_WMI_ALREADY_ENABLED        4206L "));
		; break;;case  ERROR_WMI_GUID_DISCONNECTED :  _sprintf(*buf,_T("   The WMI data block is no longer available.  ( ERROR_WMI_GUID_DISCONNECTED      4207L "));
		; break;;case  ERROR_WMI_SERVER_UNAVAILABLE :  _sprintf(*buf,_T("   The WMI data service is not available.  ( ERROR_WMI_SERVER_UNAVAILABLE     4208L "));
		; break;;case  ERROR_WMI_DP_FAILED :  _sprintf(*buf,_T("   The WMI data provider failed to carry out the request.  ( ERROR_WMI_DP_FAILED              4209L "));
		; break;;case  ERROR_WMI_INVALID_MOF :  _sprintf(*buf,_T("   The WMI MOF information is not valid.  ( ERROR_WMI_INVALID_MOF            4210L "));
		; break;;case  ERROR_WMI_INVALID_REGINFO :  _sprintf(*buf,_T("   The WMI registration information is not valid.  ( ERROR_WMI_INVALID_REGINFO        4211L "));
		; break;;case  ERROR_INVALID_MEDIA :  _sprintf(*buf,_T("   The media identifier does not represent a valid medium.  ( ERROR_INVALID_MEDIA              4300L "));
		; break;;case  ERROR_INVALID_LIBRARY :  _sprintf(*buf,_T("   The library identifier does not represent a valid library.  ( ERROR_INVALID_LIBRARY            4301L "));
		; break;;case  ERROR_INVALID_MEDIA_POOL :  _sprintf(*buf,_T("   The media pool identifier does not represent a valid media pool.  ( ERROR_INVALID_MEDIA_POOL         4302L "));
		; break;;case  ERROR_DRIVE_MEDIA_MISMATCH :  _sprintf(*buf,_T("   The drive and medium are not compatible or exist in different libraries.  ( ERROR_DRIVE_MEDIA_MISMATCH       4303L "));
		; break;;case  ERROR_MEDIA_OFFLINE :  _sprintf(*buf,_T("   The medium currently exists in an offline library and must be online to perform this operation.  ( ERROR_MEDIA_OFFLINE              4304L "));
		; break;;case  ERROR_LIBRARY_OFFLINE :  _sprintf(*buf,_T("   The operation cannot be performed on an offline library.  ( ERROR_LIBRARY_OFFLINE            4305L "));
		; break;;case  ERROR_EMPTY :  _sprintf(*buf,_T("   The library, drive, or media pool is empty.  ( ERROR_EMPTY                      4306L "));
		; break;;case  ERROR_NOT_EMPTY :  _sprintf(*buf,_T("   The library, drive, or media pool must be empty to perform this operation.  ( ERROR_NOT_EMPTY                  4307L "));
		; break;;case  ERROR_MEDIA_UNAVAILABLE :  _sprintf(*buf,_T("   No media is currently available in this media pool or library.  ( ERROR_MEDIA_UNAVAILABLE          4308L "));
		; break;;case  ERROR_RESOURCE_DISABLED :  _sprintf(*buf,_T("   A resource required for this operation is disabled.  ( ERROR_RESOURCE_DISABLED          4309L "));
		; break;;case  ERROR_INVALID_CLEANER :  _sprintf(*buf,_T("   The media identifier does not represent a valid cleaner.  ( ERROR_INVALID_CLEANER            4310L "));
		; break;;case  ERROR_UNABLE_TO_CLEAN :  _sprintf(*buf,_T("   The drive cannot be cleaned or does not support cleaning.  ( ERROR_UNABLE_TO_CLEAN            4311L "));
		; break;;case  ERROR_OBJECT_NOT_FOUND :  _sprintf(*buf,_T("   The object identifier does not represent a valid object.  ( ERROR_OBJECT_NOT_FOUND           4312L "));
		; break;;case  ERROR_DATABASE_FAILURE :  _sprintf(*buf,_T("   Unable to read from or write to the database.  ( ERROR_DATABASE_FAILURE           4313L "));
		; break;;case  ERROR_DATABASE_FULL :  _sprintf(*buf,_T("   The database is full.  ( ERROR_DATABASE_FULL              4314L "));
		; break;;case  ERROR_MEDIA_INCOMPATIBLE :  _sprintf(*buf,_T("   The medium is not compatible with the device or media pool.  ( ERROR_MEDIA_INCOMPATIBLE         4315L "));
		; break;;case  ERROR_RESOURCE_NOT_PRESENT :  _sprintf(*buf,_T("   The resource required for this operation does not exist.  ( ERROR_RESOURCE_NOT_PRESENT       4316L "));
		; break;;case  ERROR_INVALID_OPERATION :  _sprintf(*buf,_T("   The operation identifier is not valid.  ( ERROR_INVALID_OPERATION          4317L "));
		; break;;case  ERROR_MEDIA_NOT_AVAILABLE :  _sprintf(*buf,_T("   The media is not mounted or ready for use.  ( ERROR_MEDIA_NOT_AVAILABLE        4318L "));
		; break;;case  ERROR_DEVICE_NOT_AVAILABLE :  _sprintf(*buf,_T("   The device is not ready for use.  ( ERROR_DEVICE_NOT_AVAILABLE       4319L "));
		; break;;case  ERROR_REQUEST_REFUSED :  _sprintf(*buf,_T("   The operator or administrator has refused the request.  ( ERROR_REQUEST_REFUSED            4320L "));
		; break;;case  ERROR_FILE_OFFLINE :  _sprintf(*buf,_T("   The remote storage service was not able to recall the file.  ( ERROR_FILE_OFFLINE               4350L "));
		; break;;case  ERROR_REMOTE_STORAGE_NOT_ACTIVE :  _sprintf(*buf,_T("   The remote storage service is not operational at this time.  ( ERROR_REMOTE_STORAGE_NOT_ACTIVE  4351L "));
		; break;;case  ERROR_REMOTE_STORAGE_MEDIA_ERROR :  _sprintf(*buf,_T("   The remote storage service encountered a media error.  ( ERROR_REMOTE_STORAGE_MEDIA_ERROR 4352L "));
		; break;;case  ERROR_NOT_A_REPARSE_POINT :  _sprintf(*buf,_T("   The file or directory is not a reparse point.  ( ERROR_NOT_A_REPARSE_POINT        4390L "));
		; break;;case  ERROR_REPARSE_ATTRIBUTE_CONFLICT :  _sprintf(*buf,_T("   The reparse point attribute cannot be set because it conflicts with an existing attribute.  ( ERROR_REPARSE_ATTRIBUTE_CONFLICT 4391L "));
		; break;;case  ERROR_DEPENDENT_RESOURCE_EXISTS :  _sprintf(*buf,_T("   The cluster resource cannot be moved to another group because other resources are dependent on it.  ( ERROR_DEPENDENT_RESOURCE_EXISTS  5001L "));
		; break;;case  ERROR_DEPENDENCY_NOT_FOUND :  _sprintf(*buf,_T("   The cluster resource dependency cannot be found.  ( ERROR_DEPENDENCY_NOT_FOUND       5002L "));
		; break;;case  ERROR_DEPENDENCY_ALREADY_EXISTS :  _sprintf(*buf,_T("   The cluster resource cannot be made dependent on the specified resource because it is already dependent.  ( ERROR_DEPENDENCY_ALREADY_EXISTS  5003L "));
		; break;;case  ERROR_RESOURCE_NOT_ONLINE :  _sprintf(*buf,_T("   The cluster resource is not online.  ( ERROR_RESOURCE_NOT_ONLINE        5004L "));
		; break;;case  ERROR_HOST_NODE_NOT_AVAILABLE :  _sprintf(*buf,_T("   A cluster node is not available for this operation.  ( ERROR_HOST_NODE_NOT_AVAILABLE    5005L "));
		; break;;case  ERROR_RESOURCE_NOT_AVAILABLE :  _sprintf(*buf,_T("   The cluster resource is not available.  ( ERROR_RESOURCE_NOT_AVAILABLE     5006L "));
		; break;;case  ERROR_RESOURCE_NOT_FOUND :  _sprintf(*buf,_T("   The cluster resource could not be found.  ( ERROR_RESOURCE_NOT_FOUND         5007L "));
		; break;;case  ERROR_SHUTDOWN_CLUSTER :  _sprintf(*buf,_T("   The cluster is being shut down.  ( ERROR_SHUTDOWN_CLUSTER           5008L "));
		; break;;case  ERROR_CANT_EVICT_ACTIVE_NODE :  _sprintf(*buf,_T("   A cluster node cannot be evicted from the cluster while it is online.  ( ERROR_CANT_EVICT_ACTIVE_NODE     5009L "));
		; break;;case  ERROR_OBJECT_ALREADY_EXISTS :  _sprintf(*buf,_T("   The object already exists.  ( ERROR_OBJECT_ALREADY_EXISTS      5010L "));
		; break;;case  ERROR_OBJECT_IN_LIST :  _sprintf(*buf,_T("   The object is already in the list.  ( ERROR_OBJECT_IN_LIST             5011L "));
		; break;;case  ERROR_GROUP_NOT_AVAILABLE :  _sprintf(*buf,_T("   The cluster group is not available for any new requests.  ( ERROR_GROUP_NOT_AVAILABLE        5012L "));
		; break;;case  ERROR_GROUP_NOT_FOUND :  _sprintf(*buf,_T("   The cluster group could not be found.  ( ERROR_GROUP_NOT_FOUND            5013L "));
		; break;;case  ERROR_GROUP_NOT_ONLINE :  _sprintf(*buf,_T("   The operation could not be completed because the cluster group is not online.  ( ERROR_GROUP_NOT_ONLINE           5014L "));
		; break;;case  ERROR_HOST_NODE_NOT_RESOURCE_OWNER :  _sprintf(*buf,_T("   The cluster node is not the owner of the resource.  ( ERROR_HOST_NODE_NOT_RESOURCE_OWNER 5015L "));
		; break;;case  ERROR_HOST_NODE_NOT_GROUP_OWNER :  _sprintf(*buf,_T("   The cluster node is not the owner of the group.  ( ERROR_HOST_NODE_NOT_GROUP_OWNER  5016L "));
		; break;;case  ERROR_RESMON_CREATE_FAILED :  _sprintf(*buf,_T("   The cluster resource could not be created in the specified resource monitor.  ( ERROR_RESMON_CREATE_FAILED       5017L "));
		; break;;case  ERROR_RESMON_ONLINE_FAILED :  _sprintf(*buf,_T("   The cluster resource could not be brought online by the resource monitor.  ( ERROR_RESMON_ONLINE_FAILED       5018L "));
		; break;;case  ERROR_RESOURCE_ONLINE :  _sprintf(*buf,_T("   The operation could not be completed because the cluster resource is online.  ( ERROR_RESOURCE_ONLINE            5019L "));
		; break;;case  ERROR_QUORUM_RESOURCE :  _sprintf(*buf,_T("   The cluster resource could not be deleted or brought offline because it is the quorum resource.  ( ERROR_QUORUM_RESOURCE            5020L "));
		; break;;case  ERROR_NOT_QUORUM_CAPABLE :  _sprintf(*buf,_T("   The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource.  ( ERROR_NOT_QUORUM_CAPABLE         5021L "));
		; break;;case  ERROR_CLUSTER_SHUTTING_DOWN :  _sprintf(*buf,_T("   The cluster software is shutting down.  ( ERROR_CLUSTER_SHUTTING_DOWN      5022L "));
		; break;;case  ERROR_INVALID_STATE :  _sprintf(*buf,_T("   The group or resource is not in the correct state to perform the requested operation.  ( ERROR_INVALID_STATE              5023L "));
		; break;;case  ERROR_RESOURCE_PROPERTIES_STORED :  _sprintf(*buf,_T("   The properties were stored but not all changes will take effect until the next time the resource is brought online.  ( ERROR_RESOURCE_PROPERTIES_STORED 5024L "));
		; break;;case  ERROR_NOT_QUORUM_CLASS :  _sprintf(*buf,_T("   The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class.  ( ERROR_NOT_QUORUM_CLASS           5025L "));
		; break;;case  ERROR_CORE_RESOURCE :  _sprintf(*buf,_T("   The cluster resource could not be deleted since it is a core resource.  ( ERROR_CORE_RESOURCE              5026L "));
		; break;;case  ERROR_QUORUM_RESOURCE_ONLINE_FAILED :  _sprintf(*buf,_T("   The quorum resource failed to come online.  ( ERROR_QUORUM_RESOURCE_ONLINE_FAILED 5027L "));
		; break;;case  ERROR_QUORUMLOG_OPEN_FAILED :  _sprintf(*buf,_T("   The quorum log could not be created or mounted successfully.  ( ERROR_QUORUMLOG_OPEN_FAILED      5028L "));
		; break;;case  ERROR_CLUSTERLOG_CORRUPT :  _sprintf(*buf,_T("   The cluster log is corrupt.  ( ERROR_CLUSTERLOG_CORRUPT         5029L "));
		; break;;case  ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE :  _sprintf(*buf,_T("   The record could not be written to the cluster log since it exceeds the maximum size.  ( ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE 5030L "));
		; break;;case  ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE :  _sprintf(*buf,_T("   The cluster log exceeds its maximum size.  ( ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE 5031L "));
		; break;;case  ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND :  _sprintf(*buf,_T("   No checkpoint record was found in the cluster log.  ( ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND 5032L "));
		; break;;case  ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE :  _sprintf(*buf,_T("   The minimum required disk space needed for logging is not available.  ( ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE 5033L "));
		; break;;case  ERROR_ENCRYPTION_FAILED :  _sprintf(*buf,_T("   The specified file could not be encrypted.  ( ERROR_ENCRYPTION_FAILED          6000L "));
		; break;;case  ERROR_DECRYPTION_FAILED :  _sprintf(*buf,_T("   The specified file could not be decrypted.  ( ERROR_DECRYPTION_FAILED          6001L "));
		; break;;case  ERROR_FILE_ENCRYPTED :  _sprintf(*buf,_T("   The specified file is encrypted and the user does not have the ability to decrypt it.  ( ERROR_FILE_ENCRYPTED             6002L "));
		; break;;case  ERROR_NO_RECOVERY_POLICY :  _sprintf(*buf,_T("   There is no encryption recovery policy configured for this system.  ( ERROR_NO_RECOVERY_POLICY         6003L "));
		; break;;case  ERROR_NO_EFS :  _sprintf(*buf,_T("   The required encryption driver is not loaded for this system.  ( ERROR_NO_EFS                     6004L "));
		; break;;case  ERROR_WRONG_EFS :  _sprintf(*buf,_T("   The file was encrypted with a different encryption driver than is currently loaded.  ( ERROR_WRONG_EFS                  6005L "));
		; break;;case  ERROR_NO_USER_KEYS :  _sprintf(*buf,_T("   There are no EFS keys defined for the user.  ( ERROR_NO_USER_KEYS               6006L "));
		; break;;case  ERROR_FILE_NOT_ENCRYPTED :  _sprintf(*buf,_T("   The specified file is not encrypted.  ( ERROR_FILE_NOT_ENCRYPTED         6007L "));
		; break;;case  ERROR_NOT_EXPORT_FORMAT :  _sprintf(*buf,_T("   The specified file is not in the defined EFS export format.  ( ERROR_NOT_EXPORT_FORMAT          6008L "));
#endif
		; break;;case  E_UNEXPECTED :  _sprintf(*buf,_T("   Catastrophic failure  ( E_UNEXPECTED                     _HRESULT_TYPEDEF_(0x8000FFFFL) "));
		; break;;case  E_NOTIMPL :  _sprintf(*buf,_T("   Not implemented  ( E_NOTIMPL                        _HRESULT_TYPEDEF_(0x80004001L) "));
		; break;;case  E_OUTOFMEMORY :  _sprintf(*buf,_T("   Ran out of memory  ( E_OUTOFMEMORY                    _HRESULT_TYPEDEF_(0x8007000EL) "));
		; break;;case  E_INVALIDARG :  _sprintf(*buf,_T("   One or more arguments are invalid  ( E_INVALIDARG                     _HRESULT_TYPEDEF_(0x80070057L) "));
		; break;;case  E_NOINTERFACE :  _sprintf(*buf,_T("   No such interface supported  ( E_NOINTERFACE                    _HRESULT_TYPEDEF_(0x80004002L) "));
		; break;;case  E_POINTER :  _sprintf(*buf,_T("   Invalid pointer  ( E_POINTER                        _HRESULT_TYPEDEF_(0x80004003L) "));
		; break;;case  E_HANDLE :  _sprintf(*buf,_T("   Invalid handle  ( E_HANDLE                         _HRESULT_TYPEDEF_(0x80070006L) "));
		; break;;case  E_ABORT :  _sprintf(*buf,_T("   Operation aborted  ( E_ABORT                          _HRESULT_TYPEDEF_(0x80004004L) "));
		; break;;case  E_FAIL :  _sprintf(*buf,_T("   Unspecified error  ( E_FAIL                           _HRESULT_TYPEDEF_(0x80004005L) "));
		; break;;case  E_ACCESSDENIED :  _sprintf(*buf,_T("   General access denied error  ( E_ACCESSDENIED                   _HRESULT_TYPEDEF_(0x80070005L) "));
	/*	; break;;case  E_NOTIMPL :  _sprintf(*buf,_T("   Not implemented  ( E_NOTIMPL                        _HRESULT_TYPEDEF_(0x80000001L) "));
		; break;;case  E_OUTOFMEMORY :  _sprintf(*buf,_T("   Ran out of memory  ( E_OUTOFMEMORY                    _HRESULT_TYPEDEF_(0x80000002L) "));
		; break;;case  E_INVALIDARG :  _sprintf(*buf,_T("   One or more arguments are invalid  ( E_INVALIDARG                     _HRESULT_TYPEDEF_(0x80000003L) "));
		; break;;case  E_NOINTERFACE :  _sprintf(*buf,_T("   No such interface supported  ( E_NOINTERFACE                    _HRESULT_TYPEDEF_(0x80000004L) "));
		; break;;case  E_POINTER :  _sprintf(*buf,_T("   Invalid pointer  ( E_POINTER                        _HRESULT_TYPEDEF_(0x80000005L) "));
		; break;;case  E_HANDLE :  _sprintf(*buf,_T("   Invalid handle  ( E_HANDLE                         _HRESULT_TYPEDEF_(0x80000006L) "));
		; break;;case  E_ABORT :  _sprintf(*buf,_T("   Operation aborted  ( E_ABORT                          _HRESULT_TYPEDEF_(0x80000007L) "));
		; break;;case  E_FAIL :  _sprintf(*buf,_T("   Unspecified error  ( E_FAIL                           _HRESULT_TYPEDEF_(0x80000008L) "));
		; break;;case  E_ACCESSDENIED :  _sprintf(*buf,_T("   General access denied error  ( E_ACCESSDENIED                   _HRESULT_TYPEDEF_(0x80000009L) "));
	*/	; break;;case  E_PENDING :  _sprintf(*buf,_T("   The data necessary to complete this operation is not yet available.  ( E_PENDING                        _HRESULT_TYPEDEF_(0x8000000AL) "));
		; break;;case  CO_E_INIT_TLS :  _sprintf(*buf,_T("   Thread local storage failure  ( CO_E_INIT_TLS                    _HRESULT_TYPEDEF_(0x80004006L) "));
		; break;;case  CO_E_INIT_SHARED_ALLOCATOR :  _sprintf(*buf,_T("   Get shared memory allocator failure  ( CO_E_INIT_SHARED_ALLOCATOR       _HRESULT_TYPEDEF_(0x80004007L) "));
		; break;;case  CO_E_INIT_MEMORY_ALLOCATOR :  _sprintf(*buf,_T("   Get memory allocator failure  ( CO_E_INIT_MEMORY_ALLOCATOR       _HRESULT_TYPEDEF_(0x80004008L) "));
		; break;;case  CO_E_INIT_CLASS_CACHE :  _sprintf(*buf,_T("   Unable to initialize class cache  ( CO_E_INIT_CLASS_CACHE            _HRESULT_TYPEDEF_(0x80004009L) "));
		; break;;case  CO_E_INIT_RPC_CHANNEL :  _sprintf(*buf,_T("   Unable to initialize RPC services  ( CO_E_INIT_RPC_CHANNEL            _HRESULT_TYPEDEF_(0x8000400AL) "));
		; break;;case  CO_E_INIT_TLS_SET_CHANNEL_CONTROL :  _sprintf(*buf,_T("   Cannot set thread local storage channel control  ( CO_E_INIT_TLS_SET_CHANNEL_CONTROL _HRESULT_TYPEDEF_(0x8000400BL) "));
		; break;;case  CO_E_INIT_TLS_CHANNEL_CONTROL :  _sprintf(*buf,_T("   Could not allocate thread local storage channel control  ( CO_E_INIT_TLS_CHANNEL_CONTROL    _HRESULT_TYPEDEF_(0x8000400CL) "));
		; break;;case  CO_E_INIT_UNACCEPTED_USER_ALLOCATOR :  _sprintf(*buf,_T("   The user supplied memory allocator is unacceptable  ( CO_E_INIT_UNACCEPTED_USER_ALLOCATOR _HRESULT_TYPEDEF_(0x8000400DL) "));
		; break;;case  CO_E_INIT_SCM_MUTEX_EXISTS :  _sprintf(*buf,_T("   The OLE service mutex already exists  ( CO_E_INIT_SCM_MUTEX_EXISTS       _HRESULT_TYPEDEF_(0x8000400EL) "));
		; break;;case  CO_E_INIT_SCM_FILE_MAPPING_EXISTS :  _sprintf(*buf,_T("   The OLE service file mapping already exists  ( CO_E_INIT_SCM_FILE_MAPPING_EXISTS _HRESULT_TYPEDEF_(0x8000400FL) "));
		; break;;case  CO_E_INIT_SCM_MAP_VIEW_OF_FILE :  _sprintf(*buf,_T("   Unable to map view of file for OLE service  ( CO_E_INIT_SCM_MAP_VIEW_OF_FILE   _HRESULT_TYPEDEF_(0x80004010L) "));
		; break;;case  CO_E_INIT_SCM_EXEC_FAILURE :  _sprintf(*buf,_T("   Failure attempting to launch OLE service  ( CO_E_INIT_SCM_EXEC_FAILURE       _HRESULT_TYPEDEF_(0x80004011L) "));
		; break;;case  CO_E_INIT_ONLY_SINGLE_THREADED :  _sprintf(*buf,_T("   There was an attempt to call CoInitialize a second time while single threaded  ( CO_E_INIT_ONLY_SINGLE_THREADED   _HRESULT_TYPEDEF_(0x80004012L) "));
		; break;;case  CO_E_CANT_REMOTE :  _sprintf(*buf,_T("   A Remote activation was necessary but was not allowed  ( CO_E_CANT_REMOTE                 _HRESULT_TYPEDEF_(0x80004013L) "));
		; break;;case  CO_E_BAD_SERVER_NAME :  _sprintf(*buf,_T("   A Remote activation was necessary but the server name provided was invalid  ( CO_E_BAD_SERVER_NAME             _HRESULT_TYPEDEF_(0x80004014L) "));
		; break;;case  CO_E_WRONG_SERVER_IDENTITY :  _sprintf(*buf,_T("   The class is configured to run as a security id different from the caller  ( CO_E_WRONG_SERVER_IDENTITY       _HRESULT_TYPEDEF_(0x80004015L) "));
		; break;;case  CO_E_OLE1DDE_DISABLED :  _sprintf(*buf,_T("   Use of Ole1 services requiring DDE windows is disabled  ( CO_E_OLE1DDE_DISABLED            _HRESULT_TYPEDEF_(0x80004016L) "));
		; break;;case  CO_E_RUNAS_SYNTAX :  _sprintf(*buf,_T("   A RunAs specification must be <domain name><user name> or simply <user name>  ( CO_E_RUNAS_SYNTAX                _HRESULT_TYPEDEF_(0x80004017L) "));
		; break;;case  CO_E_CREATEPROCESS_FAILURE :  _sprintf(*buf,_T("   The server process could not be started.  The pathname may be incorrect.  ( CO_E_CREATEPROCESS_FAILURE       _HRESULT_TYPEDEF_(0x80004018L) "));
		; break;;case  CO_E_RUNAS_CREATEPROCESS_FAILURE :  _sprintf(*buf,_T("   The server process could not be started as the configured identity.  The pathname may be incorrect or unavailable.  ( CO_E_RUNAS_CREATEPROCESS_FAILURE _HRESULT_TYPEDEF_(0x80004019L) "));
		; break;;case  CO_E_RUNAS_LOGON_FAILURE :  _sprintf(*buf,_T("   The server process could not be started because the configured identity is incorrect.  Check the username and password.  ( CO_E_RUNAS_LOGON_FAILURE         _HRESULT_TYPEDEF_(0x8000401AL) "));
		; break;;case  CO_E_LAUNCH_PERMSSION_DENIED :  _sprintf(*buf,_T("   The client is not allowed to launch this server.  ( CO_E_LAUNCH_PERMSSION_DENIED     _HRESULT_TYPEDEF_(0x8000401BL) "));
		; break;;case  CO_E_START_SERVICE_FAILURE :  _sprintf(*buf,_T("   The service providing this server could not be started.  ( CO_E_START_SERVICE_FAILURE       _HRESULT_TYPEDEF_(0x8000401CL) "));
		; break;;case  CO_E_REMOTE_COMMUNICATION_FAILURE :  _sprintf(*buf,_T("   This computer was unable to communicate with the computer providing the server.  ( CO_E_REMOTE_COMMUNICATION_FAILURE _HRESULT_TYPEDEF_(0x8000401DL) "));
		; break;;case  CO_E_SERVER_START_TIMEOUT :  _sprintf(*buf,_T("   The server did not respond after being launched.  ( CO_E_SERVER_START_TIMEOUT        _HRESULT_TYPEDEF_(0x8000401EL) "));
		; break;;case  CO_E_CLSREG_INCONSISTENT :  _sprintf(*buf,_T("   The registration information for this server is inconsistent or incomplete.  ( CO_E_CLSREG_INCONSISTENT         _HRESULT_TYPEDEF_(0x8000401FL) "));
		; break;;case  CO_E_IIDREG_INCONSISTENT :  _sprintf(*buf,_T("   The registration information for this interface is inconsistent or incomplete.  ( CO_E_IIDREG_INCONSISTENT         _HRESULT_TYPEDEF_(0x80004020L) "));
		; break;;case  CO_E_NOT_SUPPORTED :  _sprintf(*buf,_T("   The operation attempted is not supported.  ( CO_E_NOT_SUPPORTED               _HRESULT_TYPEDEF_(0x80004021L) "));
#ifndef VCPP50
		; break;;case  CO_E_RELOAD_DLL :  _sprintf(*buf,_T("   A dll must be loaded.  ( CO_E_RELOAD_DLL                  _HRESULT_TYPEDEF_(0x80004022L) "));
		; break;;case  CO_E_MSI_ERROR :  _sprintf(*buf,_T("   A Microsoft Software Installer error was encountered.  ( CO_E_MSI_ERROR                   _HRESULT_TYPEDEF_(0x80004023L) "));
#endif
		; break;;case  OLE_E_OLEVERB :  _sprintf(*buf,_T("   Invalid OLEVERB structure  ( OLE_E_OLEVERB                    _HRESULT_TYPEDEF_(0x80040000L) "));
		; break;;case  OLE_E_ADVF :  _sprintf(*buf,_T("   Invalid advise flags  ( OLE_E_ADVF                       _HRESULT_TYPEDEF_(0x80040001L) "));
		; break;;case  OLE_E_ENUM_NOMORE :  _sprintf(*buf,_T("   Can't enumerate any more, because the associated data is missing  ( OLE_E_ENUM_NOMORE                _HRESULT_TYPEDEF_(0x80040002L) "));
		; break;;case  OLE_E_ADVISENOTSUPPORTED :  _sprintf(*buf,_T("   This implementation doesn't take advises  ( OLE_E_ADVISENOTSUPPORTED         _HRESULT_TYPEDEF_(0x80040003L) "));
		; break;;case  OLE_E_NOCONNECTION :  _sprintf(*buf,_T("   There is no connection for this connection ID  ( OLE_E_NOCONNECTION               _HRESULT_TYPEDEF_(0x80040004L) "));
		; break;;case  OLE_E_NOTRUNNING :  _sprintf(*buf,_T("   Need to run the object to perform this operation  ( OLE_E_NOTRUNNING                 _HRESULT_TYPEDEF_(0x80040005L) "));
		; break;;case  OLE_E_NOCACHE :  _sprintf(*buf,_T("   There is no cache to operate on  ( OLE_E_NOCACHE                    _HRESULT_TYPEDEF_(0x80040006L) "));
		; break;;case  OLE_E_BLANK :  _sprintf(*buf,_T("   Uninitialized object  ( OLE_E_BLANK                      _HRESULT_TYPEDEF_(0x80040007L) "));
		; break;;case  OLE_E_CLASSDIFF :  _sprintf(*buf,_T("   Linked object's source class has changed  ( OLE_E_CLASSDIFF                  _HRESULT_TYPEDEF_(0x80040008L) "));
		; break;;case  OLE_E_CANT_GETMONIKER :  _sprintf(*buf,_T("   Not able to get the moniker of the object  ( OLE_E_CANT_GETMONIKER            _HRESULT_TYPEDEF_(0x80040009L) "));
		; break;;case  OLE_E_CANT_BINDTOSOURCE :  _sprintf(*buf,_T("   Not able to bind to the source  ( OLE_E_CANT_BINDTOSOURCE          _HRESULT_TYPEDEF_(0x8004000AL) "));
		; break;;case  OLE_E_STATIC :  _sprintf(*buf,_T("   Object is static; operation not allowed  ( OLE_E_STATIC                     _HRESULT_TYPEDEF_(0x8004000BL) "));
		; break;;case  OLE_E_PROMPTSAVECANCELLED :  _sprintf(*buf,_T("   User canceled out of save dialog  ( OLE_E_PROMPTSAVECANCELLED        _HRESULT_TYPEDEF_(0x8004000CL) "));
		; break;;case  OLE_E_INVALIDRECT :  _sprintf(*buf,_T("   Invalid rectangle  ( OLE_E_INVALIDRECT                _HRESULT_TYPEDEF_(0x8004000DL) "));
		; break;;case  OLE_E_WRONGCOMPOBJ :  _sprintf(*buf,_T("   compobj.dll is too old for the ole2.dll initialized  ( OLE_E_WRONGCOMPOBJ               _HRESULT_TYPEDEF_(0x8004000EL) "));
		; break;;case  OLE_E_INVALIDHWND :  _sprintf(*buf,_T("   Invalid window handle  ( OLE_E_INVALIDHWND                _HRESULT_TYPEDEF_(0x8004000FL) "));
		; break;;case  OLE_E_NOT_INPLACEACTIVE :  _sprintf(*buf,_T("   Object is not in any of the inplace active states  ( OLE_E_NOT_INPLACEACTIVE          _HRESULT_TYPEDEF_(0x80040010L) "));
		; break;;case  OLE_E_CANTCONVERT :  _sprintf(*buf,_T("   Not able to convert object  ( OLE_E_CANTCONVERT                _HRESULT_TYPEDEF_(0x80040011L) "));
		; break;;case  OLE_E_NOSTORAGE :  _sprintf(*buf,_T("   Not able to perform the operation because object is not given storage yet  ( OLE_E_NOSTORAGE                  _HRESULT_TYPEDEF_(0x80040012L) "));
		; break;;case  DV_E_FORMATETC :  _sprintf(*buf,_T("   Invalid FORMATETC structure  ( DV_E_FORMATETC                   _HRESULT_TYPEDEF_(0x80040064L) "));
		; break;;case  DV_E_DVTARGETDEVICE :  _sprintf(*buf,_T("   Invalid DVTARGETDEVICE structure  ( DV_E_DVTARGETDEVICE              _HRESULT_TYPEDEF_(0x80040065L) "));
		; break;;case  DV_E_STGMEDIUM :  _sprintf(*buf,_T("   Invalid STDGMEDIUM structure  ( DV_E_STGMEDIUM                   _HRESULT_TYPEDEF_(0x80040066L) "));
		; break;;case  DV_E_STATDATA :  _sprintf(*buf,_T("   Invalid STATDATA structure  ( DV_E_STATDATA                    _HRESULT_TYPEDEF_(0x80040067L) "));
		; break;;case  DV_E_LINDEX :  _sprintf(*buf,_T("   Invalid lindex  ( DV_E_LINDEX                      _HRESULT_TYPEDEF_(0x80040068L) "));
		; break;;case  DV_E_TYMED :  _sprintf(*buf,_T("   Invalid tymed  ( DV_E_TYMED                       _HRESULT_TYPEDEF_(0x80040069L) "));
		; break;;case  DV_E_CLIPFORMAT :  _sprintf(*buf,_T("   Invalid clipboard format  ( DV_E_CLIPFORMAT                  _HRESULT_TYPEDEF_(0x8004006AL) "));
		; break;;case  DV_E_DVASPECT :  _sprintf(*buf,_T("   Invalid aspect(s)  ( DV_E_DVASPECT                    _HRESULT_TYPEDEF_(0x8004006BL) "));
		; break;;case  DV_E_DVTARGETDEVICE_SIZE :  _sprintf(*buf,_T("   tdSize parameter of the DVTARGETDEVICE structure is invalid  ( DV_E_DVTARGETDEVICE_SIZE         _HRESULT_TYPEDEF_(0x8004006CL) "));
		; break;;case  DV_E_NOIVIEWOBJECT :  _sprintf(*buf,_T("   Object doesn't support IViewObject interface  ( DV_E_NOIVIEWOBJECT               _HRESULT_TYPEDEF_(0x8004006DL)  ( DRAGDROP_E_FIRST 0x80040100L"));
		; break;;case  DRAGDROP_E_NOTREGISTERED :  _sprintf(*buf,_T("   Trying to revoke a drop target that has not been registered  ( DRAGDROP_E_NOTREGISTERED         _HRESULT_TYPEDEF_(0x80040100L) "));
		; break;;case  DRAGDROP_E_ALREADYREGISTERED :  _sprintf(*buf,_T("   This window has already been registered as a drop target  ( DRAGDROP_E_ALREADYREGISTERED     _HRESULT_TYPEDEF_(0x80040101L) "));
		; break;;case  DRAGDROP_E_INVALIDHWND :  _sprintf(*buf,_T("   Invalid window handle  ( DRAGDROP_E_INVALIDHWND           _HRESULT_TYPEDEF_(0x80040102L)  ( CLASSFACTORY_E_FIRST  0x80040110L"));
		; break;;case  CLASS_E_NOAGGREGATION :  _sprintf(*buf,_T("   Class does not support aggregation (or class object is remote)  ( CLASS_E_NOAGGREGATION            _HRESULT_TYPEDEF_(0x80040110L) "));
		; break;;case  CLASS_E_CLASSNOTAVAILABLE :  _sprintf(*buf,_T("   ClassFactory cannot supply requested class  ( CLASS_E_CLASSNOTAVAILABLE        _HRESULT_TYPEDEF_(0x80040111L) "));
		; break;;case  CLASS_E_NOTLICENSED :  _sprintf(*buf,_T("   Class is not licensed for use  ( CLASS_E_NOTLICENSED              _HRESULT_TYPEDEF_(0x80040112L)  ( MARSHAL_E_FIRST  0x80040120L"));
		; break;;case  VIEW_E_DRAW :  _sprintf(*buf,_T("   Error drawing view  ( VIEW_E_DRAW                      _HRESULT_TYPEDEF_(0x80040140L)  ( REGDB_E_FIRST     0x80040150L"));
		; break;;case  REGDB_E_READREGDB :  _sprintf(*buf,_T("   Could not read key from registry  ( REGDB_E_READREGDB                _HRESULT_TYPEDEF_(0x80040150L) "));
		; break;;case  REGDB_E_WRITEREGDB :  _sprintf(*buf,_T("   Could not write key to registry  ( REGDB_E_WRITEREGDB               _HRESULT_TYPEDEF_(0x80040151L) "));
		; break;;case  REGDB_E_KEYMISSING :  _sprintf(*buf,_T("   Could not find the key in the registry  ( REGDB_E_KEYMISSING               _HRESULT_TYPEDEF_(0x80040152L) "));
		; break;;case  REGDB_E_INVALIDVALUE :  _sprintf(*buf,_T("   Invalid value for registry  ( REGDB_E_INVALIDVALUE             _HRESULT_TYPEDEF_(0x80040153L) "));
		; break;;case  REGDB_E_CLASSNOTREG :  _sprintf(*buf,_T("   Class not registered  ( REGDB_E_CLASSNOTREG              _HRESULT_TYPEDEF_(0x80040154L) "));
		; break;;case  REGDB_E_IIDNOTREG :  _sprintf(*buf,_T("   Interface not registered  ( REGDB_E_IIDNOTREG                _HRESULT_TYPEDEF_(0x80040155L)  ( CAT_E_FIRST     0x80040160L"));
#ifndef VCPP50
		; break;;case  CAT_E_CATIDNOEXIST :  _sprintf(*buf,_T("   CATID does not exist  ( CAT_E_CATIDNOEXIST               _HRESULT_TYPEDEF_(0x80040160L) "));
		; break;;case  CAT_E_NODESCRIPTION :  _sprintf(*buf,_T("   Description not found  ( CAT_E_NODESCRIPTION              _HRESULT_TYPEDEF_(0x80040161L) "));
		; break;;case  CS_E_PACKAGE_NOTFOUND :  _sprintf(*buf,_T("   No package in Class Store meets this criteria  ( CS_E_PACKAGE_NOTFOUND            _HRESULT_TYPEDEF_(0x80040164L) "));
		; break;;case  CS_E_NOT_DELETABLE :  _sprintf(*buf,_T("   Deleting this will break referential integrity  ( CS_E_NOT_DELETABLE               _HRESULT_TYPEDEF_(0x80040165L) "));
		; break;;case  CS_E_CLASS_NOTFOUND :  _sprintf(*buf,_T("   No such CLSID in Class Store  ( CS_E_CLASS_NOTFOUND              _HRESULT_TYPEDEF_(0x80040166L) "));
		; break;;case  CS_E_INVALID_VERSION :  _sprintf(*buf,_T("   The Class Store is corrupted or has a version that is no more supported  ( CS_E_INVALID_VERSION             _HRESULT_TYPEDEF_(0x80040167L) "));
		; break;;case  CS_E_NO_CLASSSTORE :  _sprintf(*buf,_T("   No such Class Store  ( CS_E_NO_CLASSSTORE               _HRESULT_TYPEDEF_(0x80040168L)  ( CACHE_E_FIRST     0x80040170L"));
		; break;;case  CACHE_E_NOCACHE_UPDATED :  _sprintf(*buf,_T("   Cache not updated  ( CACHE_E_NOCACHE_UPDATED          _HRESULT_TYPEDEF_(0x80040170L)  ( OLEOBJ_E_FIRST     0x80040180L"));
		; break;;case  OLEOBJ_E_NOVERBS :  _sprintf(*buf,_T("   No verbs for OLE object  ( OLEOBJ_E_NOVERBS                 _HRESULT_TYPEDEF_(0x80040180L) "));
		; break;;case  OLEOBJ_E_INVALIDVERB :  _sprintf(*buf,_T("   Invalid verb for OLE object  ( OLEOBJ_E_INVALIDVERB             _HRESULT_TYPEDEF_(0x80040181L)  ( CLIENTSITE_E_FIRST     0x80040190L"));
		; break;;case  INPLACE_E_NOTUNDOABLE :  _sprintf(*buf,_T("   Undo is not available  ( INPLACE_E_NOTUNDOABLE            _HRESULT_TYPEDEF_(0x800401A0L) "));
		; break;;case  INPLACE_E_NOTOOLSPACE :  _sprintf(*buf,_T("   Space for tools is not available  ( INPLACE_E_NOTOOLSPACE            _HRESULT_TYPEDEF_(0x800401A1L)  ( INPLACE_E_FIRST     0x800401A0L"));
		; break;;case  CONVERT10_E_OLESTREAM_GET :  _sprintf(*buf,_T("   OLESTREAM Get method failed  ( CONVERT10_E_OLESTREAM_GET        _HRESULT_TYPEDEF_(0x800401C0L) "));
		; break;;case  CONVERT10_E_OLESTREAM_PUT :  _sprintf(*buf,_T("   OLESTREAM Put method failed  ( CONVERT10_E_OLESTREAM_PUT        _HRESULT_TYPEDEF_(0x800401C1L) "));
		; break;;case  CONVERT10_E_OLESTREAM_FMT :  _sprintf(*buf,_T("   Contents of the OLESTREAM not in correct format  ( CONVERT10_E_OLESTREAM_FMT        _HRESULT_TYPEDEF_(0x800401C2L) "));
		; break;;case  CONVERT10_E_OLESTREAM_BITMAP_TO_DIB :  _sprintf(*buf,_T("   There was an error in a Windows GDI call while converting the bitmap to a DIB  ( CONVERT10_E_OLESTREAM_BITMAP_TO_DIB _HRESULT_TYPEDEF_(0x800401C3L) "));
		; break;;case  CONVERT10_E_STG_FMT :  _sprintf(*buf,_T("   Contents of the IStorage not in correct format  ( CONVERT10_E_STG_FMT              _HRESULT_TYPEDEF_(0x800401C4L) "));
		; break;;case  CONVERT10_E_STG_NO_STD_STREAM :  _sprintf(*buf,_T("   Contents of IStorage is missing one of the standard streams  ( CONVERT10_E_STG_NO_STD_STREAM    _HRESULT_TYPEDEF_(0x800401C5L) "));
		; break;;case  CONVERT10_E_STG_DIB_TO_BITMAP :  _sprintf(*buf,_T("   There was an error in a Windows GDI call while converting the DIB to a bitmap.  ( CONVERT10_E_STG_DIB_TO_BITMAP    _HRESULT_TYPEDEF_(0x800401C6L)  ( CLIPBRD_E_FIRST        0x800401D0L"));
		; break;;case  CLIPBRD_E_CANT_OPEN :  _sprintf(*buf,_T("   OpenClipboard Failed  ( CLIPBRD_E_CANT_OPEN              _HRESULT_TYPEDEF_(0x800401D0L) "));
		; break;;case  CLIPBRD_E_CANT_EMPTY :  _sprintf(*buf,_T("   EmptyClipboard Failed  ( CLIPBRD_E_CANT_EMPTY             _HRESULT_TYPEDEF_(0x800401D1L) "));
		; break;;case  CLIPBRD_E_CANT_SET :  _sprintf(*buf,_T("   SetClipboard Failed  ( CLIPBRD_E_CANT_SET               _HRESULT_TYPEDEF_(0x800401D2L) "));
		; break;;case  CLIPBRD_E_BAD_DATA :  _sprintf(*buf,_T("   Data on clipboard is invalid  ( CLIPBRD_E_BAD_DATA               _HRESULT_TYPEDEF_(0x800401D3L) "));
		; break;;case  CLIPBRD_E_CANT_CLOSE :  _sprintf(*buf,_T("   CloseClipboard Failed  ( CLIPBRD_E_CANT_CLOSE             _HRESULT_TYPEDEF_(0x800401D4L)  ( MK_E_FIRST        0x800401E0L"));
		; break;;case  MK_E_CONNECTMANUALLY :  _sprintf(*buf,_T("   Moniker needs to be connected manually  ( MK_E_CONNECTMANUALLY             _HRESULT_TYPEDEF_(0x800401E0L) "));
		; break;;case  MK_E_EXCEEDEDDEADLINE :  _sprintf(*buf,_T("   Operation exceeded deadline  ( MK_E_EXCEEDEDDEADLINE            _HRESULT_TYPEDEF_(0x800401E1L) "));
		; break;;case  MK_E_NEEDGENERIC :  _sprintf(*buf,_T("   Moniker needs to be generic  ( MK_E_NEEDGENERIC                 _HRESULT_TYPEDEF_(0x800401E2L) "));
		; break;;case  MK_E_UNAVAILABLE :  _sprintf(*buf,_T("   Operation unavailable  ( MK_E_UNAVAILABLE                 _HRESULT_TYPEDEF_(0x800401E3L) "));
		; break;;case  MK_E_SYNTAX :  _sprintf(*buf,_T("   Invalid syntax  ( MK_E_SYNTAX                      _HRESULT_TYPEDEF_(0x800401E4L) "));
		; break;;case  MK_E_NOOBJECT :  _sprintf(*buf,_T("   No object for moniker  ( MK_E_NOOBJECT                    _HRESULT_TYPEDEF_(0x800401E5L) "));
		; break;;case  MK_E_INVALIDEXTENSION :  _sprintf(*buf,_T("   Bad extension for file  ( MK_E_INVALIDEXTENSION            _HRESULT_TYPEDEF_(0x800401E6L) "));
		; break;;case  MK_E_INTERMEDIATEINTERFACENOTSUPPORTED :  _sprintf(*buf,_T("   Intermediate operation failed  ( MK_E_INTERMEDIATEINTERFACENOTSUPPORTED _HRESULT_TYPEDEF_(0x800401E7L) "));
		; break;;case  MK_E_NOTBINDABLE :  _sprintf(*buf,_T("   Moniker is not bindable  ( MK_E_NOTBINDABLE                 _HRESULT_TYPEDEF_(0x800401E8L) "));
		; break;;case  MK_E_NOTBOUND :  _sprintf(*buf,_T("   Moniker is not bound  ( MK_E_NOTBOUND                    _HRESULT_TYPEDEF_(0x800401E9L) "));
		; break;;case  MK_E_CANTOPENFILE :  _sprintf(*buf,_T("   Moniker cannot open file  ( MK_E_CANTOPENFILE                _HRESULT_TYPEDEF_(0x800401EAL) "));
		; break;;case  MK_E_MUSTBOTHERUSER :  _sprintf(*buf,_T("   User input required for operation to succeed  ( MK_E_MUSTBOTHERUSER              _HRESULT_TYPEDEF_(0x800401EBL) "));
		; break;;case  MK_E_NOINVERSE :  _sprintf(*buf,_T("   Moniker class has no inverse  ( MK_E_NOINVERSE                   _HRESULT_TYPEDEF_(0x800401ECL) "));
		; break;;case  MK_E_NOSTORAGE :  _sprintf(*buf,_T("   Moniker does not refer to storage  ( MK_E_NOSTORAGE                   _HRESULT_TYPEDEF_(0x800401EDL) "));
		; break;;case  MK_E_NOPREFIX :  _sprintf(*buf,_T("   No common prefix  ( MK_E_NOPREFIX                    _HRESULT_TYPEDEF_(0x800401EEL) "));
		; break;;case  MK_E_ENUMERATION_FAILED :  _sprintf(*buf,_T("   Moniker could not be enumerated  ( MK_E_ENUMERATION_FAILED          _HRESULT_TYPEDEF_(0x800401EFL)  ( CO_E_FIRST        0x800401F0L"));
		; break;;case  CO_E_NOTINITIALIZED :  _sprintf(*buf,_T("   CoInitialize has not been called.  ( CO_E_NOTINITIALIZED              _HRESULT_TYPEDEF_(0x800401F0L) "));
		; break;;case  CO_E_ALREADYINITIALIZED :  _sprintf(*buf,_T("   CoInitialize has already been called.  ( CO_E_ALREADYINITIALIZED          _HRESULT_TYPEDEF_(0x800401F1L) "));
		; break;;case  CO_E_CANTDETERMINECLASS :  _sprintf(*buf,_T("   Class of object cannot be determined  ( CO_E_CANTDETERMINECLASS          _HRESULT_TYPEDEF_(0x800401F2L) "));
		; break;;case  CO_E_CLASSSTRING :  _sprintf(*buf,_T("   Invalid class string  ( CO_E_CLASSSTRING                 _HRESULT_TYPEDEF_(0x800401F3L) "));
		; break;;case  CO_E_IIDSTRING :  _sprintf(*buf,_T("   Invalid interface string  ( CO_E_IIDSTRING                   _HRESULT_TYPEDEF_(0x800401F4L) "));
		; break;;case  CO_E_APPNOTFOUND :  _sprintf(*buf,_T("   Application not found  ( CO_E_APPNOTFOUND                 _HRESULT_TYPEDEF_(0x800401F5L) "));
		; break;;case  CO_E_APPSINGLEUSE :  _sprintf(*buf,_T("   Application cannot be run more than once  ( CO_E_APPSINGLEUSE                _HRESULT_TYPEDEF_(0x800401F6L) "));
		; break;;case  CO_E_ERRORINAPP :  _sprintf(*buf,_T("   Some error in application program  ( CO_E_ERRORINAPP                  _HRESULT_TYPEDEF_(0x800401F7L) "));
		; break;;case  CO_E_DLLNOTFOUND :  _sprintf(*buf,_T("   DLL for class not found  ( CO_E_DLLNOTFOUND                 _HRESULT_TYPEDEF_(0x800401F8L) "));
		; break;;case  CO_E_ERRORINDLL :  _sprintf(*buf,_T("   Error in the DLL  ( CO_E_ERRORINDLL                  _HRESULT_TYPEDEF_(0x800401F9L) "));
		; break;;case  CO_E_WRONGOSFORAPP :  _sprintf(*buf,_T("   Wrong OS or OS version for application  ( CO_E_WRONGOSFORAPP               _HRESULT_TYPEDEF_(0x800401FAL) "));
		; break;;case  CO_E_OBJNOTREG :  _sprintf(*buf,_T("   Object is not registered  ( CO_E_OBJNOTREG                   _HRESULT_TYPEDEF_(0x800401FBL) "));
		; break;;case  CO_E_OBJISREG :  _sprintf(*buf,_T("   Object is already registered  ( CO_E_OBJISREG                    _HRESULT_TYPEDEF_(0x800401FCL) "));
		; break;;case  CO_E_OBJNOTCONNECTED :  _sprintf(*buf,_T("   Object is not connected to server  ( CO_E_OBJNOTCONNECTED             _HRESULT_TYPEDEF_(0x800401FDL) "));
		; break;;case  CO_E_APPDIDNTREG :  _sprintf(*buf,_T("   Application was launched but it didn't register a class factory  ( CO_E_APPDIDNTREG                 _HRESULT_TYPEDEF_(0x800401FEL) "));
		; break;;case  CO_E_RELEASED :  _sprintf(*buf,_T("   Object has been released  ( CO_E_RELEASED                    _HRESULT_TYPEDEF_(0x800401FFL) "));
		; break;;case  CO_E_FAILEDTOIMPERSONATE :  _sprintf(*buf,_T("   Unable to impersonate DCOM client  ( CO_E_FAILEDTOIMPERSONATE         _HRESULT_TYPEDEF_(0x80040200L) "));
		; break;;case  CO_E_FAILEDTOGETSECCTX :  _sprintf(*buf,_T("   Unable to obtain server's security context  ( CO_E_FAILEDTOGETSECCTX           _HRESULT_TYPEDEF_(0x80040201L) "));
		; break;;case  CO_E_FAILEDTOOPENTHREADTOKEN :  _sprintf(*buf,_T("   Unable to open the access token of the current thread  ( CO_E_FAILEDTOOPENTHREADTOKEN     _HRESULT_TYPEDEF_(0x80040202L) "));
		; break;;case  CO_E_FAILEDTOGETTOKENINFO :  _sprintf(*buf,_T("   Unable to obtain user info from an access token  ( CO_E_FAILEDTOGETTOKENINFO        _HRESULT_TYPEDEF_(0x80040203L) "));
		; break;;case  CO_E_TRUSTEEDOESNTMATCHCLIENT :  _sprintf(*buf,_T("   The client who called IAccessControl::IsAccessPermitted was the trustee provided tot he method  ( CO_E_TRUSTEEDOESNTMATCHCLIENT    _HRESULT_TYPEDEF_(0x80040204L) "));
		; break;;case  CO_E_FAILEDTOQUERYCLIENTBLANKET :  _sprintf(*buf,_T("   Unable to obtain the client's security blanket  ( CO_E_FAILEDTOQUERYCLIENTBLANKET  _HRESULT_TYPEDEF_(0x80040205L) "));
		; break;;case  CO_E_FAILEDTOSETDACL :  _sprintf(*buf,_T("   Unable to set a discretionary ACL into a security descriptor  ( CO_E_FAILEDTOSETDACL             _HRESULT_TYPEDEF_(0x80040206L) "));
		; break;;case  CO_E_ACCESSCHECKFAILED :  _sprintf(*buf,_T("   The system function, AccessCheck, returned false  ( CO_E_ACCESSCHECKFAILED           _HRESULT_TYPEDEF_(0x80040207L) "));
		; break;;case  CO_E_NETACCESSAPIFAILED :  _sprintf(*buf,_T("   Either NetAccessDel or NetAccessAdd returned an error code.  ( CO_E_NETACCESSAPIFAILED          _HRESULT_TYPEDEF_(0x80040208L) "));
		; break;;case  CO_E_WRONGTRUSTEENAMESYNTAX :  _sprintf(*buf,_T("   One of the trustee strings provided by the user did not conform to the <Domain> <Name> syntax and it was not the ""*"" string  ( CO_E_WRONGTRUSTEENAMESYNTAX      _HRESULT_TYPEDEF_(0x80040209L) "));
		; break;;case  CO_E_INVALIDSID :  _sprintf(*buf,_T("   One of the security identifiers provided by the user was invalid  ( CO_E_INVALIDSID                  _HRESULT_TYPEDEF_(0x8004020AL) "));
		; break;;case  CO_E_CONVERSIONFAILED :  _sprintf(*buf,_T("   Unable to convert a wide character trustee string to a multiBYTE trustee string  ( CO_E_CONVERSIONFAILED            _HRESULT_TYPEDEF_(0x8004020BL) "));
		; break;;case  CO_E_NOMATCHINGSIDFOUND :  _sprintf(*buf,_T("   Unable to find a security identifier that corresponds to a trustee string provided by the user  ( CO_E_NOMATCHINGSIDFOUND          _HRESULT_TYPEDEF_(0x8004020CL) "));
		; break;;case  CO_E_LOOKUPACCSIDFAILED :  _sprintf(*buf,_T("   The system function, LookupAccountSID, failed  ( CO_E_LOOKUPACCSIDFAILED          _HRESULT_TYPEDEF_(0x8004020DL) "));
		; break;;case  CO_E_NOMATCHINGNAMEFOUND :  _sprintf(*buf,_T("   Unable to find a trustee name that corresponds to a security identifier provided by the user  ( CO_E_NOMATCHINGNAMEFOUND         _HRESULT_TYPEDEF_(0x8004020EL) "));
		; break;;case  CO_E_LOOKUPACCNAMEFAILED :  _sprintf(*buf,_T("   The system function, LookupAccountName, failed  ( CO_E_LOOKUPACCNAMEFAILED         _HRESULT_TYPEDEF_(0x8004020FL) "));
		; break;;case  CO_E_SETSERLHNDLFAILED :  _sprintf(*buf,_T("   Unable to set or reset a serialization handle  ( CO_E_SETSERLHNDLFAILED           _HRESULT_TYPEDEF_(0x80040210L) "));
		; break;;case  CO_E_FAILEDTOGETWINDIR :  _sprintf(*buf,_T("   Unable to obtain the Windows directory  ( CO_E_FAILEDTOGETWINDIR           _HRESULT_TYPEDEF_(0x80040211L) "));
		; break;;case  CO_E_PATHTOOLONG :  _sprintf(*buf,_T("   Path too long  ( CO_E_PATHTOOLONG                 _HRESULT_TYPEDEF_(0x80040212L) "));
		; break;;case  CO_E_FAILEDTOGENUUID :  _sprintf(*buf,_T("   Unable to generate a uuid.  ( CO_E_FAILEDTOGENUUID             _HRESULT_TYPEDEF_(0x80040213L) "));
		; break;;case  CO_E_FAILEDTOCREATEFILE :  _sprintf(*buf,_T("   Unable to create file  ( CO_E_FAILEDTOCREATEFILE          _HRESULT_TYPEDEF_(0x80040214L) "));
		; break;;case  CO_E_FAILEDTOCLOSEHANDLE :  _sprintf(*buf,_T("   Unable to close a serialization handle or a file handle.  ( CO_E_FAILEDTOCLOSEHANDLE         _HRESULT_TYPEDEF_(0x80040215L) "));
		; break;;case  CO_E_EXCEEDSYSACLLIMIT :  _sprintf(*buf,_T("   The number of ACEs in an ACL exceeds the system limit  ( CO_E_EXCEEDSYSACLLIMIT           _HRESULT_TYPEDEF_(0x80040216L) "));
		; break;;case  CO_E_ACESINWRONGORDER :  _sprintf(*buf,_T("   Not all the DENY_ACCESS ACEs are arranged in front of the GRANT_ACCESS ACEs in the stream  ( CO_E_ACESINWRONGORDER            _HRESULT_TYPEDEF_(0x80040217L) "));
		; break;;case  CO_E_INCOMPATIBLESTREAMVERSION :  _sprintf(*buf,_T("   The version of ACL format in the stream is not supported by this implementation of IAccessControl  ( CO_E_INCOMPATIBLESTREAMVERSION   _HRESULT_TYPEDEF_(0x80040218L) "));
		; break;;case  CO_E_FAILEDTOOPENPROCESSTOKEN :  _sprintf(*buf,_T("   Unable to open the access token of the server process  ( CO_E_FAILEDTOOPENPROCESSTOKEN    _HRESULT_TYPEDEF_(0x80040219L) "));
		; break;;case  CO_E_DECODEFAILED :  _sprintf(*buf,_T("   Unable to decode the ACL in the stream provided by the user  ( CO_E_DECODEFAILED                _HRESULT_TYPEDEF_(0x8004021AL) "));
		; break;;case  CO_E_ACNOTINITIALIZED :  _sprintf(*buf,_T("   The COM IAccessControl object is not initialized  ( CO_E_ACNOTINITIALIZED            _HRESULT_TYPEDEF_(0x8004021BL) "));
#endif
		; break;;case  OLE_S_USEREG :  _sprintf(*buf,_T("   Use the registry database to provide the requested information  ( OLE_S_USEREG                     _HRESULT_TYPEDEF_(0x00040000L) "));
		; break;;case  OLE_S_STATIC :  _sprintf(*buf,_T("   Success, but static  ( OLE_S_STATIC                     _HRESULT_TYPEDEF_(0x00040001L) "));
		; break;;case  OLE_S_MAC_CLIPFORMAT :  _sprintf(*buf,_T("   Macintosh clipboard format  ( OLE_S_MAC_CLIPFORMAT             _HRESULT_TYPEDEF_(0x00040002L) "));
		; break;;case  DRAGDROP_S_DROP :  _sprintf(*buf,_T("   Successful drop took place  ( DRAGDROP_S_DROP                  _HRESULT_TYPEDEF_(0x00040100L) "));
		; break;;case  DRAGDROP_S_CANCEL :  _sprintf(*buf,_T("   Drag-drop operation canceled  ( DRAGDROP_S_CANCEL                _HRESULT_TYPEDEF_(0x00040101L) "));
		; break;;case  DRAGDROP_S_USEDEFAULTCURSORS :  _sprintf(*buf,_T("   Use the default cursor  ( DRAGDROP_S_USEDEFAULTCURSORS     _HRESULT_TYPEDEF_(0x00040102L) "));
		; break;;case  DATA_S_SAMEFORMATETC :  _sprintf(*buf,_T("   Data has same FORMATETC  ( DATA_S_SAMEFORMATETC             _HRESULT_TYPEDEF_(0x00040130L) "));
		; break;;case  VIEW_S_ALREADY_FROZEN :  _sprintf(*buf,_T("   View is already frozen  ( VIEW_S_ALREADY_FROZEN            _HRESULT_TYPEDEF_(0x00040140L) "));
		; break;;case  CACHE_S_FORMATETC_NOTSUPPORTED :  _sprintf(*buf,_T("   FORMATETC not supported  ( CACHE_S_FORMATETC_NOTSUPPORTED   _HRESULT_TYPEDEF_(0x00040170L) "));
		; break;;case  CACHE_S_SAMECACHE :  _sprintf(*buf,_T("   Same cache  ( CACHE_S_SAMECACHE                _HRESULT_TYPEDEF_(0x00040171L) "));
		; break;;case  CACHE_S_SOMECACHES_NOTUPDATED :  _sprintf(*buf,_T("   Some cache(s) not updated  ( CACHE_S_SOMECACHES_NOTUPDATED    _HRESULT_TYPEDEF_(0x00040172L) "));
		; break;;case  OLEOBJ_S_INVALIDVERB :  _sprintf(*buf,_T("   Invalid verb for OLE object  ( OLEOBJ_S_INVALIDVERB             _HRESULT_TYPEDEF_(0x00040180L) "));
		; break;;case  OLEOBJ_S_CANNOT_DOVERB_NOW :  _sprintf(*buf,_T("   Verb number is valid but verb cannot be done now  ( OLEOBJ_S_CANNOT_DOVERB_NOW       _HRESULT_TYPEDEF_(0x00040181L) "));
		; break;;case  OLEOBJ_S_INVALIDHWND :  _sprintf(*buf,_T("   Invalid window handle passed  ( OLEOBJ_S_INVALIDHWND             _HRESULT_TYPEDEF_(0x00040182L) "));
		; break;;case  INPLACE_S_TRUNCATED :  _sprintf(*buf,_T("   Message is too long; some of it had to be truncated before displaying  ( INPLACE_S_TRUNCATED              _HRESULT_TYPEDEF_(0x000401A0L) "));
		; break;;case  CONVERT10_S_NO_PRESENTATION :  _sprintf(*buf,_T("   Unable to convert OLESTREAM to IStorage  ( CONVERT10_S_NO_PRESENTATION      _HRESULT_TYPEDEF_(0x000401C0L) "));
		; break;;case  MK_S_REDUCED_TO_SELF :  _sprintf(*buf,_T("   Moniker reduced to itself  ( MK_S_REDUCED_TO_SELF             _HRESULT_TYPEDEF_(0x000401E2L) "));
		; break;;case  MK_S_ME :  _sprintf(*buf,_T("   Common prefix is this moniker  ( MK_S_ME                          _HRESULT_TYPEDEF_(0x000401E4L) "));
		; break;;case  MK_S_HIM :  _sprintf(*buf,_T("   Common prefix is input moniker  ( MK_S_HIM                         _HRESULT_TYPEDEF_(0x000401E5L) "));
		; break;;case  MK_S_US :  _sprintf(*buf,_T("   Common prefix is both monikers  ( MK_S_US                          _HRESULT_TYPEDEF_(0x000401E6L) "));
		; break;;case  MK_S_MONIKERALREADYREGISTERED :  _sprintf(*buf,_T("   Moniker is already registered in running object table  ( MK_S_MONIKERALREADYREGISTERED    _HRESULT_TYPEDEF_(0x000401E7L)  ******************"));
		; break;;case  CO_E_CLASS_CREATE_FAILED :  _sprintf(*buf,_T("   Attempt to create a class object failed  ( CO_E_CLASS_CREATE_FAILED         _HRESULT_TYPEDEF_(0x80080001L) "));
		; break;;case  CO_E_SCM_ERROR :  _sprintf(*buf,_T("   OLE service could not bind object  ( CO_E_SCM_ERROR                   _HRESULT_TYPEDEF_(0x80080002L) "));
		; break;;case  CO_E_SCM_RPC_FAILURE :  _sprintf(*buf,_T("   RPC communication failed with OLE service  ( CO_E_SCM_RPC_FAILURE             _HRESULT_TYPEDEF_(0x80080003L) "));
		; break;;case  CO_E_BAD_PATH :  _sprintf(*buf,_T("   Bad path to object  ( CO_E_BAD_PATH                    _HRESULT_TYPEDEF_(0x80080004L) "));
		; break;;case  CO_E_SERVER_EXEC_FAILURE :  _sprintf(*buf,_T("   Server execution failed  ( CO_E_SERVER_EXEC_FAILURE         _HRESULT_TYPEDEF_(0x80080005L) "));
		; break;;case  CO_E_OBJSRV_RPC_FAILURE :  _sprintf(*buf,_T("   OLE service could not communicate with the object server  ( CO_E_OBJSRV_RPC_FAILURE          _HRESULT_TYPEDEF_(0x80080006L) "));
		; break;;case  MK_E_NO_NORMALIZED :  _sprintf(*buf,_T("   Moniker path could not be normalized  ( MK_E_NO_NORMALIZED               _HRESULT_TYPEDEF_(0x80080007L) "));
		; break;;case  CO_E_SERVER_STOPPING :  _sprintf(*buf,_T("   Object server is stopping when OLE service contacts it  ( CO_E_SERVER_STOPPING             _HRESULT_TYPEDEF_(0x80080008L) "));
		; break;;case  MEM_E_INVALID_ROOT :  _sprintf(*buf,_T("   An invalid root block pointer was specified  ( MEM_E_INVALID_ROOT               _HRESULT_TYPEDEF_(0x80080009L) "));
		; break;;case  MEM_E_INVALID_LINK :  _sprintf(*buf,_T("   An allocation chain contained an invalid link pointer  ( MEM_E_INVALID_LINK               _HRESULT_TYPEDEF_(0x80080010L) "));
		; break;;case  MEM_E_INVALID_SIZE :  _sprintf(*buf,_T("   The requested allocation size was too large  ( MEM_E_INVALID_SIZE               _HRESULT_TYPEDEF_(0x80080011L) "));
		; break;;case  CO_S_NOTALLINTERFACES :  _sprintf(*buf,_T("   Not all the requested interfaces were available  ( CO_S_NOTALLINTERFACES            _HRESULT_TYPEDEF_(0x00080012L)  ******************"));
		; break;;case  DISP_E_UNKNOWNINTERFACE :  _sprintf(*buf,_T("   Unknown interface.  ( DISP_E_UNKNOWNINTERFACE          _HRESULT_TYPEDEF_(0x80020001L) "));
		; break;;case  DISP_E_MEMBERNOTFOUND :  _sprintf(*buf,_T("   Member not found.  ( DISP_E_MEMBERNOTFOUND            _HRESULT_TYPEDEF_(0x80020003L) "));
		; break;;case  DISP_E_PARAMNOTFOUND :  _sprintf(*buf,_T("   Parameter not found.  ( DISP_E_PARAMNOTFOUND             _HRESULT_TYPEDEF_(0x80020004L) "));
		; break;;case  DISP_E_TYPEMISMATCH :  _sprintf(*buf,_T("   Type mismatch.  ( DISP_E_TYPEMISMATCH              _HRESULT_TYPEDEF_(0x80020005L) "));
		; break;;case  DISP_E_UNKNOWNNAME :  _sprintf(*buf,_T("   Unknown name.  ( DISP_E_UNKNOWNNAME               _HRESULT_TYPEDEF_(0x80020006L) "));
		; break;;case  DISP_E_NONAMEDARGS :  _sprintf(*buf,_T("   No named arguments.  ( DISP_E_NONAMEDARGS               _HRESULT_TYPEDEF_(0x80020007L) "));
		; break;;case  DISP_E_BADVARTYPE :  _sprintf(*buf,_T("   Bad variable type.  ( DISP_E_BADVARTYPE                _HRESULT_TYPEDEF_(0x80020008L) "));
		; break;;case  DISP_E_EXCEPTION :  _sprintf(*buf,_T("   Exception occurred.  ( DISP_E_EXCEPTION                 _HRESULT_TYPEDEF_(0x80020009L) "));
		; break;;case  DISP_E_OVERFLOW :  _sprintf(*buf,_T("   Out of present range.  ( DISP_E_OVERFLOW                  _HRESULT_TYPEDEF_(0x8002000AL) "));
		; break;;case  DISP_E_BADINDEX :  _sprintf(*buf,_T("   Invalid index.  ( DISP_E_BADINDEX                  _HRESULT_TYPEDEF_(0x8002000BL) "));
		; break;;case  DISP_E_UNKNOWNLCID :  _sprintf(*buf,_T("   Unknown language.  ( DISP_E_UNKNOWNLCID               _HRESULT_TYPEDEF_(0x8002000CL) "));
		; break;;case  DISP_E_ARRAYISLOCKED :  _sprintf(*buf,_T("   Memory is locked.  ( DISP_E_ARRAYISLOCKED             _HRESULT_TYPEDEF_(0x8002000DL) "));
		; break;;case  DISP_E_BADPARAMCOUNT :  _sprintf(*buf,_T("   Invalid number of parameters.  ( DISP_E_BADPARAMCOUNT             _HRESULT_TYPEDEF_(0x8002000EL) "));
		; break;;case  DISP_E_PARAMNOTOPTIONAL :  _sprintf(*buf,_T("   Parameter not optional.  ( DISP_E_PARAMNOTOPTIONAL          _HRESULT_TYPEDEF_(0x8002000FL) "));
		; break;;case  DISP_E_BADCALLEE :  _sprintf(*buf,_T("   Invalid callee.  ( DISP_E_BADCALLEE                 _HRESULT_TYPEDEF_(0x80020010L) "));
		; break;;case  DISP_E_NOTACOLLECTION :  _sprintf(*buf,_T("   Does not support a collection.  ( DISP_E_NOTACOLLECTION            _HRESULT_TYPEDEF_(0x80020011L) "));
#ifndef VCPP50
		; break;;case  DISP_E_DIVBYZERO :  _sprintf(*buf,_T("   Division by zero.  ( DISP_E_DIVBYZERO                 _HRESULT_TYPEDEF_(0x80020012L) "));
#endif
		; break;;case  TYPE_E_BUFFERTOOSMALL :  _sprintf(*buf,_T("   Buffer too small.  ( TYPE_E_BUFFERTOOSMALL            _HRESULT_TYPEDEF_(0x80028016L) "));
#ifndef VCPP50
		; break;;case  TYPE_E_FIELDNOTFOUND :  _sprintf(*buf,_T("   Field name not defined in the record.  ( TYPE_E_FIELDNOTFOUND             _HRESULT_TYPEDEF_(0x80028017L) "));
#endif
		; break;;case  TYPE_E_INVDATAREAD :  _sprintf(*buf,_T("   Old format or invalid type library.  ( TYPE_E_INVDATAREAD               _HRESULT_TYPEDEF_(0x80028018L) "));
		; break;;case  TYPE_E_UNSUPFORMAT :  _sprintf(*buf,_T("   Old format or invalid type library.  ( TYPE_E_UNSUPFORMAT               _HRESULT_TYPEDEF_(0x80028019L) "));
		; break;;case  TYPE_E_REGISTRYACCESS :  _sprintf(*buf,_T("   Error accessing the OLE registry.  ( TYPE_E_REGISTRYACCESS            _HRESULT_TYPEDEF_(0x8002801CL) "));
		; break;;case  TYPE_E_LIBNOTREGISTERED :  _sprintf(*buf,_T("   Library not registered.  ( TYPE_E_LIBNOTREGISTERED          _HRESULT_TYPEDEF_(0x8002801DL) "));
		; break;;case  TYPE_E_UNDEFINEDTYPE :  _sprintf(*buf,_T("   Bound to unknown type.  ( TYPE_E_UNDEFINEDTYPE             _HRESULT_TYPEDEF_(0x80028027L) "));
		; break;;case  TYPE_E_QUALIFIEDNAMEDISALLOWED :  _sprintf(*buf,_T("   Qualified name disallowed.  ( TYPE_E_QUALIFIEDNAMEDISALLOWED   _HRESULT_TYPEDEF_(0x80028028L) "));
		; break;;case  TYPE_E_INVALIDSTATE :  _sprintf(*buf,_T("   Invalid forward reference, or reference to uncompiled type.  ( TYPE_E_INVALIDSTATE              _HRESULT_TYPEDEF_(0x80028029L) "));
		; break;;case  TYPE_E_WRONGTYPEKIND :  _sprintf(*buf,_T("   Type mismatch.  ( TYPE_E_WRONGTYPEKIND             _HRESULT_TYPEDEF_(0x8002802AL) "));
		; break;;case  TYPE_E_ELEMENTNOTFOUND :  _sprintf(*buf,_T("   Element not found.  ( TYPE_E_ELEMENTNOTFOUND           _HRESULT_TYPEDEF_(0x8002802BL) "));
		; break;;case  TYPE_E_AMBIGUOUSNAME :  _sprintf(*buf,_T("   Ambiguous name.  ( TYPE_E_AMBIGUOUSNAME             _HRESULT_TYPEDEF_(0x8002802CL) "));
		; break;;case  TYPE_E_NAMECONFLICT :  _sprintf(*buf,_T("   Name already exists in the library.  ( TYPE_E_NAMECONFLICT              _HRESULT_TYPEDEF_(0x8002802DL) "));
		; break;;case  TYPE_E_UNKNOWNLCID :  _sprintf(*buf,_T("   Unknown LCID.  ( TYPE_E_UNKNOWNLCID               _HRESULT_TYPEDEF_(0x8002802EL) "));
		; break;;case  TYPE_E_DLLFUNCTIONNOTFOUND :  _sprintf(*buf,_T("   Function not defined in specified DLL.  ( TYPE_E_DLLFUNCTIONNOTFOUND       _HRESULT_TYPEDEF_(0x8002802FL) "));
		; break;;case  TYPE_E_BADMODULEKIND :  _sprintf(*buf,_T("   Wrong module kind for the operation.  ( TYPE_E_BADMODULEKIND             _HRESULT_TYPEDEF_(0x800288BDL) "));
		; break;;case  TYPE_E_SIZETOOBIG :  _sprintf(*buf,_T("   Size may not exceed 64K.  ( TYPE_E_SIZETOOBIG                _HRESULT_TYPEDEF_(0x800288C5L) "));
		; break;;case  TYPE_E_DUPLICATEID :  _sprintf(*buf,_T("   Duplicate ID in inheritance hierarchy.  ( TYPE_E_DUPLICATEID               _HRESULT_TYPEDEF_(0x800288C6L) "));
		; break;;case  TYPE_E_INVALIDID :  _sprintf(*buf,_T("   Incorrect inheritance depth in standard OLE hmember.  ( TYPE_E_INVALIDID                 _HRESULT_TYPEDEF_(0x800288CFL) "));
		; break;;case  TYPE_E_TYPEMISMATCH :  _sprintf(*buf,_T("   Type mismatch.  ( TYPE_E_TYPEMISMATCH              _HRESULT_TYPEDEF_(0x80028CA0L) "));
		; break;;case  TYPE_E_OUTOFBOUNDS :  _sprintf(*buf,_T("   Invalid number of arguments.  ( TYPE_E_OUTOFBOUNDS               _HRESULT_TYPEDEF_(0x80028CA1L) "));
		; break;;case  TYPE_E_IOERROR :  _sprintf(*buf,_T("   I/O Error.  ( TYPE_E_IOERROR                   _HRESULT_TYPEDEF_(0x80028CA2L) "));
		; break;;case  TYPE_E_CANTCREATETMPFILE :  _sprintf(*buf,_T("   Error creating unique tmp file.  ( TYPE_E_CANTCREATETMPFILE         _HRESULT_TYPEDEF_(0x80028CA3L) "));
		; break;;case  TYPE_E_CANTLOADLIBRARY :  _sprintf(*buf,_T("   Error loading type library/DLL.  ( TYPE_E_CANTLOADLIBRARY           _HRESULT_TYPEDEF_(0x80029C4AL) "));
		; break;;case  TYPE_E_INCONSISTENTPROPFUNCS :  _sprintf(*buf,_T("   Inconsistent property functions.  ( TYPE_E_INCONSISTENTPROPFUNCS     _HRESULT_TYPEDEF_(0x80029C83L) "));
		; break;;case  TYPE_E_CIRCULARTYPE :  _sprintf(*buf,_T("   Circular dependency between types/modules.  ( TYPE_E_CIRCULARTYPE              _HRESULT_TYPEDEF_(0x80029C84L)  ******************"));
		; break;;case  STG_E_INVALIDFUNCTION :  _sprintf(*buf,_T("   Unable to perform requested operation.  ( STG_E_INVALIDFUNCTION            _HRESULT_TYPEDEF_(0x80030001L) "));
		; break;;case  STG_E_FILENOTFOUND :  _sprintf(*buf,_T("   %1 could not be found.  ( STG_E_FILENOTFOUND               _HRESULT_TYPEDEF_(0x80030002L) "));
		; break;;case  STG_E_PATHNOTFOUND :  _sprintf(*buf,_T("   The path %1 could not be found.  ( STG_E_PATHNOTFOUND               _HRESULT_TYPEDEF_(0x80030003L) "));
		; break;;case  STG_E_TOOMANYOPENFILES :  _sprintf(*buf,_T("   There are insufficient resources to open another file.  ( STG_E_TOOMANYOPENFILES           _HRESULT_TYPEDEF_(0x80030004L) "));
		; break;;case  STG_E_ACCESSDENIED :  _sprintf(*buf,_T("   Access Denied.  ( STG_E_ACCESSDENIED               _HRESULT_TYPEDEF_(0x80030005L) "));
		; break;;case  STG_E_INVALIDHANDLE :  _sprintf(*buf,_T("   Attempted an operation on an invalid object.  ( STG_E_INVALIDHANDLE              _HRESULT_TYPEDEF_(0x80030006L) "));
		; break;;case  STG_E_INSUFFICIENTMEMORY :  _sprintf(*buf,_T("   There is insufficient memory available to complete operation.  ( STG_E_INSUFFICIENTMEMORY         _HRESULT_TYPEDEF_(0x80030008L) "));
		; break;;case  STG_E_INVALIDPOINTER :  _sprintf(*buf,_T("   Invalid pointer error.  ( STG_E_INVALIDPOINTER             _HRESULT_TYPEDEF_(0x80030009L) "));
		; break;;case  STG_E_NOMOREFILES :  _sprintf(*buf,_T("   There are no more entries to return.  ( STG_E_NOMOREFILES                _HRESULT_TYPEDEF_(0x80030012L) "));
		; break;;case  STG_E_DISKISWRITEPROTECTED :  _sprintf(*buf,_T("   Disk is write-protected.  ( STG_E_DISKISWRITEPROTECTED       _HRESULT_TYPEDEF_(0x80030013L) "));
		; break;;case  STG_E_SEEKERROR :  _sprintf(*buf,_T("   An error occurred during a seek operation.  ( STG_E_SEEKERROR                  _HRESULT_TYPEDEF_(0x80030019L) "));
		; break;;case  STG_E_WRITEFAULT :  _sprintf(*buf,_T("   A disk error occurred during a write operation.  ( STG_E_WRITEFAULT                 _HRESULT_TYPEDEF_(0x8003001DL) "));
		; break;;case  STG_E_READFAULT :  _sprintf(*buf,_T("   A disk error occurred during a read operation.  ( STG_E_READFAULT                  _HRESULT_TYPEDEF_(0x8003001EL) "));
		; break;;case  STG_E_SHAREVIOLATION :  _sprintf(*buf,_T("   A share violation has occurred.  ( STG_E_SHAREVIOLATION             _HRESULT_TYPEDEF_(0x80030020L) "));
		; break;;case  STG_E_LOCKVIOLATION :  _sprintf(*buf,_T("   A lock violation has occurred.  ( STG_E_LOCKVIOLATION              _HRESULT_TYPEDEF_(0x80030021L) "));
		; break;;case  STG_E_FILEALREADYEXISTS :  _sprintf(*buf,_T("   %1 already exists.  ( STG_E_FILEALREADYEXISTS          _HRESULT_TYPEDEF_(0x80030050L) "));
		; break;;case  STG_E_INVALIDPARAMETER :  _sprintf(*buf,_T("   Invalid parameter error.  ( STG_E_INVALIDPARAMETER           _HRESULT_TYPEDEF_(0x80030057L) "));
		; break;;case  STG_E_MEDIUMFULL :  _sprintf(*buf,_T("   There is insufficient disk space to complete operation.  ( STG_E_MEDIUMFULL                 _HRESULT_TYPEDEF_(0x80030070L) "));
		; break;;case  STG_E_PROPSETMISMATCHED :  _sprintf(*buf,_T("   Illegal write of non-simple property to simple property set.  ( STG_E_PROPSETMISMATCHED          _HRESULT_TYPEDEF_(0x800300F0L) "));
		; break;;case  STG_E_ABNORMALAPIEXIT :  _sprintf(*buf,_T("   An API call exited abnormally.  ( STG_E_ABNORMALAPIEXIT            _HRESULT_TYPEDEF_(0x800300FAL) "));
		; break;;case  STG_E_INVALIDHEADER :  _sprintf(*buf,_T("   The file %1 is not a valid compound file.  ( STG_E_INVALIDHEADER              _HRESULT_TYPEDEF_(0x800300FBL) "));
		; break;;case  STG_E_INVALIDNAME :  _sprintf(*buf,_T("   The name %1 is not valid.  ( STG_E_INVALIDNAME                _HRESULT_TYPEDEF_(0x800300FCL) "));
		; break;;case  STG_E_UNKNOWN :  _sprintf(*buf,_T("   An unexpected error occurred.  ( STG_E_UNKNOWN                    _HRESULT_TYPEDEF_(0x800300FDL) "));
		; break;;case  STG_E_UNIMPLEMENTEDFUNCTION :  _sprintf(*buf,_T("   That function is not implemented.  ( STG_E_UNIMPLEMENTEDFUNCTION      _HRESULT_TYPEDEF_(0x800300FEL) "));
		; break;;case  STG_E_INVALIDFLAG :  _sprintf(*buf,_T("   Invalid flag error.  ( STG_E_INVALIDFLAG                _HRESULT_TYPEDEF_(0x800300FFL) "));
		; break;;case  STG_E_INUSE :  _sprintf(*buf,_T("   Attempted to use an object that is busy.  ( STG_E_INUSE                      _HRESULT_TYPEDEF_(0x80030100L) "));
		; break;;case  STG_E_NOTCURRENT :  _sprintf(*buf,_T("   The storage has been changed since the last commit.  ( STG_E_NOTCURRENT                 _HRESULT_TYPEDEF_(0x80030101L) "));
		; break;;case  STG_E_REVERTED :  _sprintf(*buf,_T("   Attempted to use an object that has ceased to exist.  ( STG_E_REVERTED                   _HRESULT_TYPEDEF_(0x80030102L) "));
		; break;;case  STG_E_CANTSAVE :  _sprintf(*buf,_T("   Can't save.  ( STG_E_CANTSAVE                   _HRESULT_TYPEDEF_(0x80030103L) "));
		; break;;case  STG_E_OLDFORMAT :  _sprintf(*buf,_T("   The compound file %1 was produced with an incompatible version of storage.  ( STG_E_OLDFORMAT                  _HRESULT_TYPEDEF_(0x80030104L) "));
		; break;;case  STG_E_OLDDLL :  _sprintf(*buf,_T("   The compound file %1 was produced with a newer version of storage.  ( STG_E_OLDDLL                     _HRESULT_TYPEDEF_(0x80030105L) "));
		; break;;case  STG_E_SHAREREQUIRED :  _sprintf(*buf,_T("   Share.exe or equivalent is required for operation.  ( STG_E_SHAREREQUIRED              _HRESULT_TYPEDEF_(0x80030106L) "));
		; break;;case  STG_E_NOTFILEBASEDSTORAGE :  _sprintf(*buf,_T("   Illegal operation called on non-file based storage.  ( STG_E_NOTFILEBASEDSTORAGE        _HRESULT_TYPEDEF_(0x80030107L) "));
		; break;;case  STG_E_EXTANTMARSHALLINGS :  _sprintf(*buf,_T("   Illegal operation called on object with extant marshallings.  ( STG_E_EXTANTMARSHALLINGS         _HRESULT_TYPEDEF_(0x80030108L) "));
		; break;;case  STG_E_DOCFILECORRUPT :  _sprintf(*buf,_T("   The docfile has been corrupted.  ( STG_E_DOCFILECORRUPT             _HRESULT_TYPEDEF_(0x80030109L) "));
		; break;;case  STG_E_BADBASEADDRESS :  _sprintf(*buf,_T("   OLE32.DLL has been loaded at the wrong address.  ( STG_E_BADBASEADDRESS             _HRESULT_TYPEDEF_(0x80030110L) "));
		; break;;case  STG_E_INCOMPLETE :  _sprintf(*buf,_T("   The file download was aborted abnormally.  The file is incomplete.  ( STG_E_INCOMPLETE                 _HRESULT_TYPEDEF_(0x80030201L) "));
		; break;;case  STG_E_TERMINATED :  _sprintf(*buf,_T("   The file download has been terminated.  ( STG_E_TERMINATED                 _HRESULT_TYPEDEF_(0x80030202L) "));
		; break;;case  STG_S_CONVERTED :  _sprintf(*buf,_T("   The underlying file was converted to compound file format.  ( STG_S_CONVERTED                  _HRESULT_TYPEDEF_(0x00030200L) "));
		; break;;case  STG_S_BLOCK :  _sprintf(*buf,_T("   The storage operation should block until more data is available.  ( STG_S_BLOCK                      _HRESULT_TYPEDEF_(0x00030201L) "));
		; break;;case  STG_S_RETRYNOW :  _sprintf(*buf,_T("   The storage operation should retry immediately.  ( STG_S_RETRYNOW                   _HRESULT_TYPEDEF_(0x00030202L) "));
		; break;;case  STG_S_MONITORING :  _sprintf(*buf,_T("   The notified event sink will not influence the storage operation.  ( STG_S_MONITORING                 _HRESULT_TYPEDEF_(0x00030203L) "));
#ifndef VCPP50
		; break;;case  STG_S_MULTIPLEOPENS :  _sprintf(*buf,_T("   Multiple opens prevent consolidated. (commit succeeded).  ( STG_S_MULTIPLEOPENS              _HRESULT_TYPEDEF_(0x00030204L) "));
		; break;;case  STG_S_CONSOLIDATIONFAILED :  _sprintf(*buf,_T("   Consolidation of the storage file failed. (commit succeeded).  ( STG_S_CONSOLIDATIONFAILED        _HRESULT_TYPEDEF_(0x00030205L) "));
		; break;;case  STG_S_CANNOTCONSOLIDATE :  _sprintf(*buf,_T("   Consolidation of the storage file is inappropriate. (commit succeeded).  ( STG_S_CANNOTCONSOLIDATE          _HRESULT_TYPEDEF_(0x00030206L)  ******************"));
#endif
		; break;;case  RPC_E_CALL_REJECTED :  _sprintf(*buf,_T("   Call was rejected by callee.  ( RPC_E_CALL_REJECTED              _HRESULT_TYPEDEF_(0x80010001L) "));
		; break;;case  RPC_E_CALL_CANCELED :  _sprintf(*buf,_T("   Call was canceled by the message filter.  ( RPC_E_CALL_CANCELED              _HRESULT_TYPEDEF_(0x80010002L) "));
		; break;;case  RPC_E_CANTPOST_INSENDCALL :  _sprintf(*buf,_T("   The caller is dispatching an intertask SendMessage call and  cannot call out via PostMessage.  ( RPC_E_CANTPOST_INSENDCALL        _HRESULT_TYPEDEF_(0x80010003L) "));
		; break;;case  RPC_E_CANTCALLOUT_INASYNCCALL :  _sprintf(*buf,_T("   The caller is dispatching an asynchronous call and cannot  make an outgoing call on behalf of this call.  ( RPC_E_CANTCALLOUT_INASYNCCALL    _HRESULT_TYPEDEF_(0x80010004L) "));
		; break;;case  RPC_E_CANTCALLOUT_INEXTERNALCALL :  _sprintf(*buf,_T("   It is illegal to call out while inside message filter.  ( RPC_E_CANTCALLOUT_INEXTERNALCALL _HRESULT_TYPEDEF_(0x80010005L) "));
		; break;;case  RPC_E_CONNECTION_TERMINATED :  _sprintf(*buf,_T("   The connection terminated or is in a bogus state  and cannot be used any more. Other connections  are still valid.  ( RPC_E_CONNECTION_TERMINATED      _HRESULT_TYPEDEF_(0x80010006L) "));
		; break;;case  RPC_E_SERVER_DIED :  _sprintf(*buf,_T("   The callee (server [not server application]) is not available  and disappeared; all connections are invalid.  The call may  have executed.  ( RPC_E_SERVER_DIED                _HRESULT_TYPEDEF_(0x80010007L) "));
		; break;;case  RPC_E_CLIENT_DIED :  _sprintf(*buf,_T("   The caller (client) disappeared while the callee (server) was  processing a call.  ( RPC_E_CLIENT_DIED                _HRESULT_TYPEDEF_(0x80010008L) "));
		; break;;case  RPC_E_INVALID_DATAPACKET :  _sprintf(*buf,_T("   The data packet with the marshalled parameter data is incorrect.  ( RPC_E_INVALID_DATAPACKET         _HRESULT_TYPEDEF_(0x80010009L) "));
		; break;;case  RPC_E_CANTTRANSMIT_CALL :  _sprintf(*buf,_T("   The call was not transmitted properly; the message queue  was full and was not emptied after yielding.  ( RPC_E_CANTTRANSMIT_CALL          _HRESULT_TYPEDEF_(0x8001000AL) "));
		; break;;case  RPC_E_CLIENT_CANTMARSHAL_DATA :  _sprintf(*buf,_T("   The client (caller) cannot marshall the parameter data - low memory, etc.  ( RPC_E_CLIENT_CANTMARSHAL_DATA    _HRESULT_TYPEDEF_(0x8001000BL) "));
		; break;;case  RPC_E_CLIENT_CANTUNMARSHAL_DATA :  _sprintf(*buf,_T("   The client (caller) cannot unmarshall the return data - low memory, etc.  ( RPC_E_CLIENT_CANTUNMARSHAL_DATA  _HRESULT_TYPEDEF_(0x8001000CL) "));
		; break;;case  RPC_E_SERVER_CANTMARSHAL_DATA :  _sprintf(*buf,_T("   The server (callee) cannot marshall the return data - low memory, etc.  ( RPC_E_SERVER_CANTMARSHAL_DATA    _HRESULT_TYPEDEF_(0x8001000DL) "));
		; break;;case  RPC_E_SERVER_CANTUNMARSHAL_DATA :  _sprintf(*buf,_T("   The server (callee) cannot unmarshall the parameter data - low memory, etc.  ( RPC_E_SERVER_CANTUNMARSHAL_DATA  _HRESULT_TYPEDEF_(0x8001000EL) "));
		; break;;case  RPC_E_INVALID_DATA :  _sprintf(*buf,_T("   Received data is invalid; could be server or client data.  ( RPC_E_INVALID_DATA               _HRESULT_TYPEDEF_(0x8001000FL) "));
		; break;;case  RPC_E_INVALID_PARAMETER :  _sprintf(*buf,_T("   A particular parameter is invalid and cannot be (un)marshalled.  ( RPC_E_INVALID_PARAMETER          _HRESULT_TYPEDEF_(0x80010010L) "));
		; break;;case  RPC_E_CANTCALLOUT_AGAIN :  _sprintf(*buf,_T("   There is no second outgoing call on same channel in DDE conversation.  ( RPC_E_CANTCALLOUT_AGAIN          _HRESULT_TYPEDEF_(0x80010011L) "));
		; break;;case  RPC_E_SERVER_DIED_DNE :  _sprintf(*buf,_T("   The callee (server [not server application]) is not available  and disappeared; all connections are invalid.  The call did not execute.  ( RPC_E_SERVER_DIED_DNE            _HRESULT_TYPEDEF_(0x80010012L) "));
		; break;;case  RPC_E_SYS_CALL_FAILED :  _sprintf(*buf,_T("   System call failed.  ( RPC_E_SYS_CALL_FAILED            _HRESULT_TYPEDEF_(0x80010100L) "));
		; break;;case  RPC_E_OUT_OF_RESOURCES :  _sprintf(*buf,_T("   Could not allocate some required resource (memory, events, ...)  ( RPC_E_OUT_OF_RESOURCES           _HRESULT_TYPEDEF_(0x80010101L) "));
		; break;;case  RPC_E_ATTEMPTED_MULTITHREAD :  _sprintf(*buf,_T("   Attempted to make calls on more than one thread in single threaded mode.  ( RPC_E_ATTEMPTED_MULTITHREAD      _HRESULT_TYPEDEF_(0x80010102L) "));
		; break;;case  RPC_E_NOT_REGISTERED :  _sprintf(*buf,_T("   The requested interface is not registered on the server object.  ( RPC_E_NOT_REGISTERED             _HRESULT_TYPEDEF_(0x80010103L) "));
		; break;;case  RPC_E_FAULT :  _sprintf(*buf,_T("   RPC could not call the server or could not return the results of calling the server.  ( RPC_E_FAULT                      _HRESULT_TYPEDEF_(0x80010104L) "));
		; break;;case  RPC_E_SERVERFAULT :  _sprintf(*buf,_T("   The server threw an exception.  ( RPC_E_SERVERFAULT                _HRESULT_TYPEDEF_(0x80010105L) "));
		; break;;case  RPC_E_CHANGED_MODE :  _sprintf(*buf,_T("   Cannot change thread mode after it is set.  ( RPC_E_CHANGED_MODE               _HRESULT_TYPEDEF_(0x80010106L) "));
		; break;;case  RPC_E_INVALIDMETHOD :  _sprintf(*buf,_T("   The method called does not exist on the server.  ( RPC_E_INVALIDMETHOD              _HRESULT_TYPEDEF_(0x80010107L) "));
		; break;;case  RPC_E_DISCONNECTED :  _sprintf(*buf,_T("   The object invoked has disconnected from its clients.  ( RPC_E_DISCONNECTED               _HRESULT_TYPEDEF_(0x80010108L) "));
		; break;;case  RPC_E_RETRY :  _sprintf(*buf,_T("   The object invoked chose not to process the call now.  Try again later.  ( RPC_E_RETRY                      _HRESULT_TYPEDEF_(0x80010109L) "));
		; break;;case  RPC_E_SERVERCALL_RETRYLATER :  _sprintf(*buf,_T("   The message filter indicated that the application is busy.  ( RPC_E_SERVERCALL_RETRYLATER      _HRESULT_TYPEDEF_(0x8001010AL) "));
		; break;;case  RPC_E_SERVERCALL_REJECTED :  _sprintf(*buf,_T("   The message filter rejected the call.  ( RPC_E_SERVERCALL_REJECTED        _HRESULT_TYPEDEF_(0x8001010BL) "));
		; break;;case  RPC_E_INVALID_CALLDATA :  _sprintf(*buf,_T("   A call control interfaces was called with invalid data.  ( RPC_E_INVALID_CALLDATA           _HRESULT_TYPEDEF_(0x8001010CL) "));
		; break;;case  RPC_E_CANTCALLOUT_ININPUTSYNCCALL :  _sprintf(*buf,_T("   An outgoing call cannot be made since the application is dispatching an input-synchronous call.  ( RPC_E_CANTCALLOUT_ININPUTSYNCCALL _HRESULT_TYPEDEF_(0x8001010DL) "));
		; break;;case  RPC_E_WRONG_THREAD :  _sprintf(*buf,_T("   The application called an interface that was marshalled for a different thread.  ( RPC_E_WRONG_THREAD               _HRESULT_TYPEDEF_(0x8001010EL) "));
		; break;;case  RPC_E_THREAD_NOT_INIT :  _sprintf(*buf,_T("   CoInitialize has not been called on the current thread.  ( RPC_E_THREAD_NOT_INIT            _HRESULT_TYPEDEF_(0x8001010FL) "));
		; break;;case  RPC_E_VERSION_MISMATCH :  _sprintf(*buf,_T("   The version of OLE on the client and server machines does not match.  ( RPC_E_VERSION_MISMATCH           _HRESULT_TYPEDEF_(0x80010110L) "));
		; break;;case  RPC_E_INVALID_HEADER :  _sprintf(*buf,_T("   OLE received a packet with an invalid header.  ( RPC_E_INVALID_HEADER             _HRESULT_TYPEDEF_(0x80010111L) "));
		; break;;case  RPC_E_INVALID_EXTENSION :  _sprintf(*buf,_T("   OLE received a packet with an invalid extension.  ( RPC_E_INVALID_EXTENSION          _HRESULT_TYPEDEF_(0x80010112L) "));
		; break;;case  RPC_E_INVALID_IPID :  _sprintf(*buf,_T("   The requested object or interface does not exist.  ( RPC_E_INVALID_IPID               _HRESULT_TYPEDEF_(0x80010113L) "));
		; break;;case  RPC_E_INVALID_OBJECT :  _sprintf(*buf,_T("   The requested object does not exist.  ( RPC_E_INVALID_OBJECT             _HRESULT_TYPEDEF_(0x80010114L) "));
		; break;;case  RPC_S_CALLPENDING :  _sprintf(*buf,_T("   OLE has sent a request and is waiting for a reply.  ( RPC_S_CALLPENDING                _HRESULT_TYPEDEF_(0x80010115L) "));
		; break;;case  RPC_S_WAITONTIMER :  _sprintf(*buf,_T("   OLE is waiting before retrying a request.  ( RPC_S_WAITONTIMER                _HRESULT_TYPEDEF_(0x80010116L) "));
		; break;;case  RPC_E_CALL_COMPLETE :  _sprintf(*buf,_T("   Call context cannot be accessed after call completed.  ( RPC_E_CALL_COMPLETE              _HRESULT_TYPEDEF_(0x80010117L) "));
		; break;;case  RPC_E_UNSECURE_CALL :  _sprintf(*buf,_T("   Impersonate on unsecure calls is not supported.  ( RPC_E_UNSECURE_CALL              _HRESULT_TYPEDEF_(0x80010118L) "));
		; break;;case  RPC_E_TOO_LATE :  _sprintf(*buf,_T("   Security must be initialized before any interfaces are marshalled or  unmarshalled.  It cannot be changed once initialized.  ( RPC_E_TOO_LATE                   _HRESULT_TYPEDEF_(0x80010119L) "));
		; break;;case  RPC_E_NO_GOOD_SECURITY_PACKAGES :  _sprintf(*buf,_T("   No security packages are installed on this machine or the user is not logged  on or there are no compatible security packages between the client and server.  ( RPC_E_NO_GOOD_SECURITY_PACKAGES  _HRESULT_TYPEDEF_(0x8001011AL) "));
		; break;;case  RPC_E_ACCESS_DENIED :  _sprintf(*buf,_T("   Access is denied.  ( RPC_E_ACCESS_DENIED              _HRESULT_TYPEDEF_(0x8001011BL) "));
		; break;;case  RPC_E_REMOTE_DISABLED :  _sprintf(*buf,_T("   Remote calls are not allowed for this process.  ( RPC_E_REMOTE_DISABLED            _HRESULT_TYPEDEF_(0x8001011CL) "));
		; break;;case  RPC_E_INVALID_OBJREF :  _sprintf(*buf,_T("   The marshaled interface data packet (OBJREF) has an invalid or unknown format.  ( RPC_E_INVALID_OBJREF             _HRESULT_TYPEDEF_(0x8001011DL) "));
#ifndef VCPP50
		; break;;case  RPC_E_NO_CONTEXT :  _sprintf(*buf,_T("   No context is associated with this call.  This happens for some custom  marshalled calls and on the client side of the call.  ( RPC_E_NO_CONTEXT                 _HRESULT_TYPEDEF_(0x8001011EL) "));
		; break;;case  RPC_E_TIMEOUT :  _sprintf(*buf,_T("   This operation returned because the timeout period expired.  ( RPC_E_TIMEOUT                    _HRESULT_TYPEDEF_(0x8001011FL) "));
		; break;;case  RPC_E_NO_SYNC :  _sprintf(*buf,_T("   There are no synchronize objects to wait on.  ( RPC_E_NO_SYNC                    _HRESULT_TYPEDEF_(0x80010120L) "));
#endif
		; break;;case  RPC_E_UNEXPECTED :  _sprintf(*buf,_T("   An internal error occurred.  ( RPC_E_UNEXPECTED                 _HRESULT_TYPEDEF_(0x8001FFFFL) "));
		; break;;case  NTE_BAD_UID :  _sprintf(*buf,_T("   Bad UID.  ( NTE_BAD_UID                      _HRESULT_TYPEDEF_(0x80090001L) "));
		; break;;case  NTE_BAD_HASH :  _sprintf(*buf,_T("   Bad Hash.  ( NTE_BAD_HASH                     _HRESULT_TYPEDEF_(0x80090002L) "));
		; break;;case  NTE_BAD_KEY :  _sprintf(*buf,_T("   Bad Key.  ( NTE_BAD_KEY                      _HRESULT_TYPEDEF_(0x80090003L) "));
		; break;;case  NTE_BAD_LEN :  _sprintf(*buf,_T("   Bad Length.  ( NTE_BAD_LEN                      _HRESULT_TYPEDEF_(0x80090004L) "));
		; break;;case  NTE_BAD_DATA :  _sprintf(*buf,_T("   Bad Data.  ( NTE_BAD_DATA                     _HRESULT_TYPEDEF_(0x80090005L) "));
		; break;;case  NTE_BAD_SIGNATURE :  _sprintf(*buf,_T("   Invalid Signature.  ( NTE_BAD_SIGNATURE                _HRESULT_TYPEDEF_(0x80090006L) "));
		; break;;case  NTE_BAD_VER :  _sprintf(*buf,_T("   Bad Version of provider.  ( NTE_BAD_VER                      _HRESULT_TYPEDEF_(0x80090007L) "));
		; break;;case  NTE_BAD_ALGID :  _sprintf(*buf,_T("   Invalid algorithm specified.  ( NTE_BAD_ALGID                    _HRESULT_TYPEDEF_(0x80090008L) "));
		; break;;case  NTE_BAD_FLAGS :  _sprintf(*buf,_T("   Invalid flags specified.  ( NTE_BAD_FLAGS                    _HRESULT_TYPEDEF_(0x80090009L) "));
		; break;;case  NTE_BAD_TYPE :  _sprintf(*buf,_T("   Invalid type specified.  ( NTE_BAD_TYPE                     _HRESULT_TYPEDEF_(0x8009000AL) "));
		; break;;case  NTE_BAD_KEY_STATE :  _sprintf(*buf,_T("   Key not valid for use in specified state.  ( NTE_BAD_KEY_STATE                _HRESULT_TYPEDEF_(0x8009000BL) "));
		; break;;case  NTE_BAD_HASH_STATE :  _sprintf(*buf,_T("   Hash not valid for use in specified state.  ( NTE_BAD_HASH_STATE               _HRESULT_TYPEDEF_(0x8009000CL) "));
		; break;;case  NTE_NO_KEY :  _sprintf(*buf,_T("   Key does not exist.  ( NTE_NO_KEY                       _HRESULT_TYPEDEF_(0x8009000DL) "));
		; break;;case  NTE_NO_MEMORY :  _sprintf(*buf,_T("   Insufficient memory available for the operation.  ( NTE_NO_MEMORY                    _HRESULT_TYPEDEF_(0x8009000EL) "));
		; break;;case  NTE_EXISTS :  _sprintf(*buf,_T("   Object already exists.  ( NTE_EXISTS                       _HRESULT_TYPEDEF_(0x8009000FL) "));
		; break;;case  NTE_PERM :  _sprintf(*buf,_T("   Access denied.  ( NTE_PERM                         _HRESULT_TYPEDEF_(0x80090010L) "));
		; break;;case  NTE_NOT_FOUND :  _sprintf(*buf,_T("   Object was not found.  ( NTE_NOT_FOUND                    _HRESULT_TYPEDEF_(0x80090011L) "));
		; break;;case  NTE_DOUBLE_ENCRYPT :  _sprintf(*buf,_T("   Data already encrypted.  ( NTE_DOUBLE_ENCRYPT               _HRESULT_TYPEDEF_(0x80090012L) "));
		; break;;case  NTE_BAD_PROVIDER :  _sprintf(*buf,_T("   Invalid provider specified.  ( NTE_BAD_PROVIDER                 _HRESULT_TYPEDEF_(0x80090013L) "));
		; break;;case  NTE_BAD_PROV_TYPE :  _sprintf(*buf,_T("   Invalid provider type specified.  ( NTE_BAD_PROV_TYPE                _HRESULT_TYPEDEF_(0x80090014L) "));
		; break;;case  NTE_BAD_PUBLIC_KEY :  _sprintf(*buf,_T("   Provider's public key is invalid.  ( NTE_BAD_PUBLIC_KEY               _HRESULT_TYPEDEF_(0x80090015L) "));
		; break;;case  NTE_BAD_KEYSET :  _sprintf(*buf,_T("   Keyset does not exist  ( NTE_BAD_KEYSET                   _HRESULT_TYPEDEF_(0x80090016L) "));
		; break;;case  NTE_PROV_TYPE_NOT_DEF :  _sprintf(*buf,_T("   Provider type not defined.  ( NTE_PROV_TYPE_NOT_DEF            _HRESULT_TYPEDEF_(0x80090017L) "));
		; break;;case  NTE_PROV_TYPE_ENTRY_BAD :  _sprintf(*buf,_T("   Provider type as registered is invalid.  ( NTE_PROV_TYPE_ENTRY_BAD          _HRESULT_TYPEDEF_(0x80090018L) "));
		; break;;case  NTE_KEYSET_NOT_DEF :  _sprintf(*buf,_T("   The keyset is not defined.  ( NTE_KEYSET_NOT_DEF               _HRESULT_TYPEDEF_(0x80090019L) "));
		; break;;case  NTE_KEYSET_ENTRY_BAD :  _sprintf(*buf,_T("   Keyset as registered is invalid.  ( NTE_KEYSET_ENTRY_BAD             _HRESULT_TYPEDEF_(0x8009001AL) "));
		; break;;case  NTE_PROV_TYPE_NO_MATCH :  _sprintf(*buf,_T("   Provider type does not match registered value.  ( NTE_PROV_TYPE_NO_MATCH           _HRESULT_TYPEDEF_(0x8009001BL) "));
		; break;;case  NTE_SIGNATURE_FILE_BAD :  _sprintf(*buf,_T("   The digital signature file is corrupt.  ( NTE_SIGNATURE_FILE_BAD           _HRESULT_TYPEDEF_(0x8009001CL) "));
		; break;;case  NTE_PROVIDER_DLL_FAIL :  _sprintf(*buf,_T("   Provider DLL failed to initialize correctly.  ( NTE_PROVIDER_DLL_FAIL            _HRESULT_TYPEDEF_(0x8009001DL) "));
		; break;;case  NTE_PROV_DLL_NOT_FOUND :  _sprintf(*buf,_T("   Provider DLL could not be found.  ( NTE_PROV_DLL_NOT_FOUND           _HRESULT_TYPEDEF_(0x8009001EL) "));
		; break;;case  NTE_BAD_KEYSET_PARAM :  _sprintf(*buf,_T("   The Keyset parameter is invalid.  ( NTE_BAD_KEYSET_PARAM             _HRESULT_TYPEDEF_(0x8009001FL) "));
		; break;;case  NTE_FAIL :  _sprintf(*buf,_T("   An internal error occurred.  ( NTE_FAIL                         _HRESULT_TYPEDEF_(0x80090020L) "));
		; break;;case  NTE_SYS_ERR :  _sprintf(*buf,_T("   A base error occurred.  ( NTE_SYS_ERR                      _HRESULT_TYPEDEF_(0x80090021L) "));
#ifndef VCPP50
		; break;;case  CRYPT_E_MSG_ERROR :  _sprintf(*buf,_T("   An error was encountered doing a cryptographic message operation.  ( CRYPT_E_MSG_ERROR                _HRESULT_TYPEDEF_(0x80091001L) "));
		; break;;case  CRYPT_E_UNKNOWN_ALGO :  _sprintf(*buf,_T("   The cryptographic algorithm is unknown.  ( CRYPT_E_UNKNOWN_ALGO             _HRESULT_TYPEDEF_(0x80091002L) "));
		; break;;case  CRYPT_E_OID_FORMAT :  _sprintf(*buf,_T("   The object identifier is badly formatted.  ( CRYPT_E_OID_FORMAT               _HRESULT_TYPEDEF_(0x80091003L) "));
		; break;;case  CRYPT_E_INVALID_MSG_TYPE :  _sprintf(*buf,_T("   The message type is invalid.  ( CRYPT_E_INVALID_MSG_TYPE         _HRESULT_TYPEDEF_(0x80091004L) "));
		; break;;case  CRYPT_E_UNEXPECTED_ENCODING :  _sprintf(*buf,_T("   The message is not encoded as expected.  ( CRYPT_E_UNEXPECTED_ENCODING      _HRESULT_TYPEDEF_(0x80091005L) "));
		; break;;case  CRYPT_E_AUTH_ATTR_MISSING :  _sprintf(*buf,_T("   The message does not contain an expected authenticated attribute.  ( CRYPT_E_AUTH_ATTR_MISSING        _HRESULT_TYPEDEF_(0x80091006L) "));
		; break;;case  CRYPT_E_HASH_VALUE :  _sprintf(*buf,_T("   The hash value is not correct.  ( CRYPT_E_HASH_VALUE               _HRESULT_TYPEDEF_(0x80091007L) "));
		; break;;case  CRYPT_E_INVALID_INDEX :  _sprintf(*buf,_T("   The index value is not valid.  ( CRYPT_E_INVALID_INDEX            _HRESULT_TYPEDEF_(0x80091008L) "));
		; break;;case  CRYPT_E_ALREADY_DECRYPTED :  _sprintf(*buf,_T("   The message content has already been decrypted.  ( CRYPT_E_ALREADY_DECRYPTED        _HRESULT_TYPEDEF_(0x80091009L) "));
		; break;;case  CRYPT_E_NOT_DECRYPTED :  _sprintf(*buf,_T("   The message content has not been decrypted yet.  ( CRYPT_E_NOT_DECRYPTED            _HRESULT_TYPEDEF_(0x8009100AL) "));
		; break;;case  CRYPT_E_RECIPIENT_NOT_FOUND :  _sprintf(*buf,_T("   The enveloped-data message does not contain the specified recipient.  ( CRYPT_E_RECIPIENT_NOT_FOUND      _HRESULT_TYPEDEF_(0x8009100BL) "));
		; break;;case  CRYPT_E_CONTROL_TYPE :  _sprintf(*buf,_T("   The control type is not valid.  ( CRYPT_E_CONTROL_TYPE             _HRESULT_TYPEDEF_(0x8009100CL) "));
		; break;;case  CRYPT_E_ISSUER_SERIALNUMBER :  _sprintf(*buf,_T("   The issuer and/or serial number are/is not valid.  ( CRYPT_E_ISSUER_SERIALNUMBER      _HRESULT_TYPEDEF_(0x8009100DL) "));
		; break;;case  CRYPT_E_SIGNER_NOT_FOUND :  _sprintf(*buf,_T("   The original signer is not found.  ( CRYPT_E_SIGNER_NOT_FOUND         _HRESULT_TYPEDEF_(0x8009100EL) "));
		; break;;case  CRYPT_E_ATTRIBUTES_MISSING :  _sprintf(*buf,_T("   The message does not contain the requested attributes.  ( CRYPT_E_ATTRIBUTES_MISSING       _HRESULT_TYPEDEF_(0x8009100FL) "));
		; break;;case  CRYPT_E_STREAM_MSG_NOT_READY :  _sprintf(*buf,_T("   The steamed message is note yet able to return the requested data.  ( CRYPT_E_STREAM_MSG_NOT_READY     _HRESULT_TYPEDEF_(0x80091010L) "));
		; break;;case  CRYPT_E_STREAM_INSUFFICIENT_DATA :  _sprintf(*buf,_T("   The streamed message needs more data before the decode can complete.  ( CRYPT_E_STREAM_INSUFFICIENT_DATA _HRESULT_TYPEDEF_(0x80091011L) "));
		; break;;case  CRYPT_E_BAD_LEN :  _sprintf(*buf,_T("   The length specified for the output data was insufficient.  ( CRYPT_E_BAD_LEN                  _HRESULT_TYPEDEF_(0x80092001L) "));
		; break;;case  CRYPT_E_BAD_ENCODE :  _sprintf(*buf,_T("   An error was encountered while encoding or decoding.  ( CRYPT_E_BAD_ENCODE               _HRESULT_TYPEDEF_(0x80092002L) "));
		; break;;case  CRYPT_E_FILE_ERROR :  _sprintf(*buf,_T("   An error occurred while reading or writing to the file  ( CRYPT_E_FILE_ERROR               _HRESULT_TYPEDEF_(0x80092003L) "));
		; break;;case  CRYPT_E_NOT_FOUND :  _sprintf(*buf,_T("   The object or property wasn't found  ( CRYPT_E_NOT_FOUND                _HRESULT_TYPEDEF_(0x80092004L) "));
		; break;;case  CRYPT_E_EXISTS :  _sprintf(*buf,_T("   The object or property already exists  ( CRYPT_E_EXISTS                   _HRESULT_TYPEDEF_(0x80092005L) "));
		; break;;case  CRYPT_E_NO_PROVIDER :  _sprintf(*buf,_T("   No provider was specified for the store or object  ( CRYPT_E_NO_PROVIDER              _HRESULT_TYPEDEF_(0x80092006L) "));
		; break;;case  CRYPT_E_SELF_SIGNED :  _sprintf(*buf,_T("   The specified certificate is self signed.  ( CRYPT_E_SELF_SIGNED              _HRESULT_TYPEDEF_(0x80092007L) "));
		; break;;case  CRYPT_E_DELETED_PREV :  _sprintf(*buf,_T("   The previous certificate or CRL context was deleted.  ( CRYPT_E_DELETED_PREV             _HRESULT_TYPEDEF_(0x80092008L) "));
		; break;;case  CRYPT_E_NO_MATCH :  _sprintf(*buf,_T("   No match when trying to find the object.  ( CRYPT_E_NO_MATCH                 _HRESULT_TYPEDEF_(0x80092009L) "));
		; break;;case  CRYPT_E_UNEXPECTED_MSG_TYPE :  _sprintf(*buf,_T("   The type of the cryptographic message being decoded is different than what was expected.  ( CRYPT_E_UNEXPECTED_MSG_TYPE      _HRESULT_TYPEDEF_(0x8009200AL) "));
		; break;;case  CRYPT_E_NO_KEY_PROPERTY :  _sprintf(*buf,_T("   The certificate doesn't have a private key property  ( CRYPT_E_NO_KEY_PROPERTY          _HRESULT_TYPEDEF_(0x8009200BL) "));
		; break;;case  CRYPT_E_NO_DECRYPT_CERT :  _sprintf(*buf,_T("   No certificate was found having a private key property to use for decrypting.  ( CRYPT_E_NO_DECRYPT_CERT          _HRESULT_TYPEDEF_(0x8009200CL) "));
		; break;;case  CRYPT_E_BAD_MSG :  _sprintf(*buf,_T("   Either, not a cryptographic message or incorrectly formatted.  ( CRYPT_E_BAD_MSG                  _HRESULT_TYPEDEF_(0x8009200DL) "));
		; break;;case  CRYPT_E_NO_SIGNER :  _sprintf(*buf,_T("   The signed message doesn't have a signer for the specified signer index  ( CRYPT_E_NO_SIGNER                _HRESULT_TYPEDEF_(0x8009200EL) "));
		; break;;case  CRYPT_E_PENDING_CLOSE :  _sprintf(*buf,_T("   Final closure is pending until additional frees or closes.  ( CRYPT_E_PENDING_CLOSE            _HRESULT_TYPEDEF_(0x8009200FL) "));
		; break;;case  CRYPT_E_REVOKED :  _sprintf(*buf,_T("   The certificate or signature has been revoked  ( CRYPT_E_REVOKED                  _HRESULT_TYPEDEF_(0x80092010L) "));
		; break;;case  CRYPT_E_NO_REVOCATION_DLL :  _sprintf(*buf,_T("   No Dll or exported function was found to verify revocation.  ( CRYPT_E_NO_REVOCATION_DLL        _HRESULT_TYPEDEF_(0x80092011L) "));
		; break;;case  CRYPT_E_NO_REVOCATION_CHECK :  _sprintf(*buf,_T("   The called function wasn't able to do a revocation check on the certificate or signature.  ( CRYPT_E_NO_REVOCATION_CHECK      _HRESULT_TYPEDEF_(0x80092012L) "));
		; break;;case  CRYPT_E_REVOCATION_OFFLINE :  _sprintf(*buf,_T("   Since the revocation server was offline, the called function wasn't able to complete the revocation check.  ( CRYPT_E_REVOCATION_OFFLINE       _HRESULT_TYPEDEF_(0x80092013L) "));
		; break;;case  CRYPT_E_NOT_IN_REVOCATION_DATABASE :  _sprintf(*buf,_T("   The certificate or signature to be checked was not found in the revocation servers database.  ( CRYPT_E_NOT_IN_REVOCATION_DATABASE _HRESULT_TYPEDEF_(0x80092014L) "));
		; break;;case  CRYPT_E_INVALID_NUMERIC_STRING :  _sprintf(*buf,_T("   The string contains a non-numeric character.  ( CRYPT_E_INVALID_NUMERIC_STRING   _HRESULT_TYPEDEF_(0x80092020L) "));
		; break;;case  CRYPT_E_INVALID_PRINTABLE_STRING :  _sprintf(*buf,_T("   The string contains a non-printable character.  ( CRYPT_E_INVALID_PRINTABLE_STRING _HRESULT_TYPEDEF_(0x80092021L) "));
		; break;;case  CRYPT_E_INVALID_IA5_STRING :  _sprintf(*buf,_T("   The string contains a character not in the 7 bit ASCII character set.  ( CRYPT_E_INVALID_IA5_STRING       _HRESULT_TYPEDEF_(0x80092022L) "));
		; break;;case  CRYPT_E_INVALID_X500_STRING :  _sprintf(*buf,_T("   The string contains an invalid X500 name attribute key, oid, value or delimiter.  ( CRYPT_E_INVALID_X500_STRING      _HRESULT_TYPEDEF_(0x80092023L) "));
		; break;;case  CRYPT_E_NOT_CHAR_STRING :  _sprintf(*buf,_T("   The dwValueType for the CERT_NAME_VALUE is not one of the character strings.  Most likely it is either a CERT_RDN_ENCODED_BLOB or CERT_TDN_OCTED_STRING.  ( CRYPT_E_NOT_CHAR_STRING          _HRESULT_TYPEDEF_(0x80092024L) "));
		; break;;case  CRYPT_E_FILERESIZED :  _sprintf(*buf,_T("   The Put operation can not continue.  The file needs to be resized.  However, there is already a signature present.  A complete signing operation must be done.  ( CRYPT_E_FILERESIZED              _HRESULT_TYPEDEF_(0x80092025L) "));
		; break;;case  CRYPT_E_SECURITY_SETTINGS :  _sprintf(*buf,_T("   The cryptography operation has failed due to a local security option setting.  ( CRYPT_E_SECURITY_SETTINGS        _HRESULT_TYPEDEF_(0x80092026L) "));
		; break;;case  CRYPT_E_NO_VERIFY_USAGE_DLL :  _sprintf(*buf,_T("   No DLL or exported function was found to verify subject usage.  ( CRYPT_E_NO_VERIFY_USAGE_DLL      _HRESULT_TYPEDEF_(0x80092027L) "));
		; break;;case  CRYPT_E_NO_VERIFY_USAGE_CHECK :  _sprintf(*buf,_T("   The called function wasn't able to do a usage check on the subject.  ( CRYPT_E_NO_VERIFY_USAGE_CHECK    _HRESULT_TYPEDEF_(0x80092028L) "));
		; break;;case  CRYPT_E_VERIFY_USAGE_OFFLINE :  _sprintf(*buf,_T("   Since the server was offline, the called function wasn't able to complete the usage check.  ( CRYPT_E_VERIFY_USAGE_OFFLINE     _HRESULT_TYPEDEF_(0x80092029L) "));
		; break;;case  CRYPT_E_NOT_IN_CTL :  _sprintf(*buf,_T("   The subject was not found in a Certificate Trust List (CTL).  ( CRYPT_E_NOT_IN_CTL               _HRESULT_TYPEDEF_(0x8009202AL) "));
		; break;;case  CRYPT_E_NO_TRUSTED_SIGNER :  _sprintf(*buf,_T("   No trusted signer was found to verify the signature of the message or trust list.  ( CRYPT_E_NO_TRUSTED_SIGNER        _HRESULT_TYPEDEF_(0x8009202BL) "));
		; break;;case  CRYPT_E_OSS_ERROR :  _sprintf(*buf,_T("   OSS Certificate encode/decode error code base   See asn1code.h for a definition of the OSS runtime errors. The OSS  error values are offset by CRYPT_E_OSS_ERROR.  ( CRYPT_E_OSS_ERROR                _HRESULT_TYPEDEF_(0x80093000L) "));
		; break;;case  CERTSRV_E_BAD_REQUESTSUBJECT :  _sprintf(*buf,_T("   The request subject name is invalid or too long.  ( CERTSRV_E_BAD_REQUESTSUBJECT     _HRESULT_TYPEDEF_(0x80094001L) "));
		; break;;case  CERTSRV_E_NO_REQUEST :  _sprintf(*buf,_T("   The request does not exist.  ( CERTSRV_E_NO_REQUEST             _HRESULT_TYPEDEF_(0x80094002L) "));
		; break;;case  CERTSRV_E_BAD_REQUESTSTATUS :  _sprintf(*buf,_T("   The request's current status does not allow this operation.  ( CERTSRV_E_BAD_REQUESTSTATUS      _HRESULT_TYPEDEF_(0x80094003L) "));
		; break;;case  CERTSRV_E_PROPERTY_EMPTY :  _sprintf(*buf,_T("   The requested property value is empty.  ( CERTSRV_E_PROPERTY_EMPTY         _HRESULT_TYPEDEF_(0x80094004L) "));
		; break;;case  CERTDB_E_JET_ERROR :  _sprintf(*buf,_T("   Jet error code base   See jet.h for a definition of the Jet runtime errors.  Negative Jet error values are masked to three digits and offset by CERTDB_E_JET_ERROR.  ( CERTDB_E_JET_ERROR               _HRESULT_TYPEDEF_(0x80095000L) "));
		; break;;case  TRUST_E_SYSTEM_ERROR :  _sprintf(*buf,_T("   A system-level error occured while verifying trust.  ( TRUST_E_SYSTEM_ERROR             _HRESULT_TYPEDEF_(0x80096001L) "));
		; break;;case  TRUST_E_NO_SIGNER_CERT :  _sprintf(*buf,_T("   The certificate for the signer of the message is invalid or not found.  ( TRUST_E_NO_SIGNER_CERT           _HRESULT_TYPEDEF_(0x80096002L) "));
		; break;;case  TRUST_E_COUNTER_SIGNER :  _sprintf(*buf,_T("   One of the counter signers was invalid.  ( TRUST_E_COUNTER_SIGNER           _HRESULT_TYPEDEF_(0x80096003L) "));
		; break;;case  TRUST_E_CERT_SIGNATURE :  _sprintf(*buf,_T("   The signature of the certificate can not be verified.  ( TRUST_E_CERT_SIGNATURE           _HRESULT_TYPEDEF_(0x80096004L) "));
		; break;;case  TRUST_E_TIME_STAMP :  _sprintf(*buf,_T("   The time stamp signer and or certificate could not be verified or is malformed.  ( TRUST_E_TIME_STAMP               _HRESULT_TYPEDEF_(0x80096005L) "));
		; break;;case  TRUST_E_BAD_DIGEST :  _sprintf(*buf,_T("   The objects digest did not verify.  ( TRUST_E_BAD_DIGEST               _HRESULT_TYPEDEF_(0x80096010L) "));
		; break;;case  TRUST_E_BASIC_CONSTRAINTS :  _sprintf(*buf,_T("   The cerficates basic constraints are invalid or missing.  ( TRUST_E_BASIC_CONSTRAINTS        _HRESULT_TYPEDEF_(0x80096019L) "));
		; break;;case  TRUST_E_FINANCIAL_CRITERIA :  _sprintf(*buf,_T("   The certificate does not meet or contain the Authenticode financial extensions.  ( TRUST_E_FINANCIAL_CRITERIA       _HRESULT_TYPEDEF_(0x8009601EL)  ( NTE_OP_OK 0 "));
#endif
		; break;;case  TRUST_E_PROVIDER_UNKNOWN :  _sprintf(*buf,_T("   The specified trust provider is not known on this system.  ( TRUST_E_PROVIDER_UNKNOWN         _HRESULT_TYPEDEF_(0x800B0001L) "));
		; break;;case  TRUST_E_ACTION_UNKNOWN :  _sprintf(*buf,_T("   The trust verification action specified is not supported by the specified trust provider.  ( TRUST_E_ACTION_UNKNOWN           _HRESULT_TYPEDEF_(0x800B0002L) "));
		; break;;case  TRUST_E_SUBJECT_FORM_UNKNOWN :  _sprintf(*buf,_T("   The form specified for the subject is not one supported or known by the specified trust provider.  ( TRUST_E_SUBJECT_FORM_UNKNOWN     _HRESULT_TYPEDEF_(0x800B0003L) "));
		; break;;case  TRUST_E_SUBJECT_NOT_TRUSTED :  _sprintf(*buf,_T("   The subject is not trusted for the specified action.  ( TRUST_E_SUBJECT_NOT_TRUSTED      _HRESULT_TYPEDEF_(0x800B0004L) "));
		; break;;case  DIGSIG_E_ENCODE :  _sprintf(*buf,_T("   Error due to problem in ASN.1 encoding process.  ( DIGSIG_E_ENCODE                  _HRESULT_TYPEDEF_(0x800B0005L) "));
		; break;;case  DIGSIG_E_DECODE :  _sprintf(*buf,_T("   Error due to problem in ASN.1 decoding process.  ( DIGSIG_E_DECODE                  _HRESULT_TYPEDEF_(0x800B0006L) "));
		; break;;case  DIGSIG_E_EXTENSIBILITY :  _sprintf(*buf,_T("   Reading / writing Extensions where Attributes are appropriate, and visa versa.  ( DIGSIG_E_EXTENSIBILITY           _HRESULT_TYPEDEF_(0x800B0007L) "));
		; break;;case  DIGSIG_E_CRYPTO :  _sprintf(*buf,_T("   Unspecified cryptographic failure.  ( DIGSIG_E_CRYPTO                  _HRESULT_TYPEDEF_(0x800B0008L) "));
		; break;;case  PERSIST_E_SIZEDEFINITE :  _sprintf(*buf,_T("   The size of the data could not be determined.  ( PERSIST_E_SIZEDEFINITE           _HRESULT_TYPEDEF_(0x800B0009L) "));
		; break;;case  PERSIST_E_SIZEINDEFINITE :  _sprintf(*buf,_T("   The size of the indefinite-sized data could not be determined.  ( PERSIST_E_SIZEINDEFINITE         _HRESULT_TYPEDEF_(0x800B000AL) "));
		; break;;case  PERSIST_E_NOTSELFSIZING :  _sprintf(*buf,_T("   This object does not read and write self-sizing data.  ( PERSIST_E_NOTSELFSIZING          _HRESULT_TYPEDEF_(0x800B000BL) "));
		; break;;case  TRUST_E_NOSIGNATURE :  _sprintf(*buf,_T("   No signature was present in the subject.  ( TRUST_E_NOSIGNATURE              _HRESULT_TYPEDEF_(0x800B0100L) "));
		; break;;case  CERT_E_EXPIRED :  _sprintf(*buf,_T("   A required certificate is not within its validity period.  ( CERT_E_EXPIRED                   _HRESULT_TYPEDEF_(0x800B0101L) "));
#ifndef VCPP50
		; break;;case  CERT_E_VALIDITYPERIODNESTING :  _sprintf(*buf,_T("   The validity periods of the certification chain do not nest correctly.  ( CERT_E_VALIDITYPERIODNESTING     _HRESULT_TYPEDEF_(0x800B0102L) "));
#endif
		; break;;case  CERT_E_ROLE :  _sprintf(*buf,_T("   A certificate that can only be used as an end-entity is being used as a CA or visa versa.  ( CERT_E_ROLE                      _HRESULT_TYPEDEF_(0x800B0103L) "));
		; break;;case  CERT_E_PATHLENCONST :  _sprintf(*buf,_T("   A path length constraint in the certification chain has been violated.  ( CERT_E_PATHLENCONST              _HRESULT_TYPEDEF_(0x800B0104L) "));
		; break;;case  CERT_E_CRITICAL :  _sprintf(*buf,_T("   An extension of unknown type that is labeled 'critical' is present in a certificate.  ( CERT_E_CRITICAL                  _HRESULT_TYPEDEF_(0x800B0105L) "));
		; break;;case  CERT_E_PURPOSE :  _sprintf(*buf,_T("   A certificate is being used for a purpose other than that for which it is permitted.  ( CERT_E_PURPOSE                   _HRESULT_TYPEDEF_(0x800B0106L) "));
		; break;;case  CERT_E_ISSUERCHAINING :  _sprintf(*buf,_T("   A parent of a given certificate in fact did not issue that child certificate.  ( CERT_E_ISSUERCHAINING            _HRESULT_TYPEDEF_(0x800B0107L) "));
		; break;;case  CERT_E_MALFORMED :  _sprintf(*buf,_T("   A certificate is missing or has an empty value for an important field, such as a subject or issuer name.  ( CERT_E_MALFORMED                 _HRESULT_TYPEDEF_(0x800B0108L) "));
		; break;;case  CERT_E_UNTRUSTEDROOT :  _sprintf(*buf,_T("   A certification chain processed correctly, but terminated in a root certificate which isn't trusted by the trust provider.  ( CERT_E_UNTRUSTEDROOT             _HRESULT_TYPEDEF_(0x800B0109L) "));
		; break;;case  CERT_E_CHAINING :  _sprintf(*buf,_T("   A chain of certs didn't chain as they should in a certain application of chaining.  ( CERT_E_CHAINING                  _HRESULT_TYPEDEF_(0x800B010AL) "));
#ifndef VCPP50
		; break;;case  TRUST_E_FAIL :  _sprintf(*buf,_T("   Generic Trust Failure.  ( TRUST_E_FAIL                     _HRESULT_TYPEDEF_(0x800B010BL) "));
		; break;;case  CERT_E_REVOKED :  _sprintf(*buf,_T("   A certificate was explicitly revoked by its issuer.  ( CERT_E_REVOKED                   _HRESULT_TYPEDEF_(0x800B010CL) "));
		; break;;case  CERT_E_UNTRUSTEDTESTROOT :  _sprintf(*buf,_T("   The root certificate is a testing certificate and the policy settings disallow test certificates.  ( CERT_E_UNTRUSTEDTESTROOT         _HRESULT_TYPEDEF_(0x800B010DL) "));
		; break;;case  CERT_E_REVOCATION_FAILURE :  _sprintf(*buf,_T("   The revocation process could not continue - the certificate(s) could not be checked.  ( CERT_E_REVOCATION_FAILURE        _HRESULT_TYPEDEF_(0x800B010EL) "));
		; break;;case  CERT_E_CN_NO_MATCH :  _sprintf(*buf,_T("   The certificate's CN name does not match the passed value.  ( CERT_E_CN_NO_MATCH               _HRESULT_TYPEDEF_(0x800B010FL) "));
		; break;;case  CERT_E_WRONG_USAGE :  _sprintf(*buf,_T("   The certificate is not valid for the requested usage.  ( CERT_E_WRONG_USAGE               _HRESULT_TYPEDEF_(0x800B0110L)  *****************"));
		; break;;case  SPAPI_E_EXPECTED_SECTION_NAME :  _sprintf(*buf,_T("   A non-empty line was encountered in the INF before the start of a section.  ( SPAPI_E_EXPECTED_SECTION_NAME    _HRESULT_TYPEDEF_(0x800F0000L) "));
		; break;;case  SPAPI_E_BAD_SECTION_NAME_LINE :  _sprintf(*buf,_T("   A section name marker in the INF is not complete, or does not exist on a line by itself.  ( SPAPI_E_BAD_SECTION_NAME_LINE    _HRESULT_TYPEDEF_(0x800F0001L) "));
		; break;;case  SPAPI_E_SECTION_NAME_TOO_LONG :  _sprintf(*buf,_T("   An INF section was encountered whose name exceeds the maximum section name length.  ( SPAPI_E_SECTION_NAME_TOO_LONG    _HRESULT_TYPEDEF_(0x800F0002L) "));
		; break;;case  SPAPI_E_GENERAL_SYNTAX :  _sprintf(*buf,_T("   The syntax of the INF is invalid.  ( SPAPI_E_GENERAL_SYNTAX           _HRESULT_TYPEDEF_(0x800F0003L) "));
		; break;;case  SPAPI_E_WRONG_INF_STYLE :  _sprintf(*buf,_T("   The style of the INF is different than what was requested.  ( SPAPI_E_WRONG_INF_STYLE          _HRESULT_TYPEDEF_(0x800F0100L) "));
		; break;;case  SPAPI_E_SECTION_NOT_FOUND :  _sprintf(*buf,_T("   The required section was not found in the INF.  ( SPAPI_E_SECTION_NOT_FOUND        _HRESULT_TYPEDEF_(0x800F0101L) "));
		; break;;case  SPAPI_E_LINE_NOT_FOUND :  _sprintf(*buf,_T("   The required line was not found in the INF.  ( SPAPI_E_LINE_NOT_FOUND           _HRESULT_TYPEDEF_(0x800F0102L) "));
		; break;;case  SPAPI_E_NO_ASSOCIATED_CLASS :  _sprintf(*buf,_T("   The INF or the device information set or element does not have an associated install class.  ( SPAPI_E_NO_ASSOCIATED_CLASS      _HRESULT_TYPEDEF_(0x800F0200L) "));
		; break;;case  SPAPI_E_CLASS_MISMATCH :  _sprintf(*buf,_T("   The INF or the device information set or element does not match the specified install class.  ( SPAPI_E_CLASS_MISMATCH           _HRESULT_TYPEDEF_(0x800F0201L) "));
		; break;;case  SPAPI_E_DUPLICATE_FOUND :  _sprintf(*buf,_T("   An existing device was found that is a duplicate of the device being manually installed.  ( SPAPI_E_DUPLICATE_FOUND          _HRESULT_TYPEDEF_(0x800F0202L) "));
		; break;;case  SPAPI_E_NO_DRIVER_SELECTED :  _sprintf(*buf,_T("   There is no driver selected for the device information set or element.  ( SPAPI_E_NO_DRIVER_SELECTED       _HRESULT_TYPEDEF_(0x800F0203L) "));
		; break;;case  SPAPI_E_KEY_DOES_NOT_EXIST :  _sprintf(*buf,_T("   The requested device registry key does not exist.  ( SPAPI_E_KEY_DOES_NOT_EXIST       _HRESULT_TYPEDEF_(0x800F0204L) "));
		; break;;case  SPAPI_E_INVALID_DEVINST_NAME :  _sprintf(*buf,_T("   The device instance name is invalid.  ( SPAPI_E_INVALID_DEVINST_NAME     _HRESULT_TYPEDEF_(0x800F0205L) "));
		; break;;case  SPAPI_E_INVALID_CLASS :  _sprintf(*buf,_T("   The install class is not present or is invalid.  ( SPAPI_E_INVALID_CLASS            _HRESULT_TYPEDEF_(0x800F0206L) "));
		; break;;case  SPAPI_E_DEVINST_ALREADY_EXISTS :  _sprintf(*buf,_T("   The device instance cannot be created because it already exists.  ( SPAPI_E_DEVINST_ALREADY_EXISTS   _HRESULT_TYPEDEF_(0x800F0207L) "));
		; break;;case  SPAPI_E_DEVINFO_NOT_REGISTERED :  _sprintf(*buf,_T("   The operation cannot be performed on a device information element that has not been registered.  ( SPAPI_E_DEVINFO_NOT_REGISTERED   _HRESULT_TYPEDEF_(0x800F0208L) "));
		; break;;case  SPAPI_E_INVALID_REG_PROPERTY :  _sprintf(*buf,_T("   The device property code is invalid.  ( SPAPI_E_INVALID_REG_PROPERTY     _HRESULT_TYPEDEF_(0x800F0209L) "));
		; break;;case  SPAPI_E_NO_INF :  _sprintf(*buf,_T("   The INF from which a driver list is to be built does not exist.  ( SPAPI_E_NO_INF                   _HRESULT_TYPEDEF_(0x800F020AL) "));
		; break;;case  SPAPI_E_NO_SUCH_DEVINST :  _sprintf(*buf,_T("   The device instance does not exist in the hardware tree.  ( SPAPI_E_NO_SUCH_DEVINST          _HRESULT_TYPEDEF_(0x800F020BL) "));
		; break;;case  SPAPI_E_CANT_LOAD_CLASS_ICON :  _sprintf(*buf,_T("   The icon representing this install class cannot be loaded.  ( SPAPI_E_CANT_LOAD_CLASS_ICON     _HRESULT_TYPEDEF_(0x800F020CL) "));
		; break;;case  SPAPI_E_INVALID_CLASS_INSTALLER :  _sprintf(*buf,_T("   The class installer registry entry is invalid.  ( SPAPI_E_INVALID_CLASS_INSTALLER  _HRESULT_TYPEDEF_(0x800F020DL) "));
		; break;;case  SPAPI_E_DI_DO_DEFAULT :  _sprintf(*buf,_T("   The class installer has indicated that the default action should be performed for this installation request.  ( SPAPI_E_DI_DO_DEFAULT            _HRESULT_TYPEDEF_(0x800F020EL) "));
		; break;;case  SPAPI_E_DI_NOFILECOPY :  _sprintf(*buf,_T("   The operation does not require any files to be copied.  ( SPAPI_E_DI_NOFILECOPY            _HRESULT_TYPEDEF_(0x800F020FL) "));
		; break;;case  SPAPI_E_INVALID_HWPROFILE :  _sprintf(*buf,_T("   The specified hardware profile does not exist.  ( SPAPI_E_INVALID_HWPROFILE        _HRESULT_TYPEDEF_(0x800F0210L) "));
		; break;;case  SPAPI_E_NO_DEVICE_SELECTED :  _sprintf(*buf,_T("   There is no device information element currently selected for this device information set.  ( SPAPI_E_NO_DEVICE_SELECTED       _HRESULT_TYPEDEF_(0x800F0211L) "));
		; break;;case  SPAPI_E_DEVINFO_LIST_LOCKED :  _sprintf(*buf,_T("   The operation cannot be performed because the device information set is locked.  ( SPAPI_E_DEVINFO_LIST_LOCKED      _HRESULT_TYPEDEF_(0x800F0212L) "));
		; break;;case  SPAPI_E_DEVINFO_DATA_LOCKED :  _sprintf(*buf,_T("   The operation cannot be performed because the device information element is locked.  ( SPAPI_E_DEVINFO_DATA_LOCKED      _HRESULT_TYPEDEF_(0x800F0213L) "));
		; break;;case  SPAPI_E_DI_BAD_PATH :  _sprintf(*buf,_T("   The specified path does not contain any applicable device INFs.  ( SPAPI_E_DI_BAD_PATH              _HRESULT_TYPEDEF_(0x800F0214L) "));
		; break;;case  SPAPI_E_NO_CLASSINSTALL_PARAMS :  _sprintf(*buf,_T("   No class installer parameters have been set for the device information set or element.  ( SPAPI_E_NO_CLASSINSTALL_PARAMS   _HRESULT_TYPEDEF_(0x800F0215L) "));
		; break;;case  SPAPI_E_FILEQUEUE_LOCKED :  _sprintf(*buf,_T("   The operation cannot be performed because the file queue is locked.  ( SPAPI_E_FILEQUEUE_LOCKED         _HRESULT_TYPEDEF_(0x800F0216L) "));
		; break;;case  SPAPI_E_BAD_SERVICE_INSTALLSECT :  _sprintf(*buf,_T("   A service installation section in this INF is invalid.  ( SPAPI_E_BAD_SERVICE_INSTALLSECT  _HRESULT_TYPEDEF_(0x800F0217L) "));
		; break;;case  SPAPI_E_NO_CLASS_DRIVER_LIST :  _sprintf(*buf,_T("   There is no class driver list for the device information element.  ( SPAPI_E_NO_CLASS_DRIVER_LIST     _HRESULT_TYPEDEF_(0x800F0218L) "));
		; break;;case  SPAPI_E_NO_ASSOCIATED_SERVICE :  _sprintf(*buf,_T("   The installation failed because a function driver was not specified for this device instance.  ( SPAPI_E_NO_ASSOCIATED_SERVICE    _HRESULT_TYPEDEF_(0x800F0219L) "));
		; break;;case  SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE :  _sprintf(*buf,_T("   There is presently no default device interface designated for this interface class.  ( SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE _HRESULT_TYPEDEF_(0x800F021AL) "));
		; break;;case  SPAPI_E_DEVICE_INTERFACE_ACTIVE :  _sprintf(*buf,_T("   The operation cannot be performed because the device interface is currently active.  ( SPAPI_E_DEVICE_INTERFACE_ACTIVE  _HRESULT_TYPEDEF_(0x800F021BL) "));
		; break;;case  SPAPI_E_DEVICE_INTERFACE_REMOVED :  _sprintf(*buf,_T("   The operation cannot be performed because the device interface has been removed from the system.  ( SPAPI_E_DEVICE_INTERFACE_REMOVED _HRESULT_TYPEDEF_(0x800F021CL) "));
		; break;;case  SPAPI_E_BAD_INTERFACE_INSTALLSECT :  _sprintf(*buf,_T("   An interface installation section in this INF is invalid.  ( SPAPI_E_BAD_INTERFACE_INSTALLSECT _HRESULT_TYPEDEF_(0x800F021DL) "));
		; break;;case  SPAPI_E_NO_SUCH_INTERFACE_CLASS :  _sprintf(*buf,_T("   This interface class does not exist in the system.  ( SPAPI_E_NO_SUCH_INTERFACE_CLASS  _HRESULT_TYPEDEF_(0x800F021EL) "));
		; break;;case  SPAPI_E_INVALID_REFERENCE_STRING :  _sprintf(*buf,_T("   The reference string supplied for this interface device is invalid.  ( SPAPI_E_INVALID_REFERENCE_STRING _HRESULT_TYPEDEF_(0x800F021FL) "));
		; break;;case  SPAPI_E_INVALID_MACHINENAME :  _sprintf(*buf,_T("   The specified machine name does not conform to UNC naming conventions.  ( SPAPI_E_INVALID_MACHINENAME      _HRESULT_TYPEDEF_(0x800F0220L) "));
		; break;;case  SPAPI_E_REMOTE_COMM_FAILURE :  _sprintf(*buf,_T("   A general remote communication error occurred.  ( SPAPI_E_REMOTE_COMM_FAILURE      _HRESULT_TYPEDEF_(0x800F0221L) "));
		; break;;case  SPAPI_E_MACHINE_UNAVAILABLE :  _sprintf(*buf,_T("   The machine selected for remote communication is not available at this time.  ( SPAPI_E_MACHINE_UNAVAILABLE      _HRESULT_TYPEDEF_(0x800F0222L) "));
		; break;;case  SPAPI_E_NO_CONFIGMGR_SERVICES :  _sprintf(*buf,_T("   The Plug and Play service is not available on the remote machine.  ( SPAPI_E_NO_CONFIGMGR_SERVICES    _HRESULT_TYPEDEF_(0x800F0223L) "));
		; break;;case  SPAPI_E_INVALID_PROPPAGE_PROVIDER :  _sprintf(*buf,_T("   The property page provider registry entry is invalid.  ( SPAPI_E_INVALID_PROPPAGE_PROVIDER _HRESULT_TYPEDEF_(0x800F0224L) "));
		; break;;case  SPAPI_E_NO_SUCH_DEVICE_INTERFACE :  _sprintf(*buf,_T("   The requested device interface is not present in the system.  ( SPAPI_E_NO_SUCH_DEVICE_INTERFACE _HRESULT_TYPEDEF_(0x800F0225L) "));
		; break;;case  SPAPI_E_DI_POSTPROCESSING_REQUIRED :  _sprintf(*buf,_T("   The device's co-installer has additional work to perform after installation is complete.  ( SPAPI_E_DI_POSTPROCESSING_REQUIRED _HRESULT_TYPEDEF_(0x800F0226L) "));
		; break;;case  SPAPI_E_INVALID_COINSTALLER :  _sprintf(*buf,_T("   The device's co-installer is invalid.  ( SPAPI_E_INVALID_COINSTALLER      _HRESULT_TYPEDEF_(0x800F0227L) "));
		; break;;case  SPAPI_E_NO_COMPAT_DRIVERS :  _sprintf(*buf,_T("   There are no compatible drivers for this device.  ( SPAPI_E_NO_COMPAT_DRIVERS        _HRESULT_TYPEDEF_(0x800F0228L) "));
		; break;;case  SPAPI_E_NO_DEVICE_ICON :  _sprintf(*buf,_T("   There is no icon that represents this device or device type.  ( SPAPI_E_NO_DEVICE_ICON           _HRESULT_TYPEDEF_(0x800F0229L) "));
		; break;;case  SPAPI_E_INVALID_INF_LOGCONFIG :  _sprintf(*buf,_T("   A logical configuration specified in this INF is invalid.  ( SPAPI_E_INVALID_INF_LOGCONFIG    _HRESULT_TYPEDEF_(0x800F022AL) "));
		; break;;case  SPAPI_E_DI_DONT_INSTALL :  _sprintf(*buf,_T("   The class in"));
		; break;;case  SPAPI_E_ERROR_NOT_INSTALLED :  _sprintf(*buf,_T("staller has denied the request to install or upgrade this device.  ( SPAPI_E_DI_DONT_INSTALL          _HRESULT_TYPEDEF_(0x800F022BL) "));
		; break;;case  SPAPI_E_INVALID_FILTER_DRIVER :  _sprintf(*buf,_T("   One of the filter drivers installed for this device is invalid.  ( SPAPI_E_INVALID_FILTER_DRIVER    _HRESULT_TYPEDEF_(0x800F022CL) "));
#endif
		default: _sprintf(*buf,_T("I don't know this error"));
	}
	return *buf;         
}