// ProgressDlgThread.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "ProgressDlgThread.h"
#include "WiatProgressDlg.h"

// CProgressDlgThread

IMPLEMENT_DYNCREATE(CProgressDlgThread, CWinThread)

CProgressDlgThread::CProgressDlgThread()
{
	m_sTitle =  APL_T(" ");
	m_Text = _T("");

	m_End = 0;
	m_bInit = false;
	m_bCanceled = false;
}

CProgressDlgThread::~CProgressDlgThread()
{
}

BOOL CProgressDlgThread::InitInstance()
{
	CWiatProgressDlg dlg;

	m_pMainWnd = &dlg;
	dlg.m_txt = m_Text;
	dlg.m_sTitle = m_sTitle;
	dlg.m_Thread = this;
	m_bInit = true;
	
	dlg.DoModal();
	return FALSE;
}

int CProgressDlgThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CProgressDlgThread, CWinThread)
END_MESSAGE_MAP()

void CProgressDlgThread::IncreaseValue( int val )
{
	if(m_End==1 || !m_bInit) return;

	for(int i=0; i<val; i++)
		((CWiatProgressDlg*)m_pMainWnd)->m_progress.StepIt();
}

BOOL CProgressDlgThread::IsInitialized()
{
	if(m_End==1 || !m_bInit) return false;
	if(!((CWiatProgressDlg*)m_pMainWnd)->m_bInit) return false;

	return IsWindow(((CWiatProgressDlg*)m_pMainWnd)->m_progress.GetSafeHwnd());	
}

void CProgressDlgThread::SetText( const TCHAR * text )
{
	if(m_End==1 || !m_bInit) return;
	if(!((CWiatProgressDlg*)m_pMainWnd)->m_progress) return;

	((CWiatProgressDlg*)m_pMainWnd)->SetText(text);
}


void CProgressDlgThread::SetTitle( const TCHAR* title )
{
	if(m_End==1 || !m_bInit) return;
	if(!((CWiatProgressDlg*)m_pMainWnd)->m_progress) return;

	((CWiatProgressDlg*)m_pMainWnd)->SetTitle(title);
}

bool CProgressDlgThread::IsReal()
{
	if(m_End==1 || !m_bInit) return false;
	if(!((CWiatProgressDlg*)m_pMainWnd)->m_progress) return false;

	return true;
}

bool CProgressDlgThread::End()
{
	CWiatProgressDlg *pDlg = (CWiatProgressDlg*)m_pMainWnd;
	if(pDlg && ::IsWindow(pDlg->m_hWnd)) 
	{
		HWND hWnd = m_pMainWnd->m_hWnd;
		//m_pMainWnd->SendMessage(WM_CLOSE);
		pDlg->Exit();

		while(::IsWindow(hWnd))
		{
			MSG msg;
			while (::PeekMessage(&msg, NULL, WM_PAINT, WM_PAINT, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
			while (::PeekMessage(&msg, NULL, WM_TIMER, WM_TIMER, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
			while (::PeekMessage(&msg, NULL, WM_SHOWWINDOW, WM_SHOWWINDOW, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
			while (::PeekMessage(&msg, NULL, WM_SIZE, WM_SIZE, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
			while (::PeekMessage(&msg, NULL, WM_COMMAND, WM_COMMAND, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
			while (::PeekMessage(&msg, NULL, WM_CLOSE, WM_COMMAND, PM_REMOVE|  PM_NOYIELD))
				DispatchMessage(&msg);
		}
	}

	return true;
}

void CProgressDlgThread::DisableBreakButton()
{
	((CWiatProgressDlg*)m_pMainWnd)->GetDlgItem(IDC_STOP)->EnableWindow(FALSE);
}

void CProgressDlgThread::SetValue( int val )
{
	if(m_End==1 || !m_bInit) return;

	for(int i=0; i<val; i++)
		((CWiatProgressDlg*)m_pMainWnd)->m_progress.SetPos(val);
}
// CProgressDlgThread message handlers
