#include "stdafx.h"
#include "apl_gui.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CaplResizablePropertySheet, CPropertySheet)

CaplResizablePropertySheet::CaplResizablePropertySheet(UINT nIDCaption, CWnd *pParentWnd, UINT iSelectPage) 
						:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
	m_psh.dwFlags |= PSH_NOAPPLYNOW;    // Lose the Apply Now button
	m_psh.dwFlags &= ~PSH_HASHELP;  // Lose the Help button

}

CaplResizablePropertySheet::CaplResizablePropertySheet(LPCTSTR pszCaption, CWnd *pParentWnd, UINT iSelectPage) 
						:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
	m_psh.dwFlags |= PSH_NOAPPLYNOW;    // Lose the Apply Now button
	m_psh.dwFlags &= ~PSH_HASHELP;  // Lose the Help button

}

CaplResizablePropertySheet::~CaplResizablePropertySheet()
{
}


BEGIN_MESSAGE_MAP(CaplResizablePropertySheet, CPropertySheet)
	//{{AFX_MSG_MAP(CaplResizablePropertySheet)
	ON_WM_SIZE()
	ON_WM_GETMINMAXINFO()
	ON_WM_PAINT()
	ON_COMMAND(IDOK, OnOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CaplResizablePropertySheet::GetPageRect(RECT *pRect)
{
	CRect rcClient;
	GetClientRect(rcClient);

	// Set the page rect and adjust using the original page size
	pRect->left   =m_rcPage.left;
	pRect->top    =m_rcPage.top;
	pRect->right  =rcClient.right-(m_rcClient.right-m_rcPage.right);
	pRect->bottom =rcClient.bottom-(m_rcClient.bottom-m_rcPage.bottom);

}

BOOL CaplResizablePropertySheet::InitButtons(void)
{
	/*
	 ok		- (610,610)-(685,633) - 75x23 now. need - 98x26. diff - 23,3
	 cancel	- (691,610)-(766,633) - 75x23 now. need - 98x26. diff - 23,3

	 moving all		by -3	by y
	 moving ok		by -46? by x
	 moving cancel	by -23	by x
	 */

	CWnd*	pWnd	=NULL;

	CRect	rt;

	pWnd=GetDlgItem(IDOK);
	if(NULL!=pWnd)
	{
		pWnd->GetWindowRect(rt);
		ScreenToClient(rt);
		rt.OffsetRect(-46,-3);
		rt.bottom+=3;
		rt.right+=23;
		pWnd->MoveWindow(rt,TRUE);

		m_btnOK.SubclassWindow(pWnd->m_hWnd);
		m_btnOK.SetIcon(GetAplStdIco16(APLSTDICO_OK));
		m_btnOK.SetFlat(FALSE);
	}

	pWnd=NULL;
	pWnd=GetDlgItem(IDCANCEL);
	if(NULL!=pWnd)
	{
		pWnd->GetWindowRect(rt);
		ScreenToClient(rt);
		rt.OffsetRect(-23,-3);
		rt.bottom+=3;
		rt.right+=23;
		pWnd->MoveWindow(rt,TRUE);

		m_btnCancel.SubclassWindow(pWnd->m_hWnd);
		m_btnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
		m_btnCancel.SetFlat(FALSE);
	}

	return TRUE;
}

BOOL CaplResizablePropertySheet::InitCenterImage(void)
{
	CWnd*	pwnd	=NULL;

	CRect rt(0,0,0,0),rt2(0,0,0,0);

	BITMAP bmp;

	int ioff=0;

	if(0==m_CenterBmp.GetObjectType())
		return TRUE;

	m_CenterBmp.GetBitmap(&bmp);
	rt.right=bmp.bmWidth;
	rt.bottom=bmp.bmHeight;

	rt.OffsetRect((m_rcClient.Width()/2)-(rt.Width()/2),5);

//	m_CenterBmpHolder.Create(NULL,WS_CHILD|WS_VISIBLE|WS_BORDER|SS_BITMAP,rt,this);
//	m_CenterBmpHolder.SetBitmap(HBITMAP(m_CenterBmp));	

	/*
	std -
		sheet.	526x544
		tab.	508x476
		dlg.	500x450

	w sheet resized
		sheet.	526x577 d	33
		tab.	508x476	d	0
		dlg.	500x483 d	33

	w sheet res & tab moved
		sheet.	526x577	d	33
		tab.	508x476	d	0
		dlg.	500x483	d	33


	 */

	//	  sheet    
	GetWindowRect(rt);
	GetParent()->ScreenToClient(rt);
	rt.bottom+=5+bmp.bmHeight;
	MoveWindow(rt,TRUE);

	pwnd=GetDlgItem(IDOK);
	pwnd->GetWindowRect(rt);
	ScreenToClient(rt);
	rt.OffsetRect(0,5+bmp.bmHeight);
	pwnd->MoveWindow(rt,TRUE);

	pwnd=GetDlgItem(IDCANCEL);
	pwnd->GetWindowRect(rt);
	ScreenToClient(rt);
	rt.OffsetRect(0,5+bmp.bmHeight);
	pwnd->MoveWindow(rt,TRUE);

	//	  tab control
	pwnd=GetDlgItem(AFX_IDC_TAB_CONTROL);
	pwnd->GetWindowRect(rt);
	ScreenToClient(rt);
	GetActivePage()->GetWindowRect(rt2);
	ScreenToClient(rt2);
	ioff=rt2.top-rt.top;

	rt.OffsetRect(0,5+bmp.bmHeight);
	pwnd->MoveWindow(rt,TRUE);

	//	    activepage - dialog
	GetActivePage()->GetWindowRect(rt2);
	ScreenToClient(rt2);
	rt2.OffsetRect(0,5+bmp.bmHeight);
	rt2.bottom-=5+bmp.bmHeight;
	GetActivePage()->MoveWindow(rt2);



	GetActivePage()->GetWindowRect(rt2);
	ScreenToClient(rt2);


	return TRUE;
}

BOOL CaplResizablePropertySheet::SetCenterImage(int iID)
{
	COLORMAP  cm;

	cm.from	=RGB(192,192,192);
	cm.to	=GetSysColor(COLOR_BTNFACE);

	if(FALSE==m_CenterBmp.LoadMappedBitmap(iID,0,&cm,1))
		return FALSE;

	return TRUE;
}

void CaplResizablePropertySheet::OnSize(UINT nType, int cx, int cy) 
{
	CRect	rcClient,rcPage;

	int		i;

	// Must repeatidly do this to keep the frame from restoring itself
	ModifyStyle(0,WS_THICKFRAME);

	CPropertySheet::OnSize(nType,cx,cy);

	// Make sure to erase the previous gripper position
	InvalidateRect(m_rcGripper,TRUE);

	if(GetTabControl())
	{
		GetClientRect(rcClient);
		GetPageRect(rcPage);

		// Resize all pages created 
		for(i=0;i<GetPageCount();i++)
		{
			CPropertyPage *page=GetPage(i);
			if(IsWindow(page->GetSafeHwnd()))
				page->MoveWindow(rcPage);
		}
		// Resize other controls
		m_Resize.Resize(this);
	}
}

BOOL CaplResizablePropertySheet::OnInitDialog() 
{
	CPropertySheet::OnInitDialog();

	ASSERT(GetActivePage()!=0);
	
	// Get the original client rect
	GetClientRect(m_rcClient);

	// Get the original page size 
	GetActivePage()->GetWindowRect(m_rcPage);
	ScreenToClient(m_rcPage);

//	disabled - not working
//	InitCenterImage();
	InitButtons();


	if(GetPageCount()>0)
	{
		CString cst;

		GetPage(0)->GetWindowText(cst);
		SetTitle(cst);
	}

	// Add all the controls to the resizer
	if (GetDlgItem(ID_APPLY_NOW)!=0)
		m_Resize.Add(this,ID_APPLY_NOW,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(ID_WIZBACK)!=0)
		m_Resize.Add(this,ID_WIZBACK,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(ID_WIZNEXT)!=0)
		m_Resize.Add(this,ID_WIZNEXT,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(ID_WIZFINISH)!=0)
		m_Resize.Add(this,ID_WIZFINISH,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(IDOK)!=0)
		m_Resize.Add(this,IDOK,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(IDHELP)!=0)
		m_Resize.Add(this,IDHELP,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(IDCANCEL)!=0)
		m_Resize.Add(this,IDCANCEL,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT);

	if (GetDlgItem(AFX_IDC_TAB_CONTROL)!=0)
		m_Resize.Add(this,AFX_IDC_TAB_CONTROL,RESIZE_LOCKALL);

	// Undocumented stuff, resize the two lines in wizard mode
	// Found the ID:s by using the Spy++ utility
	if (GetDlgItem(0x3026)!=0)
		m_Resize.Add(this,0x3026,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT|RESIZE_LOCKLEFT);
	if (GetDlgItem(0x3027)!=0)
		m_Resize.Add(this,0x3027,RESIZE_LOCKBOTTOM|RESIZE_LOCKRIGHT|RESIZE_LOCKLEFT);

	// Set the resizable border
	ModifyStyle(0, WS_THICKFRAME|WS_MAXIMIZEBOX);

	return TRUE; 
}

void CaplResizablePropertySheet::OnOK()
{
	Default();
}

LRESULT CaplResizablePropertySheet::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// In wizard mode, it seems like the tab control does not send notification
	// messages (Spy++ says it is disabled) when a page is activated. 
	// Therefore this is done to resize the page when it becomes active.
	// Is there a better way?
	if(message==WM_COMMAND)
	{
		UINT nNotifyCode	=HIWORD(wParam); // notification code 
		UINT nID			=LOWORD(wParam); // item, control, or accelerator identifier 
		HWND hwndCtl		=(HWND)lParam;   // handle of control 

		if(nNotifyCode==BN_CLICKED && (nID==ID_WIZNEXT||nID==ID_WIZBACK||nID==ID_WIZFINISH))
		{
			LRESULT result=CPropertySheet::WindowProc(message,wParam,lParam);

			// Make sure to resize it
			CRect rcPage;
			GetPageRect(rcPage);
			GetActivePage()->MoveWindow(rcPage);		

			return result;
		}
	}
	
	return CPropertySheet::WindowProc(message, wParam, lParam);
}

void CaplResizablePropertySheet::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CRect rc=m_rcClient;

	// Adjust it according to the window style
	AdjustWindowRect(rc,GetStyle(),FALSE);

	// Make sure it does not get smaller than the initial size
	lpMMI->ptMinTrackSize.x=rc.Width();
	lpMMI->ptMinTrackSize.y=rc.Height();
	
	CPropertySheet::OnGetMinMaxInfo(lpMMI);
}

void CaplResizablePropertySheet::OnPaint() 
{
	CPaintDC dc(this); 

	CRect rect;
	GetClientRect(&rect);

	// Get the standard size of the gripper
	rect.left=rect.right-GetSystemMetrics(SM_CXHSCROLL);
	rect.top=rect.bottom-GetSystemMetrics(SM_CYVSCROLL);

	// Draw it
	dc.DrawFrameControl(&rect,DFC_SCROLL,DFCS_SCROLLSIZEGRIP);

	// Save the painted rect so we can invalidate the rect on next OnSize()
	m_rcGripper=rect;
}
