#pragma once
#include "apl_gui.h"
#include <aplguiex.h>
#include "resource.h"

// CaplMultilineStringDlg dialog

class CaplMultilineStringDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CaplMultilineStringDlg)

public:
	CaplMultilineStringDlg(LPCTSTR lpTitle = NULL, LPCTSTR lpFullString = NULL, LPAplMakeStrFunction lpStrFun = NULL, LPCTSTR lpDelimeters = NULL, CWnd* pParent = NULL);   // standard constructor
	virtual ~CaplMultilineStringDlg();

// Dialog Data
	enum { IDD = IDD_MULTILINE_STRING_DLG };

protected:
	CString m_sFullString;	//   -     
	CString m_sTitle;
	CString m_sDelimeters;
	LPAplMakeStrFunction m_pStrFunction;

	//   
	void UpdateFullString();

	//     
	void ParseFullString();

	afx_msg void OnStartUserEditStrList(NMHDR* pNMHDR, LRESULT* pResult);

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	//    
	CString GetFullString() { return m_sFullString; }

	CaplButton m_add_btn;
	CaplButton m_delete_btn;
	CaplButton m_up_btn;
	CaplButton m_down_btn;
	CaplListCtrl m_str_list_ctrl;
	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	virtual BOOL OnInitDialog();
	afx_msg void OnNMClickStrList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedAddBtn();
	afx_msg void OnBnClickedDeleteBtn();
	afx_msg void OnBnClickedUpBtn();
	afx_msg void OnBnClickedDownBtn();
protected:
	virtual void OnOK();
};
