#include "stdafx.h"
#include "apl_gui.h"

CaplTranslateDialog::CaplTranslateDialog(UINT nIDTemplate, CWnd* pParentWnd /* = NULL */) :
CDialog(nIDTemplate, pParentWnd)
{
}

CaplTranslateDialog::CaplTranslateDialog(LPCTSTR lpszTemplateName, CWnd* pParentWnd /* = NULL */) :
CDialog(lpszTemplateName, pParentWnd)
{
}

BEGIN_MESSAGE_MAP(CaplTranslateDialog, CDialog)
	ON_NOTIFY_EX(TTN_NEEDTEXT, 0, OnToolTipShow)
END_MESSAGE_MAP()

bool CaplTranslateDialog::InitFont()
{
//       (        )
#ifdef _UNICODE
	CFont *pOldFont = GetFont();
	if(pOldFont)
	{
		if(m_font.m_hObject==0)
		{
			LOGFONT lf;
			pOldFont->GetLogFont(&lf);
			_strcpy(lf.lfFaceName, _T("Tahoma"));
			VERIFY(m_font.CreateFontIndirect(&lf));
		}
		SetFont(&m_font);

		return true;
	}
#endif

	return false;
}

BOOL CaplTranslateDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here

	//    
	bool bChangeFont = InitFont();

	// 
	if (CaplTranslate::IsNeedTranslate())
	{
		//   
		CString sText;
#ifdef _UNICODE
		GetWindowText(sText);
#else
		if (GetSafeHwnd())
		{
			CStringW sTextW;
			wchar_t buf[1024];
			::GetWindowTextW(GetSafeHwnd(), (LPWSTR)buf, 1023);
			CaplStringAdapter adapter(buf);
			sText = (LPCSTR)adapter;
		}
#endif
		CString sTranslatedText = CaplTranslate::Translate(sText);
		if (sTranslatedText != sText)
		{
			SetWindowText(CaplTranslate::Translate(sText));
		}

		//      
		CWnd *pWndChild = GetWindow(GW_CHILD);
		while(pWndChild)
		{
			if (bChangeFont)
				pWndChild->SetFont(&m_font);
#ifdef _UNICODE
			pWndChild->GetWindowText(sText);
#else
			if (pWndChild->GetSafeHwnd())
			{
				CStringW sTextW;
				wchar_t buf[1024];
				::GetWindowTextW(pWndChild->GetSafeHwnd(), (LPWSTR)buf, 1023);
				CaplStringAdapter adapter(buf);
				sText = (LPCSTR)adapter;
			}
#endif
			sTranslatedText = CaplTranslate::Translate(sText);
			if (sTranslatedText != sText)
			{
				pWndChild->SetWindowText(sTranslatedText);
			}
			pWndChild = pWndChild->GetNextWindow();
		}
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CaplTranslateDialog::OnToolTipShow( UINT id, NMHDR * pNMHDR, LRESULT * pResult )
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
	if(0==pTTT) return FALSE;
	UINT nID = pNMHDR->idFrom;
	if(0==nID) return FALSE;

	if (0==(pTTT->uFlags & TTF_IDISHWND)) return FALSE;

	nID = ::GetDlgCtrlID((HWND)nID);
	if(0==nID) return FALSE;

	if (!CaplTranslate::IsNeedTranslate())
	{
		pTTT->lpszText = MAKEINTRESOURCE(nID);
		pTTT->hinst = AfxGetResourceHandle();
		return TRUE;
	}

	CString tooltip_text;
	tooltip_text.LoadString(nID);
	if(tooltip_text==_T("")) return FALSE;

	static CString sOut; //        static 
	sOut=(LPTSTR)CaplTranslate::Translate(tooltip_text);
	pTTT->lpszText=(LPTSTR)(LPCTSTR)sOut;
	return TRUE;
}