#include "stdafx.h" 
#include "apl_gui.h"
#include <winver.h>
 
#ifdef _DEBUG 
#undef THIS_FILE 
static char THIS_FILE[]=__FILE__; 
#define new DEBUG_NEW 
#endif 
 

void GetVersionString(LPCTSTR appFName, LPCTSTR field_name, CString &buffer)
{
	CaplStackLogger stack_logger(__APL_FUNC__);

	buffer=_T("");
	if(field_name == 0) return;

	TCHAR subBlockName[255]; 
	DWORD fvHandle; 
	UINT  vSize; 

	LPBYTE  TransBlock; 
	LPVOID  FVData = 0; 
	LPTSTR	str_buf;

	DWORD dwSize = GetFileVersionInfoSize(appFName, &fvHandle); 

	if (dwSize) 
	{ 
		FVData = (LPVOID) new TCHAR[(UINT)dwSize]; 
		if (GetFileVersionInfo(appFName, fvHandle, dwSize, FVData)) 
		{ 
			_tcscpy(subBlockName, _T("\\VarFileInfo\\Translation")); 
			if (VerQueryValue(FVData, subBlockName, 
				(void **)&TransBlock, &vSize))
			{
				*(DWORD*)TransBlock = MAKELONG(HIWORD(*(DWORD*)TransBlock), 
					LOWORD(*(DWORD*)TransBlock)); 

				_stprintf(subBlockName, _T("\\StringFileInfo\\%08lx\\%s"), *(DWORD*)TransBlock, 
					field_name); 

				VerQueryValue(FVData, subBlockName, (void **)&str_buf, &vSize);
				if(vSize>0) buffer = str_buf;
			}
		} 
		if (FVData) delete FVData; 
	} 
}

void GetVersionString(HMODULE module, LPCTSTR field_name, CString &buffer)
{
    buffer=_T("");
	if(field_name == 0) return;

	TCHAR appFName[512]; 

	GetModuleFileName(module, (LPTSTR) appFName, sizeof(appFName)); 
	GetVersionString(appFName, field_name, buffer);
}
