// ComboTreeEdit.cpp

#include "stdafx.h"
#include "AplGuiEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ComboTreeEdit

CComboTreeEdit::CComboTreeEdit()
{
}

CComboTreeEdit::~CComboTreeEdit()
{
}

BEGIN_MESSAGE_MAP(CComboTreeEdit, CEdit)
	//{{AFX_MSG_MAP(ComboTreeEdit)
	ON_WM_CHAR()
	ON_WM_CONTEXTMENU()
	ON_WM_LBUTTONDOWN()
	ON_WM_PAINT()
	ON_WM_ACTIVATE()
	ON_CONTROL_REFLECT(EN_SETFOCUS, OnSetfocus)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_KILLFOCUS()
	ON_WM_GETDLGCODE()
	ON_WM_MOUSEACTIVATE()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_PASTE, OnIgnoreMessage )
	ON_MESSAGE(WM_CUT, OnIgnoreMessage)
	ON_MESSAGE(WM_CLEAR, OnIgnoreMessage)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ComboTreeEdit message handlers

void CComboTreeEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	UNREFERENCED_PARAMETER(nChar);
	UNREFERENCED_PARAMETER(nRepCnt);
	UNREFERENCED_PARAMETER(nFlags);

	//Customize this to do lookups, etc.
	return;	//make control read only
}

LRESULT CComboTreeEdit::OnIgnoreMessage(WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(wParam);
	UNREFERENCED_PARAMETER(lParam);
	// block cut, paste and clear messages
	return 0L;
}

void CComboTreeEdit::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	UNREFERENCED_PARAMETER(pWnd);
	UNREFERENCED_PARAMETER(point);
	//no context menu	
}

void CComboTreeEdit::OnLButtonDown(UINT nFlags, CPoint point) 
{
	UNREFERENCED_PARAMETER(point);
	UNREFERENCED_PARAMETER(nFlags);

	CComboTree* pParent = static_cast<CComboTree*>(GetParent());
	_ASSERTE(pParent);
	if (pParent)
	{
		if (pParent->GetDroppedState())
		{
			pParent->OnSelection();
		}
		else
		{
			pParent->ShowTree();
		}
	}
}

void CComboTreeEdit::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	COLORREF TextColor;
	COLORREF BkColor;

	BOOL bDrawHighlight = FALSE;

	//Draw text matching the style of a droplist ComboBox
	CComboTree* pParent = static_cast<CComboTree*>(GetParent());
	_ASSERTE(pParent);
	if (pParent && (pParent->IsEditHighlightOn() == TRUE))
	{
		bDrawHighlight = TRUE;
	}

	if (bDrawHighlight)
	{
		TextColor = GetSysColor(COLOR_HIGHLIGHTTEXT);
		BkColor = GetSysColor(COLOR_HIGHLIGHT);
	}
	else
	{
		TextColor = GetSysColor(COLOR_WINDOWTEXT);
		BkColor = GetSysColor(COLOR_WINDOW);
	}

	CString Text;
	GetWindowText(Text);

	CRect rect;
	GetClientRect(&rect);

	CBrush BkBrush(BkColor);

	dc.FillRect(&rect, &BkBrush);

	//dashed focus line if this or the dropdown button has the focus
	if (bDrawHighlight)
	{
		dc.DrawFocusRect(&rect);
	}

	int xBorder = GetSystemMetrics(SM_CXEDGE);
	rect.left += xBorder;

	CFont* pFont = GetFont();
	CFont* pOldFont = dc.SelectObject(pFont);
	COLORREF oldTextColor = dc.SetTextColor(TextColor);
	COLORREF oldBkColor = dc.SetBkColor(BkColor);

	dc.DrawText(Text, &rect, DT_LEFT | DT_VCENTER | DT_SINGLELINE);

	dc.SelectObject(pOldFont);
	dc.SetTextColor(oldTextColor);
	dc.SetBkColor(oldBkColor);
}

void CComboTreeEdit::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CEdit::OnActivate(nState, pWndOther, bMinimized);
	
	Invalidate();	
}

void CComboTreeEdit::OnSetfocus() 
{
	HideCaret();  //don't show blinking caret
	Invalidate();	
}

int CComboTreeEdit::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message)
{
	UNREFERENCED_PARAMETER(pDesktopWnd);
	UNREFERENCED_PARAMETER(nHitTest);
	UNREFERENCED_PARAMETER(message);

	return MA_ACTIVATE;
}

BOOL CComboTreeEdit::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	UNREFERENCED_PARAMETER(nFlags);
	UNREFERENCED_PARAMETER(zDelta);
	UNREFERENCED_PARAMETER(pt);

	return 0;
}

void CComboTreeEdit::OnMouseMove(UINT nFlags, CPoint point) 
{
	UNREFERENCED_PARAMETER(nFlags);
	UNREFERENCED_PARAMETER(point);
	//disregard text selection using the mouse
}

void CComboTreeEdit::OnKillfocus() 
{
	//restore caret
	ShowCaret();
	Invalidate();	
}

void CComboTreeEdit::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	UNREFERENCED_PARAMETER(nFlags);
	UNREFERENCED_PARAMETER(point);
	//disregard text selection using a double click
}

UINT CComboTreeEdit::OnGetDlgCode() 
{
	//must catch escape and other keys so that active tree can get them
	UINT result = CEdit::OnGetDlgCode();
	result |= DLGC_WANTALLKEYS | DLGC_WANTARROWS | DLGC_WANTCHARS ;
	return result;
}
