// ToolBarEx.cpp : implementation file
//

#include "stdafx.h"
#include <math.h>
#include "AplGuiEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define APL_ROUND 50
/////////////////////////////////////////////////////////////////////////////
// CToolBarEx
CToolBarEx::CToolBarEx():CToolBar()
{
	m_ItemModes.RemoveAll();
	m_bLBUP = false;
	m_bDropDown = false;
	m_pMsgTarget = NULL;
	m_bUserGradient = false;
}

CToolBarEx::~CToolBarEx()
{
	m_ItemModes.RemoveAll();
}


BEGIN_MESSAGE_MAP(CToolBarEx, CToolBar)
	//{{AFX_MSG_MAP(CToolBarEx)
	ON_NOTIFY_REFLECT(TBN_DROPDOWN, OnButtonDropDown)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CToolBarEx message handlers
void CToolBarEx::OnButtonDropDown(NMHDR* pNMHDR, LRESULT* pResult)
{
	TBNOTIFY* pNotify = reinterpret_cast<TBNOTIFY*>(pNMHDR);

	m_bDropDown = true;
	RedrawWindow();
	
	CRect rc;
	GetItemRect(CommandToIndex(pNotify->iItem), rc);
	ClientToScreen(rc);
	
	CPoint pnt(rc.left, rc.bottom);
	
	TItemDropMode idmItem;
	for(int i=0; i<m_ItemModes.GetSize();i++)
	{
		idmItem = m_ItemModes[i];
		if(idmItem.idmID==UINT(pNotify->iItem))
		{
			if(idmItem.idmMenuID!=NULL && idmItem.idmSubMenu>-1)
			{
				CMenu menu, *SubMenu;
				VERIFY(menu.LoadMenu(idmItem.idmMenuID));
				SubMenu = menu.GetSubMenu(idmItem.idmSubMenu);
				
				if (m_pMsgTarget)
					UpdatePopupMenu(m_pMsgTarget, SubMenu);
				SubMenu->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON, pnt.x, pnt.y, this);
				
				m_bDropDown = false;
				return;
			}
			else if(idmItem.idmMenuID!=NULL && idmItem.idmSubMenu==-1)
			{
				CMenu menu;
				VERIFY(menu.Attach((HMENU)idmItem.idmMenuID));
				if (m_pMsgTarget)
					UpdatePopupMenu(m_pMsgTarget, &menu);
				menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON, pnt.x, pnt.y, this);
				menu.Detach();
				m_bDropDown = false;
				return;
			}
		}
	}
	m_bDropDown = false;
}

void CToolBarEx::SetButtonDropDownMode(UINT ButtonId, bool bDropDown, UINT MenuId, int SubMenu, CCmdTarget* pMsgTarget /*= NULL*/)
{
	m_pMsgTarget = pMsgTarget;

	DWORD style = GetToolBarCtrl().GetExtendedStyle();
	if(!(style&TBSTYLE_EX_DRAWDDARROWS))
	{
		style|=TBSTYLE_EX_DRAWDDARROWS;
		GetToolBarCtrl().SetExtendedStyle(style);
	}

	TBBUTTONINFO tbInfo;
	memset(&tbInfo, 0, sizeof(TBBUTTONINFO));
	tbInfo.dwMask = TBIF_STYLE;
	tbInfo.cbSize = sizeof(TBBUTTONINFO);
	if(GetToolBarCtrl().GetButtonInfo(ButtonId, &tbInfo)==FALSE)
	{
		int ind = GetToolBarCtrl().CommandToIndex(ButtonId);
		if(ind>-1)
		{
			UINT tmp, lStyle;
			GetButtonInfo(ind, tmp, lStyle, tbInfo.iImage);
			tbInfo.fsStyle = lStyle;
			if(tmp!=ButtonId) return;
		}
		else
			return;
	}
	
	TItemDropMode idmItem;
	for(int i=0; i<m_ItemModes.GetSize();i++)
	{
		idmItem = m_ItemModes[i];
		if(idmItem.idmID==ButtonId)
		{
			if(!bDropDown)
			{
				m_ItemModes.RemoveAt(i);
				tbInfo.fsStyle &= ~TBSTYLE_DROPDOWN;
				GetToolBarCtrl().SetButtonInfo(ButtonId, &tbInfo);
				return;
			}
			idmItem.idmMenuID = MenuId;
			idmItem.idmSubMenu = SubMenu;
			m_ItemModes.SetAt(i, idmItem);
			return;
		}
	}
	if(bDropDown)
	{
		idmItem.idmID = ButtonId;
		idmItem.idmMenuID = MenuId;
		idmItem.idmSubMenu = SubMenu;
		m_ItemModes.Add(idmItem);
		tbInfo.fsStyle |= TBSTYLE_DROPDOWN;
		GetToolBarCtrl().SetButtonInfo(ButtonId, &tbInfo);
	}
}


void CToolBarEx::OnPaint() 
{
 	if (m_bDelayedButtonLayout)
 		Layout();

	// 
	CPaintDC dc(this);

	//   
	COLORREF menu_color = ::GetSysColor(COLOR_MENU);
	int i;
	HPEN hBtnHight, hBtnShadow;
	HPEN hSelect;
	HPEN hPnOld(0);
	HBRUSH hBrMenuText(0), hBrush(0);
	HBRUSH hBrDis(0), hBrSelect(0), hBrChecked(0);
	HBRUSH hBrOld(0);
	CToolBarCtrl* pTBCtrl = (CToolBarCtrl*)this;
	COLORREF color_btn_hightlight = ::GetSysColor(COLOR_BTNHIGHLIGHT);
	COLORREF color_btn_shadow = ::GetSysColor(COLOR_BTNSHADOW);
	COLORREF color_checked;
	COLORREF color_select;

	TBBUTTON tbb;
	CImageList *pIL_en = pTBCtrl->GetImageList();
	CImageList *pIL_dis = pTBCtrl->GetDisabledImageList();
	HICON icon = NULL;
	CRect item_rect, item_subrect;
	CRect drop_dn_rect, item_dr_rect;
	CPoint pt;
	CPoint mouse_pt;
	UINT DIFlags = DST_ICON;

	POINT tmp_pt;

	::GetCursorPos(&mouse_pt);
	ScreenToClient(&mouse_pt);

	hBtnHight = ::CreatePen(PS_SOLID, 0, color_btn_hightlight);
	hBtnShadow = ::CreatePen(PS_SOLID, 0, color_btn_shadow);
	hSelect = ::CreatePen(PS_SOLID, 0, ::GetSysColor(COLOR_HIGHLIGHT));

	const double k1(0.45);
	const double k2(0.7);
	const double k3(0.85);
	const double k4(0.25);

	color_select = aplFusionColors(::GetSysColor(COLOR_BTNFACE), ::GetSysColor(COLOR_HIGHLIGHT), k1, k2);
	color_checked = aplFusionColors(::GetSysColor(COLOR_BTNFACE), ::GetSysColor(COLOR_HIGHLIGHT), k3, k4);

	hBrChecked = ::CreateSolidBrush(color_checked);
	hBrSelect = ::CreateSolidBrush(color_select);
	hBrMenuText = ::CreateSolidBrush(::GetSysColor(COLOR_MENUTEXT));
	hBrDis = ::CreateSolidBrush(::GetSysColor(COLOR_BTNSHADOW));

	m_bLBUP = !(IsWindowEnabled() && IsWindowVisible());

	hPnOld = (HPEN)::SelectObject(dc.m_hDC, hSelect);
	if(hBrOld==NULL)
		hPnOld = (HPEN)::GetStockObject(DC_PEN);
	hBrOld = (HBRUSH)::SelectObject(dc.m_hDC, hBrush);
	if(hBrOld==NULL)
		hBrOld = (HBRUSH)::GetStockObject(DC_BRUSH);

	for(i=0; i<pTBCtrl->GetButtonCount(); i++)
	{
		pTBCtrl->GetButton(i, &tbb);
		if(tbb.fsState&TBSTATE_HIDDEN) continue;
		
		pTBCtrl->GetItemRect(i, item_rect);
		item_subrect = item_rect;
		item_dr_rect = item_rect;
		drop_dn_rect = item_rect;

		item_subrect.DeflateRect(3, 3, 2, 2);
		drop_dn_rect.left = item_rect.right - 13;
		item_dr_rect.DeflateRect(1, 1, 1, 1);
		hBrush = hBrChecked;
		if(tbb.iBitmap>-1 && !(tbb.fsStyle&TBSTYLE_SEP))
		{
			if(tbb.fsState&TBSTATE_PRESSED || tbb.fsState&TBSTATE_CHECKED)
			{
				if(item_rect.PtInRect(mouse_pt) || tbb.fsState&TBSTATE_PRESSED)
					hBrush = hBrSelect;
				else
					hBrush = hBrChecked;

				::SelectObject(dc.m_hDC, hSelect);
				::SelectObject(dc.m_hDC, hBrush);
				dc.Rectangle(item_dr_rect);

				if(tbb.fsStyle&TBSTYLE_DROPDOWN && drop_dn_rect.PtInRect(mouse_pt))
					drop_dn_rect.top++;
			}
			else if(tbb.fsState&TBSTATE_ENABLED)
			{
				if(!m_bLBUP && item_rect.PtInRect(mouse_pt))
				{
					::SelectObject(dc.m_hDC, hSelect);
					::SelectObject(dc.m_hDC, hBrush);
					dc.Rectangle(item_dr_rect);
				}

				if(tbb.fsStyle&TBSTYLE_DROPDOWN)
				{
					if(drop_dn_rect.PtInRect(mouse_pt) && m_bDropDown)
					{
 						drop_dn_rect.top++;
					}
					else if(item_rect.PtInRect(mouse_pt))
					{
						//
						::SelectObject(dc.m_hDC, hBtnShadow);
						::MoveToEx(dc.m_hDC, drop_dn_rect.left, drop_dn_rect.top+2, &tmp_pt);
						::LineTo(dc.m_hDC, drop_dn_rect.left, drop_dn_rect.bottom-2);
						::SelectObject(dc.m_hDC, hBtnHight);
						::MoveToEx(dc.m_hDC, drop_dn_rect.left+1, drop_dn_rect.top+2, &tmp_pt);
						::LineTo(dc.m_hDC, drop_dn_rect.left+1, drop_dn_rect.bottom-2);
					}
					// 
					::SelectObject(dc.m_hDC, hBrMenuText);
					DrawArrow(dc.m_hDC, drop_dn_rect);
				}
			}
			
			DIFlags = DST_ICON;
			if(tbb.fsState&TBSTATE_ENABLED && pIL_en)
				icon = pIL_en->ExtractIcon(tbb.iBitmap);
			else if(pIL_dis)
				icon = pIL_dis->ExtractIcon(tbb.iBitmap);
			else if(pIL_en)
			{
				icon = pIL_en->ExtractIcon(tbb.iBitmap);
				DIFlags = DSS_DISABLED|DST_ICON;
			}
			dc.DrawState(item_subrect.TopLeft(), m_sizeImage, icon, DIFlags, (CBrush*)NULL);
			if(icon)
				DestroyIcon(icon);
			if(tbb.fsStyle&TBSTYLE_DROPDOWN)
			{
				// 
				if(tbb.fsState&TBSTATE_ENABLED)
					::SelectObject(dc.m_hDC, hBrMenuText);
				else
					::SelectObject(dc.m_hDC, hBrDis);
				DrawArrow(dc.m_hDC, drop_dn_rect);
			}
			if(GetStyle()&TBSTYLE_LIST)
			{
				COLORREF cr = 0;
				UINT styles = DT_VCENTER|DT_SINGLELINE;
				CString sBuf;
				GetButtonText(i, sBuf);
				item_subrect.left+=m_sizeImage.cx+2;
				if(!(tbb.fsState&TBSTATE_ENABLED))
					cr = ::GetSysColor(COLOR_3DSHADOW);
				else
					cr = ::GetSysColor(COLOR_MENUTEXT);
				CFont *pFont = (CFont*)dc.SelectStockObject(ANSI_VAR_FONT);
				int old_bk_mode = dc.SetBkMode(TRANSPARENT);
				cr = dc.SetTextColor(cr);
				dc.DrawText(sBuf, item_subrect, styles);
				dc.SelectObject(pFont);
				dc.SetBkMode(old_bk_mode);
				dc.SetTextColor(cr);
			}
		}
		else if(tbb.fsStyle&TBSTYLE_SEP)
		{
			::SelectObject(dc.m_hDC, hBtnHight);
			::MoveToEx(dc.m_hDC, item_subrect.left-2, item_rect.top+2, &tmp_pt);
			::LineTo(dc.m_hDC, item_subrect.left-2, item_rect.bottom-2);
			::SelectObject(dc.m_hDC, hBtnShadow);
			::MoveToEx(dc.m_hDC, item_subrect.left-1, item_rect.top+2, &tmp_pt);
			::LineTo(dc.m_hDC, item_subrect.left-1, item_rect.bottom-2);
		}
		icon = NULL;
	}

	::SelectObject(dc.m_hDC, hPnOld);
	::SelectObject(dc.m_hDC, hBrOld);

	::DeleteObject(hBtnHight);
	::DeleteObject(hBtnShadow);
	::DeleteObject(hBrDis);
	::DeleteObject(hBrMenuText);
	::DeleteObject(hBrSelect);
	::DeleteObject(hBrChecked);

	::DeleteObject(hSelect);

//	m_bLBUP = false;
}

void CToolBarEx::DrawArrow(HDC hDC, CRect &rect)
{
	if(hDC==NULL) return;

	POINT cpt = rect.CenterPoint();
	POINT pt[4];
	pt[0].x = cpt.x-2;
	pt[1].x = cpt.x+3;
	pt[2].x = cpt.x;
	pt[3].x = cpt.x-2;

	pt[0].y = cpt.y-2;
	pt[1].y = cpt.y-2;
	pt[2].y = cpt.y+1;
	pt[3].y = cpt.y-2;

	::BeginPath(hDC);
	::Polyline(hDC, &pt[0], 4);
	::EndPath(hDC);
	::FillPath(hDC);
}

void CToolBarEx::SetUserGradient(COLORREF clr1, COLORREF clr2)
{
	m_userGradientColor1 = clr1;
	m_userGradientColor2 = clr2;

	m_bUserGradient = true;
}

BOOL CToolBarEx::OnEraseBkgnd(CDC* pDC) 
{
	CRect cl_rect;
	GetWindowRect(&cl_rect);
	ScreenToClient(&cl_rect);

	if ( cl_rect.right > 0 && cl_rect.bottom > 0 )
	{
		CPoint tl = cl_rect.TopLeft();
		cl_rect.OffsetRect(-cl_rect.left, -cl_rect.top);
		COLORREF btn_face_color = ::GetSysColor(COLOR_BTNFACE);
		COLORREF menu_color = ::GetSysColor(COLOR_MENU);
		COLORREF color;
		BYTE r1, r2, g1, g2, b1, b2;
		int i, height;
		int h(0);

		if(m_bUserGradient)
		{
			btn_face_color = m_userGradientColor1;
			menu_color = m_userGradientColor2;			
		}

		r1 = GetRValue(btn_face_color);
		g1 = GetGValue(btn_face_color);
		b1 = GetBValue(btn_face_color);

		r2 = GetRValue(menu_color);
		g2 = GetGValue(menu_color);
		b2 = GetBValue(menu_color);

		if(r2>=r1)
			r2 = r2-r1<APL_ROUND && 255-r2>APL_ROUND ? r2 = r1+APL_ROUND : (r2-r1<APL_ROUND ? 255:r2);
		else
			r2 = r1-r2<APL_ROUND && 255-r1>APL_ROUND ? r2 = r1-APL_ROUND : (r1-r2<APL_ROUND ? 255:r2);
		if(g2>=g1)
			g2 = g2-g1<APL_ROUND && 255-g2>APL_ROUND ? g2 = g1+APL_ROUND : (g2-g1<APL_ROUND ? 255:g2);
		else
			g2 = g1-g2<APL_ROUND && 255-g1>APL_ROUND ? g2 = g1-APL_ROUND : (g1-g2<APL_ROUND ? 255:g2);
		if(b2>=b1)
			b2 = b2-b1<APL_ROUND && 255-b2>APL_ROUND ? b2 = b1+APL_ROUND : (b2-b1<APL_ROUND ? 255:b2);
		else
			b2 = b1-b2<APL_ROUND && 255-b1>APL_ROUND ? b2 = b1-APL_ROUND : (b1-b2<APL_ROUND ? 255:b2);
		
		// 
		height = cl_rect.Height()+1;
		int width(cl_rect.Width());

		double dH = (double)( (double)height / 5);

		int iStart = (int)(floor((dH / 1.0) + 0.5));
		int j;
		h = (height - iStart);
		COLORREF	*pColors = new COLORREF[width*height];
		memset(pColors, 0, sizeof(COLORREF)*width*height);

#define def_RKoef 0.8
#define def_HKoef 0.55

		r2 = (BYTE)(r2*def_RKoef);
		g2 = (BYTE)(g2*def_RKoef);
		b2 = (BYTE)(b2*def_RKoef);
		for(i=iStart; i<height*def_HKoef; ++i)
		{
			color = RGB(b1+(((b2-b1)*(i-iStart))/h), g1+(((g2-g1)*(i-iStart))/h), r1+(((r2-r1)*(i-iStart))/h));
 			for(j=0; j<width; ++j)
 				pColors[i*width+j] = color;
		}
		r2 = (BYTE)(r2/def_RKoef);
		g2 = (BYTE)(g2/def_RKoef);
		b2 = (BYTE)(b2/def_RKoef);
		for(i=(int)(height*def_HKoef); i<height; ++i)
		{
			color = RGB(b1+(((b2-b1)*(i-iStart))/h), g1+(((g2-g1)*(i-iStart))/h), r1+(((r2-r1)*(i-iStart))/h));
			for(j=0; j<width; ++j)
				pColors[i*width+j] = color;
		}

		r2 = (BYTE)(r1*0.9);
		g2 = (BYTE)(g1*0.9);
		b2 = (BYTE)(b1*0.9);

		h = iStart;
		for(i=iStart; i>-1; --i)
		{
			color = RGB(b1+(((b2-b1)*i)/h), g1+(((g2-g1)*i)/h), r1+(((r2-r1)*i)/h));
 			for(j=0; j<width; ++j)
 				pColors[(iStart-i)*width+j] = color;
		}

		BITMAPINFO bmpInfo = {sizeof(BITMAPINFOHEADER), width, height, 1, 32, BI_RGB, 0, 0, 0, 0, 0};
		HBITMAP hBMP(::CreateDIBitmap(pDC->GetSafeHdc(), &bmpInfo.bmiHeader, CBM_INIT, pColors, &bmpInfo, DIB_RGB_COLORS));
		delete []pColors;
		if(hBMP)
		{
			pDC->DrawState(tl, cl_rect.Size(), hBMP, DST_BITMAP, (HBRUSH)0);
		}
		::DeleteObject(hBMP);

	}

	return TRUE;
	
}

void CToolBarEx::OnLButtonUp(UINT nFlags, CPoint point) 
{
//	m_bLBUP = true;

// 	Invalidate(FALSE);
// 
 	CToolBar::OnLButtonUp(nFlags, point);

	Invalidate(TRUE);
}

#define CX_GRIPPER  3
#define CY_GRIPPER  3
#define CX_BORDER_GRIPPER 2
#define CY_BORDER_GRIPPER 2

BOOL CToolBarEx::DrawThemedGripper(CDC* pDC, const CRect& rect, BOOL fCentered)
{
	return FALSE;
}

BOOL CToolBarEx::DrawNonThemedGripper(CDC* pDC, const CRect& rect)
{
	ENSURE_ARG( pDC );

	// draw the gripper in the border
	CRect cl_rect;
	GetWindowRect(cl_rect);
	ScreenToClient(cl_rect);

	if ( cl_rect.right > 0 && cl_rect.bottom > 0 )
	{
		CPoint tl = cl_rect.TopLeft();
		if(GetStyle()&CBRS_FLYBY)
		{
			cl_rect = rect;
			cl_rect.right = cl_rect.left + 2*CX_BORDER_GRIPPER+CX_GRIPPER;
			cl_rect.DeflateRect(0, -2, 0, -2);
			tl = cl_rect.TopLeft();
		}
		else
		{
			cl_rect.OffsetRect(-cl_rect.left, -cl_rect.top);
			tl = cl_rect.TopLeft();
		}
		COLORREF btn_face_color = ::GetSysColor(COLOR_BTNFACE);
		COLORREF menu_color = ::GetSysColor(COLOR_MENU);
		COLORREF color;
		BYTE r1, r2, g1, g2, b1, b2;
		int i, height;
		int h(0);
		r1 = GetRValue(btn_face_color);
		g1 = GetGValue(btn_face_color);
		b1 = GetBValue(btn_face_color);

		r2 = GetRValue(menu_color);
		g2 = GetGValue(menu_color);
		b2 = GetBValue(menu_color);

		if(r2>=r1)
			r2 = r2-r1<APL_ROUND && 255-r2>APL_ROUND ? r2 = r1+APL_ROUND : (r2-r1<APL_ROUND ? 255:r2);
		else
			r2 = r1-r2<APL_ROUND && 255-r1>APL_ROUND ? r2 = r1-APL_ROUND : (r1-r2<APL_ROUND ? 255:r2);
		if(g2>=g1)
			g2 = g2-g1<APL_ROUND && 255-g2>APL_ROUND ? g2 = g1+APL_ROUND : (g2-g1<APL_ROUND ? 255:g2);
		else
			g2 = g1-g2<APL_ROUND && 255-g1>APL_ROUND ? g2 = g1-APL_ROUND : (g1-g2<APL_ROUND ? 255:g2);
		if(b2>=b1)
			b2 = b2-b1<APL_ROUND && 255-b2>APL_ROUND ? b2 = b1+APL_ROUND : (b2-b1<APL_ROUND ? 255:b2);
		else
			b2 = b1-b2<APL_ROUND && 255-b1>APL_ROUND ? b2 = b1-APL_ROUND : (b1-b2<APL_ROUND ? 255:b2);

		// 
		height = cl_rect.Height()+1;
		int width(cl_rect.Width());
		double dH = (double)( (double)height / 5);

		int iStart = (int)(floor((dH / 1.0) + 0.5));
		int j;
		h = (height - iStart);
		COLORREF	*pColors = new COLORREF[width*height];
		memset(pColors, 0, sizeof(COLORREF)*width*height);

		for(i=iStart; i<height; i++)
		{
			color = RGB(b1+(((b2-b1)*(i-iStart))/h), g1+(((g2-g1)*(i-iStart))/h), r1+(((r2-r1)*(i-iStart))/h));
			for(j=0; j<width; ++j)
				pColors[i*width+j] = color;
		}

		r2 = (BYTE)(r1*0.9);
		g2 = (BYTE)(g1*0.9);
		b2 = (BYTE)(b1*0.9);

		h = iStart;
		for(i=iStart; i>-1; i--)
		{
			color = RGB(b1+(((b2-b1)*i)/h), g1+(((g2-g1)*i)/h), r1+(((r2-r1)*i)/h));
			for(j=0; j<width; ++j)
				pColors[(iStart-i)*width+j] = color;
		}

		BITMAPINFO bmpInfo = {sizeof(BITMAPINFOHEADER), width, height, 1, 32, BI_RGB, 0, 0, 0, 0, 0};
		HBITMAP hBMP(::CreateDIBitmap(pDC->GetSafeHdc(), &bmpInfo.bmiHeader, CBM_INIT, pColors, &bmpInfo, DIB_RGB_COLORS));
		if(hBMP)
		{
			pDC->DrawState(tl, cl_rect.Size(), hBMP, DST_BITMAP, (HBRUSH)0);
		}
		::DeleteObject(hBMP);
		delete []pColors;

		if (m_dwStyle & CBRS_ORIENT_HORZ)
		{
			int i(0);
			int cnt((rect.Height()-CY_BORDER_GRIPPER*2)/4);
			int cy_offset = (rect.Height()-cnt*4)/2+1;

			CPen pen_shadow, pen_highlight, *oldPen;
			pen_shadow.CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_BTNSHADOW));
			pen_highlight.CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_BTNHIGHLIGHT));
			oldPen = pDC->SelectObject(&pen_highlight);
			for(i=0; i<cnt; ++i)
			{
				pDC->SelectObject(&pen_shadow);
				pDC->MoveTo(rect.left+CX_BORDER_GRIPPER, rect.top + cy_offset + i*4);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER+1, rect.top + cy_offset+ i*4);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER+1, rect.top + cy_offset+ i*4 +1);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER, rect.top + cy_offset+ i*4 +1);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER, rect.top + cy_offset+ i*4);
				pDC->SelectObject(&pen_highlight);
				pDC->MoveTo(rect.left+CX_BORDER_GRIPPER+2, rect.top + cy_offset+ i*4+1);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER+2, rect.top + cy_offset+ i*4+2);
				pDC->LineTo(rect.left+CX_BORDER_GRIPPER, rect.top + cy_offset+ i*4+2);
			}
			pDC->SelectObject(oldPen);
		}
		else
		{
			int i(0);
			int cnt((rect.Width()-CX_BORDER_GRIPPER*2)/4);
			int cx_offset = (rect.Width()-cnt*4)/2+1;

			CPen pen_shadow, pen_highlight, *oldPen;
			pen_shadow.CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_BTNSHADOW));
			pen_highlight.CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_BTNHIGHLIGHT));
			oldPen = pDC->SelectObject(&pen_highlight);
			for(i=0; i<cnt; ++i)
			{
				pDC->SelectObject(&pen_shadow);
				pDC->MoveTo(rect.left+cx_offset+i*4, rect.top + CY_BORDER_GRIPPER );
				pDC->LineTo(rect.left+cx_offset+1+i*4, rect.top + CY_BORDER_GRIPPER);
				pDC->LineTo(rect.left+cx_offset+1+i*4, rect.top + CY_BORDER_GRIPPER+ 1);
				pDC->LineTo(rect.left+cx_offset+i*4, rect.top + CY_BORDER_GRIPPER+ 1);
				pDC->LineTo(rect.left+cx_offset+i*4, rect.top + CY_BORDER_GRIPPER);
				pDC->SelectObject(&pen_highlight);
				pDC->MoveTo(rect.left+cx_offset+2+i*4, rect.top + CY_BORDER_GRIPPER+ 1);
				pDC->LineTo(rect.left+cx_offset+2+i*4, rect.top + CY_BORDER_GRIPPER+ 2);
				pDC->LineTo(rect.left+cx_offset+i*4, rect.top + CY_BORDER_GRIPPER+ 2);
			}
			pDC->SelectObject(oldPen);
		}

	}
	return TRUE;
}
