#pragma once
#include "stdafx.h"

enum EConditionType
{
	COND_STRING,
	COND_DATE,
	COND_INSTANCE,
};

class CConditionOperation
{
public:

	CConditionOperation() {};
	CConditionOperation(CString name, CString oper)
	{
		m_sName = name;
		m_sOperation = oper;
	};
	~CConditionOperation(void) {};

	CString GetName() { return m_sName; }
	CString GetOperation() { return m_sOperation; }

private:
	CString m_sName;
	CString m_sOperation;
};

class CCondition
{
public:
	CCondition(void);
	~CCondition(void);
	CCondition& operator=(const CCondition& obj);
	CCondition(const CCondition& obj);

	CString GetAttr() { return m_sAttr; }
	EConditionType GetType() { return m_type; };
	CString GetName() { return m_sName; }
	CConditionOperation* GetOperation(int i) { return m_caOperations[i]; }
	int GetOperationsSize() { return m_caOperations.GetSize(); }
	int GetDefaultValueSize() { return m_saDefaultValues.GetSize(); }
	CString GetDefaultValue(int i) { return m_saDefaultValues[i]; }
	CaplInstance *GetParentInst() { return m_ciChooseParent; }
	CString GetTitle() { return m_sChooseTitle; }

	void Clear();
	void SetFuncParam(CaplInstance *ciRoot, CString sTitle) { m_ciChooseParent=ciRoot; m_sChooseTitle=sTitle; }
	void SetType(EConditionType type) { m_type = type; }
	void SetName(CString str) { m_sName = str; };
	void SetAttr(CString attr) { m_sAttr = attr; }
		
	void AddDefaultValue(CString str) { m_saDefaultValues.Add(str); };
	void AddOperation(CConditionOperation *op) { m_caOperations.Add(op); }

	CaplInstance* (*lpFuncChoose)(CaplAPI*, CaplPreExploitationMgr*, CaplInstance*, CString);
	
protected:

	//  
	CStringArray m_saDefaultValues;
	CArray<CConditionOperation*, CConditionOperation*> m_caOperations;
	
	// 
	CString m_sName;
	CString m_sAttr;
	EConditionType m_type;

	//  
	CString m_sVal;
	COleDateTime m_dtTime;
	CaplInstance *m_ciVal;

	//   
	CString m_sChooseTitle;
	CaplInstance *m_ciChooseParent;
};

