// RefAdminInfoChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefAdminInfoChildDlg.h"


// CRefAdminInfoChildDlg dialog

IMPLEMENT_DYNAMIC(CRefAdminInfoChildDlg, CaplTranslateDialog)

CRefAdminInfoChildDlg::CRefAdminInfoChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefAdminInfoChildDlg::IDD, pParent)
{
	m_api = api;
}

CRefAdminInfoChildDlg::~CRefAdminInfoChildDlg()
{
}

void CRefAdminInfoChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST, m_list);
}


BEGIN_MESSAGE_MAP(CRefAdminInfoChildDlg, CaplTranslateDialog)
END_MESSAGE_MAP()

BOOL CRefAdminInfoChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitList();
	FillList();

	return TRUE;
}

void CRefAdminInfoChildDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0, APL_T(""),		LVCFMT_LEFT, (int)(rect.Width()*0.5));
	m_list.InsertColumn(1, APL_T(""),		LVCFMT_LEFT, (int)(rect.Width()*0.5));	

	m_list.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
}

void CRefAdminInfoChildDlg::FillList()
{
	if(!m_ciRef) return;

	CString str;
	SInstInfo *pItem=new SInstInfo(m_ciRef);
	CaplTAggr<SInstInfo*,SInstInfo*,APLAGGR_AUTOKILLREF> data;		

	data.Add(pItem);
	m_api->m_data.NET_LoadInstUserDataTimeInfo(data, APL_T("  ..."));

	m_list.InsertItem(0, APL_T("  :"));
	if(pItem->create_user)
	{
		m_api->m_appr_mgr.GetPersonName(pItem->create_user, str);
		m_list.SetItemText(0, 1, str);
	}

	m_list.InsertItem(1, APL_T("  :"));
	if(pItem->create_date)
	{
		COleDateTime time(pItem->create_date);
		str.Format(_T("%.2d:%.2d:%.2d   %.2d.%.2d.%.4d"), time.GetHour(), time.GetMinute(), time.GetSecond(), time.GetDay(), time.GetMonth(), time.GetYear());
		m_list.SetItemText(1, 1, str);
	}
	
	m_list.InsertItem(2, _T(""));
	m_list.InsertItem(3, _T(""));

	m_list.InsertItem(4, APL_T("  :"));
	if(pItem->update_user)
	{
		m_api->m_appr_mgr.GetPersonName(pItem->update_user, str);
		m_list.SetItemText(4, 1, str);
	}

	m_list.InsertItem(5, APL_T("  :"));
	if(pItem->update_date)
	{
		COleDateTime time(pItem->update_date);
		str.Format(_T("%.2d:%.2d:%.2d   %.2d.%.2d.%.4d"), time.GetHour(), time.GetMinute(), time.GetSecond(), time.GetDay(), time.GetMonth(), time.GetYear());
		m_list.SetItemText(5, 1, str);
	}	
}
