// RefChildsChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefChildsChildDlg.h"


// CRefChildsChildDlg dialog

IMPLEMENT_DYNAMIC(CRefChildsChildDlg, CaplResizableDialog)

CRefChildsChildDlg::CRefChildsChildDlg(CaplAPI *api, CaplFaultMgr *FaultMgr, CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CRefChildsChildDlg::IDD, pParent)
{
	m_api = api;
	m_FaultMgr = FaultMgr;
	m_ParentDlg = (CRefusalPropertyDlg*)pParent;
}

CRefChildsChildDlg::~CRefChildsChildDlg()
{
}

void CRefChildsChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CRefChildsChildDlg, CaplResizableDialog)
	ON_WM_DESTROY()
	ON_NOTIFY(NM_DBLCLK, IDC_TREE_LIST, OnDblClickTree)
	ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

BOOL CRefChildsChildDlg::OnInitDialog()
{
	CaplResizableDialog::OnInitDialog();
	ShowSizeGrip(FALSE);

	InitTreeList();
	FillTreeList();

	return TRUE;
}

void CRefChildsChildDlg::OnCancel()
{

}

void CRefChildsChildDlg::OnOK()
{

}

void CRefChildsChildDlg::InitTreeList()
{
	RECT rect;
	GetDlgItem(IDC_LIST)->GetWindowRect(&rect);
	ScreenToClient(&rect);

	m_pTreeList = (CaplTreeListCtrlView*)(RUNTIME_CLASS(CaplTreeListCtrlView)->CreateObject());
	m_pTreeList->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW,rect,this,IDC_TREE_LIST);

	m_pTreeList->OnInitialUpdate();
	m_pTreeList->m_tree.m_bSortRoot=true;
	m_pTreeList->m_bAutofit=true;
	m_pTreeList->m_tree.m_wndHeader.SetAutofit();
	m_pTreeList->m_tree.m_dlg=this;
	m_pTreeList->MoveWindow(&rect);
	m_pTreeList->n_bNoParentNotify = false;		

	m_pTreeList->m_tree.InsertColumn(0, APL_T(""),		LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_pTreeList->m_tree.InsertColumn(1, APL_T(""),		LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_pTreeList->m_tree.InsertColumn(2, APL_T(""),		LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_pTreeList->m_tree.InsertColumn(3, APL_T(" "),	LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_pTreeList->m_tree.InsertColumn(4, APL_T(" "),		LVCFMT_LEFT, (int)((rect.right-rect.left)*0.2));
	m_pTreeList->m_tree.m_wndHeader.SetAutofit();		
}

void CRefChildsChildDlg::FillTreeList()
{
	if(!m_ciRef) return;

	long dID = aplStartWaitDlg(APL_T("   ..."));
	m_pTreeList->m_tree.DeleteAllItems();
	InsertLevel(m_ciRef, m_pTreeList->m_tree.GetRootItem());	
	aplEndWaitDlg(dID);
}

void CRefChildsChildDlg::InsertLevel(CaplInstance *ciRef, HTREEITEM hItem)
{
	//  
	CString sSql;
	aplExtent aeChilds;

	sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_refusal.parent = #%d } END_SELECT"), ciRef->GetId());
	if(m_api->m_data.NET_QueryEditParse(sSql, false) == false) return;
	m_api->m_data.NET_QueryExecute(aeChilds);	
	m_FaultMgr->LoadRefusalInfo(aeChilds);	

	for(int i=0; i<aeChilds.Size; i++ )
	{
		HTREEITEM hNewItem = AddItem(aeChilds[i], hItem, false);
		InsertLevel(aeChilds[i], hNewItem);
	}
}

HTREEITEM CRefChildsChildDlg::AddItem(CaplInstance *ciRef, HTREEITEM hItem, bool bUpdateOnly)
{
	if(!ciRef) return 0;

	COleDateTime time;
	CaplInstance *ciType = 0;
	CString sType, sDoc, sDocNum, sDate, sState;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	HTREEITEM hNewItem;

	if(!bUpdateOnly) hNewItem = m_pTreeList->m_tree.InsertItem(_T(""), hItem);
	else hNewItem = hItem;

	//  
	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_type, ciType);
	if(ciType) 
	{
		m_api->m_data.GetAttr(ciType, m_api->m_classifier_mgr.a_apl_classifier_level_name, sType);
		m_pTreeList->m_tree.SetItemText(hNewItem, 0, sType);
	}

	// 
	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_state, sState);
	m_pTreeList->m_tree.SetItemText(hNewItem, 1, sState);

	// 
	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_doc_type, sDoc);
	m_pTreeList->m_tree.SetItemText(hNewItem, 2, sDoc);

	//  
	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_doc_num, sDocNum);
	m_pTreeList->m_tree.SetItemText(hNewItem, 3, sDocNum);

	//  
	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_date_detection, sDate);
	if(!sDate.IsEmpty())
	{
		aplString2Date(sDate, time);
		sDate.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
	}
	m_pTreeList->m_tree.SetItemText(hNewItem, 4, sDate);

	m_pTreeList->m_tree.SetItemData(hNewItem, (DWORD)ciRef);
	return hNewItem;
}

void CRefChildsChildDlg::OnDestroy()
{
	m_pTreeList->m_tree.DeleteAllItems();
}

void CRefChildsChildDlg::OnDblClickTree( NMHDR* pNMHDR, LRESULT* pResult )
{
	
}

void CRefChildsChildDlg::OnLButtonDblClk( UINT nFlags, CPoint point )
{
	
}

BOOL CRefChildsChildDlg::PreTranslateMessage( MSG* pMsg )
{
	if(pMsg->hwnd == m_pTreeList->m_tree.m_hWnd && pMsg->message == WM_LBUTTONDBLCLK)
	{
		CArray<HTREEITEM, HTREEITEM> caItems;
		m_pTreeList->m_tree.GetListSelected(caItems);

		if(caItems.GetSize())
		{
			CaplInstance *ciRefusal = (CaplInstance*)m_pTreeList->m_tree.GetItemData(caItems[0]);
			if(ciRefusal)
			{
				CRefusalPropertyDlg dlg(m_api, m_FaultMgr);
				dlg.m_ciRef = ciRefusal;
				dlg.m_bChildDlg = true;

				if(dlg.DoModal() == IDOK)
					m_ParentDlg->m_aeRefusalToUpdate.Append(dlg.m_aeRefusalToUpdate);

				//      
				//       
				if(dlg.m_aeRefusalToUpdate.Size) 
				{
					RedrawTree(m_pTreeList->m_tree.GetRootItem(), dlg.m_aeRefusalToUpdate);
					m_ParentDlg->FillInfoAboutRelatingRefusal();
				}

				return true;
			}
		}
	}

	return CaplResizableDialog::PreTranslateMessage(pMsg);
}

void CRefChildsChildDlg::RedrawTree(HTREEITEM hItem, aplExtent &aeRefusalToUpdate)
{
	FillTreeList();

	/*while(hItem)
	{
		CaplInstance *ciRef = (CaplInstance*)m_pTreeList->m_tree.GetItemData(hItem);
		if(aplQFindInstInExtent(aeRefusalToUpdate, ciRef) != -1) AddItem(ciRef, hItem, true);

		if(m_pTreeList->m_tree.ItemHasChildren(hItem))
		{
			HTREEITEM hChildItem = m_pTreeList->m_tree.GetChildItem(hItem);
			RedrawTree(hChildItem, aeRefusalToUpdate);
		}

		hItem = m_pTreeList->m_tree.GetNextSiblingItem(hItem);
	}*/
}