// RefFilesChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefFilesChildDlg.h"


// CRefFilesChildDlg dialog

IMPLEMENT_DYNAMIC(CRefFilesChildDlg, CaplTranslateDialog)

CRefFilesChildDlg::CRefFilesChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefFilesChildDlg::IDD, pParent)
{
	m_api = api;
	m_ciRef = 0;	
}

CRefFilesChildDlg::~CRefFilesChildDlg()
{
}

void CRefFilesChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDC_NEW, m_new);
	DDX_Control(pDX, IDC_SHOW, m_show);
	DDX_Control(pDX, IDC_DEL, m_del);
}


BEGIN_MESSAGE_MAP(CRefFilesChildDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_NEW, &CRefFilesChildDlg::OnBnClickedNew)
	ON_BN_CLICKED(IDC_SHOW, &CRefFilesChildDlg::OnBnClickedShow)
	ON_BN_CLICKED(IDC_DEL, &CRefFilesChildDlg::OnBnClickedDel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, &CRefFilesChildDlg::OnNMDblclkList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &CRefFilesChildDlg::OnLvnItemchangedList)
END_MESSAGE_MAP()

BOOL CRefFilesChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();	

	InitBtns();
	InitList();
	FillList();

	return TRUE;
}

void CRefFilesChildDlg::OnCancel()
{

}

void CRefFilesChildDlg::OnOK()
{

}

bool CRefFilesChildDlg::CheckFile(CString sPath)
{
	CFile file;
	CString sErr;
	CFileStatus fileStatus;

	if(!file.Open(sPath, CFile::modeRead|CFile::typeBinary|CFile::shareDenyNone))
	{
		sErr.Format(APL_T("   \n\n\"%s\"!"), sPath);
		MessageBox(sErr, APL_T("   "), MB_OK|MB_ICONSTOP);

		return false;
	}

	file.GetStatus(fileStatus);
	if(fileStatus.m_size > 100000)
	{
		MessageBox(APL_T("  !"), APL_T(""), MB_OK|MB_ICONSTOP);
		return false;
	}

	return true;
}

void CRefFilesChildDlg::OnBnClickedNew()
{
	CFileDialog dlg(TRUE,0,0,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT,
		_T("All Files (*.*)|*.*||"));

	CString buf, sName;
	LPTSTR szFilesNames= buf.GetBuffer(2048);
	dlg.m_ofn.lpstrFile= szFilesNames;
	dlg.m_ofn.nMaxFile= 2048;

	if(dlg.DoModal()==IDOK)
	{
		POSITION pos=dlg.GetStartPosition();
		while(pos!=0) 
		{
			sName= dlg.GetNextPathName(pos);	
			//if(!CheckFile(sName)) continue;

			LVFINDINFO info;
			info.flags= LVFI_STRING;		
			info.psz= sName;

			if(m_list.FindItem(&info, -1)==-1)
			{
				UINT ico= ICON_DOCUMENT_COPY;
				int n= m_list.GetItemCount();
				int m= m_list.InsertItem(n, sName, ico);

				m_list.SetItemData(m, 0);															
			}
		}
	}	
}

void CRefFilesChildDlg::OnBnClickedShow()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciDoc = (CaplInstance*)m_list.GetItemData(nIndex);

	if(ciDoc == 0)
		ShellExecute(NULL, _T("open"), m_list.GetItemText(nIndex, 0), NULL, NULL, SW_SHOW);
	else
		m_api->m_doc_mgr.View(ciDoc);
}

void CRefFilesChildDlg::OnBnClickedDel()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	if(MessageBox(APL_T("       ?"), APL_T(""), MB_YESNO|MB_ICONQUESTION) == IDNO)
		return;

	CaplInstance *ciDoc = (CaplInstance*)m_list.GetItemData(nIndex);
	if(ciDoc) m_aeDelFiles.Add(ciDoc);

	m_list.DeleteItem(nIndex);
}

void CRefFilesChildDlg::InitBtns()
{
	CBitmap bmp;

	// 
	bmp.LoadBitmap(IDB_FILES);
	imageList.Create(32,32,ILC_COLOR16|ILC_MASK,20,20);
	imageList.Add(&bmp,RGB(192,192,192));

	// 
	m_new.SetFlat(TRUE);
	m_new.SetIcon(imageList.ExtractIcon(0));
	m_new.SetTooltipText(APL_T(" "));

	m_show.SetFlat(TRUE);
	m_show.SetIcon(imageList.ExtractIcon(1));
	m_show.SetTooltipText(APL_T(" "));

	m_del.SetFlat(TRUE);
	m_del.SetIcon(imageList.ExtractIcon(2));
	m_del.SetTooltipText(APL_T("    "));	


	if(m_api->m_data.IsReadOnly())
	{
		m_new.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
}

void CRefFilesChildDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);
	m_list.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()));	
}

void CRefFilesChildDlg::FillList()
{
	if(!m_ciRef) return;

	aplExtent aeFiles;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_files, aeFiles);

	for(int i=0; i<aeFiles.Size; i++) AddString(aeFiles[i]);
}

void CRefFilesChildDlg::AddString(CaplInstance *ciFile)
{
	if(!ciFile) return;

	CString buf;
	int nIndex = m_list.InsertItem(m_list.GetItemCount(), _T(""));
	m_api->m_data.GetAttr(ciFile, m_api->m_doc_mgr.a_apl_stored_document_file_name, buf);

	int nLastSlashIndex = buf.ReverseFind(_T('\\'));
	buf = buf.Right( buf.GetLength() - nLastSlashIndex - 1 );

	m_list.SetItemText(nIndex, 0, buf);
	m_list.SetItemData(nIndex, (DWORD)ciFile);
}

void CRefFilesChildDlg::DiscardChanges()
{
	
}

void CRefFilesChildDlg::SaveRefData( CaplInstance *ciRef, bool bExitDlg )
{
	if(!ciRef) return;
	if(!bExitDlg) return;

	int i;
	CString sPath, sErr;
	bool bChange = false;
	CaplInstance *ciDoc = 0;
	aplExtent aeNewFiles, aeOldFiles;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	m_api->m_data.GetAttr(ciRef, mgr->a_apl_refusal_files, aeOldFiles);

	//    
	for(i=0; i<m_list.GetItemCount(); i++)
	{
		ciDoc = (CaplInstance*)m_list.GetItemData(i);
		if(ciDoc) continue;

		sPath = m_list.GetItemText(i, 0);
		if(sPath.IsEmpty()) continue;

		ciDoc = m_api->m_doc_mgr.CreateFile(sPath, true);
		if(!ciDoc)
		{
			sErr.Format(APL_T("   \n\n\"%s\"!"), sPath);
			MessageBox(sErr, APL_T("   "), MB_OK|MB_ICONSTOP);
			continue;
		}

		aeNewFiles.Add(ciDoc);
	}
	if(aeNewFiles.Size) bChange = true;

	// ,   
	for(i=0; i<m_aeDelFiles.Size; i++)
	{
		for(int j=0; j<aeOldFiles.Size; j++)
		{
			if(aeOldFiles[j] == m_aeDelFiles[i])
			{
				aeOldFiles.Remove(j);
				m_api->m_data.DeleteInstance(m_aeDelFiles[i]);

				bChange = true;
				break;
			}
		}
	}

	//  
	if(bChange)
	{
		aeOldFiles.Append(aeNewFiles);
		m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_files, aeOldFiles);
	}		
}

void CRefFilesChildDlg::OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedShow();
	*pResult = 0;
}

void CRefFilesChildDlg::UpdateToolBar()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex == -1)
	{
		m_show.EnableWindow(FALSE);
		m_del.EnableWindow(FALSE);
	}
	else
	{
		m_show.EnableWindow(TRUE);
		m_del.EnableWindow(TRUE);
	}
}

void CRefFilesChildDlg::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	UpdateToolBar();
	*pResult = 0;
}
