#pragma once
#include "resource.h"
#include "RefDocumentsChildDlg.h"

// CRefResearchResultsChildDlg dialog

class CRefDocumentsChildDlg;

class CRefResearchResultsChildDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefResearchResultsChildDlg)

public:
	CRefResearchResultsChildDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefResearchResultsChildDlg();

// Dialog Data
	enum { IDD = IDD_REF_RESEARCH };

	CString m_sLab;
	CString m_sSector;
	CString m_sResearchResult;
	CString m_sTestDeductionId;
	CString m_sTestDeductionName;
	CString m_sCulpritDeductionId;
	CString m_sCulpritDeductionName;
	CString m_sActNum;
	CString m_sActName;
	CString m_sNecassaryArrangm;

	CaplButton m_choose_lab;
	CaplButton m_choose_sector;
	CaplButton m_clear_lab;
	CaplButton m_clear_sector;
	CaplButton m_choose_test;
	CaplButton m_choose_culprit;
	CaplButton m_clear_test;
	CaplButton m_clear_culprit;
	CaplButton m_choose_act;
	CaplButton m_clear_act;
	CaplButton m_create_act;
	CaplButton m_show_act;

	CDateTimeCtrl m_date_act_date;

	CaplAPI *m_api;
	CaplInstance *m_ciRef;

	CaplInstance *m_ciLab;
	CaplInstance *m_ciSector;
	CaplInstance *m_ciAct;
	CaplInstance *m_ciTestDeduction;
	CaplInstance *m_ciCulpritDeduction;

	CaplInstance *m_ciOldAct;
	CaplInstance *m_ciActAssoc;

	CRefDocumentsChildDlg *m_pDocDlg;

	void SetReadOnly();

	void ClearAct();
	void InitBtns();
	void FillDataBase();
	void InitInstances();
	void SetAct(CaplInstance *ciDoc, bool bNewDoc);
	void SaveRefData(CaplInstance *ciRef);
	void ShowClassificatorNonfoundError(CString sClassifier);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()
public:
	
	afx_msg void OnBnClickedChooseLab();
	afx_msg void OnBnClickedChooseSector();
	afx_msg void OnBnClickedClearLab();
	afx_msg void OnBnClickedClearSector();
	afx_msg void OnBnClickedChooseTest();
	afx_msg void OnBnClickedChooseCulprit2();
	afx_msg void OnBnClickedClearTest();
	afx_msg void OnBnClickedClearCulprit2();
	afx_msg void OnBnClickedClearAct();
	afx_msg void OnBnClickedChooseAct();
	afx_msg void OnBnClickedCreateAct();
	afx_msg void OnBnClickedShowAct();
};
