#pragma once
#include "resource.h"
#include "RefusalPropertyDlg.h"

// CRefChildsChildDlg dialog

class CRefusalPropertyDlg;

class CRefChildsChildDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CRefChildsChildDlg)

public:
	CRefChildsChildDlg(CaplAPI *api, CaplFaultMgr *FaultMgr, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefChildsChildDlg();

// Dialog Data
	enum { IDD = IDD_REF_CHILDS };

	CRefusalPropertyDlg *m_ParentDlg;	

	CaplAPI *m_api;
	CaplFaultMgr *m_FaultMgr;
	CaplInstance *m_ciRef;
	CaplTreeListCtrlView *m_pTreeList;

	void InitTreeList();
	void FillTreeList();
	void RedrawTree(HTREEITEM hItem, aplExtent &aeRefusalToUpdate);

	HTREEITEM AddItem(CaplInstance *ciRef, HTREEITEM hItem, bool bUpdateOnly);
	void InsertLevel(CaplInstance *ciRef, HTREEITEM hItem);

protected:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()

	afx_msg void OnDestroy();
	afx_msg void OnDblClickTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
};
