// AplAPI.h : Declaration of the CAplAPI

#ifndef __APLAPI_H_
#define __APLAPI_H_

#include "APL_PSS_APICP.h"
#include "resource.h"       // main symbols
#include <atlctl.h>

//#include "aplExplotationMgr.h"

#include  "aplworkflowmanager.h"

class CaplAPI;  

/////////////////////////////////////////////////////////////////////////////
// CAplAPI
class ATL_NO_VTABLE CAplPssAPI : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CStockPropImpl<CAplPssAPI, IAplAPI, &IID_IAplAPI, &LIBID_APL_PSS_API_Lib>,
	public CComControl<CAplPssAPI>,
	public IPersistStreamInitImpl<CAplPssAPI>,
	public IOleControlImpl<CAplPssAPI>,
	public IOleObjectImpl<CAplPssAPI>,
	public IOleInPlaceActiveObjectImpl<CAplPssAPI>,
	public IViewObjectExImpl<CAplPssAPI>,
	public IOleInPlaceObjectWindowlessImpl<CAplPssAPI>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CAplPssAPI>,
	public IPersistStorageImpl<CAplPssAPI>,
	public ISpecifyPropertyPagesImpl<CAplPssAPI>,
	public IQuickActivateImpl<CAplPssAPI>,
	public IDataObjectImpl<CAplPssAPI>,
	public IProvideClassInfo2Impl<&CLSID_AplPssAPI, &DIID__IAplAPIEvents, &LIBID_APL_PSS_API_Lib>,
	public IPropertyNotifySinkCP<CAplPssAPI>,
	public CComCoClass<CAplPssAPI, &CLSID_AplPssAPI>,
	public IDispatchImpl<IAplAPI_Data, &IID_IAplAPI_Data, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Autorization, &IID_IAplAPI_Autorization, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_BProcess, &IID_IAplAPI_BProcess, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Category, &IID_IAplAPI_Category, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Characteristic, &IID_IAplAPI_Characteristic, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Classifier, &IID_IAplAPI_Classifier, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Document, &IID_IAplAPI_Document, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Folder, &IID_IAplAPI_Folder, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Product, &IID_IAplAPI_Product, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Workflow, &IID_IAplAPI_Workflow, &LIBID_APL_PSS_API_Lib>,
	public IDispatchImpl<IAplAPI_Option, &IID_IAplAPI_Option, &LIBID_APL_PSS_API_Lib>,
	public CProxy_IAplAPIEvents< CAplPssAPI >

{
public:
	CContainedWindow m_ctlStatic;
	CAplPssAPI();
	~CAplPssAPI();

DECLARE_REGISTRY_RESOURCEID(IDR_APLAPI)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CAplPssAPI)
	COM_INTERFACE_ENTRY(IAplAPI)
/*	COM_INTERFACE_ENTRY(IDispatch)*/
	COM_INTERFACE_ENTRY(IAplAPI_Data)
	COM_INTERFACE_ENTRY(IAplAPI_Autorization)
	COM_INTERFACE_ENTRY(IAplAPI_BProcess)
	COM_INTERFACE_ENTRY(IAplAPI_Category)
	COM_INTERFACE_ENTRY(IAplAPI_Characteristic)
	COM_INTERFACE_ENTRY(IAplAPI_Classifier)
	COM_INTERFACE_ENTRY(IAplAPI_Document)
	COM_INTERFACE_ENTRY(IAplAPI_Folder)
	COM_INTERFACE_ENTRY(IAplAPI_Product)
	COM_INTERFACE_ENTRY(IAplAPI_Workflow)
	COM_INTERFACE_ENTRY(IAplAPI_Option)
	COM_INTERFACE_ENTRY2(IDispatch, IAplAPI)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CAplPssAPI)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	PROP_ENTRY("Caption", DISPID_CAPTION, CLSID_NULL)
	// Example entries
	// PROP_ENTRY(_T("Property Description"), dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CAplPssAPI)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IAplAPIEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CAplPssAPI)
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	MESSAGE_HANDLER(WM_SETFOCUS, OnSetFocus)
	CHAIN_MSG_MAP(CComControl<CAplPssAPI>)
ALT_MSG_MAP(1)
	// Replace this with message map entries for superclassed Static
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);


	LRESULT OnSetFocus(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
	STDMETHOD(SetObjectRects)(LPCRECT prcPos,LPCRECT prcClip);

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

private:
	CaplAPI* m_api;
	CaplWorkFlowManager m_wf_mgr;
	bool m_bCanDelete;
//	CaplExplotationMgr m_expl_mgr;

// IAutorization
public:
	STDMETHOD(LoadItemApproval)(/*[in]*/long item, /*[out]*/ VARIANT* allApprovals, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectPersonOrOrganization)(/*[in]*/ long mode, /*[in]*/ BSTR sDialogTitle, /*[in]*/ BSTR sTreeTitle,  /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectPersonsOrganizations)(/*[in]*/ long mode, /*[in]*/ BSTR sDialogTitle, /*[in]*/ BSTR sTreeTitle, /*[out]*/ VARIANT* persOrOrgs, /*[in, defaultvalue(TRUE)]*/ BOOL bShowUserWG, /*[in, defaultvalue(TRUE)]*/ BOOL bRecursiveSelect, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowOfficialHistory)(/*[in]*/ long official, /*[in, defaultvalue(0)]*/ long showMode, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowPersonOfficials)(/*[in]*/ long person, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetPersonOfficials)(/*[in]*/ long person,  /*[out]*/ VARIANT* officials, /*[in, defaultvalue(TRUE)]*/ BOOL bOwner, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetPersonName)(/*[in]*/ long personOrOrg, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowApproval)(/*[in]*/ long approval, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateApproval)(/*[in]*/ long instObject, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadOrgStruct)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckApproval)(/*[in]*/ long approval, BOOL bShowResult, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SignDocument)(/*[in]*/ long doc, /*[in]*/ BSTR system, /*[in]*/ BSTR key, /*[in]*/ BSTR password, /*[out]*/ BSTR* sign, /*[out]*/ BSTR* hash, /*[out]*/ BSTR* openKey, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateApprovalEx)(/*[in]*/ long item, /*[in]*/ long status, /*[in]*/ BSTR role, /*[in]*/ long person, /*[in]*/ long apprOwner, /*[in]*/ BSTR level, /*[in]*/ DATE apprDate,  /*[in]*/ BSTR signSystem, /*[in]*/ BSTR key, /*[in]*/ BSTR password, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsAdmin)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetCurrentUser)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectPersonOrOrganization2)(/*[in]*/ long mode, /*[in]*/ BSTR sDialogTitle, /*[in]*/ BSTR sTreeTitle,  /*[in]*/ VARIANT rootObjects, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectPersonsOrganizations2)(/*[in]*/ long mode, /*[in]*/ BSTR sDialogTitle, /*[in]*/ BSTR sTreeTitle, /*[in]*/ VARIANT rootObjects, /*[out]*/ VARIANT* persOrOrgs, /*[in, defaultvalue(TRUE)]*/ BOOL bShowUserWG, /*[in, defaultvalue(TRUE)]*/ BOOL bRecursiveSelect, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetSignMode)(/*[in]*/ long lMode,  /*[out, retval]*/ VARIANT* result);

// IBProcess
public:
	STDMETHOD(DeleteBPRelation)(/*[in]*/ long subBP, /*[in]*/ long baseBP, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(AddBPToBP)(/*[in]*/ long subBP, /*[in]*/ long baseBp, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAllBPVersion)(/*[in]*/ long bp, /*[out]*/ VARIANT* versions, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadAllBPResources)(/*[in]*/ long bp, /*[out]*/ VARIANT* resources, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindBPAssociation)(/*[in]*/ long instance, /*[in]*/ long bp, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateBPAssociation)(/*[in]*/ long instance, /*[in]*/ long bp, /*[in]*/ BSTR assocId, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindAssociatedBP)(/*[in]*/ long instance, /*[out]*/ VARIANT* ext, /*[out]*/ VARIANT* rels, /*[out, retval]*/ VARIANT* result );
	STDMETHOD(WhereUsedBP)(/*[in]*/ long bp, /*[out]*/ VARIANT* objects, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowBPProperties)(/*[in]*/ long bp, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindBPById)(/*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadBPInfo)(/*[in]*/ long bp, /*[in, defaultvalue(TRUE)]*/ BOOL bLoadSubBPInfo, /*[out, retval]*/ VARIANT* relust);
	STDMETHOD(DeleteBP)(/*[in]*/ long bp, /*[in, defaultvalue(TRUE)]*/ BOOL bDelSubBP, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(MakeBPVersionActive)(/*[in]*/ long bpVersion, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateBPVersion)(/*[in]*/ long bpr, /*[in]*/ BSTR idr, /*[in, defaultvalue(TRUE)]*/ BOOL bSetActive, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateBP)(/*[in]*/ BSTR id, /*[in]*/ BSTR name, /*[in]*/ long type, /*[in]*/ long baseBP, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadBPDictionary)(/*[out, retval]*/ VARIANT* result);

// ICategory
public:
	STDMETHOD(GetProductCategories)(/*[in]*/ long product, /*[in, out]*/ VARIANT* extent, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RemoveProductFromCategory)(/*[in]*/ long product, /*[in]*/ long category, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(AddProductToCategory)(/*[in]*/ long product, /*[in]*/ long category, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindProductInCategory)(/*[in]*/ long product, /*[in]*/ long category, /*[in, defaultvalue(FALSE)]*/ BOOL all, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetCategoryContents)(/*[in]*/ long category, /*[in, out]*/ VARIANT* extent, /*[in, defaultvalue(FALSE)]*/ BOOL all, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAllParentCategory)(/*[in]*/ long category, /*[in, out]*/ VARIANT* parentCategories, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RemoveCategory)(/*[in]*/ long category, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(GetAllSubCategory)(/*[in]*/ long category, /*[in, out]*/ VARIANT* subCategories, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(GetCategoryAttr)(/*[in]*/ long category, /*[out]*/ BSTR* id, /*[out]*/ BSTR* name, /*[out]*/ BSTR* description, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateCategory)(/*[in]*/ BSTR id, /*[in]*/ BSTR name, /*[in]*/ BSTR description, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RemoveSubCategory)(/*[in]*/ long baseCategory, /*[in]*/ long subCategory, /*[out, retval]*/ VARIANT *result);
	STDMETHOD(InsertSubCategory)(/*[in]*/ long baseCategory, /*[in]*/ long subCategory, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindCategory)(/*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAllCategoryVersion)(/*[in]*/ long categ, /*[out]*/ VARIANT* versions, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadCategoryInfo)(/*[in]*/ long categ, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RefreshRootCategories)(/*[out, retval]*/ VARIANT* result);

// ICharacteristic
public:
	STDMETHOD(CreateDateTimeCharacteristic)(/*[in]*/ long item, /*[in]*/ long characteristic, /*[in]*/ long type, /*[in]*/ DATE value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectCharacteristic)(/*[in, defaultvalue(0)]*/ long defaultCharact, /*[in, defaultvalue(0)]*/ long defaultGroup, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateMeasuredCharacteristic)(/*[in]*/ long item, /*[in]*/ long characteristic, /*[in]*/ long type, /*[in]*/ double value, /*[in]*/ double maxDeviation, /*[in]*/ double minDeviation, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateDescriptiveCharacteristic)(/*[in]*/ long item, /*[in]*/ long characteristic, /*[in]*/ long type, /*[in]*/ BSTR value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetCharacteristicType)(/*[in]*/ BSTR type, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindAssociatedCharacteristic)(/*[in]*/ long instance, /*[out]*/ VARIANT* outExt, /*[out]*/ VARIANT* outGroup, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstCharacteristic)(/*[in]*/ long instance, /*[in]*/ long characteristic, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetCharacteristicById)(/*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateCopyCharacteristicVal)(/*[in]*/ long old_instance, /*[in, defaultvalue(0)]*/ long new_instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(PrintCharacteristicValue)(/*[in]*/ long value, /*[in]*/ long unit, /*[out]*/ BSTR* name, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetUnitName)(/*[in]*/ long unit, /*[out]*/ BSTR* name, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteCharacteristic)(/*[in]*/ long val, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateCharacteristic)(/*[in]*/ long item, /*[in]*/ long base_val, /*[in]*/ long new_char, /*[out]*/ long *val, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetUnitById)(/*[in]*/ BSTR name, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadCharacteristicDictionary)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectCharactUnionGroup)(/*[in, defaultvalue(0)]*/ long defaultCharactUnion, /*[in, defaultvalue(0)]*/ long defaultCharactGroup, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstancesCharacteristic)(/*[in, out]*/ IDispatch** longMap, /*[in]*/ long characteristic, /*[in]*/ long type, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateEnumirationCharacteristic)(/*[in]*/ long item, /*[in]*/ long characteristic, /*[in]*/ long type, /*[in]*/ BSTR value, /*[out, retval]*/ VARIANT* result);

// IDocument
public:
	STDMETHOD(CheckSubDocument)(/*[in]*/ long docOrRevision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectDocType)(/*[in, defaultvalue(0)]*/ long selectedDocType, /*[in, defaultvalue(0)]*/ long selectedDocGroup, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateDocumentRevision)(/*[in]*/ long document, /*[in]*/ BSTR path, /*[in, defaultvalue(TRUE)]*/ BOOL stored, /*[in, defaultvalue(FALSE)]*/ BOOL setActive, /*[in, defaultvalue(0)]*/ long baseRevision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateFile)(/*[in]*/ BSTR path, /*[in, defaultvalue(TRUE)]*/ BOOL stored, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowDocChanges)(/*[in]*/ long document, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteRevision)(/*[in]*/ long revision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowDocumentProperties)(/*[in]*/ long docOrRevision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadAllDocumentRevision)(/*[in]*/ long doc, /*[in, out]*/ VARIANT* revExt, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadDocInfo)(/*[in]*/ long doc, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindAssociation)(/*[in]*/ long instance, /*[in]*/ long doc, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateAssociation)(/*[in]*/ long instance, /*[in]*/ long doc, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteDoc)(/*[in]*/ long doc, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindAssociatedDocuments)(/*[in]*/ long instance, /*[in, out]*/ VARIANT* outExt, /*[in, out]*/ VARIANT* outRel, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(Edit)(/*[in]*/ long docOrRevision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(View)(/*[in]*/ long docOrRevision, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadRevision)(/*[in]*/ long docOrRevision, /*[in]*/ BSTR path, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateDocument)(/*[in]*/ BSTR id, /*[in]*/ BSTR name, /*[in]*/ BSTR description, /*[in]*/ long type, /*[in]*/ BSTR path, /*[in, defaultvalue(TRUE)]*/ BOOL stored, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetFullFileName)(/*[in]*/ long docOrRevision, /*[out]*/ BSTR* buf, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetFileName)(/*[in]*/ long docOrRevision, /*[out]*/ BSTR* buf, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetDocumentTypeBN)(/*[in]*/ BSTR type, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindDocById)(/*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadDocumentDictionary)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadDataModule)(/*[in]*/ BSTR DMCode, /*[in]*/ BSTR pictureRef, /*[in]*/ BSTR path,  /*[out]*/ BSTR* file, /*[out, retval]*/ VARIANT* result);

// IFolder
public:
	STDMETHOD(MoveFolder)(/*[in]*/ long folder, /*[in]*/ long parentFolder, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowFolderProperties)(/*[in]*/ long folder, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RemoveFromFolder)(/*[in]*/ long folder, /*[in]*/ long item, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(AddToFolder)(/*[in]*/ long folder, /*[in]*/ long item, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetFolderContents)(/*[in]*/ long folder, /*[out]*/ VARIANT* folderContents, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteFolder)(/*[in]*/ long folder, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateFolder)(/*[in]*/ long parentFolder, /*[in]*/ BSTR name, /*[in]*/ BSTR description, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAllSubFolder)(/*[in]*/ long folder, /*[in, out]*/ VARIANT* subFolders, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadFolderInfo)(/*[in]*/ long folder, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindFolderByName)(/*[in]*/ BSTR name, /*[in. defaultvalue(0)]*/ long parentFolder, /*[out, retval]*/ VARIANT* result);

// IProduct
public:
	STDMETHOD(LoadAllZagotov)(/*[in]*/ long pdf, /*[out]*/ VARIANT* extRel, /*[out]*/ VARIANT* extPdf, /*[in, defaultvalue(FALSE)]*/ BOOL includeDesign, /*[in, defaultvalue(TRUE)]*/ BOOL fromBase, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadProductAlternates)(/*[in]*/ long product, /*[out]*/ VARIANT* extRel, /*[out]*/ VARIANT* extPrd, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(WhereProductUsed)(/*[in]*/ long pdf, /*[out]*/ VARIANT* extRel, /*[out]*/ VARIANT* extPdf, /*[in, defaultvalue(TRUE)]*/ BOOL fromBase, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DisassemblyProduct)(/*[in]*/ long ci, /*[in]*/ long context, /*[in]*/ long pdf, /*[out]*/ VARIANT*  pdfArray, /*[out]*/ VARIANT* countArray, /*[out]*/ VARIANT* unitArray, /*[in, defaultvalue(TRUE)]*/ BOOL ReturnOnlyPart, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreatePdfRelation)(/*[in]*/ long context, /*[in]*/ long relatingPDF, /*[in]*/ long relatedPDF, /*[in]*/ BSTR id, /*[in]*/ BSTR name, /*[in]*/ double count, /*[in, defaultvalue(0)]*/ long unit, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreatePDF)(/*[in]*/ BSTR id, /*[in]*/ BSTR name, /*[in]*/ BSTR version, /*[in, defaultvalue(TRUE)]*/ BOOL testUnique, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadProductInfo)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindPdfByID)(/*[in]*/ long product, /*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindProductByID)(/*[in]*/BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAllProductVersion)(/*[in]*/ long prd, /*[in, out]*/ VARIANT* outExt, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FilterlByDate)(/*[in]*/ VARIANT inExt, /*[in]*/ DATE time, /*[out]*/ VARIANT* outExt, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FilterlBySN)(/*[in]*/ VARIANT inExt, /*[in]*/ BSTR sn, /*[out]*/ VARIANT* outExt, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadAllSubProduct)(/*[in]*/ long ci, /*[in]*/ long context, /*[in]*/ long pdf, /*[out]*/ VARIANT* extRel, /*[out]*/ VARIANT* extPdf, /*[in, defaultvalue(TRUE)]*/ BOOL fromBase, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(StrConvertRus2MakeOrBuy)(/*[in]*/ BSTR sRusSource, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(StrConvertMakeOrBuy2Rus)(/*[in]*/ BSTR sSource, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(StrConvertRus2PdfType)(/*[in]*/ BSTR sRusType, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(StrConvertPdfType2Rus)(/*[in]*/ BSTR sType, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadProductDictionary)(/*[out, retval]*/ VARIANT* result);

// IAplAPI
public:
	STDMETHOD(Test)(/*[out, retval]*/ BOOL* result);
	STDMETHOD(InitAPI)(/*[in]*/ long apiInstance, /*[put, retval]*/ BOOL* result);
	STDMETHOD(LoadEntityExtentFromDB)(/*[in]*/ BSTR entity, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadExtentInfo)(/*[in]*/ VARIANT ext, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectInstance)(/*[in]*/ long selectMode, /*[in]*/ VARIANT rootObjects, /*[in, defaultvalue(_T(""))]*/ BSTR title, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetCurrentPerson)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(Connect)(/*[in]*/ BSTR userName, /*[in]*/ BSTR passWord, /*[in]*/ BSTR baseName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(Disconnect)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(SaveChanges)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetOraAlias)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsConnected)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetAccessByPatternName)(/*[in]*/ VARIANT instances, /*[in]*/ BSTR sPaternName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAccessString)(/*[in]*/ long instance, /*[in, defaultvalue(TRUE)]*/ BOOL bForUI, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(EndAdministrationMode)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(StartAdministrationMode)(/*[in]*/ BSTR Admin, /*[in]*/ BSTR Password, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CopyAccessFromInst2Inst)(/*[in]*/ VARIANT patterns, /*[in]*/ VARIANT destinations, /*[in]*/ BSTR sWaitText, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetCheckCurAccess)(/*[in]*/ BOOL bBefoSetAccess, /*[in]*/ BOOL bAfterSetAccess, /*[out. retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceName)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ConnectNoDlg)(/*[in]*/ BSTR userName, /*[in]*/ BSTR password, /*[in]*/ BSTR connect, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetMaxItemsLoad)(/*[in]*/ LONG MaxItemsLoad, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAPI)(/*[out, retval]*/ long* result);
	STDMETHOD(IsKindOf)(/*[in]*/ long instance, /*[in]*/ long type, /*[out, retval]*/ VARIANT* result);		
	STDMETHOD(CopyGroupeAccess)(/*[in]*/ long pattern, /*[in]*/ VARIANT destination, /*[in, defaultvalue(_T(""))]*/ BSTR sWaitText, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsVersionOK)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetLoadCharacteristicValues)(/*[in]*/BOOL NewValue, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(PrepareAccessStringPattern)(/*[in]*/ BSTR sPatern, /*[in, defaultvalue(_T(""))]*/ BSTR* sDefinition, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(RefreshAccessPatterns)(/*[out,retval]*/ VARIANT* result);
	STDMETHOD(SetAccessFromPatternInst)(/*[in]*/ VARIANT Instances, /*[in]*/ long Pattern, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(SetAccessFromPatternName)(/*[in]*/ VARIANT Instances, /*[in]*/ BSTR Pattern, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(SetInstancesAccess)(/*[in]*/ VARIANT instances, /*[in]*/ long userOrWG, /*[in]*/ long accessLevel, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SetInstancesAccess2)(/*[in]*/ VARIANT instances, /*[in]*/ long userOrWG, /*[in]*/ long accessLevel, /*[in, defaultvalue(-1)]*/ long AccessPattern, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsUsedAccessPattern)(/*[in]*/ long instance, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(IsUsedAccessPatterns)(/*[in]*/VARIANT Instances, /*[out]*/ VARIANT* UsedPatterns, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(RemoveAccessAgent)(/*[in]*/ VARIANT Instances, /*[in]*/ long access_agent, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceAccessMode2Users)(/*[in]*/ long instance, /*[in]*/ VARIANT users, /*[out]*/ VARIANT* usersAccess, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(ReplaceInstance)(/*[in]*/ long instance1, /*[in]*/ long instance2, /*[in]*/ BOOL bSelectInstances, /*[in, defaultvalue(FALSE)]*/ BOOL bAutoRun, /*[in, defaultvalue(FALSE)]*/ BOOL bAutoHide, /*[out,retval]*/ VARIANT* result);
	STDMETHOD(UpdatePSS)(/*[out,retval]*/ VARIANT* NeedExitApp);
	STDMETHOD(GetNameCurrUser)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetNameCurrConnection)(/*[out, retval]*/ VARIANT* result);

// IData
public:
	STDMETHOD(SaveBlobBN)(/*[in]*/ long instance, /*[in]*/ BSTR attr, /*[in]*/ BSTR filePath, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteBlobBN)(/*[in]*/ long instance, /*[in]*/ BSTR attr, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ClearData)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateInstance)(/*[in]*/ BSTR entity, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteInstance)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAttrBN)(/*[in]*/ long instance, /*[in]*/ BSTR attrName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAttr)(/*[in]*/ long instance, /*[in]*/ long attr, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetEntityExtent)(/*[in]*/ long entity, /*[out]*/ VARIANT* extent, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetEntityExtentBN)(/*[in]*/ BSTR entity, /*[out]*/ VARIANT* extent, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceId)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceById)(/*[in]*/ long id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceType)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsKindOfBN)(/*[in]*/ long instance, /*[in]*/ BSTR type, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(PutAttrBN)(/*[in]*/ long instance, BSTR attrName, /*[in]*/ VARIANT value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(PutAttr)(/*[in]*/ long instance, long attr, /*[in]*/ VARIANT value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(QueryExecute)(/*[in]*/ BSTR queryString, /*[out]*/ BSTR* errorDescription, /*[out]*/ VARIANT*objArray, /*[in, defaultvalue(FALSE)]*/ BOOL showDlg, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(Test1)(/*[out, retval]*/ BOOL* result);
	STDMETHOD(LoadSystemDictionary)(/*[in]*/ BSTR schema, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SaveP21)(/*[in]*/ BSTR fileName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadP21)(/*[in]*/ BSTR sFileName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SaveToFile)(/*[in]*/ BSTR fileName, /*[in, defaultvalue (FALSE)]*/ BOOL saveChanges, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadFromFile)(/*[in]*/ BSTR fileName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetAttrName)(/*[in]*/ long attr, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetEntityName)(/*[in]*/ long entity, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(IsValidInstance)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetEntityDefinition)(/*[in]*/ BSTR entityName, /*[out, retval]*/ long* result);
	STDMETHOD(GetAttrDefinition)(/*[in]*/ long entity, /*[in]*/ BSTR attrName, /*[out, retval]*/ long* result);
	STDMETHOD(ClearInstances)(/*[in]*/ VARIANT instances, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FreeInstancesAttr)(/*[in]*/ VARIANT instances, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceSysInfo)(/*[in]*/ long instance, /*[out]*/ BSTR* createdBy, /*[out]*/ DATE* createTime,  /*[out]*/ BSTR* editedBy, /*[out]*/ DATE* editTime, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetBlobSizeBN)(/*[in]*/ long instance, /*[in]*/ BSTR attr, /*[out, retval]*/ VARIANT*result);
	STDMETHOD(LoadBlobBN)(/*[in]*/ long istance, /*[in]*/ BSTR attr, /*[in]*/ BSTR fileName, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceTypeId)(/*[in]*/ long instance, /*[out, retval]*/ long* result);
	STDMETHOD(GetInstanceAccessmode)(/*[in]*/long instance, /*[out, retval]*/ VARIANT* result);

public:
	STDMETHOD(CheckIn)(/*[in]*/ long instance, /*[in, defaultvalue(FALSE)]*/ BOOL setActive, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckIn)(/*[in]*/ long categ, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckIn)(/*[in]*/ long doc, /*[in]*/ BSTR path, /*[in, defaultvalue(FALSE)]*/ BOOL setActive, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckOut)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckOut)(/*[in]*/ long bp, /*[in, defaultvalue (FALSE)]*/ BOOL checkOutSubBP, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CheckOut)(/*[in]*/ long docOrRevision, /*[in]*/ BSTR path, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(UndoCheckOut)(/*[in]*/ long instance, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(UndoCheckOut)(/*[in]*/ long bp, /*[in, defaultvalue (FALSE)]*/ BOOL undoCheckOutSubBP, /*[out, retval]*/ VARIANT* result);

// IWorkflow
public:
	STDMETHOD(EndTask2)(/*[in]*/ long Task, /*[in, defaultvalue(0)]*/ long Connector, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(EndTask)(/*[in]*/ long Task, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SuspendTask)(/*[in]*/ long Task, /*[in, defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateTask)(/*[in]*/ long Process, /*[in]*/ long Activity, /*[in]*/ VARIANT SubProcesses, /*[in]*/ BSTR sTaskId, /*[in]*/ BSTR sTaskName, /*[in]*/ BSTR sTaskDscr, /*[in]*/ DATE StartDate, /*[in]*/ DATE FinishDate, /*[in]*/ DATE CheckDate, /*[in, defaultvalue(0)]*/ long Manager, /*[in, defaultvalue(0)]*/ long Performer, /*[in, defaultvalue(0)]*/ long PreviousTask, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RunTask)(/*[in]*/ long Task, /*[in, defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RestartTask)(/*[in]*/ long Task, /*[in, defaultvalue(0)]*/ long NewManager, /*[in, defaultvalue(0)]*/ long NewPerformer, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowProcessProperties)(/*[in]*/long Process, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadProcessInfo)(/*[in]*/long Process, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetProcessTasks)(/*[in]*/ long Process, /*[out]*/ VARIANT* OutArray, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetUserProcessList)(/*[in]*/ long Person, /*[out]*/ VARIANT* OutArray, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetUserProcessTempList)(/*[in]*/ long Person, /*[out]*/ VARIANT* OutArray, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetUserTaskList)(/*[in]*/ long Person, /*[out]*/ VARIANT* OutArray, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(EndWfProcess)(/*[in]*/ long Process, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(TerminateWfProcess)(/*[in]*/ long Process, /*[in, defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SuspendWfProcess)(/*[in]*/ long Process, /*[in. defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RestartWfProcess)(/*[in]*/long Process, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(RunWfProcess)(/*[in]*/ long Process, /*[in, defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[in, defaultvalue(0)]*/ long FirstActivity, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteWfProcess)(/*[in]*/ long Process, /*[in, defaultvalue(TRUE)]*/ BOOL SaveChanges, /*[in, defaultvalue(TRUE)]*/ BOOL VerifyAccess, /*[out, retval]*/ VARIANT* result );
	STDMETHOD(CreateWfProcess)(/*[in]*/ BSTR sProcessId, /*[in]*/ BSTR sProcessName, /*[in]*/ BSTR sProcessDscr, /*[in]*/ long ProcessTmpl, /*[in]*/ long ProcessOwner, /*[in]*/ DATE StartDate, /*[in]*/ DATE FinishDate, /*[in]*/ DATE CheckDate, /*[in]*/ VARIANT TaskProt, /*[in]*/ VARIANT WorkObj, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadTemplates)(/*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetProcessTmplById)(/*[in]*/ BSTR sTmplId, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetProcessComponents)(/*[in]*/ long ProcessOrTmpl, /*[out]*/ VARIANT* OutArray, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowTaskProperties)(/*[in]*/ long Task, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadTaskInfo)(/*[in]*/ long Task, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetConnectors)(/*[in]*/ long TaskOrActivity, /*[out]*/ VARIANT* IncomConnectors, /*[out]*/ VARIANT* OutcomConnectors, /*[out, retval]*/ VARIANT* result);

// IClassifier
public:
	STDMETHOD(LoadClassifierInfo)(/*[in]*/ long Classifier, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteClassifierAssociation)(/*[in]*/ long item, /*[in]*/ long ClassifierLevel, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindClassifiersContained)(/*[in]*/ long item, /*[out]*/ VARIANT* classifiers, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateClassifierAssociation)(/*[in]*/ long item, /*[in]*/ long ClassifierLevel, /*[in, defaultvalue(TRUE)]*/ BOOL bTestUnique, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadSubClassifierLevels)(/*[in]*/long ClassifierItem, /*[out]*/ VARIANT* SubElements, /*[in, defaultvalue(FALSE)]*/BOOL bAllLevels, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadSubClassifierSystems)(/*[in]*/long ClassifierSystem, /*[out]*/ VARIANT* SubElements, /*[in, defaultvalue(FALSE)]*/BOOL bAllLevels, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetSubItems)(/*[in]*/ VARIANT ClassifierLevels, /*[out]*/ VARIANT* items, /*[out]*/ VARIANT* rels, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetClassifierCharacteristic)(/*[in]*/ long item, /*[out]*/ VARIANT* characteristics, /*[in, defaultvalue (FALSE)]*/ BOOL bAllLevels,  /*[in, defaultvalue (TRUE)]*/ BOOL bCheckUnique, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetClassifierLevelById)(/*[in]*/ BSTR id, /*[in]*/ long ClassifierSystem, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetClassifierLevelByName)(/*[in]*/ BSTR name, /*[in]*/ long ClassifierSystem, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetClassifierSystemById)(/*[in]*/ BSTR name, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetClassifierSystemBN)(/*[in]*/ BSTR id, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(MoveClassifierLevel)(/*[in]*/ long MovedLevel, /*[in, defaultvalue(0)]*/ long NewParent, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(MoveClassifierSystem)(/*[in]*/ long MovedSystem, /*[in, defaultvalue(0)]*/ long NewParent, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(ShowClassifierProperties)(/*[in]*/ long item, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteClassifierItem)(/*[in]*/ long item, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateClassifierLevel)(/*[in]*/ long ClassifierSystem, /*[in, defaultvalue(0)]*/ long ParentElement, /*[in, defaultvalue(_T(""))]*/ BSTR sId, /*[in, defaultvalue(_T(""))]*/ BSTR sName, /*[in, defaultvalue(_T(""))]*/ BSTR sDescription, /*[in, defaultvalue(TRUE)]*/ BOOL bTestUnique, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateClassifierSystem)(/*[in, defaultvalue(0)]*/ long ParentElement, /*[in, defaultvalue(_T(""))]*/ BSTR sId, /*[in, defaultvalue(_T(""))]*/ BSTR sName, /*[in, defaultvalue(_T(""))]*/ BSTR sDescription, /*[in, defaultvalue(TRUE)]*/ BOOL bTestUnique, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(SelectItem)(/*[in]*/ VARIANT BaseClassifierSystems, /*[in, defaultvalue(4)]*/ long mode, /*[in, defaultvalue (_T(""))]*/ BSTR sTitle, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadDictionary)(/*[out, retval]*/ VARIANT* result);

// IOption
public:
	STDMETHOD(LoadOptionsInfo)(/*[in]*/ long Option, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetInstanceOption)(/*[in]*/ BSTR Name, /*[in]*/ long DefaultValue, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetNumbericOption)(/*[in]*/ BSTR Name, /*[in]*/ long DefaultValue, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(GetStringOption)(/*[in]*/ BSTR Name, /*[in]*/ BSTR DefaultValue, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateOption)(/*[in]*/BSTR  Name, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(FindOption)(/*[in]*/ BSTR Option, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(DeleteOption)(/*[in]*/ long Option, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateInstanceOption)(/*[in]*/ BSTR Name, /*[in]*/ long Value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateNumericOption)(/*[in]*/ BSTR Name, /*[in]*/ long Value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(CreateStringOption)(/*[in]*/ BSTR Name, /*[in]*/ BSTR Value, /*[out, retval]*/ VARIANT* result);
	STDMETHOD(LoadOptionDictionary)(/*[out, retval]*/ VARIANT* result);

// Properties
public:
	STDMETHOD(get_LastErrorCode)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_AdminMode)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(get_LastErrorDescription)(/*[out, retval]*/ BSTR* pVal);
	STDMETHOD(get_ModeInteractive)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(get_AutoSave)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_SetHideMode)(/*[in]*/ BOOL newVal);
	STDMETHOD(put_WarningMode)(/*[in]*/ BOOL newVal);
	STDMETHOD(put_ErrorMode)(/*[in]*/ BOOL newVal);
	STDMETHOD(put_ModeInteractive)(/*[in]*/ BOOL newVal);
	STDMETHOD(put_AutoSave)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_LoadCharacteristicValues)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_LoadCharacteristicValues)(/*[in]*/ BOOL newVal);

public:
	CComBSTR m_bstrCaption;
};

#endif //__APLAPI_H_
