#ifndef _GENERAL_FUNCTIONS_H_
#define _GENERAL_FUNCTIONS_H_

#include <afxtempl.h>

typedef CArray<long, long> LongArray;
typedef CArray<double, double>DoubleArray;
typedef CArray<BSTR, BSTR> BSTRArray;

template <class T,class T1> 
void FillVariant(VARIANT* pVariant, T& arrySrc,int iType)
{
	ASSERT(NULL!=pVariant);
	VariantInit(pVariant);
	int iMax = arrySrc.GetSize();

	SAFEARRAY * pSafeArray; 
	SAFEARRAYBOUND aDim[1]; 
	aDim[0].lLbound = 0; 
	aDim[0].cElements = iMax;

	pVariant->vt = VT_ARRAY | iType; //vt=8195,  iType= VT_I4

	pSafeArray = SafeArrayCreate(iType, 1, aDim);

	T1* dwArray = NULL;
	SafeArrayAccessData(pSafeArray, (void**)&dwArray);

	for(int nCount = 0; nCount < iMax ; nCount++)
	{
		dwArray[nCount] = (T1)arrySrc[nCount];
	}
	SafeArrayUnaccessData(pSafeArray);
	pVariant->parray = pSafeArray;
} 

template <class T, class T1> 
void GetVariant(VARIANT variant, T& arrySrc)
{
	long lStartBound = 0;
	long lEndBound = 0;
	long ix;	//  
	T1 lx;	//   
	HRESULT hr;
	VARIANT vElm;	//    - 
	VARIANT vScr;	//---//---  - 
	VariantInit(&vElm);
	VariantInit(&vScr);
	ix= 0;
	
	SAFEARRAY* pSafeArray= NULL;

	if(variant.vt==(VT_VARIANT|VT_BYREF))
	{
		if(variant.pvarVal->vt!=VT_EMPTY)
			pSafeArray= variant.pvarVal->parray;
	}
	else if(VT_ARRAY|VT_I4)
	{
		pSafeArray = variant.parray;
	}
	else if(VT_BYREF|VT_ARRAY|VT_I4)
	{
		pSafeArray  = *(variant.pparray);
	}
	else return;
	
	if(!pSafeArray) return;
	SafeArrayGetLBound(pSafeArray, 1, &lStartBound);
	SafeArrayGetUBound(pSafeArray, 1, &lEndBound);

	T1* arrayAccess = NULL;
	SafeArrayAccessData(pSafeArray, (void**)&arrayAccess);
	
	int iSize = SafeArrayGetElemsize(pSafeArray);
	VARTYPE curVarType;
	SafeArrayGetVartype(pSafeArray, &curVarType);

//	CString sStr;
//	sStr.Format(_T(" %i "), iSize);
//	AfxMessageBox(sStr, MB_OK);

//    4,  
//     long
	if (iSize != 4 && sizeof(long)==sizeof(T1))
	{
		for(int iIndex = lStartBound; iIndex <= lEndBound; iIndex++)
		{
			hr= SafeArrayGetElement(pSafeArray, &ix, &vElm);
			if(!SUCCEEDED(hr)) continue;;
			hr= VariantChangeType(&vScr, &vElm, 0, VT_I4);
			if(!SUCCEEDED(hr)) continue;;
			lx= (T1)vScr.lVal;			
			arrySrc.Add(lx);

			ix++;
		}
	}
	else	//  (__int32, unsigned long, float)	
	{
		for(int iIndex = lStartBound; iIndex <= lEndBound; iIndex ++)
		{
			arrySrc.Add((T1)arrayAccess[iIndex]);
		}
	}

	SafeArrayDestroy(pSafeArray);
	SafeArrayUnaccessData(pSafeArray);
}

#endif //_GENERAL_FUNCTIONS_H_