#pragma once
#include "apltreeitem.h"
#include "resource.h"

class CaplRequirementTreeItem :
	public CaplTreeItem
{
public:
	CaplRequirementTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *ciReq=0,CaplInstance *ciParent=0,
		CaplInstance *ciRootParent=0, CaplInstance *ciAssoc=0);

	~CaplRequirementTreeItem(void);

	//  
	CaplInstance *m_ciReq;
	CaplInstance *m_ciParent;
	CaplInstance *m_ciRoot;
	CaplInstance *m_ciAssoc;

	// 
	aplExtent m_child_items;

	//  
	virtual bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode/* = APLICM_NORMALE */);
	virtual bool PasteItem(CaplTreeItem *item, CPoint *point/* =0 */);
	virtual bool PasteFile(LPCTSTR file, CPoint *point);
	virtual bool CreateTreeItem(HTREEITEM parent_item);
	virtual BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	virtual bool ShowInListCtrl(CListCtrl *list);
	virtual bool GetName(CString &name);
	virtual bool Expand(UINT action);
	virtual bool RefreshItem();

	virtual void ShowProperties();
	virtual void ShowCmd(long cmd);
	virtual void GetAccessedInstances(aplExtent &ext);
	virtual void Sort(bool bRefreshParent = false);

	//  
	bool ShowAssoc();
	bool ShowChildItems();
	bool ShowChildFolders();
	bool ShowWhereUsed();	
	bool RemoveAssociation();
	bool CreateFolderItem(CaplInstance *folder);
	bool CopyItem(CaplTreeItem *moved_item, CPoint *point);
	bool MoveItem(CaplTreeItem *moved_item, CPoint *point);
	bool SelectChildItemByInst(CaplInstance *ciRequirement);

	static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);
};
