// ClassifierListView.cpp: implementation of the CClassifierListView class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ClassifierListView.h"
#include "psm.h"

#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "aplTreeApprovalItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplFolderTreeItem.h"
#include "aplTopLevelItem.h"
#include "aplChangeTreeItem.h"

#include "aplDocTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "act_res_treeitem.h"
#include "aplProjectTreeItem.h"

#define my_mgr m_doc->m_api.m_classifier_mgr

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CClassifierListView, CaplListView)

CClassifierListView::CClassifierListView()
{
	SetUniqueName(_T("CClassifierListView"));
}

CClassifierListView::~CClassifierListView()
{
}


BEGIN_MESSAGE_MAP(CClassifierListView, CaplListView)
	//{{AFX_MSG_MAP(CClassifierListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierListView drawing

void CClassifierListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CClassifierListView diagnostics

#ifdef _DEBUG
void CClassifierListView::AssertValid() const
{
	CListView::AssertValid();
}

void CClassifierListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CClassifierListView message handlers

int CClassifierListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_ImageList.Create(aplGetInstImageList());
	LIST.SetImageList(&m_ImageList,LVSIL_SMALL);

	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,120);
	LIST.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,150);
	LIST.InsertColumn(2, APL_T(" "),LVCFMT_LEFT,120);
	LIST.InsertColumn(3, APL_T(" "),LVCFMT_LEFT,150);
	LIST.InsertColumn(4, APL_T(" "),LVCFMT_LEFT,80);
	LIST.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,80);
	LoadColumnWidths();

//	SetColumnDate(3);
	return 0;
}

void CClassifierListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	CString m_type = _T(""),s_dt;
	aplExtent ext;
	CaplInstance *baseinst=0;
	CString buf;

	CaplInstance *m_prd=0, *m_pdf=0; 
	
	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{
		m_prd=((CaplProductTreeItem*)item)->m_prd;
		m_pdf=((CaplProductTreeItem*)item)->m_pdf;
		if(m_pdf!=0) baseinst=m_pdf;
		else baseinst=m_prd;
	}
	else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
	{
//		if(((CaplDocTreeItem*)item)->m_rev!=0) baseinst=((CaplDocTreeItem*)item)->m_rev;
//		else item->m_doc_data.GetAttrBN(((CaplDocTreeItem*)item)->m_inst, S::active, baseinst);
		baseinst=((CaplDocTreeItem*)item)->m_inst;
	}
	else if(item->m_type==APL_TREE_ITEM_LOT) baseinst=((CaplLotTreeItem*)item)->m_lot;
	else if(item->m_type==APL_TREE_ITEM_PRDINST) baseinst=((CaplPrdInstTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_BP)
	{
		CaplInstance *rev=((CaplBPTreeItem*)item)->m_rev;
		if(rev) 
			baseinst=rev;
		else 
		{
			baseinst=((CaplBPTreeItem*)item)->m_inst;
		}
	}
	else if(item->m_type==APL_TREE_ITEM_BPINST) baseinst=((CaplBPInstTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_PROJECT) baseinst=((CaplProjectTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_CATEGORIES) baseinst=((CaplCategoryTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_FOLDER) baseinst=((CaplFolderTreeItem*)item)->m_inst;
	else if(item->m_type==APL_TREE_ITEM_CHANGE) baseinst=((CaplChangeTreeItem*)item)->m_chng;


	if(baseinst==0)return;

	StartBusy();
	SetStatusString( APL_T("  "));
	
	item->my_mgr.FindClassifiersContained(baseinst,ext);

	SetStatusString(_T(""));
	SetRedraw(FALSE);

//	CaplLoadData ld(item->m_doc_data,DEF_SOURCE);
//	int num=ld.AddQuery(_T('b'),baseinst->id,
//		item->m_doc->m_api.m_classifier_mgr.e_apl_classifier_association,
//		item->m_doc->m_api.m_classifier_mgr.a_apl_classifier_association_item,
//		true);
//	ld.AddQuery(_T('d'),num,0,)

	int i,real_pos,k;
	CaplInstance *system=0, *level=0; 
	for(i=0;i<ext.Size;i++)
	{
		level=ext[i];
		if(level==0)continue;
		real_pos=-1;

		item->m_doc_data.GetAttr(level,item->my_mgr.a_apl_classifier_level_system,system);
		int icon = ICON_DOCUMENT;
		if(system!=0){
			icon = item->m_doc->m_api.GetInstIco(system);
			item->m_doc_data.GetAttr(system,item->my_mgr.a_apl_classifier_system_id,buf);
			real_pos=LIST.InsertItem(0,buf,icon);
			item->m_doc_data.GetAttr(system,item->my_mgr.a_apl_classifier_system_name,buf);
			LIST.SetItemText(real_pos,1,buf);
		}else{
			real_pos=LIST.InsertItem(0,buf);
		}
		LIST.SetItemData(real_pos,(long)level);
		icon = item->m_doc->m_api.GetInstIco(level);
		item->m_doc_data.GetAttr(level,item->my_mgr.a_apl_classifier_level_id,buf);
		LIST.SetItem(real_pos,2,LVIF_IMAGE | LVIF_TEXT,buf,icon,0,0,0);
		item->m_doc_data.GetAttr(level,item->my_mgr.a_apl_classifier_level_name,buf);
		LIST.SetItemText(real_pos,3,buf);
		item->my_mgr.GetObjectCode(level,baseinst,buf);
		LIST.SetItemText(real_pos,4,buf);
		k=item->my_mgr.GetLevelClassifierLevel(level);
		buf.Format(_T("%i"),k);
		LIST.SetItemText(real_pos,5,buf);

	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CClassifierListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		LVHITTESTINFO lvhti;
		// Clear the subitem text the user clicked on.
		lvhti.pt = point;
		LIST.SubItemHitTest(&lvhti);

		if(lvhti.iItem!=-1 && lvhti.iSubItem!=-1)
		{
			CaplInstance *level=(CaplInstance *)LIST.GetItemData(lvhti.iItem);
			if(level!=0)
			{
				if(lvhti.iSubItem<2){
					CaplInstance* system;
					m_cur_item->m_doc_data.GetAttr(level,m_cur_item->my_mgr.a_apl_classifier_level_system,system);
					m_cur_item->my_mgr.ShowClassifierProperties(system);
				}else{
					m_cur_item->my_mgr.ShowClassifierProperties(level);
				}
			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}

LRESULT CClassifierListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}




