// EffDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PSMDoc.h"
#include "EffDlg.h"
#include "EffectivitySetDlg.h"
#include "TreeProductItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEffDlg dialog


CEffDlg::CEffDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CEffDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEffDlg)
	//}}AFX_DATA_INIT
	m_data=0;
	m_pdf=0;
	m_doc=0;
	m_prd_mgr=0;
}


void CEffDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEffDlg)
	DDX_Control(pDX, IDC_DEL_EFF, m_del_eff_btn);
	DDX_Control(pDX, IDC_ADD_EFF, m_add_eff_btn);
	DDX_Control(pDX, IDC_PRD, m_prd_name_ctrl);
	DDX_Control(pDX, IDC_EFF, m_eff_ctrl);
	DDX_Control(pDX, IDC_PRODUCTS, m_in_prd_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEffDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CEffDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_PRODUCTS, OnItemchangedProducts)
	ON_BN_CLICKED(IDC_ADD_EFF, OnAddEff)
	ON_BN_CLICKED(IDC_DEL_EFF, OnDelEff)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEffDlg message handlers

void CEffDlg::InitAnchors()
{
	ShowSizeGrip(FALSE);

	AddAnchor(IDC_PRD, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_PRODUCTS, TOP_LEFT, CSize(100, 50));
	AddAnchor(IDC_EFF, CSize(0, 50), BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);
	AddAnchor(IDC_STATIC_EFF, CSize(0, 50));
	AddAnchor(IDC_ADD_EFF, CSize(100, 50));
	AddAnchor(IDC_DEL_EFF, CSize(100, 50));
}

BOOL CEffDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	// TODO: Add extra initialization here
	int i,j,k;
	LVITEM lvitem; lvitem.mask=LVIF_TEXT;
	CString id,name,ver,buf;
	CaplInstance *inst, *inst0, *inst1, *i_pdf, *i_prd;
	aplExtent ext0,ext1;

    ListView_SetExtendedListViewStyle(m_eff_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_eff_ctrl.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);

	ListView_SetExtendedListViewStyle(m_in_prd_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_in_prd_ctrl.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);

	m_in_prd_ctrl.InsertColumn(0, APL_T(""),LVCFMT_LEFT,70);
	m_in_prd_ctrl.InsertColumn(1, APL_T(""),LVCFMT_LEFT,140);
	m_in_prd_ctrl.InsertColumn(2, APL_T(""),LVCFMT_LEFT,200);
	m_in_prd_ctrl.InsertColumn(3, APL_T(""),LVCFMT_LEFT,70);
	m_in_prd_ctrl.InsertColumn(4, APL_T(""),LVCFMT_LEFT,80);
	m_in_prd_ctrl.InsertColumn(5,_T("*"),LVCFMT_LEFT,27);

	m_eff_ctrl.InsertColumn(0, APL_T(""),LVCFMT_LEFT,217);
	m_eff_ctrl.InsertColumn(1, APL_T(""),LVCFMT_LEFT,185);
	m_eff_ctrl.InsertColumn(2, APL_T(""),LVCFMT_LEFT,185);

	if(m_pdf==0) return FALSE;
	if(m_data==0) return FALSE;
	if(m_doc==0) return FALSE;

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(m_data);

	
	m_data->GetAttrBN(m_pdf,S::of_product,inst);
	m_data->GetAttrBN(inst,S::id,buf);
	name+=buf;
	name+=_T(" : ");
	m_data->GetAttrBN(inst,S::name,buf);
	name+=buf;
	name+=_T(" : ");
	m_data->GetAttrBN(m_pdf,S::id,buf);
	name+=buf;
	m_prd_name_ctrl.SetWindowText(name);

	m_doc->m_api.m_prd_mgr.LoadAllSubProduct(0,0,m_pdf,ext0,ext1,true);
	for(i=0;i<ext0.Size;i++)
	{
		m_data->GetAttrBN(ext0[i],S::related_pd,i_pdf);
		m_data->GetAttrBN(i_pdf,S::of_product,i_prd);
		if(i_prd!=0)
		{
			m_data->GetAttrBN(ext0[i],S::id,id);
			k=m_in_prd_ctrl.InsertItem(-1,id);
			m_in_prd_ctrl.SetItemData(k,(long)ext0[i]);

			m_data->GetAttrBN(i_prd,S::id,id);
			m_in_prd_ctrl.SetItemText(k,1,id);

			m_data->GetAttrBN(i_prd,S::name,name);
			m_in_prd_ctrl.SetItemText(k,2,name);
			
			m_data->GetAttrBN(i_pdf,S::id,ver);
			m_in_prd_ctrl.SetItemText(k,3,ver);

			buf=_T("");
			double count=1;
			if(m_data->IsKindOfBN(ext0[i],S::apl_qacu))
			{
				m_data->GetAttrBN(ext0[i],S::value_component,count);
				m_data->GetAttrBN(ext0[i],S::unit_component,inst1);
				if(inst1!=0)
				{
					if(m_data->IsKindOfBN(inst1,S::si_unit))
					{
						m_data->GetAttrBN(inst1,S::id,buf);
					}
					else m_data->GetAttrBN(inst1,S::name,buf);
				}
			}
			id = Double2Str(count)+_T(" ")+buf;
			//id.Format(_T("%g %s"),count,buf);
			m_in_prd_ctrl.SetItemText(k,4,id);

			aplExtent ext2;
			m_data->GetEntityExtentBN(_T("product_definition_effectivity"),ext2);
			for(j=0;j<ext2.Size;j++)
			{
				m_data->GetAttrBN(ext2[j],S::usage,inst0);
				if(inst0==ext0[i])
				{
					m_in_prd_ctrl.SetItemText(k,5,_T("X"));
					break;
				}
			}
		}
	}
	if(m_pdf!=0)
	{
		if(m_pdf->GetAccessmode()>aplRW)
		{
			m_add_eff_btn.EnableWindow(FALSE);
			m_del_eff_btn.EnableWindow(FALSE);
		}
	}

	InitAnchors();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEffDlg::OnItemchangedProducts(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	*pResult = 0;
	if(pNMListView->uNewState!=3) return;
	// TODO: Add your control notification handler code here
	m_eff_ctrl.DeleteAllItems();
	int i,k;
	CString buf;
	CaplInstance *inst0;
	POSITION pos;
	pos=m_in_prd_ctrl.GetFirstSelectedItemPosition();
	k=m_in_prd_ctrl.GetNextSelectedItem(pos);
	if(k<0) return;
	CaplInstance *i_pdr=(CaplInstance*)m_in_prd_ctrl.GetItemData(k);
	if(i_pdr==0) return;
	aplExtent ext0;
	m_data->GetEntityExtentBN(_T("product_definition_effectivity"),ext0);
	for(i=0;i<ext0.Size;i++)
	{
		m_data->GetAttrBN(ext0[i],S::usage,inst0);
		if(inst0==i_pdr)
		{
			AddEff(ext0[i]);
		}
	}
}
void CEffDlg::OnAddEff() 
{
	// TODO: Add your control notification handler code here
	CEffectivitySetDlg dlg;
	dlg.m_data=m_data;
	dlg.m_prd_mgr=m_prd_mgr;

	POSITION pos;
	pos=m_in_prd_ctrl.GetFirstSelectedItemPosition();
	int k=m_in_prd_ctrl.GetNextSelectedItem(pos);
	if(k<0) return;
	CaplInstance *inst0=(CaplInstance*)m_in_prd_ctrl.GetItemData(k);
	if(inst0==0) return;
	
	if(dlg.DoModal()==IDOK)
	{
		m_data->PutAttrBN(dlg.m_eff,S::usage,inst0);
		AddEff(dlg.m_eff);
	}
}

void CEffDlg::AddEff(CaplInstance *eff)
{
	if(eff==0) return;
	if(m_data==0) return;
	
	bool bHide= false;
	m_data->GetAttrBN(eff, _T("is_not_active"), bHide);
	if(bHide) return;
	
	CString buf,buf1;
	m_data->GetAttrBN(eff,S::id,buf);
	
	if(buf==_T("fictive")) return;

	int k=m_eff_ctrl.InsertItem(-1,buf);
	m_eff_ctrl.SetItemData(k,(long)eff);

	if(m_data->IsKindOfBN(eff,_T("serial_numbered_effectivity")))
	{
		m_data->GetAttrBN(eff,_T("effectivity_start_id"),buf);
		if(buf!=_T("")){ buf1=_T("SN : "); buf1+=buf;} else buf1=_T("");
		m_eff_ctrl.SetItemText(k,1,buf1);
		

		m_data->GetAttrBN(eff,_T("effectivity_end_id"),buf);
		if(buf!=_T("")){ buf1=_T("SN : "); buf1+=buf;} else buf1=_T("");
		m_eff_ctrl.SetItemText(k,2,buf1);
	}
	else if(m_data->IsKindOfBN(eff,_T("dated_effectivity")))
	{
		CString s_dt;
		COleDateTime time;
		m_data->GetAttrBN(eff,_T("effectivity_start_date_s"),s_dt);
		if(aplString2Date(s_dt,time))
		{
			buf1=time.Format( APL_T("%d.%m.%Y . %H:%M:%S"));
			m_eff_ctrl.SetItemText(k,1,buf1);
		}

		m_data->GetAttrBN(eff,_T("effectivity_end_date_s"),s_dt);
		if(aplString2Date(s_dt,time))
		{
			buf1=time.Format( APL_T("%d.%m.%Y . %H:%M:%S"));
			m_eff_ctrl.SetItemText(k,2,buf1);
		}
	}
}

void CEffDlg::OnDelEff() 
{
	if(m_data==0) return;
	POSITION pos;
	pos=m_eff_ctrl.GetFirstSelectedItemPosition();
	int k=m_eff_ctrl.GetNextSelectedItem(pos);

	if(k<0) return;
	CaplInstance *inst0=(CaplInstance*)m_eff_ctrl.GetItemData(k);
	m_eff_ctrl.DeleteItem(k);
	m_data->DeleteInstance(inst0);
}
