// InfoBar.cpp : implementation file
//

#include "stdafx.h"
#include "PSM.h"
#include "InfoBar.h"
//#include "NavigatorView.h"
#include "TabView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInfoBar

IMPLEMENT_DYNCREATE(CInfoBar, baseCInfoBar)

CInfoBar::CInfoBar()
{
	//m_BarNameColor=RGB(0,128,192);
	//m_BarNameColor=RGB(160,160,255);
	m_MyWnd= 0;
}

CInfoBar::~CInfoBar()
{
}


BEGIN_MESSAGE_MAP(CInfoBar, baseCInfoBar)
	//{{AFX_MSG_MAP(CInfoBar)
	ON_WM_SIZE()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
//	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CInfoBar message handlers


void CInfoBar::OnSize(UINT nType, int cx, int cy) 
{
	SetRedraw(FALSE);
	baseCInfoBar::OnSize(nType, cx, cy);
	// TODO: Add your message handler code here
    
	CRect rect;
    GetClientRect(rect);
	if(m_MyWnd!=0)
	{
		m_MyWnd->MoveWindow(rect);
		//m_MyWnd->Invalidate();
		//m_MyWnd->ShowWindow(SW_NORMAL);
	}
	SetRedraw(TRUE);
	if(m_MyWnd!=0)m_MyWnd->Invalidate();

}

BOOL CInfoBar::CreateView(CCreateContext * pContext)
{
	CCreateContext context;
	if (pContext == NULL) 
		pContext = &context;
	
	CWnd* pWnd;
	TRY
	{
		pWnd = (CWnd*)(RUNTIME_CLASS(CTabView)->CreateObject());
		if (pWnd == NULL)AfxThrowMemoryException();
	}
	CATCH_ALL(e)
	{
		TRACE0("Out of memory creating a view.\n");
		// Note: DELETE_EXCEPTION(e) not required
		return FALSE;
	}
	END_CATCH_ALL
		
    ASSERT_KINDOF(CWnd, pWnd);
	ASSERT(pWnd->m_hWnd == NULL);       // not yet created
	
	DWORD dwStyle = AFX_WS_DEFAULT_VIEW|WS_CHILD;
	CRect rect;
	rect.left=0;rect.right=10;rect.top=0;rect.bottom=10;
//	GetClientRect(rect);
	// Create with the right size and position
	if (!pWnd->Create(NULL, NULL, dwStyle, rect, this, 0, pContext))
	{
		TRACE0("Warning: couldn't create client pane for view.\n");
		// pWnd will be cleaned up by PostNcDestroy
		return FALSE;
	}
	m_MyWnd=pWnd;
//	GetClientRect(rect);
//	m_MyWnd->MoveWindow(rect);

	return TRUE;
}


LRESULT CInfoBar::UpdateWnd(UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::SendMessage(m_MyWnd->m_hWnd, message, wParam, lParam);
}

int CInfoBar::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (baseCInfoBar::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	SetSCBStyle(GetSCBStyle() | SCBS_SHOWEDGES | SCBS_SIZECHILD);
	
	return 0;
}


/************************************************************************/
/*                  CaplAddInBar                                        */
/************************************************************************/

IMPLEMENT_DYNCREATE(CaplAddInBar, CInfoBar)

CaplAddInBar::CaplAddInBar()
{
	//m_BarNameColor=RGB(0,128,192);
	//m_BarNameColor=RGB(160,160,255);
	m_type= 0;
	m_iBarID= -1;
	m_iViewID= -1;
	m_iIsVisible= 1;
	m_sAddInName= _T("PlugIn");
	m_nRegDockBarID= AFX_IDW_DOCKBAR_RIGHT;
}

CaplAddInBar::~CaplAddInBar()
{
	
}

BEGIN_MESSAGE_MAP(CaplAddInBar, CInfoBar)
	//{{AFX_MSG_MAP(CaplAddInBar)
    ON_WM_NCLBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CaplAddInBar message handlers

BOOL CaplAddInBar::AttachWnd(CWnd* pWnd)
{
	if(!pWnd) return FALSE;
	if(!::IsWindow(pWnd->m_hWnd)) return FALSE;
	if(!pWnd->IsKindOf(RUNTIME_CLASS(CWnd))) return FALSE;

	CCreateContext context;
	
	m_MyWnd= pWnd;

	return TRUE;
}

void CaplAddInBar::SaveState(LPCTSTR lpszProfileName)
{
	CWinApp* pApp= AfxGetApp();
	if(!pApp) return;
	
	CString sValue;
    
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeHorzCX"));
	pApp->WriteProfileInt(_T("BarStates"), sValue, m_szHorz.cx);
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeHorzCY"));
    pApp->WriteProfileInt(_T("BarStates"), sValue, m_szHorz.cy);

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeVertCX"));
    pApp->WriteProfileInt(_T("BarStates"), sValue, m_szVert.cx);
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeVertCY"));
    pApp->WriteProfileInt(_T("BarStates"), sValue, m_szVert.cy);

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeFloatCX"));
    pApp->WriteProfileInt(_T("BarStates"), sValue, m_szFloat.cx);
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeFloatCY"));
    pApp->WriteProfileInt(_T("BarStates"), sValue, m_szFloat.cy);
    
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("docBarID"));
	pApp->WriteProfileInt(_T("BarStates"), sValue, m_nDockBarID);	
	
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("docBarVisible"));
	pApp->WriteProfileInt(_T("BarStates"), sValue, m_iIsVisible);	
}

void CaplAddInBar::LoadState(LPCTSTR lpszProfileName)
{
	CWinApp* pApp= AfxGetApp();
	if(!pApp) return;

	CString sValue;

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeHorzCX"));
    m_szHorz.cx = max(m_szMinHorz.cx, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinHorz.cx));
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeHorzCY"));
    m_szHorz.cy = max(m_szMinHorz.cy, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinHorz.cy));

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeVertCX"));
    m_szVert.cx = max(m_szMinVert.cx, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinVert.cx));
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeVertCY"));
    m_szVert.cy = max(m_szMinVert.cy, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinVert.cy));

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeFloatCX"));
    m_szFloat.cx = max(m_szMinFloat.cx, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinFloat.cx));
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("sizeFloatCY"));
    m_szFloat.cy = max(m_szMinFloat.cy, (int) pApp->GetProfileInt(_T("BarStates"), sValue, m_szMinFloat.cy));
    
	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("docBarID"));
	m_nRegDockBarID= pApp->GetProfileInt(_T("BarStates"), sValue, AFX_IDW_DOCKBAR_RIGHT);

	sValue.Format(_T("%s_%i_%s"), m_sAddInName, m_iViewID, _T("docBarVisible"));
	m_iIsVisible= pApp->GetProfileInt(_T("BarStates"), sValue, 1);
}

void CaplAddInBar::OnNcLButtonUp(UINT nHitTest, CPoint point) 
{
    m_iIsVisible= 0;
    CInfoBar::OnNcLButtonUp(nHitTest, point);
}
