#if !defined(AFX_MAILLISTVIEW_H__A6D1ED52_8C4C_4AA7_A832_32B8D1C90A30__INCLUDED_)
#define AFX_MAILLISTVIEW_H__A6D1ED52_8C4C_4AA7_A832_32B8D1C90A30__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MailListView.h : header file
//
#include "aplListView.h"

class CMailBodyFrame;
class CPSMDoc;
/////////////////////////////////////////////////////////////////////////////
// CMailListView view

class CMailListView : public CaplListView
{
protected:
	CMailListView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CMailListView)

// Attributes
public:
	CMailBodyFrame* m_content_body;
	//CaplTreeItem* m_cur_item;
	
	UINT m_iShowDeletedMes;
	UINT m_iShowFolderMes;
	UINT m_iShowLostMes;
	
	int m_iSubItem;
	SORT_STATE m_ssDefault;

// Operations
public:
	CPSMDoc* GetDocument();
	void UpdateTreeItem(CaplTreeItem *item);
	void UpdateView();
	void InsertMessages(long mode, aplExtent& messages);
	void ResetHeader(long mode);
	void GetStateAdd2AddressBook(bool &is_recipi, bool &is_sender);
	void Add2AddressBook(int command);
	void Move2FromFolder(bool MoveInto);
	void DeleteMessages();
	bool CheckMailMenu(bool &is_draft);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMailListView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CMailListView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CMailListView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMessageDeliver();
	afx_msg void OnUpdateMessageDeliver(CCmdUI* pCmdUI);
public:
	afx_msg void OnMessageForward();
	afx_msg void OnMessageReply();
	afx_msg void OnMessageRead();
protected:
	afx_msg void OnUpdateMessageForward(CCmdUI* pCmdUI);
	afx_msg void OnMessagePrint();
	afx_msg void OnUpdateMessagePrint(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMessageReply(CCmdUI* pCmdUI);
	afx_msg void OnMessageSend();
	afx_msg void OnUpdateMessageSend(CCmdUI* pCmdUI);
	afx_msg void OnMessageDelete();
	afx_msg void OnUpdateMessageDelete(CCmdUI* pCmdUI);
	afx_msg void OnUpdateMessageRead(CCmdUI* pCmdUI);
	afx_msg void OnShowMessageItems();
	afx_msg void OnUpdateShowMessageItems(CCmdUI* pCmdUI);
	afx_msg void OnNewMessageCreate();
	afx_msg void OnUpdateNewMessageCreate(CCmdUI* pCmdUI);
	afx_msg void OnDestroy();
	afx_msg void OnShowDeletedMessages();
	afx_msg void OnUpdateShowDeletedMessages(CCmdUI* pCmdUI);
	afx_msg void OnShowLostMessages();
	afx_msg void OnUpdateShowLostMessages(CCmdUI* pCmdUI);
	afx_msg void OnShowFolderMessages();
	afx_msg void OnUpdateShowFolderMessages(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg void OnMessagechanged(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ILSView.cpp
inline CPSMDoc* CMailListView::GetDocument()
   { return (CPSMDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAILLISTVIEW_H__A6D1ED52_8C4C_4AA7_A832_32B8D1C90A30__INCLUDED_)
