// act_res_treeitem.cpp


#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "act_res_treeitem.h"
#include "aplTreeApprovalItem.h"
#include "apl_prd_inst_item.h"
#include "TreeProductItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
#include "BPResDlg.h"
#include "TabView.h"
#include "aplBPTreeItem.h"

//****************************************************************
//****************************************************************
//****************************************************************

CaplBPResourceTreeItem::CaplBPResourceTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *inst)
{
	m_type=APL_TREE_ITEM_BPRES;
	m_tree=tree;
	m_doc=doc;
	m_inst=inst;
	m_bp_rev=0;
	if(doc!=0) 
	{
		doc->m_items.Add(this);
		//if(inst!=0)doc->m_api.m_prd_inst_mgr.LoadPrdInstInfo(inst);
	}
	m_my_prd_item=0;
}
//****************************************************************
bool CaplBPResourceTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	int ico = m_doc->m_api.GetInstIco(m_inst);
	InsetItem(buf,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}
//****************************************************************
bool CaplBPResourceTreeItem::GetName(CString &name)
{
	name=_T("???");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	m_doc->m_api.GetItemName(m_inst,name);

//	if(m_doc!=0)
//	{
//		m_doc->m_api.GetItemName(m_inst,name);
//
//		if(m_inst!=0)
//		{
//			//--
//			name=_T("");
/*
			CaplInstance *inst;
			CString s_type,buf,buf1;
			double v;
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_type,inst);
			if(inst!=0) m_doc_data.GetAttr(inst,m_doc->m_api.m_bp_mgr.a_bp_res_type_name,s_type);
			if(s_type==_T("")) s_type =_T("");
			s_type+=_T(": ");
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_object,inst);
			if(inst!=0) m_doc->m_api.m_bp_mgr.GetItemName(inst,buf);
			s_type+=buf;
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_val,v);
			if(v!=0)
			{
				m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_unit,inst);
				m_doc->m_api.m_charact_mgr.GetUnitName(inst,buf1);
				buf.Format(_T(" : %g %s"),v,LPCSTR(buf1));
				s_type+=buf;
			}
			name=s_type;*/
//		}
//	}
	return true;
}
//****************************************************************
bool CaplBPResourceTreeItem::RefreshItem()
{
	CString buf;
	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}

//****************************************************************
void CaplBPResourceTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_inst==0) return;
	CaplInstance *inst=0;
	if(m_doc->m_api.m_bp_mgr.ShowBPResourceProperties(m_inst,&inst,m_bp_rev))
	{
		if(m_doc->m_api.m_bp_mgr.m_bUseVersions)
			if(inst && inst!=m_inst)
				m_inst=inst;
		RefreshItem();

		if(m_my_prd_item!=0)
		{
			m_doc->m_items.Remove(m_doc->m_items.Find(m_my_prd_item));			
						
			m_my_prd_item=0;
			CaplInstance *inst;
			m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_object,inst);	
			
			if(inst!=0)
			{
				int num=m_all_items.Find(inst);
				if(num!=-1) m_all_items.Remove(num);			
				if((m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_mgr.e_prd))||
					(m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_mgr.e_pdf)))
				{
					m_doc->m_api.m_prd_mgr.LoadPrdInfo(inst);
				}
				InsertInstInTree(inst,m_item,m_doc,m_tree,m_all_items,0,&m_my_prd_item);
			}			
			if(m_my_prd_item!=0) m_my_prd_item->RefreshItem();
			Sort();
		}
	}

}
//****************************************************************
bool CaplBPResourceTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	//_APL_TREE_ITEM_CHEK_PARAM

	if(action==2)
	{
		if(m_expanded) return true;
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		CaplInstance *inst;
		m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_object,inst);

		if((m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_mgr.e_prd))||
			(m_doc_data.IsKindOf(inst,m_doc->m_api.m_prd_mgr.e_pdf)))
		{
			m_doc->m_api.m_prd_mgr.LoadPrdInfo(inst);
		}


		if(m_hasSubItem)Expand(1);
		if(inst!=0) 
		{
			if(m_my_prd_item==0)
				InsertInstInTree(inst,m_item,m_doc,m_tree,m_all_items,0,&m_my_prd_item);
		}
			bool old = m_bShowNoFoundMessage;
			m_bShowNoFoundMessage = false;
			m_ExecMyExpand = true;
			if(m_doc->m_auto_expand_items.m_showintree_bpres&APL_SHOW_DOC)
				ShowAllDocs(false,false);
			if(m_doc->m_auto_expand_items.m_showintree_bpres&APL_SHOW_CHARACT)
				ShowAllCharacteristic(false);
			if(m_doc->m_auto_expand_items.m_showintree_bpres&APL_SHOW_APPROVAL)
				ShowAllApproval(false);
			m_bShowNoFoundMessage = old;
			m_ExecMyExpand = true;
	}
	else if(action==1)
	{
		CollapseItem();

		m_hasSubItem=false;
		m_expanded=false;
		m_all_items.Clear();
		m_my_prd_item=0; 
	}
	return true;
}

//****************************************************************
bool CaplBPResourceTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_inst==0) return false;
	if(m_doc==0) return false;
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
//	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); //	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_ACTION_RES_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);


/*	if(m_folder==0)pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	CaplInstance *pdf;
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,pdf);
	if(pdf==0)
		pPopup->EnableMenuItem(ID_SHOW_BASE_PDF, MF_BYCOMMAND | MF_GRAYED);
	if(m_lot==0) pPopup->EnableMenuItem(ID_REMOVE_FROM_LOT, MF_BYCOMMAND | MF_GRAYED);
*/
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	switch(res)
	{
	case ID_DELETE:
		{
			if(m_inst->GetAccessmode()>aplOWN)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return true;
			}
			if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDYES)
			{
				CaplInstance *bp_ver=0;
				CaplInstance *bp=0,*bp_inst=0;
				CaplAggr aggr;
				if(m_doc->m_api.m_bp_mgr.m_bUseVersions)
				{
					if(m_bp_rev)
					{
						if(m_bp_rev->GetAccessmode()>aplOWN)
						{
							AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
							return true;
						}
						m_doc->m_api.m_bp_mgr.LoadBPInfo(m_bp_rev);
						bp_ver=m_bp_rev;
					}
					else
					{
						CaplInstance *process=0;
						m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_process,process);
						if(!process) return true;
						if(m_doc_data.IsKindOf(process,m_doc->m_api.m_bp_mgr.e_bp))
						{
							m_doc->m_api.m_bp_mgr.LoadBPInfo(process);
							bp=process;
						}
						else 
						{
							m_doc->m_api.m_bp_mgr.LoadBPInstInfo(process);
							bp_inst=process;
						}
						if(bp)
						{
							if(!m_doc->m_api.m_bp_mgr.CheckMyLockAndCheckOut(bp)) return true;
							bp_ver=m_doc->m_api.m_bp_mgr.CheckMyLock(bp,false);
						}
					}
					if(bp_ver) m_doc_data.GetAttr(bp_ver,m_doc->m_api.m_bp_mgr.a_bp_ver_res,aggr);
					else if(bp_inst) m_doc_data.GetAttr(bp_inst,m_doc->m_api.m_bp_mgr.a_bp_inst_res,aggr);

					for(int i=0;i<aggr.GetSize();i++)
					{
						CaplInstance *inst;
						aggr.GetByIndex(i,inst);
						if(inst==m_inst) aggr.Remove(i);
					}
					if(bp_ver) m_doc_data.PutAttr(bp_ver,m_doc->m_api.m_bp_mgr.a_bp_ver_res,aggr);
					else if(bp_inst) m_doc_data.PutAttr(bp_inst,m_doc->m_api.m_bp_mgr.a_bp_inst_res,aggr);
					CaplTreeItem *item0=GetParentItem(this);
					if(item0) item0->RefreshItem();
				}
				else
				{
					m_doc_data.DeleteInstance(m_inst);
				
					for(int i=0;i<m_doc->m_items.Size;i++)
					{
						if(m_doc->m_items[i]!=this)
						{
							if(m_doc->m_items[i]->m_type==m_type)
							{
								CaplBPResourceTreeItem *item1=
									(CaplBPResourceTreeItem*)m_doc->m_items[i];
								{
									if(item1->m_inst==m_inst)
									{m_doc->m_items.Remove(i); i--;}
								}
							}
						}
					}
				}
				m_doc_data.NET_SaveChanges();
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
		}
		break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_inst); break;
	case ID_CREATE_CHARACTERISTIC_GROUP: CreateCharacteristicGroup(m_inst);break;
	default: PrepareContextMenu(res); 
	}
	return true;
}
//****************************************************************
void CaplBPResourceTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_inst!=0){if(m_inst->GetType()!=0)ext.Add(m_inst);}
}

//****************************************************************
bool CaplBPResourceTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	CHECK_SHOW_LIST_CTRL(m_inst);
	if(m_doc==0)return false;

	CaplInstance *inst;
	double v;
	CString buf,buf1;

	int i=list->InsertItem(0, APL_T(":"));
	m_doc_data.GetAttrBN(m_inst,S::id,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(1, APL_T(":"));
	m_doc_data.GetAttrBN(m_inst,S::name,buf);
	list->SetItemText(i,1,buf);
	
	i=list->InsertItem(2, APL_T(":"));
	m_doc_data.GetAttrBN(m_inst,S::description,buf);
	list->SetItemText(i,1,buf);


	i=list->InsertItem(3, APL_T(":"));
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_type,inst);
	if(inst!=0) m_doc_data.GetAttr(inst,m_doc->m_api.m_bp_mgr.a_bp_res_type_name,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(4, APL_T(":"));
	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_object,inst);
	if(inst!=0) m_doc->m_api.m_bp_mgr.GetItemName(inst,buf);
	list->SetItemText(i,1,buf);


	i=list->InsertItem(5, APL_T(":"));

	m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_val,v);
	if(v!=0)
	{
		m_doc_data.GetAttr(m_inst,m_doc->m_api.m_bp_mgr.a_bp_res_unit,inst);
		m_doc->m_api.m_charact_mgr.GetUnitName(inst,buf1);
		buf = Double2Str(v)+_T(" ")+buf1;
//		buf.Format(_T("%g %s"),v,LPCSTR(buf1));
		list->SetItemText(i,1,buf);
	}

	  list->InsertItem(6,_T(""));
	i=list->InsertItem(7, APL_T(":"));
	GetAccessName(m_inst,buf);
	list->SetItemText(i,1,buf);

	aplExtent ext;
	CStringArray comment;
	if(m_inst!=0){ comment.Add( APL_T("")); ext.Add(m_inst);}
	if(m_bp_rev!=0){ comment.Add( APL_T(" ")); ext.Add(m_bp_rev);}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}/*
//****************************************************************
void CaplBPResourceTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *new_val=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(m_inst,val, &new_val,0,0,true))
	{

		if(CaplTreeItem::m_AutoUzurpireCharacteristic)
		{
			aplExtent ext; ext.Add(new_val);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}

		CaplCharacteristicTreeItem *characteristic_item=
			new CaplCharacteristicTreeItem(m_tree,m_doc,new_val);
		characteristic_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(new_val);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}*/
//****************************************************************
void CaplBPResourceTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
		case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_inst); break;
		default: PrepareContextMenu(cmd);break;
	}
}
BOOL CaplBPResourceTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}

	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
//	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
//	case ID_SHOW_ALL_VERSION:
//	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplBPResourceTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if (item->m_type != APL_TREE_ITEM_DOCUMENT)
		if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
			if (item->m_type != APL_TREE_ITEM_CHARACTERISTICGROUP)
				return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	//if(item->m_type == APL_TREE_ITEM_PRODUCT)
	//	pPopup = menu.GetSubMenu(INDEX_PRODUCT_MENU);
	//else
	if(item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		CString state;
		m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
		if(state==_T("canceled")) return false;
		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
	}
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	
	if(pPopup!=0)
	{
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
		if(parent_item && parent_item->m_type==APL_TREE_ITEM_QUERY)
		{
			pPopup->EnableMenuItem(ID_DOCUMENT_MOVE, MF_BYCOMMAND|MF_GRAYED);
		}
		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
			
			HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
			CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
			aplAccessModeType access =aplOWN;
			aplExtent instances;
			if(Item)
			{
				Item->GetAccessedInstances(instances);
				access = instances.GetAt(0)->GetAccessmode();
			}

			if(m_inst->GetAccessmode()>aplRW || access>aplRO)
			{
				AfxMessageBox( APL_T("   "));
				return false;
			}
			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_inst, false))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		//  
		else if(res == ID_DOCUMENT_BYDOT)
		{
			CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
			aplExtent instances;
			GetAccessedInstances(instances);
			if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		// 
		else if(res == ID_DOCUMENT_MOVE)
		{
			CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
			HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
			CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
			
			CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
		}
		//  
		else if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}

		}
	}
	m_tree->RedrawWindow();
	return true;
}

//****************************************************************
bool CaplBPResourceTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	CreateDoc(m_inst,file);
	return true;
}/*
//****************************************************************
void CaplBPResourceTreeItem::CreateCharacteristicGroup(CaplInstance *group)
{
	CaplInstance *group_new=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristicGroup(m_inst,&group_new,group))
	{
		if(group!=0)
		{
			if(CaplTreeItem::m_AutoUzurpireCharacteristic)
			{
				aplExtent ext; ext.Add(group);
				m_doc_data.NET_BecomeInstancesOwner(&ext);
			}

		}
		CaplCharacteristicGroupTreeItem *characteristic_group_item=
			new CaplCharacteristicGroupTreeItem(m_tree,m_doc,group_new);
		characteristic_group_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(group_new);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}
*/