// aplClassifierTreeItem.h: interface for the CaplClassifierTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLCLASSIFIERTREEITEM_H__73E4B821_3E52_4F26_9B58_D246C2F646EC__INCLUDED_)
#define AFX_APLCLASSIFIERTREEITEM_H__73E4B821_3E52_4F26_9B58_D246C2F646EC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "aplTreeItem.h"

class CaplClassifierTreeItem : public CaplTreeItem  
{
public:
	CaplClassifierTreeItem(CTreeCtrl *tree, CPSMDoc *pDoc, CaplInstance *inst=0, CaplInstance *system=0, CaplInstance *folder=0);
	virtual ~CaplClassifierTreeItem();

	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CaplInstance* m_system;
	CaplInstance *m_classifier;

public:
    bool GetName(CString &name);
	void GetAccessedInstances(aplExtent &ext);
    bool RefreshItem();
	bool RefreshAllThisClassifierItem(bool with_parent=false);
 
	bool PasteItem(CaplTreeItem *item, CPoint *point=0);
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool CreateTreeItem(HTREEITEM parent_item);
    bool Expand(UINT action);
	bool ShowContents();
    bool ShowInListCtrl(CListCtrl *list);
	bool MoveClassifierLevel(CaplClassifierTreeItem* moved_el);
	void ShowCmd(long cmd);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	//++***    
	void CreateCharacteristic(CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *group=0);
	void CreateBP();
	void CreateBPInst();
	void CreateProduct(CaplProductTreeItem *baseitem,bool return_pdf=false);
	void CreateChange();
	void CreateProject();
	void CreateWithForm();
	bool PasteFile(LPCTSTR file, CPoint *point);

protected:
	bool TestBufer();
	void ShowProperties();

};

#endif // !defined(AFX_APLCLASSIFIERTREEITEM_H__73E4B821_3E52_4F26_9B58_D246C2F646EC__INCLUDED_)
