// aplDocCopyItem.h: interface for the CaplDocCopyItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLDOCCOPYITEM_H__9248724A_3B0B_4501_B19D_990028746AA8__INCLUDED_)
#define AFX_APLDOCCOPYITEM_H__9248724A_3B0B_4501_B19D_990028746AA8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "aplTreeItem.h"

class CaplDocCopyTreeItem : public CaplTreeItem  
{
public:
	CaplDocCopyTreeItem(CTreeCtrl *tree, CPSMDoc* pDoc, CaplInstance *inst);
	virtual ~CaplDocCopyTreeItem();
	virtual bool CreateTreeItem(HTREEITEM parent_item);
	virtual bool GetName(CString &name);
	virtual void GetAccessedInstances(aplExtent& ext);
	virtual bool Expand(UINT action);
	void ShowAllBaseObjects();
	void ShowAllDocs(bool bExpand=true, bool showMsg = true);
	virtual bool ShowInListCtrl(CListCtrl* list);
	bool RefreshItem();
	void ShowProperties();
	void ShowCmd(long cmd);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool PasteItem(CaplTreeItem *item, CPoint *point);
	void RemoveRelation();
	aplExtent m_all_items;
	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_document;
	CaplInstance *m_subitem;
	CaplInstance *m_project;
	bool m_bReloadContentOnExpand;

};

#endif // !defined(AFX_APLDOCCOPYITEM_H__9248724A_3B0B_4501_B19D_990028746AA8__INCLUDED_)
