// aplFolderTreeItem.cpp

#include "stdafx.h"
#include "aplTreeItem.h"
 
#include "PSMDoc.h"
#include "resource.h"
//#include "HackDefence.h"

#include "aplTopLevelItem.h"
#include "TreeProductItem.h"
#include "TabView.h"

#include "ProductCategoryDlg.h"
#include "aplDocTreeItem.h"
#include "aplFolderTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "aplMessageTreeItem.h"
#include "Defence.h"
#include "aplQueryItem.h"
#include "aplChangeTreeItem.h"
#include "aplProjectTreeItem.h"
#include "aplTreeProcessItem.h"
#include "aplClassifierTreeItem.h"
#include "aplOrganizationTreeItem.h"
#include "aplPersonTreeItem.h"
#include "aplDocCopyItem.h"
#include "CaplRequirementTreeItem.h"
#include "CaplRefusalTreeItem.h"
#include "aplTreeProcessTmplItem.h"

//****************************************************************
//****************************************************************
//****************************************************************
CaplFolderTreeItem::CaplFolderTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
				CaplTreeItem *parent, CaplInstance *instance)
{ 
	m_type=APL_TREE_ITEM_FOLDER;
	m_tree=tree;
	m_doc=doc;
	m_parent=parent;
	m_folder=0;
	m_classifier=0;
	m_inst=instance;
	m_bCopyOnPaste = false;
	m_bIsParent4Folder=false;

	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************
bool CaplFolderTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_doc==0 || !m_doc->m_api.m_data.IsConnected()) return false;

//#ifdef _DEBUG
	if(m_type==_T("Super_type")) 
		return true;
//#endif

	CaplInstance * inst;
	CaplTreeItem *par=0;
	bool change_flag;

	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
	//VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); //VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
	//m_doc->ModifyItemContextMenu(&menu);
    CMenu* pPopup = menu.GetSubMenu(INDEX_FOLDER_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	if(m_inst!=0) AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	if(m_inst==0)
	{
		pPopup->EnableMenuItem(ID_SHOW_PARENT_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_CONTAINED_FOLDER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_CONTAINED_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);
		
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_DOC, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_BP, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_BP_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT_BY_DOT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRD_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_REFUSAL, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_LOT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_BP, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_CHANGE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_OPEN_ITEM_IN_NEW_WINDOW, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PROJECT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRJ_TREE_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_VIEW_CONTENT_IN_TABLE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_WF_PROCESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_WINETD_SAVE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_REQ, MF_BYCOMMAND | MF_GRAYED);
		
		pPopup->EnableMenuItem(ID_EXPORT_ITEM, MF_BYCOMMAND | MF_GRAYED);

		while(pPopup->DeleteMenu(1,MF_BYPOSITION));

		if(!m_doc->m_api.m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T("\\    "),false))
			pPopup->EnableMenuItem(ID_FOLDER_CREATE, MF_BYCOMMAND | MF_GRAYED);	}

	else
	{
		//m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
		if (m_inst->GetAccessmode() != aplOWN)
			pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
	}
	if(m_folder==0)pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	else pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
	if(m_classifier==0){pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);}

#ifdef _DEMO
	pPopup->EnableMenuItem(ID_FREZEE_INST, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_SET_INST_ACCSESS, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_SET_INST_OWNER, MF_BYCOMMAND | MF_GRAYED);
	pPopup->EnableMenuItem(ID_SET_INST_ACCSESS_RECURSIVE, MF_BYCOMMAND | MF_GRAYED);
#endif

	if(!m_doc->m_bUseProject)
	{
		pPopup->EnableMenuItem(ID_CREATE_PROJECT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRJ_TREE_COPY, MF_BYCOMMAND | MF_GRAYED);
	}
	
	if(m_doc->m_api.m_prd_mgr.bNoCreateAndChangePDF)
	{
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRODUCT_BY_DOT, MF_BYCOMMAND | MF_GRAYED);
	}

	BOOL res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
						point.x, point.y, wnd);
	switch (res)
	{
		case ID_SHOW_CONTAINED_FOLDER:
			ShowContainedFolder(m_inst);
			break;
		case ID_SHOW_CONTAINED_CLASSIFIER:
			ShowContainedClassifier(m_inst);
			break;
		case ID_SHOW_PARENT_FOLDER:
			{
				if(0!=m_inst)
				{
					CaplInstance *parent_folder;
					m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_folder_mgr.a_folder_parent,parent_folder);
					if(0!=parent_folder)
					{
						if(!m_doc->m_api.m_data.IsKindOf(parent_folder,m_doc->m_api.m_folder_mgr.e_folder))
							parent_folder=0;
					}
					if(0==parent_folder)
						AfxMessageBox(APL_T("   (  )"),MB_OK|MB_ICONWARNING);
					else
					{
						
						m_doc->m_api.m_folder_mgr.LoadFolderInfo(parent_folder);
						if(parent_folder->GetAccessmode()>aplRO)
							AfxMessageBox(APL_T(" !"),MB_OK|MB_ICONSTOP);
						else
						{
							CaplFolderTreeItem *new_item=0;
							InsertInstInTree(parent_folder,m_item,m_doc,m_tree,m_all_projects,0,(CaplTreeItem **)(&new_item));
							if(0!=new_item)
							{
								new_item->m_bIsParent4Folder=true;
								new_item->RefreshItem();
							}
							MyExpand();
						}
					}
				}
			}
			break;
		case ID_WINETD_SAVE:						
			m_doc->m_exchng_mgr.SaveDocsToWinETDpackage(m_inst);
			break;
		
		case ID_FOLDER_CREATE:

			if(m_inst!=0)
			{
				m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
				if(m_inst->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return false;}
			}
			inst=m_doc->m_api.m_folder_mgr.CreateFolder(m_inst,0,0);
			if(inst!=0)
			{
				CaplFolderTreeItem *fi=new CaplFolderTreeItem(m_tree,m_doc,this,inst);
				fi->CreateTreeItem(m_item);
				m_sub_folders.Add(inst);
				ShowContents();
				MyExpand();

				/*
				if(CaplTreeItem::m_AutoUzurpireFolder)
				{
					aplExtent ext; ext.Add(inst);
					m_doc_data.NET_BecomeInstancesOwner(&ext);
				}*/
			}
			break;
		case ID_OPEN_ITEM_IN_NEW_WINDOW:
			m_doc->OpenInstanceInNewWindow(m_inst);
			break;
		case ID_CREATE_PRODUCT: CreateProduct(0);break;
		case ID_DELETE:
			if(m_tree!=0)
			{
				HTREEITEM tritem=m_tree->GetParentItem(m_item);
				par=(CaplTreeItem*)m_tree->GetItemData(tritem);
			}
			if(m_inst!=0)
			{
				if(AfxMessageBox( APL_T("    ?"),MB_YESNO)!=IDYES) return false;
				if(m_doc->m_api.m_folder_mgr.DeleteFolder(m_inst))
				{
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
// 					if(par!=0)
// 					{
// 						par->Expand(1);
// 						par->Expand(2);
// 					}
				}
			}
			break;
		case ID_CREATE_LOT: 
			{
				m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
				if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
				CaplInstance *lot=m_doc->m_api.m_prd_inst_mgr.CreateLot();
				if(lot!=0)
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,lot);
					ShowContents();
					MyExpand();
				}
			}
			break;
		case ID_CREATE_PRD_INST:
			{
				m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
				if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
				CaplInstance *prd_inst=m_doc->m_api.m_prd_inst_mgr.CreatePrdInst();
				if(prd_inst!=0)
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,prd_inst);
					ShowContents();
					MyExpand();
				}
			}
			break;
		case ID_CREATE_BP: CreateBP();break;
		case ID_CREATE_BP_INST: CreateBPInst();break;
		case ID_CREATE_REFUSAL: CreateRefusal(); break;
		case ID_CREATE_CHANGE: CreateChange(); break;
		case ID_EXPORT_ITEM: m_doc->ExportItem(m_inst); break;
//		case ID_SET_ACCSESS_FOLDER_CONTENTS:
//			{
//				aplExtent ext;
//				m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
//				m_doc->m_api.m_folder_mgr.GetFolderContents(m_inst,ext);
//				if(ext.Size<=0) AfxMessageBox(APL_T("  !!!"));
//				else
//				{
//					m_doc_data.NET_SetInstancesAccess(&ext,(CaplInstance *)0,
//						(aplAccessModeType)-1);
//				}
//				if(m_doc->m_api.SetRecursiveAccess(m_inst)){
//					AfxMessageBox(APL_T("   !"),MB_ICONINFORMATION | MB_OK);
//				}
//
//			}	
//			break;
		case ID_REMOVE_FROM_FOLDER:
			if(m_folder!=0)
			{
				if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_inst))
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
			break;
		case ID_REMOVE_FROM_CLASSIFIER:
			if(m_classifier!=0)
			{
				if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
				if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_inst,m_classifier))
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
			break;
		case ID_CREATE_PROJECT:CreateProject();break;
		case ID_CREATE_PRJ_TREE_COPY:
			{
				CaplInstance *newprj=m_doc->m_project_mgr->CreateProjectTreeCopy(0,m_inst);
				if(0!=newprj) AfxMessageBox(APL_T("!"));
				ShowContents();
				MyExpand();
			}
			break;
		case ID_CREATE_PRODUCT_BY_DOT:
			{
				aplExtent res;
				CaplInstance *instance = m_doc->m_api.m_prd_mgr.CreatePdfByDot(m_inst, res);
				if(instance) ShowContents();
			}
			break;
		case ID_VIEW_CONTENT_IN_TABLE:
			change_flag=false;
			m_doc->m_api.m_folder_mgr.MakeTable(m_inst,true,&change_flag,CaplFolderManager::m_create_assoc_folder_doc==TRUE,m_doc->m_b_show_categ==TRUE);
			if(change_flag){
				Expand(1);
				ShowContents();
			}
			break;
		case ID_SS_COPY_DOCDISK:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				m_doc->m_api.m_folder_mgr.CopyDocOnDisk(m_inst, path);
				RefreshAllDocs();
				Expand(1);
				ShowContents();
				Sort();
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case ID_SS_ADD_FILEDOCS:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				if(m_doc->m_api.m_folder_mgr.AddDocFromDisk(m_inst,path))
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
				}
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case ID_SS_ADD_FILEFOLDER:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				if(m_doc->m_api.m_folder_mgr.AddDocFromPath(m_inst,path))
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
				}
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case  ID_ITEM_CHECK_OUT:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				if(m_doc->m_api.m_folder_mgr.CopyDocOnDisk(m_inst,path,APL_CHECKOUT_DOCS))
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
				}
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case ID_ITEM_CHECK_IN:
			{
				if(m_doc->m_api.m_folder_mgr.CheckInAllDocs(m_inst,m_doc->m_folders_map[m_inst->GetId()]))
					{
						RefreshAllDocs();
						Expand(1);
						ShowContents();
						Sort();
					}
			}
			break;
		case ID_ITEM_UNDO_CHECK_OUT:
			if(m_doc->m_api.m_folder_mgr.UndoCheckOut(m_inst))
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
			}
			break;
		case ID_SS_SETACCESS:
			{
				aplExtent docs;
				docs.Clear();
				m_doc->m_api.m_folder_mgr.GetAllSubDocuments(m_inst,docs);
				m_doc->m_api.m_data.NET_SetInstancesAccess(&docs);
				RefreshAllDocs();
				Expand(1);
				ShowContents();
				Sort();
			}
			break;
		case ID_SS_COMPARE_FOLDERS:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				m_doc->m_api.m_folder_mgr.CompareFolders(m_inst,path);
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
				}
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case ID_SS_PRINT_FOLDER:
			{
				CString path = m_doc->m_folders_map[m_inst->GetId()];
				m_doc->m_api.m_folder_mgr.CopyDocOnDisk(m_inst,path,APL_PRINT_DOCS);
				m_doc->m_folders_map[m_inst->GetId()] = path;
			}
			break;
		case ID_CREATE_WF_PROCESS:
			{
				aplExtent prots, wos;
				CaplInstance* proc_tmpl= m_doc->m_wf_mgr.CreateWfProcess(_T(""), _T(""), _T(""), 
					NULL, m_doc->m_api.m_appr_mgr.GetCurrentPerson(), 
					NULL, _T(""), _T(""), _T(""), prots, wos);

				if(proc_tmpl)
				{
					m_doc->m_wf_mgr.RunWfProcess(proc_tmpl);
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, proc_tmpl);
					ShowContents();
					MyExpand();
				}
			}
			break;
		case ID_CREATE_REQ:
			{
				CaplInstance *ciReq = m_doc->m_api.m_req_mgr.CreateRequirement();
				
				if(ciReq)
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, ciReq);
					ShowContents();
					MyExpand();
				}
			}
			break;
		case ID_IMPORT_REQ_FROM_XML:
			{
				aplExtent aeRootItems;

				m_doc->m_api.m_req_mgr.ImportRequirementsFromXMLword2003(aeRootItems);
				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, aeRootItems);

				if(aeRootItems.Size)
				{
					ShowContents();
					MyExpand();
				}
			}
			break;

		case ID_EDIT_PASTE: 

			m_bCopyOnPaste = true;
			((CNavigatorView*)m_tree)->OnPaste(); 
			m_bCopyOnPaste = false;
			break;

		default: PrepareContextMenu(res); break;
	}
	return true;
}
//****************************************************************
bool CaplFolderTreeItem::GetName(CString &name)
{
	name=_T("???");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if(m_type == _T("Super_type"))
	{
		name =  APL_T(" ");
		return true;
	}
	if(m_inst==0){
		name =  APL_T("");
		return true;
	}
	m_doc->m_api.GetItemName(m_inst,name);
	return true;
}
//****************************************************************
bool CaplFolderTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	CString buf;
	GetName(buf);

	int ico=ICON_FOLDERS;

	if(m_inst)
	{
	    ico = m_doc->m_api.GetInstIco(m_inst);

		//    ?
		if(m_folder!=0) ico+=2;
	}
	else
		if(m_folder)
			ico = m_doc->m_api.GetInstIco(m_folder);

	if(m_type == _T("Super_type"))
		ico = ICON_PERSON_LOCK_FOLDER;

	InsetItem(buf,ico,parent_item);

	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	m_expanded=false;
	return true;
}

void CaplFolderTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
	case ID_CREATE_BP: CreateBP(); break;
	case ID_CREATE_PRODUCT: CreateProduct(); break;
	case ID_CREATE_BP_INST: CreateBPInst();	break;
	case ID_SHOW_ALL_CONTENTS:  Expand(2); MyExpand(); break;
	case ID_EXPAND_ALL: {int i=1; ExpandAll(i);} break;
	case  ID_ITEM_CHECK_OUT:
		{
			CString path = m_doc->m_folders_map[m_inst->GetId()];
			if(m_doc->m_api.m_folder_mgr.CopyDocOnDisk(m_inst,path,true))
			{
				RefreshAllDocs();
				Expand(1);
				ShowContents();
				Sort();
			}
			m_doc->m_folders_map[m_inst->GetId()] = path;
		}
		break;
	case ID_ITEM_CHECK_IN:
		{
			if(m_doc->m_api.m_folder_mgr.CheckInAllDocs(m_inst,m_doc->m_folders_map[m_inst->GetId()]))
				{
					RefreshAllDocs();
					Expand(1);
					ShowContents();
					Sort();
				}
		}
		break;
	case ID_ITEM_UNDO_CHECK_OUT:
		if(m_doc->m_api.m_folder_mgr.UndoCheckOut(m_inst))
			{
				RefreshAllDocs();
				Expand(1);
				ShowContents();
				Sort();
		}
		break;
	default: PrepareContextMenu(cmd);break;
	}
}
BOOL CaplFolderTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(m_inst==0) return FALSE;
	if(m_inst->GetType()==0) return FALSE;
	if(!m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_folder_mgr.e_folder)) return FALSE;

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}


	if(m_doc->m_api.m_prd_mgr.bNoCreateAndChangePDF)
	{
		if(ID_CREATE_PRODUCT==pCmdUI->m_nID)  return FALSE;
		if(ID_CREATE_PRODUCT_VERSION==pCmdUI->m_nID)  return FALSE;
	}

	switch(pCmdUI->m_nID)
	{
	case ID_CREATE_BP:
	//case ID_SHOW_ALL_DOCS:
	//case ID_SHOW_ALL_CHARACTERISTIC:
	//case ID_SHOW_ALL_APPROVAL:
	//case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
	//case ID_SHOW_ALL_LOT:
	//case ID_SHOW_ALL_PRD_INST:
	//case ID_CREATE_APPROVAL:
	//case ID_SHOW_ALL_VERSION:
	case ID_CREATE_PRODUCT:
	case ID_CREATE_BP_INST:
	//case ID_ITEM_CHECK_IN:
	//case ID_ITEM_CHECK_OUT:
	//case ID_ITEM_UNDO_CHECK_OUT:
	//case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_CREATE_NOTE:
	case ID_SHOW_NOTES:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}

bool CaplFolderTreeItem::ShowContents()
{
	if(m_doc==0) return false;
	if(m_tree==0) return false;
	if(!m_doc_data.IsConnected())
	{
		m_tree->DeleteItem(m_fictive_item);
		m_fictive_item = 0;
		return false;
	}

	CaplInstance* inst= NULL/*, *mes, *sender, *recip, *folder*/;
	CaplInstance* person= m_doc->m_api.m_appr_mgr.GetCurrentPerson();

	int i;
	aplExtent ext;

	m_tree->SetRedraw(FALSE);
	if(m_fictive_item!=0)
	{
		m_tree->DeleteItem(m_fictive_item);
		m_fictive_item=0;
	}

//#ifdef _DEBUG
	if(m_type==_T("Super_type")) 
	{
		ShowContentsP();
		m_tree->SetRedraw();
		return true;
	}
//#endif
	//  m_inst    0 -  ,    
	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	m_expanded=true;
	//  
	m_doc->m_api.m_folder_mgr.GetAllSubFolder(m_inst,ext,false,false);
	for(i=0;i<ext.Size;i++)
	{
		if(ext[i]->GetAccessmode()>aplRO) continue;
		if(-1==m_sub_folders.Find(ext[i]))
		{
			CaplFolderTreeItem *fi=new CaplFolderTreeItem(m_tree,m_doc,this,ext[i]);
			fi->CreateTreeItem(m_item);
			fi->RefreshItem();
			m_sub_folders.Add(ext[i]);
		}
	}
	if(m_inst!=0)
	{
		//  
		StartBusy();
		m_doc->m_api.m_folder_mgr.GetFolderContents(m_inst,ext);
		StopBusy();


		if(m_doc->m_bUseProject)
		{
			aplExtent ext_projects;
			for(i=0;i<ext.Size;i++)
			{
				if(m_doc_data.IsKindOf(ext[i], m_doc->m_project_mgr->e_project))
				{
					ext_projects.Add(ext[i]);
				}
			}
			m_doc->m_project_mgr->LoadProjectInfo(ext_projects);
		}
		//         
		CaplLoadData ld(&m_doc->m_api.m_data,DEF_SOURCE);
		for(i=0;i<ext.Size;i++)
		{
			//    ,   
			if(m_doc_data.IsKindOf(ext[i], m_doc->m_api.m_message_mgr.e_message))
			{
				ld.AddQuery(0, ext[i]);
			}
		}
		if(ld.IsQueryNotEmpty())
		{
			ld.AddQuery(_T('d'), 0, 0, m_doc->m_api.m_message_mgr.a_message_copy, true);
			ld.LoadEx();
		}

		for(i=0;i<ext.Size;i++)
		{
			//    ,   
			if(m_doc_data.IsKindOf(ext[i], m_doc->m_api.m_message_mgr.e_message))
			{
				CaplInstance* mainMes= NULL;
				m_doc_data.GetAttr(ext[i], m_doc->m_api.m_message_mgr.a_message_copy, mainMes);
				if(mainMes)
				{
					int index= ext.Find(mainMes);
					if(-1!=index) continue;//  
				}
			}
			if(m_doc_data.IsKindOf(ext[i], m_doc->m_project_mgr->e_project))
			{
				if(!m_doc->m_bUseProject)
					continue;
			}
			CaplTreeItem* aplItem= NULL;
			InsertInstInTree(ext[i],m_item,m_doc,m_tree,m_contents,m_inst, &aplItem);
		}
	}
	m_tree->SetRedraw(TRUE);
	return true;
}

//****************************************************************
bool CaplFolderTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	if(action==2)
	{

		if(m_expanded) return true;
		if(m_inst==0)
		{
			aplExtent ext;
			m_doc->m_api.m_folder_mgr.GetAllSubFolder(0,ext,false,false);
			if(ext.Size==0)
			{
				//AfxMessageBox(APL_T("   !"));
				m_tree->SetItemText(m_fictive_item, APL_T("<   >"));
				return true;
			}
		}
		if(m_hasSubItem)Expand(1);
		ShowContents();
		Sort();
	}
	else if(action==1)
	{
		CollapseItem();
		m_sub_folders.Clear();
		m_contents.Clear();
		m_hided_messages.Clear();
	}
	return true;
}
//****************************************************************
bool CaplFolderTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	if(m_type == _T("Super_type"))
	{
		CHECK_SHOW_LIST_CTRL_TOP(m_inst, APL_T(" "));
	}
	else
	{
		CHECK_SHOW_LIST_CTRL_TOP(m_inst, APL_T(""));
	}
	if(m_doc==0)return false;
	//LoadProperties();
	
	CString buf;
	if(m_inst!=0)
	{
		int i=list->InsertItem(0, APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::name,buf);
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(1, APL_T(":"));
		m_doc_data.GetAttrBN(m_inst,S::description,buf);
		list->SetItemText(i,1,buf);
	}
	
	int i=list->InsertItem(2,_T(""));
	if(m_inst!=0)
	{
		i=list->InsertItem(3, APL_T("  :"));
		GetAccessName(m_inst,buf);
		list->SetItemText(i,1,buf);
	}
	aplExtent ext;
	int iFoldCount= 0, n=0;
	CaplInstance* par_folder;
	i=list->InsertItem(4,_T(""));
	if(m_inst!=0)
	{
		i=list->InsertItem(5, APL_T(" :"));
		m_doc_data.GetAttr(m_inst,m_doc->m_api.m_folder_mgr.a_folder_content,ext);
		buf.Format(_T("%i"),ext.GetSize());
		list->SetItemText(i,1,buf);
		i=list->InsertItem(6, APL_T(" :"));
//		m_doc->m_api.m_folder_mgr.GetAllSubFolder(m_inst,ext);

		m_doc->m_api.m_data.GetEntityExtent(m_doc->m_api.m_folder_mgr.e_folder, ext);
		for (n= 0; n<ext.GetSize(); n++)
		{
			if(!ext[n]) continue;
			if(ext[n]->GetAccessmode()>aplRO) continue;
			
			m_doc->m_api.m_data.GetAttr(ext[n], m_doc->m_api.m_folder_mgr.a_folder_parent, par_folder);
			if(par_folder==m_inst)
				iFoldCount++;
		}
		
		buf.Format(_T("%i"),iFoldCount);
		list->SetItemText(i,1,buf);
		
		i=list->InsertItem(7,_T("packet_date:"));
		m_doc_data.GetAttr(m_inst,m_doc->m_api.m_folder_mgr.a_folder_packet_date,buf);
		list->SetItemText(i,1,buf);
		i=list->InsertItem(8,_T("packet_size:"));
		m_doc_data.GetAttr(m_inst,m_doc->m_api.m_folder_mgr.a_folder_packet_size,buf);
		list->SetItemText(i,1,buf);

	}

	CStringArray  comment;
	ext.Clear();
	
	if(m_inst!=0){
		comment.Add(_T("m_inst"));
		ext.Add(m_inst);
	}
	if(m_folder!=0){
		comment.Add(_T("m_folder"));
		ext.Add(m_folder);
	}
	if(m_classifier!=0){
		CaplInstance* classif_ref;
		m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_inst,m_classifier,&classif_ref);
		if(classif_ref!=0){
			comment.Add(_T("classifier association"));
			ext.Add(classif_ref);
		}
		comment.Add(_T("m_classifier"));
		ext.Add(m_classifier);
	}
	
	ShowInstanceInfoInListCtrl(ext,list,&comment);
	
	return true;
}
//****************************************************************
bool CaplFolderTreeItem::RefreshItem()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL

	Sort();
	CString name,name1;
	GetName(name);

	if(0!=m_inst)
	{
		if(m_doc->m_api.m_data.IsKindOf(m_inst,m_doc->m_api.m_folder_mgr.e_folder))
		{
			int new_image=ICON_FOLDER;
			if(m_folder!=0) new_image+=2;
			name1=name; name1.MakeLower();
			if(name1==APL_NO_T(" "))
			{
				CaplInstance *parent;
				m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_folder_mgr.a_folder_parent,parent);
				if(parent==m_doc->m_api.m_data.GetCurrUser()) new_image=ICON_PERS_FOLDER;
			}
			SetItemImage(new_image, IDX_IL_TREE_ITEM);
		}
	}

	if(m_bIsParent4Folder) 
		SetItemImage(ICO_REL_WHERE_USED,IDX_IL_TREE_REL_TYPE,false);

	m_tree->SetItemText(m_item,name);
	m_tree->RedrawWindow();
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}

bool CaplFolderTreeItem::RefreshAllThisFolderItem()
{
	int i;
	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]!=this)
		{
			if(m_doc->m_items[i]->m_type==m_type)
			{
				CaplFolderTreeItem *item=(CaplFolderTreeItem*)m_doc->m_items[i];
				if(item->m_inst==m_inst) item->RefreshItem();
			}
		}
	}
	RefreshItem();
	return true;
}
//****************************************************************
void CaplFolderTreeItem::ShowProperties()
{
    if(m_doc==0) return;
    if(m_inst==0) return;
    
    m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	m_doc->m_api.m_folder_mgr.ShowFolderProperties(m_inst);
	RefreshAllThisFolderItem();
}
//****************************************************************
void CaplFolderTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_inst!=0)
	{
//		m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
		if(m_inst->GetType()!=0)ext.Add(m_inst);
	}
}

//****************************************************************

//****************************************************************

void CaplFolderTreeItem::CreateProduct(CaplProductTreeItem *baseitem)
{
	if(m_doc==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;

	if(m_doc->m_api.m_prd_mgr.bNoCreateAndChangePDF)
	{
		AfxMessageBox(IDS_NO_CREATE_PDF,MB_OK|MB_ICONSTOP);
		return;
	}

	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	CaplInstance* tmp_inst = m_doc->m_api.m_prd_mgr.CreateProduct(baseitem!=0?baseitem->m_pdf:0, aplModeCreateProduct);
	if(tmp_inst!=0)
	{
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, tmp_inst);
		ShowContents();
		MyExpand();
	}
	RefreshAllThisFolderItem();
	m_tree->RedrawWindow();
}
//****************************************************************
bool CaplFolderTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	if(m_inst==0) return false;
	CreateDoc(0,file);
	return true;
}
//****************************************************************
void CaplFolderTreeItem::CreateBP()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	CaplInstance *act_inst=m_doc->m_api.m_bp_mgr.CreateBP();
	if(act_inst!=0)
	{
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,act_inst);
		ShowContents();
		MyExpand();
	}
}
//****************************************************************
void CaplFolderTreeItem::CreateBPInst()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	CaplInstance *act_inst=m_doc->m_api.m_bp_mgr.CreateBPInst();
	if(act_inst!=0)
	{
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,act_inst);
		ShowContents();
		MyExpand();
	}
}
void CaplFolderTreeItem::CreateRefusal()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	//CaplInstance *refusalt=m_doc->m_api.m_expl_mgr->CreateRefusal();
	aplExtent ext;
	CaplInstance *refusalt=m_doc->m_fault_mgr.CreateRefusal(0,ext);
	if(refusalt!=0)
	{
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,refusalt);
		ShowContents();
		MyExpand();
	}
}

//****************************************************************
void CaplFolderTreeItem::CreateProject()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	CaplInstance *act_inst=m_doc->m_project_mgr->CreateProject();
	if(act_inst!=0)
	{
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,act_inst);
		ShowContents();
		MyExpand();
	}
}
//****************************************************************
void CaplFolderTreeItem::CreateChange()
{
	if(m_doc==0) return;
	if(m_tree==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	
	if(m_inst->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	
	aplExtent ext;
	CaplInstance* change= m_doc->m_api.m_change_mgr.CreateChange(_T(""), _T(""), _T(""), _T(""), NULL, ext);
	
	if(change)
	{
		/*
		if(CaplTreeItem::m_AutoUzurpireChange)
		{
			aplExtent ext; ext.Add(change);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}*/

		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, change);
		ShowContents();
		MyExpand();
	}
}


//****************************************************************
bool CaplFolderTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
//#ifdef _DEBUG
//#endif
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;

	CaplFolderTreeItem *p = (CaplFolderTreeItem*)m_tree->GetItemData(m_item);
	if(p->m_type==_T("Super_type")) 
	{
		if(item->m_type==APL_TREE_ITEM_DOCUMENT)
		{
			if(AfxMessageBox( APL_T("   ?"),MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1)!=IDYES) return true;
			CaplDocTreeItem *doc = ((CaplDocTreeItem*)item);
			doc->CheckOut();
			Expand(1);
			Expand(2);
			return true;
		}
		if(item->m_type==APL_TREE_ITEM_CATEGORIES)
		{
			if(AfxMessageBox( APL_T("   ?"),MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1)!=IDYES) return true;
			CaplInstance *inst = ((CaplCategoryTreeItem*)item)->m_inst;
			m_doc->m_api.m_categ_mgr.CheckOut(inst);
			Expand(1);
			Expand(2);
			((CaplCategoryTreeItem*)item)->Expand(1);
			((CaplCategoryTreeItem*)item)->Expand(2);
			return true;
		}
		if(item->m_type==APL_TREE_ITEM_BP)
		{
			if(AfxMessageBox( APL_T("    ?"),MB_ICONQUESTION | MB_YESNO | MB_DEFBUTTON1)!=IDYES) return true;
			CaplBPTreeItem *inst = ((CaplBPTreeItem*)item);
			CString tmp_path; tmp_path.GetEnvironmentVariable(_T("temp"));
			inst->CheckOut();
			Expand(1);
			Expand(2);
			return true;
		}
		return false;
	}

	if((m_inst==0)&&(item->m_type!=APL_TREE_ITEM_FOLDER)) return false;

	if(m_inst!=0)
	{
		m_doc->m_api.m_folder_mgr.LoadFolderInfo(m_inst);
		if(m_inst->GetAccessmode()>aplRW)
			{ AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
	}
	else
	{
		if(!m_doc->m_api.m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T("\\    "),true))
			return false;
	}
	// Product
	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{
		CaplInstance *inst=((CaplProductTreeItem*)item)->m_pdf;
		if(inst==0) inst=((CaplProductTreeItem*)item)->m_prd;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	// Document
	else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
	{

		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
//		VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
		CaplMenu::Install(m_tree); //		VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
		if(pPopup!=0)
		{
			POINT pnt;
			if(point==0)
			{
				RECT rect;
				m_tree->GetItemRect(m_item,&rect,TRUE);
				m_tree->ClientToScreen(&rect);
				pnt.x=rect.right;
				pnt.y=rect.bottom;
			}
			else
			{
				pnt.x=point->x;
				pnt.y=point->y;
			}

			HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
			CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
			if(parent_item && parent_item->m_type==APL_TREE_ITEM_QUERY)
			{
				pPopup->EnableMenuItem(ID_DOCUMENT_MOVE, MF_BYCOMMAND|MF_GRAYED);
			}
			BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
				TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

			//  
			if (res == ID_DOCUMENT_COPY)
			{
				CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
				
				HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
				CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
				aplAccessModeType access =aplOWN;
				if(Item)
				{
					aplExtent instances;
					Item->GetAccessedInstances(instances);
					if (instances.GetSize())
						access = instances.GetAt(0)->GetAccessmode();
				}
				
				if(m_inst->GetAccessmode()>aplRW || access>aplRO)
				{
					AfxMessageBox( APL_T("   "));
					return false;
				}
				if(CaplFolderManager::m_create_assoc_folder_doc==FALSE)//   
				{
					if(m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, i_doc))
					{
						ShowContents();
						MyExpand();
					}
				}
				else//    .
				{
					if(m_doc->m_api.m_doc_mgr.CreateAssociation(m_inst,i_doc))
					{
						ShowContents();
						MyExpand();
					}
				}
			}
			//  
			else if(res == ID_DOCUMENT_BYDOT)
			{
				CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
				
				aplExtent instances;
				GetAccessedInstances(instances);
				CaplInstance *docum = m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]);
				if(docum)
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(instances[0],docum);
					ShowContents();
					MyExpand();
				}
			}
			// 
			else if(res == ID_DOCUMENT_MOVE)
			{
				CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
				HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
				CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);

				CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
			}
		}
	/*		
		CaplInstance *inst=((CaplDocTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();*/
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_CATEGORIES)
	{
		CaplInstance *inst=((CaplCategoryTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_LOT)
	{
		CaplInstance *inst=((CaplLotTreeItem*)item)->m_lot;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_PRDINST)
	{
		CaplInstance *inst=((CaplPrdInstTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_REFUSAL)
	{
		CaplInstance *inst=((CaplRefusalTreeItem*)item)->m_refusal;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_BP)
	{
		CaplInstance *inst=((CaplBPTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_BPINST)
	{
		CaplInstance *inst=((CaplBPInstTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_PROJECT)
	{
		if(m_doc->m_bUseProject)
		{
			CaplInstance *inst=((CaplProjectTreeItem*)item)->m_inst;
			if(inst==0) return false;

			CMenu menu;  gSetPsmResourceHandle();
			CMenu *pPopup;
			VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
			CaplMenu::Install(m_tree); 
			pPopup = menu.GetSubMenu(INDEX_PASTE_PRECESS_MENU);

			POINT pnt;
			if(point==0)
			{
				RECT rect;
				m_tree->GetItemRect(m_item,&rect,TRUE);
				m_tree->ClientToScreen(&rect);
				pnt.x=rect.right;
				pnt.y=rect.bottom;
			}
			else
			{
				pnt.x=point->x;
				pnt.y=point->y;
			}

			if(0==((CaplProjectTreeItem*)item)->m_folder)
				pPopup->EnableMenuItem(ID_ITEM_MOVE, MF_BYCOMMAND | MF_GRAYED);

			BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD, pnt.x, pnt.y, m_tree);

			switch (res)
			{
			case ID_ITEM_COPY:
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
					ShowContents();
					MyExpand();
					break;
				}
			case ID_ITEM_MOVE:
				{
					if(m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst))
					{
						CaplInstance *old_folder=((CaplProjectTreeItem*)item)->m_folder;
						if(0!=old_folder)
						{
							if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(old_folder, inst))
							{
								m_doc->m_items.Remove(m_doc->m_items.Find(item));
							}
						}
					}
					ShowContents();
					MyExpand();
					break;
				}
			}

			return true;
		}
	}
	else if(item->m_type==APL_TREE_ITEM_PROCESS)
	{
		CaplInstance *inst=((CaplProcessTreeItem*)item)->m_process;
		if(inst==0) return false;

		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
		CaplMenu::Install(m_tree); 
		pPopup = menu.GetSubMenu(INDEX_PASTE_PRECESS_MENU);

		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		if(0==((CaplProcessTreeItem*)item)->m_folder)
			pPopup->EnableMenuItem(ID_ITEM_MOVE, MF_BYCOMMAND | MF_GRAYED);

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD, pnt.x, pnt.y, m_tree);

		switch (res)
		{
		case ID_ITEM_COPY:
			{
				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, inst);
				ShowContents();
				MyExpand();			
				break;
			}
		case ID_ITEM_MOVE:
			{
				if(m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, inst))
				{
					CaplInstance *old_folder=((CaplProcessTreeItem*)item)->m_folder;
					if(0!=old_folder)
					{
						if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(old_folder, inst))
						{
							m_doc->m_items.Remove(m_doc->m_items.Find(item));
						}
					}
				}
				ShowContents();
				MyExpand();
				break;
			}
		}
	}
	else if(item->m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM || item->m_type==APL_TREE_ITEM_CLASSIFIERLEVEL)
	{
		CaplInstance *inst=((CaplClassifierTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_ORGANIZATION)
	{
		CaplInstance *inst=((CaplOrganizationTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_PERSON)
	{
		CaplInstance *inst=((CaplPersonTreeItem*)item)->m_person;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_PROCESSTMPL)
	{
		CaplInstance *inst=((CaplProcessTmplTreeItem*)item)->m_proc_tmpl;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_REQUIREMENT)
	{
		if(!m_bCopyOnPaste)
		{
			CaplInstance *inst=((CaplRequirementTreeItem*)item)->m_ciReq;
			if(inst==0) return false;

			//   
			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);			
		}
		else
		{
			//   
			CaplInstance* inst_moved = ((CaplRequirementTreeItem*)item)->m_ciReq;
			CaplInstance *ciNewRoot = m_doc->m_api.m_req_mgr.CreateRequirementCopy(inst_moved);
			
			//    
			m_doc->m_api.m_req_mgr.CopyRequirementsRecursive(inst_moved, ciNewRoot, inst_moved);

			//   
			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, ciNewRoot);			
		}

		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==APL_TREE_ITEM_MESSAGE)
	{
		CaplInstance* inst= NULL, *mes, *sender, *recip, *folder;
		CaplInstance* person=m_doc->m_api.m_appr_mgr.GetCurrentPerson();
		
		mes=((CaplMessageTreeItem*)item)->m_message;
		folder=((CaplMessageTreeItem*)item)->m_folder; 
		if(mes==0) return false;
		if(folder==m_inst) return true;

		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_sender, sender);
		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_recipient, recip);
		
		//    ...
		if(person!=sender && person!=recip) return false;

		bool bSave= false;
		CaplInstance* rec_folder, *send_folder;
		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_recipient_folder, rec_folder);
		m_doc_data.GetAttr(mes, m_doc->m_api.m_message_mgr.a_message_sender_folder, send_folder);
		
		if(sender==person)//
		{
			//       
			if(send_folder && rec_folder!=folder)
			{
				m_doc->m_api.m_folder_mgr.RemoveFromFolder(send_folder, mes);
				//  
				CaplFolderTreeItem* fldOld= ((CaplMessageTreeItem*)item)->m_folderItem;
				int ind= fldOld->m_contents.Find(mes);
				fldOld->m_contents.Remove(ind);
			}
			else
			{
				m_doc->m_send_or_dr_messages.Remove(m_doc->m_send_or_dr_messages.Find(mes));
			}

			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, mes);
			m_doc_data.PutAttr(mes, 
				m_doc->m_api.m_message_mgr.a_message_sender_folder, m_inst);		
			
			folder= send_folder;

			bSave= true;
		}
		if(recip==person)//
		{
			//       
			if(rec_folder && send_folder!=folder)
			{
				m_doc->m_api.m_folder_mgr.RemoveFromFolder(folder, mes);
				//  
				((CaplMessageTreeItem*)item)->m_folderItem->m_contents.Remove(
					((CaplMessageTreeItem*)item)->m_folderItem->m_contents.Find(mes));
			}
			else
			{
				m_doc->m_incoming_messages.Remove(m_doc->m_incoming_messages.Find(mes));
			}
			
			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, mes);
			m_doc_data.PutAttr(mes, 
				m_doc->m_api.m_message_mgr.a_message_recipient_folder, m_inst);
			
			folder= rec_folder;

			bSave= true;
		}
		if(bSave)
		{
			m_doc_data.NET_SaveChanges();
			
			//
			for(int j= 0; j<m_doc->m_items.GetSize(); j++)
			{
				if(m_doc->m_items[j]->m_type==APL_TREE_ITEM_MESSAGE
					&& mes==((CaplMessageTreeItem*)m_doc->m_items[j])->m_message
					&& folder==((CaplMessageTreeItem*)m_doc->m_items[j])->m_folder)
				{
					CaplFolderTreeItem* fldOld= ((CaplMessageTreeItem*)m_doc->m_items[j])->m_folderItem;
					if(fldOld)
						fldOld->m_contents.Remove(fldOld->m_contents.Find(mes));

					m_doc->m_items.Remove(j);
					
					if(fldOld)fldOld->ShowContents();
					break;
				}
			}

			// ...    
//			((CaplMessageTreeItem*)item)->m_iShowPropertyEvent= APL_MESSAGE_DELETE_EVENT;
//			((CaplMessageTreeItem*)item)->RefreshAllMessages(m_doc);				
		}
		ShowContents();
		MyExpand();
		return true;
	}
	// Change
	else if(item->m_type==APL_TREE_ITEM_CHANGE)
	{
		CaplChangeTreeItem* changeItem= (CaplChangeTreeItem*)item;
		CaplInstance* chng= changeItem->m_chng;

		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
//		VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
		CaplMenu::Install(m_tree); //		VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));
		pPopup = menu.GetSubMenu(INDEX_PASTE_CHANGE_MENU);
		
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}
		
		if(changeItem->m_folder==NULL)
			pPopup->EnableMenuItem(ID_CHANGE_REMOVE, MF_BYCOMMAND | MF_GRAYED);

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD, pnt.x, pnt.y, m_tree);
		
		switch (res)
		{
			case ID_CHANGE_REMOVE:
				{
					m_doc->m_api.m_folder_mgr.RemoveFromFolder(changeItem->m_folder, changeItem->m_chng);
					m_doc->m_items.Remove(m_doc->m_items.Find(item));
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, chng);
					ShowContents();
					MyExpand();
					break;
				}
			case ID_CHANGE_COPY:
				{
					m_doc->m_api.m_folder_mgr.AddToFolder(m_inst, chng);
					ShowContents();
					MyExpand();				
					break;
				}
			case ID_UNDO_MENU:
				
				break;
		}
	}
	// Folder
	else if(item->m_type==APL_TREE_ITEM_FOLDER)
	{
		CaplInstance *inst=((CaplFolderTreeItem*)item)->m_inst;
		if(inst==0) return false;
		if(inst==m_inst)return false;
		if(m_folder!=0)  return false;
		//  
		CaplInstance *inst0=m_inst,*inst1;
		bool found=false;
		
		while (1)
		{
			if(inst0==0) break;
			m_doc_data.GetAttr(inst0,m_doc->m_api.m_folder_mgr.a_folder_parent,inst1);
			if(inst1==inst){found=true; break;}
			inst0=inst1;
		}
		if(found) return false;
		//

		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 		VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
		CaplMenu::Install(m_tree); // 		VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));
		pPopup = menu.GetSubMenu(INDEX_PASTE_FOLDER_MENU);
		if(pPopup==0) return false;
		if(m_inst==0)  pPopup->EnableMenuItem(ID_FOLDER_INS_SHORCUT, MF_BYCOMMAND | MF_GRAYED);
		if(((CaplFolderTreeItem*)item)->m_folder!=0) pPopup->EnableMenuItem(ID_FOLDER_MOVE, MF_BYCOMMAND | MF_GRAYED);

		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		switch (res)
		{
		case ID_FOLDER_MOVE:
			if(m_doc->m_api.m_folder_mgr.MoveFolder(inst,m_inst))
			{
				m_doc->m_items.Remove(m_doc->m_items.Find(item));
				CaplFolderTreeItem *fi=new CaplFolderTreeItem(m_tree,m_doc,this,inst);
				fi->CreateTreeItem(m_item);
				m_sub_folders.Add(inst);
				ShowContents();
				MyExpand();
				return true;
			}
			break;
		case ID_FOLDER_INS_SHORCUT:
			if(m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst))
			{
				CaplInstance *inst=((CaplFolderTreeItem*)item)->m_inst;
				if(inst==0) return false;
				if(m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst))
				ShowContents();
				MyExpand();
				return true;
			}
			break;
		}
	}
	// Find
	else if(item->m_type==APL_TREE_ITEM_QUERY || item->m_type==APL_TREE_ITEM_QUERY_NIIAO ||
				item->m_type==APL_TREE_ITEM_FIND||item->m_type==APL_TREE_ITEM_COMBINED_TABLE)
	{
		CaplInstance *inst=0;
		aplExtent* contents=0;
		((CaplQueryTreeItem*)item)->LoadQueryResult();
		contents=&(((CaplQueryTreeItem*)item)->m_exec_result);
		inst=(((CaplQueryTreeItem*)item)->m_inst);
	
		HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);

		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
		CaplMenu::Install(m_tree); 
		pPopup = menu.GetSubMenu(INDEX_PASTE_QUERY_MENU);
		if(pPopup==0) return false;
		if(inst==0){
			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_QUERY_MOVE_QUERY, MF_BYCOMMAND | MF_GRAYED);
		}else if(inst->GetTemporary()){
			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
			pPopup->EnableMenuItem(ID_QUERY_MOVE_QUERY, MF_BYCOMMAND | MF_GRAYED);
		}
		if(item->m_type!=APL_TREE_ITEM_QUERY)
		{
			pPopup->EnableMenuItem(ID_QUERY_MOVE_QUERY, MF_BYCOMMAND | MF_GRAYED);
		}
		
		if(contents->GetSize()==0)
			pPopup->EnableMenuItem(ID_QUERY_COPY_CONTENT, MF_BYCOMMAND | MF_GRAYED);
		
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}
		
		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);
		
		bool old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
		m_doc->m_api.m_folder_mgr.m_AutoSave=false;
		switch (res)
		{
		case ID_QUERY_COPY_QUERY:
			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
			break;
		case ID_QUERY_COPY_CONTENT:
			for(int i=0;i<contents->GetSize();i++){
				inst=contents->GetAt(i);
				if(inst==0) continue;
				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
			}
			break;
		case ID_QUERY_MOVE_QUERY:
			//    ;         -    
			CaplQueryTreeItem::MoveQuery(m_doc, (CaplQueryTreeItem*)item, parent_item, this);
			break;
		}

		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
		if(old_flag) m_doc_data.NET_SaveChanges();
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==_T("Combined_table"))
	{
		CaplInstance *inst=0;
		aplExtent* contents=0;
		((CaplQueryTreeItem*)item)->LoadQueryResult();
		contents=&(((CaplQueryTreeItem*)item)->m_exec_result);
		contents->Clear();
		inst=(((CaplQueryTreeItem*)item)->m_inst);
		CMenu menu;  gSetPsmResourceHandle();
		CMenu *pPopup;
		VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
		CaplMenu::Install(m_tree); 
		pPopup = menu.GetSubMenu(INDEX_PASTE_QUERY_MENU);
		if(pPopup==0) return false;
		if(inst==0){
			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
		}else if(inst->GetTemporary()){
			pPopup->EnableMenuItem(ID_QUERY_COPY_QUERY, MF_BYCOMMAND | MF_GRAYED);
		}
		pPopup->ModifyMenu(ID_QUERY_COPY_QUERY,MF_BYCOMMAND,ID_QUERY_COPY_QUERY, APL_T("  "));
		if(contents->GetSize()==0)
			pPopup->EnableMenuItem(ID_QUERY_COPY_CONTENT, MF_BYCOMMAND | MF_GRAYED);
		
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}
		
		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);
		
		bool old_flag=m_doc->m_api.m_folder_mgr.m_AutoSave;
		m_doc->m_api.m_folder_mgr.m_AutoSave=false;
		switch (res)
		{
		case ID_QUERY_COPY_QUERY:
			m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
			break;
		case ID_QUERY_COPY_CONTENT:
			for(int i=0;i<contents->GetSize();i++){
				inst=contents->GetAt(i);
				if(inst==0) continue;
				m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
			}
			break;
		}
		m_doc->m_api.m_folder_mgr.m_AutoSave=old_flag;
		if(old_flag) m_doc_data.NET_SaveChanges();
		ShowContents();
		MyExpand();
		return true;
	}
	else if(item->m_type==_T("DocHardCopy"))
	{
		CaplInstance *inst=((CaplDocCopyTreeItem*)item)->m_inst;
		if(inst==0) return false;
		m_doc->m_api.m_folder_mgr.AddToFolder(m_inst,inst);
		ShowContents();
		MyExpand();
		return true;
	}

	return false;
}

//*******************************************************************************


bool CaplFolderTreeItem::ShowContentsP()
{
	if(m_doc==0) return false;
	if(m_tree==0) return false;

	CaplInstance* inst= NULL/*, *mes, *sender, *recip, *folder*/;
	CaplInstance* person= m_doc_data.GetCurrUser();

	int i;
	m_tree->SetRedraw(FALSE);
	if(m_fictive_item!=0)
	{
		m_tree->DeleteItem(m_fictive_item);
		m_fictive_item=0;
	}
	

	m_expanded=true;

	aplExtent ext;
	CString sUserId, sUserName, sPersonId, error;

	//  
	
	CaplInstance *user=m_doc_data.GetCurrUser();
	if(0==user) return false;

	m_doc->m_api.m_data.GetAttrBN(user,S::name, sUserName);
	sUserId.Format(_T("%i"),user->GetId());

	CaplInstance *pers=m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	sPersonId.Format(_T("%i"),pers->GetId());
	
	CString query;
	query = _T("SELECT\nExt_doc OR Ext_bp  OR Ext_proj\nFROM\n");

	if(0==pers)  query +=_T("Ext_doc{apl_document(.locker->apl_document_revision.user LIKE \"%sUserName\")}\n");
	else         query +=_T("Ext_doc{apl_document(.locker->apl_document_revision.author = #%sPersonId)}\n");
	query +=_T("Ext_bp{apl_business_process.locker->apl_business_process_version.author=#%sUserId}\n");
	query +=_T("Ext_proj{apl_project.locker_adm_version->apl_project_administrativ_version.author = #%sUserId}\n");
	query +=_T("END_SELECT");

	query.Replace(_T("%sUserName"), sUserName);
	query.Replace(_T("%sUserId"), sUserId);
	query.Replace(_T("%sPersonId"), sPersonId);

	m_doc->m_api.m_data.NET_QueryEditParse(query, false, &error);
	m_doc->m_api.m_data.NET_QueryExecute(ext, APL_T(", ..."));
	m_doc->m_api.m_doc_mgr.LoadExtentInfo(ext);
	for(i=0;i<ext.Size;i++)
	{
		aplExtent tmp;
		InsertInstInTree(ext[i],m_item,m_doc,m_tree,tmp);
	}

	if(ext.Size<1) 
		m_fictive_item=m_tree->InsertItem( APL_T("<   >"),0,0,m_item);

	m_tree->SetRedraw(TRUE);
	return true;
}

bool CaplFolderTreeItem::RefreshAllDocs()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	int i;
	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]->m_type==APL_TREE_ITEM_DOCUMENT) m_doc->m_items[i]->RefreshItem();
	}
	return true;
}
