// aplRecAlertTreeItem.cpp: implementation of the CaplRecAlertTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplRecAlertTreeItem.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplProjectTreeItem.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplAlertTreeItem::CaplAlertTreeItem(CTreeCtrl *tree, CPSMDoc* pDoc, CaplInstance* inst)
{
	m_doc = pDoc;
	m_tree = tree;
	m_type = _T("Alert");
	m_inst=inst;
	if(m_doc)
		m_doc->m_items.Add(this);
	m_expanded = false;
	RefreshItem();
}

CaplAlertTreeItem::~CaplAlertTreeItem()
{
	RemoveFromParenContents(m_inst);
}

bool CaplAlertTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
    if(m_tree==0) return false;
    if(m_doc==0) return false;
	CString name;
	GetName(name);
	InsetItem(name,ICON_ALERT,parent_item);
	SetItemImage(ICON_ALERT, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),ICON_ALERT,ICON_ALERT,m_item);
	m_expanded=false;
	RefreshItem();
	return true;
}

bool CaplAlertTreeItem::GetName(CString &name)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	if(m_inst)
		m_doc->m_api.GetItemName(m_inst, name);
	else
	{
		if(m_type==_T("distributed"))
			name =  APL_T("");
		else
			name =  APL_T("");
	}

	return true;
}

void CaplAlertTreeItem::GetAccessedinstances(aplExtent& ext)
{
	ext.Clear();
	if(m_inst!=0){if(m_inst->GetType()!=0)ext.Add(m_inst);}
}

bool CaplAlertTreeItem::Expand(UINT action)
{
	if(action == 2)
	{
		if(m_expanded) return false;
		m_tree->SetRedraw(FALSE);
		if(m_fictive_item)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item = 0;
		}
		if(!m_doc->m_api.m_data.IsConnected())
		{
			m_tree->SetRedraw();
			return false;
		}
		if(m_inst==0)
		{
			CaplInstance* cur_person = m_doc->m_api.m_appr_mgr.GetCurrentPerson();
			if(cur_person)
			{
				aplExtent ext;
				if(m_type==_T("distributed"))
				{
					m_doc->m_api.m_message_mgr.LoadPersonAlerts(cur_person,true,false,ext);
				}
				else
				{
					m_doc->m_api.m_message_mgr.LoadPersonAlerts(cur_person,false,true,ext);
				}
				int i=0;
				for(i=0; i<ext.Size;i++)
				{
					CaplAlertTreeItem *new_item=0;
					InsertInstInTree(ext[i],m_item,m_doc,m_tree,m_sub_alerts,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0)
					{
						new_item->m_type = m_type;
						new_item->RefreshItem();
					}
				}
			}
		}
		else
		{
			if(m_inst->GetType() && m_inst->GetAccessmode()<aplNO)
			{
				CaplInstance *item=0;
				m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_item,item);
				if(item)
				{
					CaplTreeItem *new_item=0;
					if(m_doc->m_api.m_data.IsKindOf(item,m_doc->m_api.m_project_mgr->e_project))
					{
						m_doc->m_api.m_project_mgr->LoadProjectInfo(item);
						CaplProjectTreeItem *prj_item=0;
						InsertInstInTree(item,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&prj_item));
						if(prj_item!=0) prj_item->m_alert=m_inst;
					}
					else
					{
						m_doc->m_api.LoadItemInfo(item);
						InsertInstInTree(item,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					}
				}
			}
		}
		Sort();
		m_tree->SetRedraw(TRUE);
		m_expanded = true;
	}
	else if(action == 1)
	{
		m_all_items.Clear();
		m_sub_alerts.Clear();
		CollapseItem();
	}
	return true;
}

bool CaplAlertTreeItem::ShowInListCtrl(CListCtrl* list)
{
	list->DeleteAllItems();
	CHECK_SHOW_LIST_CTRL(m_inst);

	CString buf;
	CaplInstance* author, *person;

	int count=0;

	list->InsertItem(count, APL_T(":"));
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_text,buf);
	list->SetItemText(count,1,buf);
	count++;

	list->InsertItem(count,_T(""));
	count++;

	list->InsertItem(count, APL_T(":"));
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_author,author);
	//m_doc->m_api.m_appr_mgr.GetPersonName(author, buf);
	m_doc->m_api.GetItemName(author, buf);
	list->SetItemText(count,1,buf);
	count++;

	list->InsertItem(count, APL_T(":"));
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_person,person);
	//m_doc->m_api.m_appr_mgr.GetPersonName(person, buf);
	m_doc->m_api.GetItemName(person, buf);
	list->SetItemText(count,1,buf);
	count++;

	list->InsertItem(count,_T(""));
	count++;

	list->InsertItem(count, APL_T(" :"));
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_date,buf);
	if(buf!=_T(""))
	{
		COleDateTime dt;
		aplString2Date(buf,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			buf=dt.Format(_T("%d.%m.%Y %H.%M"));
		}
	}
	list->SetItemText(count,1,buf);
	count++;

	list->InsertItem(count, APL_T(""));
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_state,buf);
	list->SetItemText(count,1,buf);
	count++;

	return true;
}

//****************************************************************
bool CaplAlertTreeItem::RefreshItem()
{

	int ico = ICON_ALERT;
	if(m_inst)
	{
		if(m_inst->GetAccessmode()>aplRO) return false;
		if(m_type==_T("received")) ico++;
		else ico+=2;
		CString state=_T("");
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_state,state);
		if(state==m_doc->m_api.m_message_mgr.m_alert_state_completed) 
		{
			color=RGB(128,128,128);
			font_style|=APL_FONT_STRIKEOUT;
		}
		else
		{
			color=0;
			font_style&=APL_FONT_DEFAULT;
		}
	}
	else
	{
		if(m_doc->m_RecAlert==this) 
			ico++;
		else if(m_doc->m_DisAlert==this) 
			ico+=2;
		
	}
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	CString buf;
	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);

	return true;
}
//****************************************************************
void CaplAlertTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO) return;
	
	CaplInstance *item=0;
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_item,item);
	if(item) m_doc->m_api.LoadItemInfo(item);
	if(m_doc->m_api.m_message_mgr.ShowAlertProperties(m_inst))
	{
		if(m_inst->GetType()==0) 
		{
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		else
		{
			RefreshItem();
			Expand(1);
			Expand(2);
			MyExpand();
		}
	}
}

void CaplAlertTreeItem::CreateAlert()
{
	if(!m_doc || !m_doc->m_api.m_data.IsConnected()) return;
	
	CaplInstance *cur_person = m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	if(!cur_person)
	{
		AfxMessageBox( APL_T("     !"));
		return;
	}
	CaplInstance *default_recipient=0;
	if(m_type==_T("received")) default_recipient=cur_person;
	CaplInstance *new_alert=m_doc->m_api.m_message_mgr.CreateAlert(default_recipient);
	if(new_alert)
	{
		CaplInstance *author=0,*recipient=0;
		m_doc->m_api.m_data.GetAttr(new_alert,m_doc->m_api.m_message_mgr.a_alert_author,author);
		m_doc->m_api.m_data.GetAttr(new_alert,m_doc->m_api.m_message_mgr.a_alert_person,recipient);
		if(m_doc->m_api.m_data.IsKindOf(recipient,m_doc->m_api.m_appr_mgr.e_official))
			m_doc->m_api.m_data.GetAttr(recipient, m_doc->m_api.m_appr_mgr.a_official_act_person, recipient);
		if(cur_person==recipient) 
		{
			if(m_type==_T("received")) 
			{
				CaplAlertTreeItem *new_item=0;
				InsertInstInTree(new_alert,m_item,m_doc,m_tree,m_sub_alerts,0,(CaplTreeItem **)(&new_item));
				if(new_item!=0)
				{
					new_item->m_type = m_type;
					new_item->RefreshItem();
				}
			}
			else
			{
				if(m_doc->m_RecAlert) 
				{
					m_doc->m_RecAlert->Expand(1);
					m_doc->m_RecAlert->Expand(2);
				}
			}
		}
		if(cur_person==author) 
		{
			if(m_type==_T("distributed")) 
			{
				CaplAlertTreeItem *new_item=0;
				InsertInstInTree(new_alert,m_item,m_doc,m_tree,m_sub_alerts,0,(CaplTreeItem **)(&new_item));
				if(new_item!=0)
				{
					new_item->m_type = m_type;
					new_item->RefreshItem();
				}
			}
			else
			{
				if(m_doc->m_DisAlert) 
				{
					m_doc->m_DisAlert->Expand(1);
					m_doc->m_DisAlert->Expand(2);
				}
			}
		}
		MyExpand(false);


	}
}

//****************************************************************
bool CaplAlertTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_doc==0 || !m_doc->m_api.m_data.IsConnected()) return false;
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU1));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_ALERT_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	CaplInstance *cur_person = m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	bool m_bIsAdmin=m_doc->m_api.m_appr_mgr.IsAdmin();
	CaplInstance *author=0,*recipient=0;
	CString state=_T("");
	if(m_inst) 	
	{
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_state,state);
		if(state==_T("")) state=m_doc->m_api.m_message_mgr.m_alert_state_active;
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_author,author);
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_person,recipient);
		if(state==m_doc->m_api.m_message_mgr.m_alert_state_active) 
			pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		else 
			pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		if(!m_bIsAdmin)
		{
			if(author!=cur_person)
			{
				pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
				//if(state==m_doc->m_api.m_message_mgr.m_alert_state_completed) pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
			}
		}
		pPopup->EnableMenuItem(ID_CREATE_ALERT, MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);

		if(!m_doc->m_api.m_data.IsConnected()) 
			pPopup->EnableMenuItem(ID_CREATE_ALERT, MF_BYCOMMAND | MF_GRAYED);
	}
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);

	switch(res)
	{
		case ID_CREATE_ALERT:
			{
				CreateAlert();
			}
			break;
		case ID_SHOW_PROPERTIES:
			{
				ShowProperties();
			}
			break;
		case ID_DELETE:
			{
				if(AfxMessageBox( APL_T("     ?"),MB_YESNO)==IDYES)
				{
					if(m_doc->m_api.m_message_mgr.DeleteAlert(m_inst))
					{
						m_doc->m_items.Remove(m_doc->m_items.Find(this));
					}
				}
			}
			break;
		case ID_MARK_COMPLETED:
			{
				if(m_doc->m_api.m_message_mgr.SetAlertState(m_inst,m_doc->m_api.m_message_mgr.m_alert_state_completed))
				{
					if(m_inst->GetType()==0) 
					{
						m_doc->m_items.Remove(m_doc->m_items.Find(this));
					}
					else RefreshItem();
				}
			}
			break;
		case ID_MARK_ACTIVE:
			{
				if(m_doc->m_api.m_message_mgr.SetAlertState(m_inst,m_doc->m_api.m_message_mgr.m_alert_state_active))
				{
					RefreshItem();
				}
			}
			break;
		default: PrepareContextMenu(res); 
	}	
	
	return true;
}

//****************************************************************
bool CaplAlertTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_inst==0) return false;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return false;}

	CaplInstance *item_inst=GetItemInstance(item);
	if(item_inst)
	{
		if(m_doc->m_api.m_message_mgr.AddItemToAlert(m_inst,item_inst))
		{
			Expand(1);
			Expand(2);
			MyExpand();
			return true;
		}
	}
	return false;
}