#ifndef _APL_PROCESS_TREE_ITEM_H_
#define _APL_PROCESS_TREE_ITEM_H_

#include "aplTreeItem.h" 

class CaplProcessTreeItem: public CaplTreeItem
{
public:
	//       
	//  
	class CStPointsMenuInfo
	{
	public:
		long m_iID;
		CString m_sName;
		CaplInstance* m_point;
		
 
		CStPointsMenuInfo(DWORD id= 0, CString name= _T(""), CaplInstance* point= NULL)
		{
			m_iID= id;
			m_sName= name;
			m_point= point;
		}
	};
public:
	CaplProcessTreeItem(CTreeCtrl *tree= 0, CPSMDoc *doc= 0, CaplInstance* inst= 0);
    bool GetName(CString &name);
    bool RefreshItem();
    bool CreateTreeItem(HTREEITEM parent_item);
	bool Expand(UINT action);
	void ShowProperties();
	bool ShowInListCtrl(CListCtrl *list);
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	void GetAccessedInstances(aplExtent &ext);
	void SortTask();
	void ShowWorkObjects();
	void SuspendWfProcess();
	void GetProcessTasks();
	void RunWfProcess(CaplInstance* first_activity= NULL);
	void ShowUserProcesses();
	bool PasteItem(CaplTreeItem* item, CPoint* point= NULL);
	bool CreateProduct();
	bool CreateDocument();
	bool CreateRefusal();

	bool ShowParentProcess();
	bool ShowParentTasks();

	static int CALLBACK CompareTaskTreeItem(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);

	virtual void Sort(bool bRefreshParent=false);
	
public:	
	CaplInstance* m_process;
	CaplInstance* m_folder;
	CaplInstance* m_project;
	CaplInstance* m_task;
	aplExtent m_task_items;
	aplExtent m_work_obj_items;
	bool m_bIsParent; //   
};

#endif //_APL_PROCESS_TREE_ITEM_H_