#include "stdafx.h"
#include "dictionary.h"

#include "PSMDoc.h"

/*#include "aplTopLevelItem.h"
#include "aplFolderTreeItem.h"
#include "aplMessageTreeItem.h"*/
#include "aplMessageFolderTreeItem.h"
#include "aplTreeWfFolderItem.h"
#include "aplTreeProcessTmplItem.h"
#include "aplTreeProcessItem.h"
#include "aplTreeTaskItem.h"
#include "TabView.h"

#include "resource.h"

//CaplWfFolderTreeItem
CaplWfFolderTreeItem::CaplWfFolderTreeItem(CTreeCtrl *tree, CPSMDoc *doc)
{
	m_type= _T("WfFolder");
	m_doc= doc;
	m_tree= tree;
	if(doc!=0) 
		doc->m_items.Add(this);	
}

bool CaplWfFolderTreeItem::GetName(CString &name)
{
	name= m_name;
	return true;
}

bool CaplWfFolderTreeItem::RefreshItem()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
	UINT ico= 0;
	
	if(m_tree!=0)
	{
		CString name, buf, buf1;
		GetName(name);
		
		if(m_name== APL_T("")) ico= ICON_TASK-1;
		else if(m_name== APL_T("")) ico= ICON_PROCESS-1;
		else if(m_name== APL_T("")) ico= ICON_PROCESS_TMPL-1;	

		SetItemImage(ico, IDX_IL_TREE_ITEM);
		m_tree->SetItemText(m_item, name);	
	}
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}

bool CaplWfFolderTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	  
	UINT ico= 0;
	if(m_name== APL_T("")) ico= ICON_TASK-1;
	else if(m_name== APL_T("")) ico= ICON_PROCESS-1;
	else if(m_name== APL_T("")) ico= ICON_PROCESS_TMPL-1;	

	InsetItem(m_name,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"), 0, 0, m_item);

	m_expanded=false;

	return true;
}

bool CaplWfFolderTreeItem::Expand(UINT action)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
	if(action==2)
	{
		if(m_expanded) return true;
		if(m_hasSubItem) Expand(1);
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		ShowWfFolderContent();
		m_hasSubItem= true;
		m_expanded= true;
		m_tree->SetRedraw(TRUE);
		Sort();
	}
	else if(action==1)
	{
		CollapseItem();
		m_items.Clear();
	}
	return true;
}

void CaplWfFolderTreeItem::ShowProperties()
{
	
}

bool CaplWfFolderTreeItem::ShowInListCtrl(CListCtrl *list)
{
	return true;
}

void CaplWfFolderTreeItem::ShowCmd(long cmd)
{
	
}

BOOL CaplWfFolderTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
/*	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
	case ID_SHOW_ALL_LOT:
	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
	case ID_SHOW_ALL_VERSION:
	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}*/
	return FALSE;
}

bool CaplWfFolderTreeItem::TrackPopupMenu(CWnd* wnd, CPoint &point, UINT view_mode)
{
	if(m_doc==0 || !m_doc->m_api.m_data.IsConnected()) return false;

	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_WF_FOLDER_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;
	
	if(m_name!= APL_T(""))
		pPopup->RemoveMenu(ID_WF_ARHIVE, MF_BYCOMMAND);

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);
	
	BOOL res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
						point.x, point.y, wnd);
	switch (res)
	{
		case ID_WF_FOLDER_SHOW_CONTENT:
			{
				m_tree->SetRedraw(FALSE);
				ShowWfFolderContent();
				if(!IsExpandet())
				{
					m_hasSubItem= true;
					m_expanded= true;
				}
				MyExpand();
				m_tree->SetRedraw();
				break;
			}
		case ID_WF_FOLDER_SHOW_WORK_SCREEN:
			{
				m_doc->m_wf_mgr.AnalyzeWorkTimes();
				break;
			}
		case ID_WF_ARHIVE:
			{
				CaplInstance *user= m_doc->m_api.m_appr_mgr.GetCurrentPerson();
				COleDateTime odt;
				CString sDate;
				CString buf;
				int i;

				aplExtent ext;
				if(user)
				{
					m_doc->m_wf_mgr.GetUserProcessList(user, ext);
					m_doc->m_api.m_data.NET_GetServerDateTime(odt);
					aplDate2String(odt, sDate);

					for(i= 0; i<ext.GetSize(); i++)
					{
						m_doc->m_api.m_data.GetAttr(ext[i], m_doc->m_wf_mgr.a_proc_state, buf);
						if(buf==_T("terminated") || buf==_T("completed"))
						{
							m_doc->m_api.m_data.GetAttr(ext[i], m_doc->m_wf_mgr.a_proc_archive_date, buf);
							if(buf.IsEmpty())
								m_doc->m_api.m_data.PutAttr(ext[i], m_doc->m_wf_mgr.a_proc_archive_date, sDate);
						}
					}

					m_doc->m_api.SaveChanges();
				}
				break;
			}
		case ID_UNDO_MENU:
			break;
		default: PrepareContextMenu(res); 
			break;
	}
	return true;
}

void CaplWfFolderTreeItem::ShowWfFolderContent()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	
	if(!m_doc->m_api.m_data.IsConnected()) return;

	if(m_name== APL_T("")) ShowTasks();
	else if(m_name== APL_T("")) ShowProcesses();
	else if(m_name== APL_T("")) ShowProcessTemplates();	
}

void CaplWfFolderTreeItem::ShowProcessTemplates()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	
	CaplInstance *user= m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	if(!user) return;

	aplExtent ext;
	m_doc->m_wf_mgr.GetUserProcessTempList(user, ext);
	
//	bool bIsNew= false;
	
	m_tree->SetRedraw(FALSE);	
	for(int i= 0; i<ext.GetSize(); i++)
	{
		if(-1==m_items.Find(ext[i]))
		{
//			bIsNew= true;

			CaplProcessTmplTreeItem* item= new CaplProcessTmplTreeItem(
				m_tree, m_doc, ext[i]);
			item->CreateTreeItem(m_item);
			m_items.Add(ext[i]);
		}
	}
	Sort();
	m_tree->SetRedraw(TRUE);	
	
/*	if(!bIsNew)
		MessageBox(NULL, APL_T("   ."), APL_T(" "), 
		MB_OK|MB_ICONINFORMATION);*/
}

void CaplWfFolderTreeItem::ShowTasks()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	
	CaplInstance *user= m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	if(!user) return;

	aplExtent ext;	
	if(m_doc->m_wf_mgr.GetUserTaskList(user, ext))
	{
		CString msg=APL_T("  .\n\n     \" -> \".");
		AfxMessageBox(msg,MB_ICONINFORMATION | MB_OK);
	}
	
	CString buf;
	bool bInsert;

	m_tree->SetRedraw(FALSE);	
	for(int i= 0; i<ext.GetSize(); i++)
	{
		if(-1==m_items.Find(ext[i]))
		{
			buf= _T("");
			bInsert= true;
			m_doc_data.GetAttr(ext[i], m_doc->m_wf_mgr.a_task_state, buf);
			if(buf==_T("suspend") && !m_doc->m_api.m_show.m_task_suspend) bInsert= false;
			if(buf==_T("complete") && !m_doc->m_api.m_show.m_task_complete) bInsert= false;
			if(buf==_T("cancel") && !m_doc->m_api.m_show.m_task_cancel) bInsert= false;
			if(bInsert)
			{
				CaplTaskTreeItem* item= new CaplTaskTreeItem(
					m_tree, m_doc, ext[i], APL_WF_SHOW_WO);
				item->CreateTreeItem(m_item);
				m_items.Add(ext[i]);
			}
		}
	}
	Sort();
	m_tree->SetRedraw(TRUE);	
}


void CaplWfFolderTreeItem::ShowProcesses()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID

	CaplInstance *user= m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	if(!user) return;

	aplExtent ext;
	m_doc->m_wf_mgr.GetUserProcessList(user, ext);

	m_tree->SetRedraw(FALSE);	
	for(int i= 0; i<ext.GetSize(); i++)
	{
		if(-1==m_items.Find(ext[i]))
		{
			CaplProcessTreeItem* item= new CaplProcessTreeItem(
				m_tree, m_doc, ext[i]);
			item->CreateTreeItem(m_item);
			m_items.Add(ext[i]);
		}
	}
	Sort();
	m_tree->SetRedraw(TRUE);
}
