// apl_lot_item.h

#include "aplTreeItem.h"

class CaplLotTreeItem: public CaplTreeItem
{
        //Attributes
public:
	CaplInstance *m_lot;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;

	CaplInstance *m_prd_inst_rel;
	CaplInstance *m_parent_lot;
	CaplInstance *m_parent_prd_inst;

	aplExtent m_all_prd_inst;
	aplExtent m_all_lots;

	CaplLotTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *lot=0);
	~CaplLotTreeItem(){RemoveFromParenContents(m_lot);}

    bool CreateTreeItem(HTREEITEM parent_item); 
	bool GetName(CString &name);
    bool RefreshItem();
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);

	void ShowProperties();
	void ShowPrdInstances();
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);

 	void GetAccessedInstances(aplExtent &ext);
	bool ShowInListCtrl(CListCtrl *list);
	bool Expand(UINT action);
	bool PasteItem(CaplTreeItem *item, CPoint *point);
	bool PasteFile(LPCTSTR file, CPoint *point);

	//void CreateCharacteristic(CaplInstance *val=0);
	//void CreateCharacteristicGroup(CaplInstance *group=0);
};

