// aplPacketMgr.h: interface for the CaplPacketMgr class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLPACKETMGR_H__DB028248_060E_493C_9408_70D497AB76ED__INCLUDED_)
#define AFX_APLPACKETMGR_H__DB028248_060E_493C_9408_70D497AB76ED__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <apl_api.h>
#include <aplPacket.h>

#define APL_PACKET_UPDATE_STATE_PATH		APL_T(" \\  ")
#define APL_AUTOCREATE_PROVIDER				APL_T(" \\   ")

#ifdef APL_PACKETMGR_IMPEXP_DLL
	#define APL_PACKETMGR_IMPEXP __declspec(dllexport)
#else
	#define APL_PACKETMGR_IMPEXP __declspec(dllimport)

#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"PacketMgr_ud.lib")
#else
#pragma comment (lib,"PacketMgrD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"PacketMgr_u.lib")
#else
#pragma comment (lib,"PacketMgr.lib")
#endif
#endif
#endif

class APL_PACKETMGR_IMPEXP CaplPacketMgr : public CaplStepManager  
{
protected:
	CaplInstance* LoadData(CaplInstance *Item, CDataSet *pDataSet, CaplPacket *pPacket, CaplInstance *iPacket);
	bool SaveData(CaplInstance *Item, CDataSet *pDataSet, CaplPacket *pPacket);
public:
	CaplPacketMgr();
	virtual ~CaplPacketMgr();

	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	bool	ShowPacketProperties(CaplInstance* packet);
	CaplInstance*	ShowCreatePacketDlg(CaplPacket *pPacket, LPCTSTR nState = NULL, bool bOut=true);

	/**    
	@param lpFileName  - 
	@param bOut - (from DIV -    )
	@param err_mess -     ,         
			 .     -      
	@param ignore_errors -  <b>false</b>        -       
			 <b>true</b>     
	@return         0    */
	CaplInstance* CreateFromFile(LPCTSTR lpFileName, bool bOut,CString *err_mess=0,bool ignore_errors=false);

	CaplInstance* CreateDataSetSign(CaplInstance* pDataSet, CDataSetSign* pDSSign);
	bool Delete(CaplInstance* inst);
	bool SaveToFile(CaplInstance *iPacket, LPCTSTR lpFileName);
	bool ExportData(CaplInstance *iPacket, LPCTSTR lpPathName);
	bool Check(CaplInstance *iPacket);
	bool Extract(CaplInstance *Packet);
	bool ExtractStpFile(CaplInstance *pDataSet);

	bool LoadItemInfo(CaplInstance *Inst);
	bool LoadExtentInfo(aplExtent &ext);

	//  
	CaplEntity	*e_packet;
	CaplAttr	*a_packet_id;
	CaplAttr	*a_packet_descr;
	CaplAttr	*a_packet_provider;
	CaplAttr	*a_packet_date_send;
	CaplAttr	*a_packet_sender;
	CaplAttr	*a_packet_date_receipt;
	CaplAttr	*a_packet_recipient;
	CaplAttr	*a_packet_date_registr;
	CaplAttr	*a_packet_registrator;
	CaplAttr	*a_packet_date_load;
	CaplAttr	*a_packet_loader;
	CaplAttr	*a_packet_date_confirmation_of_receipt;
	CaplAttr	*a_packet_confirmatory_of_receipt;
	CaplAttr	*a_packet_state;
	CaplAttr	*a_packet_data;
	CaplAttr	*a_packet_type;
	CaplAttr	*a_packet_comment;

	CaplEntity	*e_data_set;
	CaplEntity	*e_folder_data_set;
	CaplEntity	*e_file_data_set;

	CaplAttr	*a_data_set_name;
	CaplAttr	*a_data_set_of_packet;
	CaplAttr	*a_data_set_parametrs;
	CaplAttr	*a_data_set_signs;
	CaplAttr	*a_data_set_parent;
	CaplAttr	*a_folder_data_set_content;
	CaplAttr	*a_file_data_set_data;

	CaplEntity	*e_data_set_parametr;
	CaplAttr	*a_data_set_parametr_name;
	CaplAttr	*a_data_set_parametr_value;
	CaplAttr	*a_data_set_parametr_of_data_set;

	CaplEntity	*e_data_set_sign;
	CaplAttr	*a_data_set_sign_date;
	CaplAttr	*a_data_set_sign_role;
	CaplAttr	*a_data_set_sign_of_data_set;
	CaplAttr	*a_data_set_sign_sertificate;
	CaplAttr	*a_data_set_sign_data;

	CaplEntity	*e_sign_sertificate;
	CaplAttr	*a_sign_sertificate_name;
	CaplAttr	*a_sign_sertificate_of_packet;
	CaplAttr	*a_sign_sertificate_data;

	// 
	CStringArray	m_OutPacketStates;
	CStringArray	m_InPacketStates;
};

#endif // !defined(AFX_APLPACKETMGR_H__DB028248_060E_493C_9408_70D497AB76ED__INCLUDED_)
