// ColumnArray.cpp: implementation of the CReportBound class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReportDict.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CColumnArray::CColumnArray(CaplReportMgr *ReportMgr)
{
	m_ReportMgr = ReportMgr;
	m_Data.RemoveAll();
}

CColumnArray::~CColumnArray()
{
	RemoveAll();
}

void CColumnArray::Update(bool set)
{
	for(int i=0; i<m_Data.GetSize();i++)
		m_Data.GetAt(i)->Update(set);
}

void CColumnArray::GetExtent(aplExtent &ext)
{
	ext.Clear();
	for(int i=0; i<m_Data.GetSize();i++)
		ext.Add(m_Data.GetAt(i)->m_inst);
}

void CColumnArray::RemoveAll()
{
	for(int i=0;i<m_Data.GetSize();i++)
	{
		CColumn* c = m_Data.GetAt(i);
		delete c;
	}
	m_Data.RemoveAll();
}

int CColumnArray::Find(CaplInstance *inst)
{
	{
		for(int i=0;i<m_Data.GetSize();i++)
		{
			CColumn* c = m_Data.GetAt(i);
			if(c->m_inst==inst) return i;
		}
		return -1;
	};
}

int CColumnArray::Find(CString name)
{
	for(int i=0;i<m_Data.GetSize();i++)
	{
		CColumn* c = m_Data.GetAt(i);
		if(c->m_name==name) return i;
	}
	return -1;
}

int CColumnArray::Move(CColumn *col, int ind)
{
	int ind1 = Find(col);
	if(ind1==ind) return 0;
	if(ind1<0) return -1;
	m_Data.RemoveAt(ind1);
	m_Data.InsertAt(ind,col);
	return 0;
}

CColumnArray& CColumnArray::operator=(CColumnArray& ColArr)
{
	RemoveAll();
	int cnt = ColArr.GetSize();
	for(int i=0; i<cnt; i++)
	{
		CColumn* nCol = new CColumn(m_ReportMgr);
		CColumn* Col = ColArr.GetAt(i);
		*nCol = *Col;
		m_Data.Add(nCol);
	}
	return *this;
}

int CColumnArray::GetMemSize(bool bIncludeDSCol)
{
	int size = 0;
	for(int i=0; i<m_Data.GetSize();i++)
		size+=m_Data.GetAt(i)->GetMemSize(bIncludeDSCol);
	return size;
}

void CColumnArray::CopyToMem(BYTE *pByte, int &ind, bool bIncludeDSCol)
{
	for(int i=0; i<m_Data.GetSize();i++)
		m_Data.GetAt(i)->CopyToMem(pByte,ind, bIncludeDSCol);
}

bool CColumnArray::LoadDataFromMem(BYTE *pByte, int &ind)
{
	for(int i=0; i<m_Data.GetSize();i++)
		m_Data.GetAt(i)->LoadDataFromMem(pByte,ind);
	return true;
}
