#include "stdafx.h"
#include "ReportDict.h"

CLegendElement::CLegendElement(CaplReportMgr *ReportMgr)
{
	m_ReportMgr = ReportMgr;

	m_inst = NULL;
	m_font_inst = NULL;

	m_LegendMode = aplLegendMode_1;
	m_LegendPosition = aplLegendPositionNone;
	m_LegendPosition2 = aplLegendPositionCenter;

	memset(&m_LogFont, 0, sizeof(LOGFONT));
	m_LogFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
	m_LogFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	m_LogFont.lfQuality = DEFAULT_QUALITY;
	m_LogFont.lfPitchAndFamily = DEFAULT_PITCH;
	m_LogFont.lfWidth = 0;
	m_LogFont.lfOrientation = 0;
	m_LogFont.lfStrikeOut = 0;
	m_LogFont.lfItalic = 255;
	m_LogFont.lfUnderline = 0;
	m_LogFont.lfEscapement = 0;
	m_LogFont.lfHeight = 80;
	m_LogFont.lfWeight = FW_NORMAL;
	m_LogFont.lfCharSet = RUSSIAN_CHARSET;
	_strcpy(m_LogFont.lfFaceName,_T("Arial"));
	
	m_TextColor = 0;
}

CLegendElement::~CLegendElement()
{
}

void CLegendElement::Update(bool set)
{
	if(m_ReportMgr==NULL) return;
	if(set)//storing
	{
		if(m_inst==NULL)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_legend);
		if(m_font_inst==NULL)
			m_font_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_font);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_legend_mode, m_LegendMode);
		int LegendPosition = m_LegendPosition;
		if(LegendPosition)
			LegendPosition += m_LegendPosition2<<8;
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_legend_position, LegendPosition);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_legend_font, m_font_inst);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_legend_font_color, (int)m_TextColor);
		m_ReportMgr->SetFontValue(m_font_inst, m_LogFont);
	}
	else
	{
		if(m_inst==NULL) return;
		int tmpInt;

		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_legend_mode, m_LegendMode);
		int LegendPosition;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_legend_position, LegendPosition);
		m_LegendPosition = LegendPosition&0x000000ff;
		if(LegendPosition)
			m_LegendPosition2 = (LegendPosition&0x0000ff00)>>8;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_legend_font, m_font_inst);

		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_legend_font_color, tmpInt);
		m_TextColor = (int)tmpInt;
		if(m_font_inst)
			m_ReportMgr->GetFontValue(m_font_inst, m_LogFont);
	}
}

bool CLegendElement::LoadDataFromMem(BYTE *pByte, int &ind)
{
	int* pInt = NULL;
	LOGFONT	*pLF = NULL;
	COLORREF *pCR = NULL;
	
	pInt = (int*)&pByte[ind];
	m_LegendMode = *pInt;
	ind+=sizeof(int);
	pInt = (int*)&pByte[ind];
	int LegendPosition = *pInt;
	m_LegendPosition = LegendPosition&0x000000ff;
	if(LegendPosition)
		m_LegendPosition2 = (LegendPosition&0x0000ff00)>>8;
	ind+=sizeof(int);
	pLF = (LOGFONT*)&pByte[ind];
	m_LogFont = *pLF;
	ind+=sizeof(LOGFONT);
	pCR = (COLORREF*)&pByte[ind];
	m_TextColor = *pCR;
	ind+=sizeof(COLORREF);
	
	return true;
}

void CLegendElement::CopyToMem(BYTE* pByte, int &ind)
{
	int* pInt = NULL;
	LOGFONT	*pLF = NULL;
	COLORREF *pCR = NULL;

	pInt = (int*)&pByte[ind];
	*pInt = m_LegendMode;
	ind+=sizeof(int);
	pInt = (int*)&pByte[ind];
	int LegendPosition = m_LegendPosition;
	if(LegendPosition)
		LegendPosition += m_LegendPosition2<<8;
	*pInt = LegendPosition;
	ind+=sizeof(int);
	pLF = (LOGFONT*)&pByte[ind];
	*pLF = m_LogFont;
	ind+=sizeof(LOGFONT);
	pCR = (COLORREF*)&pByte[ind];
	*pCR = m_TextColor;
	ind+=sizeof(COLORREF);
}

int CLegendElement::GetMemSize()
{
	int size = sizeof(int);//Mode
	size+=sizeof(int);//Position
	size+=sizeof(LOGFONT);//FONT
	size+=sizeof(COLORREF);//COLOR

	return size;
}

void CLegendElement::Delete()
{
	if(m_ReportMgr==NULL) return;
	if(m_ReportMgr->m_data==NULL) return;
	
	if(m_inst==NULL) return;

	m_ReportMgr->m_data->DeleteInstance(m_inst);
	if(m_font_inst)
		m_ReportMgr->m_data->DeleteInstance(m_font_inst);
}

CLegendElement& CLegendElement::operator = (const CLegendElement &Legend)
{
	m_inst = Legend.m_inst;
	m_font_inst = Legend.m_font_inst;

	m_TextColor = Legend.m_TextColor;
	m_LegendMode = Legend.m_LegendMode;
	m_LegendPosition = Legend.m_LegendPosition;
	m_LegendPosition2 = Legend.m_LegendPosition2;
	m_LogFont = Legend.m_LogFont;

	return *this;
}
