// PictureSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReportDict.h"
#include "PictureSetupDlg.h"
#include "PropertyDlg.h"
#include <apl_image.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPictureSetupDlg dialog


CPictureSetupDlg::CPictureSetupDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPictureSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPictureSetupDlg)
	m_path_name = _T("");
	m_pic_id = _T("");
	m_save_proport = FALSE;
	m_height = 0;
	m_width = 0;
	m_fit_to_rect = FALSE;
	//}}AFX_DATA_INIT
}


void CPictureSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPictureSetupDlg)
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Text(pDX, IDC_PATH_NAME, m_path_name);
	DDX_Text(pDX, IDC_PIC_ID, m_pic_id);
	DDX_Check(pDX, IDC_SAVE_PROPORTION, m_save_proport);
	DDX_Text(pDX, IDC_HEIGHT, m_height);
	DDX_Text(pDX, IDC_WIDTH, m_width);
	DDX_Check(pDX, IDC_FIT_TO_RECT, m_fit_to_rect);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPictureSetupDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CPictureSetupDlg)
	ON_BN_CLICKED(IDC_BROWSE_FILE, OnBrowseFile)
	ON_BN_CLICKED(IDC_SAVE, OnSave)
	ON_BN_CLICKED(IDC_FIT_TO_RECT, OnFitToRect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPictureSetupDlg message handlers

bool CPictureSetupDlg::UpdateDlg()
{
	if(!TestUpdate()) return false;
	if(!m_path_name.IsEmpty() && m_path_name.CompareNoCase(APL_T("  "))!=0)
		m_elem->LoadPicture(m_path_name);
	m_elem->m_mode=0;
	if(m_fit_to_rect)
		m_elem->m_mode |= DM_FIT_TO_RECT;
	if(m_save_proport)
		m_elem->m_mode |=DM_FIT_SCALE;

	m_elem->m_pictureId = m_pic_id;
	return true;
}

BOOL CPictureSetupDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_pic_id = m_elem->m_pictureId;
	m_save_proport = m_elem->m_mode&DM_FIT_SCALE;
	m_fit_to_rect = m_elem->m_mode&DM_FIT_TO_RECT;

	if(m_elem->m_image)
	{
		m_width = m_elem->m_image->GetWidth();
		m_height = m_elem->m_image->GetHeight();
		m_path_name = APL_T("  ");		

		m_ImageCtrl.SetImage(m_elem->m_image);
	}

	CWnd* wnd = GetDlgItem(IDC_SAVE_PROPORTION);
	wnd->EnableWindow(m_fit_to_rect);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPictureSetupDlg::OnBrowseFile() 
{
	UpdateData();
	CFileDialog dlg(TRUE,_T("jpg"),NULL, OFN_FILEMUSTEXIST,
		APL_T("  (*.ico;*.bmp;*.png;*.gif;*.tif;*.tiff;*.jpeg;*.jpg)|*.ico;*.bmp;*.png;*.gif;*.tif;*.tiff;*.jpeg;*.jpg|  (*.*)|*.*|"));
	if(dlg.DoModal()!=IDOK) return;
	m_path_name = dlg.GetPathName();
	int type = 0;
	CString ext = dlg.GetFileExt();
	ext.MakeLower();
	if(ext==_T("bmp") || ext==_T("dib")) type=APLIMAGE_FORMAT_BMP;
	else if(ext==_T("gif")) type=APLIMAGE_FORMAT_GIF;
	else if(ext==_T("tif") || ext==_T("tiff")) type=APLIMAGE_FORMAT_TIF;
	else if(ext==_T("png")) type=APLIMAGE_FORMAT_PNG;
	else if(ext==_T("ico")) type=APLIMAGE_FORMAT_ICO;
	else if(ext==_T("jpg") || ext==_T("jpeg")) type=APLIMAGE_FORMAT_JPG;
	else
	{
		AfxMessageBox(APL_T("  ."));
		return;
	}
	CaplImage img(m_path_name, type);
	m_width = img.GetWidth();
	m_height = img.GetHeight();
	
	m_ImageCtrl.SetImage(&img);
	UpdateData(FALSE);
}

void CPictureSetupDlg::OnSave() 
{
	CFileDialog dlg(FALSE,_T("jpg"),NULL,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
		APL_T(" JPEG(*.jpg)|*.jpg| TIFF(*.tif)|*.tif| BMP(*.bmp)|*.bmp| PNG(*.png)|*.png|  (*.*)|*.*|"));
	if(dlg.DoModal()!=IDOK) return;
	int type = 0;
	CString ext = dlg.GetFileExt();
	ext.MakeLower();
	if(ext==_T("bmp") || ext==_T("dib")) type=APLIMAGE_FORMAT_BMP;
	else if(ext==_T("tif") || ext==_T("tiff")) type=APLIMAGE_FORMAT_TIF;
	else if(ext==_T("png")) type=APLIMAGE_FORMAT_PNG;
	else if(ext==_T("ico")) type=APLIMAGE_FORMAT_ICO;
	else if(ext==_T("jpg") || ext==_T("jpeg")) type=APLIMAGE_FORMAT_JPG;
	else
	{
		AfxMessageBox(APL_T("  ."));
		return;
	}
	m_elem->m_image->Save(dlg.GetPathName(),type);
}

void CPictureSetupDlg::OnFitToRect() 
{
	UpdateData();
	CWnd* wnd = GetDlgItem(IDC_SAVE_PROPORTION);
	wnd->EnableWindow(m_fit_to_rect);
}

void CPictureSetupDlg::OnOK() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CPictureSetupDlg::OnCancel() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}

bool CPictureSetupDlg::TestUpdate()
{
	if(!UpdateData()) return false;

	return true;
}
