
#include "stdafx.h"
#include "ReportDict.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CSortColumn::CSortColumn(CaplReportMgr* mgr)
{
	ASSERT(mgr);
	m_report_mgr = mgr;
	m_inst = NULL;
}

CSortColumn::~CSortColumn()
{
}

void CSortColumn::Delete()
{
	if(m_inst)
		m_report_mgr->m_data->DeleteInstance(m_inst);
	m_inst = NULL;
}

void CSortColumn::Update(bool bSet/* =true */)
{
	if(bSet)
	{
		if(m_column==NULL) return;

		if(m_inst==NULL)
			m_inst = m_report_mgr->m_data->CreateInstance(m_report_mgr->e_apl_sort_column);
		m_report_mgr->m_data->PutAttr(m_inst, m_report_mgr->a_apl_sc_column, m_column->m_inst);
		m_report_mgr->m_data->PutAttr(m_inst, m_report_mgr->a_apl_sc_sort_as_string, m_bSortAsString);
		m_report_mgr->m_data->PutAttr(m_inst, m_report_mgr->a_apl_sc_sort_direction, m_SortDirection);
	}
	else
	{
		CaplInstance* inst;
		m_report_mgr->m_data->GetAttr(m_inst, m_report_mgr->a_apl_sc_column, inst);
		m_column = m_report_mgr->FindColumnByInst(inst);
		m_report_mgr->m_data->GetAttr(m_inst, m_report_mgr->a_apl_sc_sort_as_string, m_bSortAsString);
		m_report_mgr->m_data->GetAttr(m_inst, m_report_mgr->a_apl_sc_sort_direction, m_SortDirection);
	}
}


CSortColumnArray::CSortColumnArray()
{
	m_Data.RemoveAll();
}

CSortColumnArray::~CSortColumnArray()
{
	RemoveAll();
}

CSortColumn* CSortColumnArray::operator [](int index)
{
	return GetAt(index);
}

CSortColumn* CSortColumnArray::GetAt(int index)
{
	return m_Data.GetAt(index);
}

void CSortColumnArray::RemoveAt(int index)
{
	CSortColumn* col = m_Data.GetAt(index);
	delete col;
	m_Data.RemoveAt(index);
}

void CSortColumnArray::RemoveAll()
{
	CSortColumn* col;
	for(int i=0; i<GetSize(); i++)
	{
		col = m_Data[i];
		delete col;
	}
	m_Data.RemoveAll();
}

int CSortColumnArray::Add(CSortColumn* nSortCol)
{
	return m_Data.Add(nSortCol);
}

int CSortColumnArray::GetSize()
{
	return m_Data.GetSize();
}

int CSortColumnArray::Find(CSortColumn* SortCol)
{
	int cnt = m_Data.GetSize();
	for(int i=0; i<cnt; i++)
		if(m_Data[i]==SortCol) return i;

	return -1;
}

void CSortColumnArray::Remove(CSortColumn* SortCol)
{
	int cnt = m_Data.GetSize();
	for(int i=0; i<cnt; i++)
		if(m_Data[i]==SortCol)
		{
			delete SortCol;
			m_Data.RemoveAt(i);
			return;
		}
}

void CSortColumnArray::Move(int ind, int nInd)
{
	if(ind<0 || nInd<0) return;
	CSortColumn* col = m_Data.GetAt(ind);
	m_Data.RemoveAt(ind);
	m_Data.InsertAt(nInd, col);
	
	return;
}

CSortColumn& CSortColumn::operator = (const CSortColumn &col)
{
	m_inst = col.m_inst;
	m_report_mgr = col.m_report_mgr;
	m_column = col.m_column;
	m_bSortAsString = col.m_bSortAsString;
	m_SortDirection = col.m_SortDirection;

	return *this;
}